/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.kga;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.sourceforge.kga.GardenObserver;
import org.sourceforge.kga.Plant;
import org.sourceforge.kga.Point;
import org.sourceforge.kga.Rectangle;

public class Garden {
    private static Logger log = Logger.getLogger(Garden.class.getName());
    private Rectangle bounds = new Rectangle(0, 0, 1, 1);
    private TreeMap<Integer, HashMap<Point, List<Plant>>> squares;
    private List<GardenObserver> observers = new ArrayList<GardenObserver>();

    public Garden() {
        log.info("Creating new garden");
        this.squares = new TreeMap();
    }

    public void addObserver(GardenObserver gardenObserver) {
        this.observers.add(gardenObserver);
    }

    public void removeObserver(GardenObserver gardenObserver) {
        this.observers.add(gardenObserver);
    }

    public boolean addYear(int n) {
        if (this.squares.size() == 0) {
            return true;
        }
        log.info("Adding year " + Integer.toString(n));
        if (this.getYears().contains(n)) {
            return false;
        }
        this.copyPermanentSquares(this.squares.lastKey(), n);
        if (!this.getYears().contains(n)) {
            this.squares.put(n, new HashMap());
        }
        return true;
    }

    private void copyPermanentSquares(int n, int n2) {
        HashMap hashMap = new HashMap();
        for (Map.Entry<Point, List<Plant>> entry : this.squares.get(n).entrySet()) {
            ArrayList<Plant> arrayList = null;
            for (Plant plant : entry.getValue()) {
                if (!plant.isItem() && !this.findSquare(n2, entry.getKey(), 0, plant.lifetime.getRepetitionYears(), plant.lifetime.getRepetitionYears(), plant, true, false).isEmpty()) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<Plant>();
                }
                arrayList.add(plant);
            }
            if (arrayList == null) continue;
            hashMap.put(entry.getKey(), arrayList);
        }
        this.squares.put(n2, hashMap);
    }

    public Set<Integer> getYears() {
        return this.squares.keySet();
    }

    public String toString() {
        return "Garden with " + this.squares.size() + " squares";
    }

    public boolean addPlant(int n, Point point, Plant plant) {
        List<Plant> list;
        HashMap<Point, List<Plant>> hashMap = this.squares.get(n);
        if (hashMap == null) {
            hashMap = new HashMap();
            this.squares.put(n, hashMap);
        }
        if ((list = hashMap.get(point)) == null) {
            list = new ArrayList<Plant>();
            hashMap.put(point, list);
        }
        if (list.contains(plant)) {
            return false;
        }
        if (list.size() > 0 && (plant.isItem() || list.get(0).isItem())) {
            list.clear();
        }
        list.add(plant);
        if (!this.bounds.contains(point)) {
            this.bounds.add(point);
            if (!this.bounds.contains(point)) {
                if (this.bounds.x + this.bounds.width == point.x) {
                    ++this.bounds.width;
                }
                if (this.bounds.y + this.bounds.height == point.y) {
                    ++this.bounds.height;
                }
            }
            log.info("Bounds changed " + this.bounds);
            for (GardenObserver gardenObserver : this.observers) {
                gardenObserver.boundsChanged(this.bounds);
            }
        } else {
            this.squareChanged(n, point);
        }
        return true;
    }

    public TreeMap<Integer, HashMap<Point, List<Plant>>> getAllSquares() {
        return this.squares;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public List<Plant> getPlants(int n, Point point) {
        HashMap<Point, List<Plant>> hashMap = this.squares.get(n);
        if (hashMap == null) {
            return null;
        }
        return hashMap.get(point);
    }

    public void deleteYear(int n) {
        this.squares.remove(n);
        for (GardenObserver gardenObserver : this.observers) {
            gardenObserver.yearDeleted();
        }
    }

    public void removePlant(int n, Point point, Plant plant) {
        HashMap<Point, List<Plant>> hashMap = this.squares.get(n);
        if (hashMap == null) {
            return;
        }
        List<Plant> list = hashMap.get(point);
        if (list == null) {
            return;
        }
        if (plant != null && list.contains(plant)) {
            list.remove(plant);
            if (list.size() == 0) {
                hashMap.remove(point);
            }
        } else {
            hashMap.remove(point);
        }
        if (list.size() == 0) {
            hashMap.remove(point);
        }
        this.squareChanged(n, point);
    }

    protected void squareChanged(int n, Point point) {
        for (GardenObserver object : this.observers) {
            object.plantsChanged(n, point);
        }
        for (Map.Entry entry : this.squares.entrySet()) {
            if ((Integer)entry.getKey() < n) continue;
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    Point point2 = new Point(point.x + i, point.y + j);
                    for (GardenObserver gardenObserver : this.observers) {
                        gardenObserver.hintsChanged((Integer)entry.getKey(), point2);
                    }
                }
            }
        }
    }

    private void checkSquare(int n, Point point, Plant plant, boolean bl, boolean bl2, ArrayList<FindResult> arrayList) {
        List<Plant> list = this.getPlants(n, point);
        if (list == null) {
            return;
        }
        Iterator<Plant> iterator = list.iterator();
        while (iterator.hasNext()) {
            Plant plant2;
            for (Plant plant3 = plant2 = iterator.next(); plant3 != null; plant3 = plant3.getParent()) {
                if (plant3 == plant) {
                    arrayList.add(new FindResult(new Coordinate(n, point), plant2));
                    break;
                }
                if (bl) break;
            }
            if (bl2 || arrayList.isEmpty()) continue;
            break;
        }
    }

    public ArrayList<FindResult> findSquare(int n, Point point, int n2, int n3, int n4, Plant plant, boolean bl, boolean bl2) {
        ArrayList<FindResult> arrayList = new ArrayList<FindResult>();
        for (int i = n4; i >= n3; --i) {
            block1: for (int j = 0; j <= n2; ++j) {
                for (int k = -j + (j == 0 ? 0 : 1); k <= j; ++k) {
                    this.checkSquare(n - i, new Point(point.x + k, point.y - j), plant, bl, bl2, arrayList);
                    if (!bl2 && !arrayList.isEmpty()) {
                        return arrayList;
                    }
                    if (k == 0 && j == 0) continue block1;
                    this.checkSquare(n - i, new Point(point.x - k, point.y + j), plant, bl, bl2, arrayList);
                    if (!bl2 && !arrayList.isEmpty()) {
                        return arrayList;
                    }
                    this.checkSquare(n - i, new Point(point.x - j, point.y - k), plant, bl, bl2, arrayList);
                    if (!bl2 && !arrayList.isEmpty()) {
                        return arrayList;
                    }
                    this.checkSquare(n - i, new Point(point.x + j, point.y + k), plant, bl, bl2, arrayList);
                    if (bl2 || arrayList.isEmpty()) continue;
                    return arrayList;
                }
            }
        }
        return arrayList;
    }

    public class FindResult {
        public final Coordinate coordinate;
        public final Plant plant;

        public FindResult(Coordinate coordinate, Plant plant) {
            this.coordinate = coordinate;
            this.plant = plant;
        }
    }

    public static class Coordinate {
        public final int year;
        public final Point grid;

        public boolean equals(Object object) {
            return object instanceof Coordinate && ((Coordinate)object).grid.equals(this.grid) && ((Coordinate)object).year == this.year;
        }

        public Coordinate(int n, Point point) {
            this.year = n;
            this.grid = point;
        }
    }
}

