/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.kga;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import org.sourceforge.kga.Plant;
import org.sourceforge.kga.translation.Translation;

public class SeedList {
    ArrayList<Listener> listeners = new ArrayList();
    private static Set<String> units = new TreeSet<String>();
    private LocalDate date = LocalDate.now();
    private ArrayList<Entry> filteredSeeds = new ArrayList();
    private Set<LocalDate> dates = new TreeSet<LocalDate>();
    public ArrayList<Entry> seeds = new ArrayList();

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public static Set<String> getUnits() {
        return units;
    }

    public void sortFilteredEntries() {
        Collections.sort(this.filteredSeeds, new Comparator<Entry>(){

            @Override
            public int compare(Entry entry, Entry entry2) {
                Translation translation = Translation.getPreferred();
                return translation.getCollator().compare(entry.getPlantName(true), entry2.getPlantName(true));
            }
        });
    }

    public void setDate(LocalDate localDate) {
        this.date = localDate;
        this.filteredSeeds.clear();
        for (Entry object : this.seeds) {
            if (!object.isVisible(localDate)) continue;
            this.filteredSeeds.add(object);
        }
        this.sortFilteredEntries();
        for (Listener listener : this.listeners) {
            listener.viewChanged();
        }
    }

    public LocalDate getDate() {
        return this.date;
    }

    public Set<LocalDate> getValidFromDates() {
        return this.dates;
    }

    public int size() {
        return this.filteredSeeds.size();
    }

    public Entry get(int n) {
        return this.filteredSeeds.get(n);
    }

    public ArrayList<Entry> getFilteredEntries() {
        return this.filteredSeeds;
    }

    public ArrayList<Entry> getAllEntries() {
        return this.seeds;
    }

    private void fireListChanged() {
        for (Listener listener : this.listeners) {
            listener.listChanged();
        }
    }

    private void add(Entry entry) {
        if (entry.quantity != null && ((Entry)entry).quantity.unit != null) {
            units.add(((Entry)entry).quantity.unit);
        }
        this.seeds.add(entry);
        this.dates.add(entry.validFrom);
        if (entry.isVisible(this.date)) {
            this.filteredSeeds.add(entry);
        }
        this.fireListChanged();
    }

    public void add(Entry.PlantOrUnregistered plantOrUnregistered, String string, Entry.Quantity quantity, String string2, LocalDate localDate, LocalDate localDate2) {
        Entry entry = new Entry();
        entry.plant = plantOrUnregistered;
        entry.variety = string;
        entry.quantity = quantity;
        entry.comment = string2;
        entry.validFrom = localDate;
        entry.validTo = localDate2;
        this.add(entry);
    }

    public void add(Plant plant, LocalDate localDate) {
        this.add(new Entry.PlantOrUnregistered(plant), null, null, null, localDate, null);
    }

    public void add(String string, LocalDate localDate) {
        this.add(new Entry.PlantOrUnregistered(string), null, null, null, localDate, null);
    }

    private void modifyEntry(Entry entry, LocalDate localDate) {
        if (!entry.validFrom.equals(localDate)) {
            Entry entry2 = (Entry)entry.clone();
            entry2.validTo = localDate;
            this.seeds.add(entry2);
            this.dates.add(localDate);
            entry.validFrom = localDate;
        }
    }

    public void remove(Entry entry, LocalDate localDate) throws IllegalArgumentException {
        if (entry.validFrom.compareTo(localDate) > 0) {
            throw new IllegalArgumentException("Invalid date " + localDate.toString() + " for entry with validFrom " + entry.validFrom.toString());
        }
        if (entry.validTo != null && entry.validTo.compareTo(localDate) <= 0) {
            throw new IllegalArgumentException("Invalid date " + localDate.toString() + " for entry with validTo " + entry.validTo.toString());
        }
        boolean bl = entry.isVisible(localDate);
        if (entry.validFrom.equals(localDate)) {
            this.seeds.remove(entry);
        } else {
            entry.validTo = localDate;
        }
        if (bl) {
            this.filteredSeeds.remove(entry);
        }
        this.fireListChanged();
    }

    private static int compareNullStrings(String string, String string2) {
        if (string == null && string2 == null) {
            return 0;
        }
        if (string == null && string2.isEmpty()) {
            return 0;
        }
        if (string2 == null && string.isEmpty()) {
            return 0;
        }
        return string == null ? -1 : (string2 == null ? 1 : string.compareTo(string2));
    }

    public void setVariety(Entry entry, String string, LocalDate localDate) {
        if (!entry.validFrom.equals(localDate)) {
            throw new IllegalArgumentException("Can not modify variety on a different date");
        }
        if (SeedList.compareNullStrings(entry.variety, string) == 0) {
            return;
        }
        entry.variety = string;
        this.fireListChanged();
    }

    public void setComment(Entry entry, String string, LocalDate localDate) {
        if (!entry.validFrom.equals(localDate)) {
            throw new IllegalArgumentException("Can not modify comment on a different date");
        }
        if (SeedList.compareNullStrings(entry.comment, string) == 0) {
            return;
        }
        entry.comment = string;
        this.fireListChanged();
    }

    public void setQuantity(Entry entry, Entry.Quantity quantity, LocalDate localDate) {
        this.modifyEntry(entry, localDate);
        if (entry.quantity == null && quantity == null) {
            return;
        }
        entry.quantity = quantity;
        if (quantity != null && quantity.unit != null) {
            units.add(quantity.unit);
        }
        this.fireListChanged();
    }

    static {
        Translation translation = Translation.getPreferred();
        units.add(translation.measurement_unit_grams());
        units.add(translation.measurement_unit_pieces());
    }

    public static class Entry
    implements Cloneable {
        private LocalDate validFrom = null;
        private LocalDate validTo = null;
        private PlantOrUnregistered plant = null;
        private String variety = null;
        private Quantity quantity = null;
        private String comment = null;

        private Entry() {
        }

        public boolean isVisible(LocalDate localDate) {
            return this.validFrom.compareTo(localDate) <= 0 && (this.validTo == null || localDate.compareTo(this.validTo) < 0);
        }

        public Object clone() {
            Entry entry = new Entry();
            entry.validFrom = this.validFrom;
            entry.validTo = this.validTo;
            entry.plant = this.plant;
            entry.variety = this.variety;
            entry.quantity = this.quantity;
            entry.comment = this.comment;
            return entry;
        }

        public String getPlantName(boolean bl) {
            Translation translation = Translation.getPreferred();
            String string = this.getPlant().unregisteredPlant == null ? translation.translate(this.getPlant().plant) : this.getPlant().unregisteredPlant;
            if (bl && this.getVariety() != null && !this.getVariety().isEmpty()) {
                string = string + " ( " + this.getVariety() + " )";
            }
            return string;
        }

        public LocalDate getValidFrom() {
            return this.validFrom;
        }

        public LocalDate getValidTo() {
            return this.validTo;
        }

        public PlantOrUnregistered getPlant() {
            return this.plant;
        }

        public String getVariety() {
            return this.variety;
        }

        public Quantity getQuantity() {
            return this.quantity;
        }

        public String getComment() {
            return this.comment;
        }

        public static class Quantity {
            public double quantity = 0.0;
            public String unit = null;
        }

        public static class PlantOrUnregistered {
            public Plant plant;
            public String unregisteredPlant;

            public PlantOrUnregistered(Plant plant) {
                this.plant = plant;
                this.unregisteredPlant = null;
            }

            public PlantOrUnregistered(String string) {
                this.plant = null;
                this.unregisteredPlant = string;
            }
        }
    }

    public static class PlantOrUnregisteredComparatorByName
    implements Comparator<Entry.PlantOrUnregistered> {
        @Override
        public int compare(Entry.PlantOrUnregistered plantOrUnregistered, Entry.PlantOrUnregistered plantOrUnregistered2) {
            String string;
            Translation translation = Translation.getPreferred();
            boolean bl = plantOrUnregistered.plant != null && plantOrUnregistered.plant.isItem();
            boolean bl2 = plantOrUnregistered2.plant != null && plantOrUnregistered2.plant.isItem();
            String string2 = plantOrUnregistered.unregisteredPlant != null ? plantOrUnregistered.unregisteredPlant : translation.translate(plantOrUnregistered.plant);
            String string3 = string = plantOrUnregistered2.unregisteredPlant != null ? plantOrUnregistered2.unregisteredPlant : translation.translate(plantOrUnregistered2.plant);
            if (bl == bl2) {
                return translation.getCollator().compare(string2, string);
            }
            return bl ? 1 : -1;
        }
    }

    public static interface Listener {
        public void viewChanged();

        public void listChanged();
    }
}

