/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.kga;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.sourceforge.kga.Garden;
import org.sourceforge.kga.Plant;
import org.sourceforge.kga.wrappers.Image;

public class Taxon
implements Comparable<Taxon> {
    private static Logger log = Logger.getLogger(Garden.class.getName());
    private int id;
    private Type type;
    private String name = "unknown";
    private Map<String, String> translations;
    private Image image;
    String imageString = null;
    protected Taxon parent = null;
    private Set<Taxon> children = new TreeSet<Taxon>(new Comparator<Taxon>(){

        @Override
        public int compare(Taxon taxon, Taxon taxon2) {
            return taxon.id - taxon2.id;
        }
    });

    @Override
    public int compareTo(Taxon taxon) {
        return this.id - taxon.id;
    }

    public Taxon(int n) {
        this.id = n;
    }

    public Taxon(Type type, int n, String string, Taxon taxon) {
        String[] stringArray = string.replace("\u00d7", "").replace("  ", " ").split(" ");
        int n2 = stringArray.length;
        if (type != Type.KINGDOM && taxon == null) {
            log.severe("Parent not specified for " + string);
        } else if (type == Type.FAMILY && taxon.type != Type.KINGDOM || type == Type.GENUS && taxon.type != Type.FAMILY || type == Type.SPECIES && taxon.type != Type.FAMILY && taxon.type != Type.GENUS || type == Type.SUBSPECIES && taxon.type != Type.SPECIES) {
            log.severe("Invalid parent type " + taxon.type.toString() + " for " + type.toString() + " " + string);
        } else if (n2 != 1 && (type == Type.KINGDOM || type == Type.FAMILY || type == Type.GENUS) || n2 != 2 && type == Type.SPECIES || n2 != 4 && type == Type.SUBSPECIES) {
            log.severe("Invalid name " + string + " for " + type.toString());
        } else if (type == Type.SPECIES && taxon.type == Type.GENUS && !string.startsWith(taxon.name + " ")) {
            log.severe("Invalid species name " + string + " in genus " + taxon.name);
        } else if (type == Type.SUBSPECIES && !string.startsWith(taxon.name + " ")) {
            log.severe("Invalid subspecies name " + string + " in species " + taxon.name);
        } else if (type == Type.SUBSPECIES && stringArray[2].compareTo("subsp.") != 0 && stringArray[2].compareTo("var.") != 0 && stringArray[2].compareTo("subvar.") != 0 && stringArray[2].compareTo("f.") != 0 && stringArray[2].compareTo("subf.") != 0) {
            log.severe("Invalid connector name " + stringArray[2] + " for " + string);
        }
        this.id = n;
        this.type = type;
        this.name = string.trim();
        this.parent = taxon;
        this.translations = new HashMap<String, String>();
        if (taxon != null) {
            this.parent.children.add(this);
        }
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object object) {
        if (object instanceof Plant) {
            return ((Plant)object).getId() == this.getId();
        }
        return false;
    }

    public String toString() {
        return "Plant " + this.getName() + " id: " + this.getId();
    }

    public Type getType() {
        return this.type;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getTranslation(String string) {
        return this.translations.get(string);
    }

    public boolean isItem() {
        return this.type == Type.ITEM;
    }

    public Image getImage() {
        return this.image;
    }

    public Taxon getFamily() {
        Taxon taxon = this.parent;
        while (taxon != null && taxon.type != Type.FAMILY) {
            taxon = taxon.parent;
        }
        return taxon;
    }

    public Taxon getTaxonParent() {
        return this.parent;
    }

    public Set<Taxon> getChildren() {
        return this.children;
    }

    public boolean isParentOf(Taxon taxon) {
        Taxon taxon2 = taxon.parent;
        while (taxon2 != null) {
            if (taxon2 == this) {
                return true;
            }
            taxon2 = taxon2.parent;
        }
        return false;
    }

    public void setTranslation(String string, String string2) {
        this.translations.put(string, string2);
    }

    public Map<String, String> getTranslations() {
        return this.translations;
    }

    public void setImage(String string) {
        this.image = new Image(string);
        this.imageString = string;
    }

    public String getImageAsString() {
        return this.imageString;
    }

    public static enum Type {
        KINGDOM,
        FAMILY,
        GENUS,
        SPECIES,
        SUBSPECIES,
        ITEM;

    }
}

