/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.kga.gui.desktop;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.sourceforge.kga.Garden;
import org.sourceforge.kga.Plant;
import org.sourceforge.kga.Point;
import org.sourceforge.kga.gui.desktop.EditableGardenObserver;
import org.sourceforge.kga.rules.Hint;
import org.sourceforge.kga.rules.HintList;
import org.sourceforge.kga.rules.Rule;

public class EditableGarden
extends Garden {
    private static Logger log = Logger.getLogger(Garden.class.getName());
    public static int minZoomFactor = 50;
    public static int maxZoomFactor = 200;
    int zoomFactor = 100;
    int previewYear = 0;
    Point previewGrid = null;
    Plant previewPlant = null;
    Plant selectedPlant = null;
    List<EditableGardenObserver> observers = new ArrayList<EditableGardenObserver>();
    Operation operation = Operation.AddPlant;

    public EditableGarden() {
        log.setLevel(Level.FINEST);
    }

    public void addObserver(EditableGardenObserver editableGardenObserver) {
        this.observers.add(editableGardenObserver);
    }

    public void removeObserver(EditableGardenObserver editableGardenObserver) {
        this.observers.remove(editableGardenObserver);
    }

    public int getZoomFactor() {
        return this.zoomFactor;
    }

    public void setZoomFactor(int n) {
        if (n < minZoomFactor) {
            n = minZoomFactor;
        }
        if (n > maxZoomFactor) {
            n = maxZoomFactor;
        }
        if (n == this.zoomFactor) {
            return;
        }
        this.zoomFactor = n;
        for (EditableGardenObserver editableGardenObserver : this.observers) {
            editableGardenObserver.zoomFactorChanged(this);
        }
    }

    public boolean isPreview(int n, Point point, Plant plant) {
        if (this.previewYear == 0 || this.previewGrid == null || this.previewPlant == null) {
            return false;
        }
        return this.previewYear == n && this.previewPlant.equals(plant) && this.previewGrid.x == point.x && this.previewGrid.y == point.y;
    }

    public int getPreviewYear() {
        return this.previewYear;
    }

    public Point getPreviewGrid() {
        return this.previewGrid;
    }

    public Plant getPreviewPlant() {
        return this.previewPlant;
    }

    public void addPreview(int n, Point point, Plant plant) {
        this.removePreview();
        List<Plant> list = this.getPlants(n, point);
        if (list != null && list.contains(plant)) {
            return;
        }
        this.previewYear = n;
        this.previewGrid = point;
        this.previewPlant = plant;
        this.squareChanged(n, point);
    }

    public void removePreview() {
        if (this.previewYear == 0 || this.previewGrid == null || this.previewPlant == null) {
            return;
        }
        int n = this.previewYear;
        Point point = new Point(this.previewGrid);
        this.previewYear = 0;
        this.previewGrid = null;
        this.previewPlant = null;
        this.squareChanged(n, point);
    }

    @Override
    public List<Plant> getPlants(int n, Point point) {
        List<Plant> list = super.getPlants(n, point);
        if (this.previewYear == n && this.previewGrid != null && point.equals(this.previewGrid)) {
            list = list == null || this.previewPlant.isItem() || list.get(0).isItem() ? new ArrayList<Plant>() : new ArrayList<Plant>(list);
            list.add(this.previewPlant);
        }
        return list;
    }

    public List<Plant> getSpeciesNoPreview(int n, Point point) {
        return super.getPlants(n, point);
    }

    public Plant getSelectedPlant() {
        return this.selectedPlant;
    }

    public void setSelectedPlant(Plant plant) {
        this.selectedPlant = plant;
        for (EditableGardenObserver editableGardenObserver : this.observers) {
            editableGardenObserver.previewSpeciesChanged(this, this.selectedPlant);
        }
    }

    public Map.Entry<Integer, Integer> getPreviewHints(int n, Point point) {
        if (this.selectedPlant == null || this.selectedPlant.isItem()) {
            return null;
        }
        int n2 = this.previewYear;
        Point point2 = this.previewGrid;
        Plant plant = this.previewPlant;
        int n3 = 0;
        int n4 = 0;
        this.previewYear = 0;
        this.previewGrid = null;
        this.previewPlant = null;
        List<Plant> list = this.getPlants(n, point);
        if (list == null || !list.contains(this.selectedPlant)) {
            HintList hintList;
            int n5;
            int n6;
            for (n6 = -1; n6 <= 1; ++n6) {
                for (n5 = -1; n5 <= 1; ++n5) {
                    hintList = Rule.getHints(this, n, new Point(point.x + n6, point.y + n5), false);
                    n3 -= hintList.getValue(Hint.Value.GOOD);
                    n4 -= hintList.getValue(Hint.Value.BAD);
                }
            }
            this.previewYear = n;
            this.previewGrid = point;
            this.previewPlant = this.selectedPlant;
            for (n6 = -1; n6 <= 1; ++n6) {
                for (n5 = -1; n5 <= 1; ++n5) {
                    hintList = Rule.getHints(this, n, new Point(point.x + n6, point.y + n5), false);
                    n3 += hintList.getValue(Hint.Value.GOOD);
                    n4 += hintList.getValue(Hint.Value.BAD);
                }
            }
        }
        this.previewYear = n2;
        this.previewGrid = point2;
        this.previewPlant = plant;
        return new AbstractMap.SimpleEntry<Integer, Integer>(n3, n4);
    }

    private void callGardenChanged() {
        for (EditableGardenObserver editableGardenObserver : this.observers) {
            editableGardenObserver.gardenChanged(this);
        }
    }

    @Override
    public boolean addPlant(int n, Point point, Plant plant) {
        boolean bl = super.addPlant(n, point, plant);
        if (bl) {
            this.callGardenChanged();
        }
        return bl;
    }

    @Override
    public boolean addYear(int n) {
        boolean bl = super.addYear(n);
        if (bl) {
            this.callGardenChanged();
        }
        return bl;
    }

    @Override
    public void deleteYear(int n) {
        super.deleteYear(n);
        this.callGardenChanged();
    }

    @Override
    public void removePlant(int n, Point point, Plant plant) {
        super.removePlant(n, point, plant);
        this.callGardenChanged();
    }

    public Operation getOperation() {
        return this.operation;
    }

    public void setOperation(Operation operation) {
        this.operation = operation;
        for (EditableGardenObserver editableGardenObserver : this.observers) {
            editableGardenObserver.operationChanged(this);
        }
    }

    public static enum Operation {
        AddPlant,
        DeletePlant,
        PickPlant;

    }
}

