/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.kga.gui.desktop;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;

public class GardenPanelHeaders
extends JComponent {
    private static final long serialVersionUID = 1L;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public int orientation;
    private Font font;
    private FontMetrics fm;
    private int zoomFactor;

    public GardenPanelHeaders(int n) {
        this.orientation = n;
        this.font = new Font("SansSerif", 0, 10);
        this.fm = this.getFontMetrics(this.font);
    }

    public void setPreferredHeight(int n) {
        int n2 = this.fm.stringWidth("999");
        this.setPreferredSize(new Dimension(n2, n));
    }

    public void setPreferredWidth(int n) {
        this.setPreferredSize(new Dimension(n, this.fm.getHeight() + this.fm.getLeading()));
    }

    public void setZoomFactor(int n) {
        this.zoomFactor = n;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        graphics.clearRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setFont(this.font);
        int n = 66;
        if (this.orientation == 0) {
            int n2 = rectangle.x * 100 / this.zoomFactor / n - 1;
            graphics.translate(0, this.fm.getLeading());
            GardenPanelHeaders.paintHeader(graphics, n, this.zoomFactor, this.orientation, (n2 + 1) * n * this.zoomFactor / 100, n2, (rectangle.x + rectangle.width) * 100 / this.zoomFactor / n);
        } else {
            int n3 = rectangle.y * 100 / this.zoomFactor / n - 1;
            GardenPanelHeaders.paintHeader(graphics, n, this.zoomFactor, this.orientation, (n3 + 1) * n * this.zoomFactor / 100, n3, (rectangle.y + rectangle.height) * 100 / this.zoomFactor / n);
        }
    }

    public static void paintHeader(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        graphics.setColor(Color.black);
        if (n3 == 0) {
            int n7 = fontMetrics.getAscent();
            for (int i = n5; i < n6; ++i) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int j = i; j >= 0; --j) {
                    stringBuffer.insert(0, (char)(65 + j % 26));
                    j /= 26;
                }
                int n8 = fontMetrics.stringWidth(stringBuffer.toString());
                graphics.drawString(stringBuffer.toString(), n4 + (i - n5) * n * n2 / 100 + (n * n2 / 100 - n8) / 2, n7);
            }
        } else {
            int n9 = (n * n2 / 100 - fontMetrics.getAscent() - fontMetrics.getDescent()) / 2 + fontMetrics.getAscent();
            int n10 = fontMetrics.stringWidth("999");
            for (int i = Math.max(0, n5); i < n6; ++i) {
                String string = Integer.toString(i + 1);
                graphics.drawString(string, (n10 - fontMetrics.stringWidth(string)) / 2, n4 + (i - n5) * n * n2 / 100 + n9);
            }
        }
    }
}

