/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.kga.gui.desktop;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import org.sourceforge.kga.Plant;
import org.sourceforge.kga.gui.desktop.EditableGarden;
import org.sourceforge.kga.translation.Translation;
import org.sourceforge.kga.wrappers.Image;

public class Toolbox
extends JPanel
implements ItemListener {
    static ImageIcon imageCursor = new ImageIcon(Image.getFromResources("cursor.png").get());
    private JToggleButton addPlantButton = new JToggleButton(imageCursor);
    private JToggleButton deletePlantButton = new JToggleButton(new ImageIcon(Image.getFromResources("delete.png").get()));
    private JToggleButton pickPlantButton = new JToggleButton(new ImageIcon(Image.getFromResources("picker.png").get()));
    Listener listener;
    private Plant selectedPlant = null;

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public Toolbox() {
        this.deletePlantButton.setToolTipText(Translation.getPreferred().delete_square());
        this.pickPlantButton.setToolTipText(Translation.getPreferred().pick_species());
        this.add(this.addPlantButton);
        this.add(this.deletePlantButton);
        this.add(this.pickPlantButton);
    }

    void startListening() {
        this.addPlantButton.addItemListener(this);
        this.deletePlantButton.addItemListener(this);
        this.pickPlantButton.addItemListener(this);
    }

    void stopListening() {
        this.addPlantButton.removeItemListener(this);
        this.deletePlantButton.removeItemListener(this);
        this.pickPlantButton.removeItemListener(this);
    }

    public void setOperation(EditableGarden.Operation operation) {
        if (this.addPlantButton.isSelected() && operation == EditableGarden.Operation.AddPlant && this.selectedPlant != null) {
            return;
        }
        if (this.deletePlantButton.isSelected() && operation == EditableGarden.Operation.DeletePlant) {
            return;
        }
        if (this.pickPlantButton.isSelected() && operation == EditableGarden.Operation.PickPlant) {
            return;
        }
        this.stopListening();
        this.addPlantButton.setSelected(operation == EditableGarden.Operation.AddPlant && this.selectedPlant != null);
        this.deletePlantButton.setSelected(operation == EditableGarden.Operation.DeletePlant);
        this.pickPlantButton.setSelected(operation == EditableGarden.Operation.PickPlant);
        if (this.selectedPlant != null) {
            this.listener.operationChanged(operation);
        } else {
            this.listener.operationChanged(null);
        }
        this.startListening();
    }

    public void setSelectedPlant(Plant plant) {
        if (this.selectedPlant == plant) {
            return;
        }
        this.stopListening();
        this.selectedPlant = plant;
        ImageIcon imageIcon = imageCursor;
        if (plant != null && plant.getImage() != null) {
            imageIcon = new ImageIcon(plant.getImage().get().getScaledInstance(24, 24, 4));
        }
        this.addPlantButton.setIcon(imageIcon);
        this.startListening();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() != 1) {
            if (itemEvent.getSource() == this.addPlantButton) {
                this.setSelectedPlant(null);
                this.listener.operationChanged(null);
            } else if (this.selectedPlant != null) {
                this.setOperation(EditableGarden.Operation.AddPlant);
            } else {
                this.setOperation(null);
            }
            return;
        }
        this.stopListening();
        if (itemEvent.getSource() == this.addPlantButton) {
            if (this.selectedPlant == null) {
                this.addPlantButton.setSelected(false);
            } else {
                this.listener.operationChanged(EditableGarden.Operation.AddPlant);
            }
        } else {
            this.addPlantButton.setSelected(false);
        }
        if (itemEvent.getSource() != this.deletePlantButton) {
            this.deletePlantButton.setSelected(false);
        } else {
            this.listener.operationChanged(EditableGarden.Operation.DeletePlant);
        }
        if (itemEvent.getSource() != this.pickPlantButton) {
            this.pickPlantButton.setSelected(false);
        } else {
            this.listener.operationChanged(EditableGarden.Operation.PickPlant);
        }
        this.startListening();
    }

    public static interface Listener {
        public void operationChanged(EditableGarden.Operation var1);
    }
}

