/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.kga.gui.desktop.actions;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.sourceforge.kga.Garden;
import org.sourceforge.kga.Plant;
import org.sourceforge.kga.PlantList;
import org.sourceforge.kga.Taxon;
import org.sourceforge.kga.gui.desktop.Gui;
import org.sourceforge.kga.gui.desktop.PlantProperties;
import org.sourceforge.kga.gui.desktop.actions.KgaAction;
import org.sourceforge.kga.gui.desktop.actions.importData.ImportCsv;
import org.sourceforge.kga.plant.Lifetime;
import org.sourceforge.kga.plant.NutritionalNeeds;
import org.sourceforge.kga.plant.RootDeepness;
import org.sourceforge.kga.plant.WeedControl;
import org.sourceforge.kga.translation.Iso639_1;
import org.sourceforge.kga.translation.Translation;

public class EditSpecies
extends KgaAction
implements TreeSelectionListener {
    Translation t = Translation.getPreferred();
    private static Logger log = Logger.getLogger(Garden.class.getName());
    JComboBox<Iso639_1.Language> comboLanguage = null;
    EditFamilyTableModel model = new EditFamilyTableModel();
    JTree tree;
    JDialog dialog = null;
    PlantProperties properties = new PlantProperties();
    JButton buttonImportCsv = new JButton(Translation.getPreferred().import_csv());
    JButton buttonSave = new JButton(Translation.getPreferred().action_save());

    public EditSpecies(Gui gui) {
        super(gui, Translation.getPreferred().action_edit_species());
        this.buttonSave.addActionListener(this);
        this.buttonImportCsv.addActionListener(this);
    }

    private void buttonSaveAction() {
        Preferences preferences = Preferences.userRoot().node("/org/sourceforge/kga/gui");
        String string = preferences.get("lastSpeciesFilePath", "");
        JFileChooser jFileChooser = new JFileChooser(string);
        FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter("Species", "xml");
        jFileChooser.setFileFilter(fileNameExtensionFilter);
        if (jFileChooser.showSaveDialog(this.getGui()) != 0) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        if (!file.getName().endsWith(".xml")) {
            file = new File(file.getParent() + "/" + file.getName() + ".xml");
        }
        preferences.put("lastSpeciesFilePath", file.getParent());
        log.info("Set last path to  " + file.getParent());
        try {
            PlantList.serializableSpecies.saveToFile(file);
        }
        catch (Exception exception) {
            Translation translation = Translation.getPreferred();
            JOptionPane.showMessageDialog(this.getGui(), exception.toString(), translation.error_saving_file(), 0);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.buttonSave) {
            this.buttonSaveAction();
            return;
        }
        if (actionEvent.getSource() == this.buttonImportCsv) {
            ImportCsv importCsv = new ImportCsv(this.getGui());
            importCsv.actionPerformed(null);
            return;
        }
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setPreferredSize(new Dimension(700, 350));
        JTable jTable = new JTable(this.model);
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jPanel.add((Component)jScrollPane, "West");
        jTable.getColumnModel().getColumn(0).setCellRenderer(new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                JLabel jLabel = (JLabel)jTable.getDefaultRenderer(String.class).getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (bl2) {
                    TreeNodeStatus treeNodeStatus = (TreeNodeStatus)((Object)EditSpecies.this.model.getValueAt(n, 0));
                    EditSpecies.this.model.setValueAt((Object)(treeNodeStatus == TreeNodeStatus.EXPANDED ? TreeNodeStatus.COLLAPSED : TreeNodeStatus.EXPANDED), n, n2);
                }
                jLabel.setForeground(Color.BLACK);
                jLabel.setText(EditSpecies.this.model.getName(n));
                return jLabel;
            }
        });
        jTable.getColumnModel().getColumn(1).setCellRenderer(new PlantPropertiesRenderer(){

            @Override
            public boolean hasProperty(Plant plant) {
                return plant.hasNutritionalNeeds();
            }

            @Override
            public Object getProperty(Plant plant) {
                return plant.getNutritionalNeeds();
            }
        });
        jTable.getColumnModel().getColumn(2).setCellRenderer(new PlantPropertiesRenderer(){

            @Override
            public boolean hasProperty(Plant plant) {
                return plant.hasRootDeepness();
            }

            @Override
            public Object getProperty(Plant plant) {
                return plant.getRootDeepness();
            }
        });
        jTable.getColumnModel().getColumn(3).setCellRenderer(new PlantPropertiesRenderer(){

            @Override
            public boolean hasProperty(Plant plant) {
                return plant.hasWeedControl();
            }

            @Override
            public Object getProperty(Plant plant) {
                return plant.getWeedControl();
            }
        });
        jTable.getColumnModel().getColumn(0).sizeWidthToFit();
        jTable.getColumnModel().getColumn(1).setResizable(true);
        JScrollPane jScrollPane2 = new JScrollPane(this.properties);
        jPanel.add((Component)jScrollPane2, "Center");
        TableColumn tableColumn = jTable.getColumnModel().getColumn(1);
        JComboBox<NutritionalNeeds.Type> jComboBox = new JComboBox<NutritionalNeeds.Type>();
        jComboBox.addItem(null);
        for (NutritionalNeeds.Type type : NutritionalNeeds.Type.values()) {
            jComboBox.addItem(type);
        }
        tableColumn.setCellEditor(new DefaultCellEditor(jComboBox));
        this.dialog = new JOptionPane(jPanel, -1, 0, null, new JButton[]{this.buttonImportCsv, this.buttonSave}).createDialog(Translation.getPreferred().action_edit_species());
        Gui.makeWindowBoundsPersistent(this.dialog, "EditFamilies", false);
        this.dialog.setVisible(true);
        this.getGui().resetGui();
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
    }

    abstract class PlantPropertiesRenderer
    implements TableCellRenderer {
        JLabel c = null;

        PlantPropertiesRenderer() {
        }

        public abstract boolean hasProperty(Plant var1);

        public abstract Object getProperty(Plant var1);

        public String getPropertyAsString(Plant plant) {
            Object object = this.getProperty(plant);
            if (object == null) {
                return "";
            }
            return object.toString();
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Object object2;
            Plant plant = EditSpecies.this.model.displayed.get(n);
            if (this.c == null) {
                object2 = (JLabel)jTable.getDefaultRenderer(String.class).getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                this.c = new JLabel();
                this.c.setFont(((Component)object2).getFont());
            }
            this.c.setOpaque(false);
            object2 = this.getPropertyAsString(plant);
            if (this.hasProperty(plant)) {
                this.c.setText((String)object2);
                this.c.setForeground(Color.BLACK);
            } else if (!((String)object2).isEmpty()) {
                this.c.setText((String)object2);
                this.c.setForeground(Color.LIGHT_GRAY);
            } else {
                this.c.setText("");
                if (!this.checkChildren(plant)) {
                    this.c.setOpaque(true);
                    this.c.setBackground(new Color(255, 235, 230));
                }
            }
            return this.c;
        }

        public boolean checkChildren(Plant plant) {
            if (this.hasProperty(plant)) {
                return true;
            }
            if (plant.getChildren().size() == 0) {
                return false;
            }
            for (Taxon taxon : plant.getChildren()) {
                if (this.checkChildren((Plant)taxon)) continue;
                return false;
            }
            return true;
        }
    }

    public class EditFamilyTableModel
    extends AbstractTableModel {
        ArrayList<Plant> displayed = new ArrayList();

        @Override
        public int getRowCount() {
            return this.displayed.size();
        }

        @Override
        public int getColumnCount() {
            return 7;
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return EditSpecies.this.t.name();
                }
                case 1: {
                    return EditSpecies.this.t.nutritional_needs();
                }
                case 2: {
                    return "root_deepness";
                }
                case 3: {
                    return "weed_control";
                }
                case 4: {
                    return "lifetime";
                }
                case 5: {
                    return "repetition";
                }
                case 6: {
                    return "gap";
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            switch (n) {
                case 1: {
                    return NutritionalNeeds.class;
                }
                case 2: {
                    return RootDeepness.class;
                }
                case 3: {
                    return WeedControl.class;
                }
                case 4: {
                    return Lifetime.Value.class;
                }
                case 5: {
                    return Integer.class;
                }
                case 6: {
                    return Integer.class;
                }
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 1;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Plant plant = this.displayed.get(n);
            switch (n2) {
                case 0: {
                    return plant.getChildren().size() == 0 ? TreeNodeStatus.LEAF : (n + 1 < EditSpecies.this.model.displayed.size() && EditSpecies.this.model.displayed.get(n) == EditSpecies.this.model.displayed.get(n + 1).getParent() ? TreeNodeStatus.EXPANDED : TreeNodeStatus.COLLAPSED);
                }
                case 1: {
                    return plant.getNutritionalNeeds();
                }
                case 2: {
                    return plant.getRootDeepness();
                }
                case 3: {
                    return plant.getWeedControl();
                }
                case 4: {
                    return plant.lifetime.get();
                }
                case 5: {
                    int n3 = plant.lifetime.getRepetitionYears();
                    if (n3 == Integer.MAX_VALUE) {
                        return "\u221e";
                    }
                    return n3;
                }
                case 6: {
                    return plant.lifetime.getRepetitionGap();
                }
            }
            return null;
        }

        public String getName(int n) {
            TreeNodeStatus treeNodeStatus = (TreeNodeStatus)((Object)this.getValueAt(n, 0));
            Plant plant = this.displayed.get(n);
            Plant plant2 = plant.getParent();
            String string = "";
            while ((plant2 = plant2.getParent()) != null) {
                string = string + "        ";
            }
            string = treeNodeStatus == TreeNodeStatus.LEAF ? string + "" : string + (treeNodeStatus == TreeNodeStatus.COLLAPSED ? "+ " : "- ");
            String string2 = plant.getName();
            String string3 = EditSpecies.this.t.translate(plant);
            string = string2.compareTo(string3) == 0 ? string + string2 : string + string3 + " ( " + string2 + " )";
            return string;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                if (((TreeNodeStatus)((Object)this.getValueAt(n, 0))).equals(object)) {
                    return;
                }
                TreeNodeStatus treeNodeStatus = (TreeNodeStatus)((Object)object);
                Plant plant = this.displayed.get(n);
                if (treeNodeStatus != TreeNodeStatus.EXPANDED) {
                    while (n + 1 < this.displayed.size()) {
                        Plant plant2 = this.displayed.get(n + 1);
                        for (Plant plant3 = plant2.getParent(); plant3 != null; plant3 = plant3.getParent()) {
                            if (plant3 != plant) continue;
                            this.displayed.remove(n + 1);
                            plant2 = null;
                            break;
                        }
                        if (plant2 == null) continue;
                        break;
                    }
                }
                this.fireTableDataChanged();
            } else if (n2 == 1) {
                this.displayed.get(n).setNutritionalNeeds((NutritionalNeeds)object);
                this.fireTableDataChanged();
            }
        }

        public void expand() {
        }
    }

    static enum TreeNodeStatus {
        EXPANDED,
        COLLAPSED,
        LEAF;

    }
}

