/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.kga.gui.desktop.actions;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import org.sourceforge.kga.Animal;
import org.sourceforge.kga.Garden;
import org.sourceforge.kga.Plant;
import org.sourceforge.kga.PlantList;
import org.sourceforge.kga.Taxon;
import org.sourceforge.kga.gui.desktop.Gui;
import org.sourceforge.kga.gui.desktop.actions.ExportTranslation;
import org.sourceforge.kga.gui.desktop.actions.KgaAction;
import org.sourceforge.kga.translation.Iso639_1;
import org.sourceforge.kga.translation.Translation;

public class EditTranslation
extends KgaAction {
    private static Logger log = Logger.getLogger(Garden.class.getName());
    Set<String> languages;
    JComboBox<Iso639_1.Language> comboLanguage = null;
    TranslationTableModel model = null;
    JDialog dialog = null;
    JCheckBox checkOnlyMissing = null;
    JButton buttonNewLanguage = null;

    public EditTranslation(Gui gui) {
        super(gui, Translation.getPreferred().action_edit_translation());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.buttonNewLanguage) {
            Object[] objectArray = Iso639_1.getLanguages();
            Iso639_1.Language language = (Iso639_1.Language)JOptionPane.showInputDialog(this.dialog, Translation.getPreferred().new_language(), Translation.getPreferred().new_language(), -1, null, objectArray, 0);
            if (language != null) {
                int n;
                for (n = 0; n < this.comboLanguage.getItemCount(); ++n) {
                    if (this.comboLanguage.getItemAt(n) != language) continue;
                    this.comboLanguage.setSelectedIndex(n);
                    break;
                }
                if (n == this.comboLanguage.getItemCount()) {
                    Translation.addTranslation(language.code);
                    for (Iso639_1.Language jButton : Translation.getLanguageItems()) {
                        this.comboLanguage.addItem(jButton);
                        if (!jButton.code.equals(language.code)) continue;
                        this.comboLanguage.setSelectedItem(jButton);
                    }
                }
            }
            return;
        }
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridLayout(2, 1));
        this.checkOnlyMissing = new JCheckBox(Translation.getPreferred().only_missing_translations());
        this.checkOnlyMissing.setSelected(true);
        this.checkOnlyMissing.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                log.info(EditTranslation.this.model == null ? "model null" : "model created");
                if (EditTranslation.this.model == null) {
                    return;
                }
                EditTranslation.this.model.setOnlyMissing(EditTranslation.this.checkOnlyMissing.isSelected());
            }
        });
        this.comboLanguage = new JComboBox();
        this.comboLanguage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                log.info(EditTranslation.this.model == null ? "model null" : "model created");
                if (EditTranslation.this.model == null) {
                    return;
                }
                EditTranslation.this.model.setLanguage(((Iso639_1.Language)EditTranslation.this.comboLanguage.getSelectedItem()).code);
            }
        });
        for (Iso639_1.Language object2 : Translation.getLanguageItems()) {
            this.comboLanguage.addItem(object2);
            if (!object2.code.equals(Translation.getPreferred().getLanguage())) continue;
            this.comboLanguage.setSelectedItem(object2);
        }
        jPanel2.add(this.comboLanguage);
        jPanel2.add(this.checkOnlyMissing);
        jPanel.add((Component)jPanel2, "North");
        this.model = new TranslationTableModel(Translation.getPreferred().getLanguage());
        JTable jTable = new JTable(this.model);
        jTable.setDefaultRenderer(String.class, new TranslationChangedCellRenderer(jTable.getDefaultRenderer(String.class)));
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jPanel.add((Component)jScrollPane, "Center");
        this.buttonNewLanguage = new JButton();
        JButton jButton = new JButton(Translation.getPreferred().action_export_translation());
        jButton.setAction(new ExportTranslation(this.getGui()));
        this.buttonNewLanguage.setAction(this);
        this.buttonNewLanguage.setText(Translation.getPreferred().new_language());
        this.dialog = new JOptionPane(jPanel, -1, 0, null, new JButton[]{this.buttonNewLanguage, jButton}).createDialog(Translation.getPreferred().action_edit_translation());
        Gui.makeWindowBoundsPersistent(this.dialog, "EditTranslation", false);
        this.dialog.setVisible(true);
        this.getGui().resetGui();
    }

    class TranslationChangedCellRenderer
    implements TableCellRenderer {
        TableCellRenderer renderer;

        public TranslationChangedCellRenderer(TableCellRenderer tableCellRenderer) {
            this.renderer = tableCellRenderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JComponent jComponent = (JComponent)this.renderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            TranslationTableModel translationTableModel = (TranslationTableModel)jTable.getModel();
            TranslationTableModel.ChangeType changeType = translationTableModel.isChangedAt(n, n2);
            if (changeType == TranslationTableModel.ChangeType.CUSTOM_TRANSLATION) {
                jComponent.setForeground(new Color(255, 0, 0));
            } else if (changeType == TranslationTableModel.ChangeType.MISSING_TRANSLATION) {
                jComponent.setForeground(new Color(255, 192, 192));
            } else {
                jComponent.setForeground(Color.BLACK);
            }
            if (translationTableModel.getKeys().size() == n || translationTableModel.getKeys().size() + translationTableModel.getFamilies().size() == n || translationTableModel.getKeys().size() + translationTableModel.getFamilies().size() + translationTableModel.getSpecies().size() == n) {
                jComponent.setBorder(BorderFactory.createMatteBorder(2, 0, 0, 0, Color.BLACK));
            }
            return jComponent;
        }
    }

    public static class TranslationTableModel
    extends AbstractTableModel {
        String language;
        boolean onlyMissing;
        ArrayList<Translation.Key> keys = new ArrayList();
        ArrayList<Plant> families = new ArrayList();
        ArrayList<Plant> species = new ArrayList();
        ArrayList<Animal> animals = new ArrayList();

        public TranslationTableModel(String string) {
            this.language = string;
            this.onlyMissing = true;
            this.loadKeys();
        }

        public void setLanguage(String string) {
            log.info("Edit language " + string);
            this.language = string;
            this.loadKeys();
        }

        public void setOnlyMissing(boolean bl) {
            this.onlyMissing = bl;
            this.loadKeys();
        }

        public ArrayList<Translation.Key> getKeys() {
            return this.keys;
        }

        public ArrayList<Plant> getFamilies() {
            return this.families;
        }

        public ArrayList<Plant> getSpecies() {
            return this.species;
        }

        public ArrayList<Animal> getAnimals() {
            return this.animals;
        }

        private void loadKeys() {
            Translation translation = Translation.getTranslation(this.language);
            this.keys.clear();
            for (Translation.Key key : Translation.Key.values()) {
                if (this.onlyMissing && translation.getCustomTranslations().getProperty(key.toString()) == null && translation.getDefaultTranslation(key) != null) continue;
                this.keys.add(key);
            }
            this.families.clear();
            this.species.clear();
            for (Plant plant : PlantList.getResources().getPlants()) {
                if (plant.getTranslation("en") == null || this.onlyMissing && translation.getCustomTranslations().getProperty(plant.getName()) == null && translation.getDefaultTranslation(plant) != null) continue;
                (plant.getType() == Taxon.Type.FAMILY ? this.families : this.species).add(plant);
            }
            this.animals.clear();
            for (Animal animal : PlantList.getResources().getAnimals()) {
                if (animal.getTranslation("en") == null || this.onlyMissing && translation.getCustomTranslations().getProperty(animal.getName()) == null && translation.getDefaultTranslation(animal) != null) continue;
                this.animals.add(animal);
            }
            this.fireTableStructureChanged();
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            return this.keys.size() + this.families.size() + this.species.size() + this.animals.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "ID";
                }
                case 1: {
                    return Iso639_1.getLanguageName("en");
                }
                case 2: {
                    return Iso639_1.getLanguageName(this.language);
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 2;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n < this.keys.size()) {
                switch (n2) {
                    case 0: {
                        return this.keys.get(n);
                    }
                    case 1: {
                        return Translation.getTranslation("en").translate(this.keys.get(n));
                    }
                    case 2: {
                        return Translation.getTranslation(this.language).translate(this.keys.get(n));
                    }
                }
                return null;
            }
            if ((n -= this.keys.size()) < this.families.size()) {
                switch (n2) {
                    case 0: {
                        return this.families.get(n).getName();
                    }
                    case 1: {
                        return this.families.get(n).getTranslation("en");
                    }
                    case 2: {
                        return Translation.getTranslation(this.language).translate(this.families.get(n));
                    }
                }
                return null;
            }
            if ((n -= this.families.size()) < this.species.size()) {
                switch (n2) {
                    case 0: {
                        return this.species.get(n).getName();
                    }
                    case 1: {
                        return this.species.get(n).getTranslation("en");
                    }
                    case 2: {
                        return Translation.getTranslation(this.language).translate(this.species.get(n));
                    }
                }
                return null;
            }
            if ((n -= this.species.size()) < this.animals.size()) {
                switch (n2) {
                    case 0: {
                        return this.animals.get(n).getName();
                    }
                    case 1: {
                        return this.animals.get(n).getTranslation("en");
                    }
                    case 2: {
                        return Translation.getTranslation(this.language).translate(this.animals.get(n));
                    }
                }
                return null;
            }
            return "";
        }

        public ChangeType isChangedAt(int n, int n2) {
            if (n2 < 2) {
                return ChangeType.NOT_CHANGED;
            }
            Translation translation = Translation.getTranslation(this.language);
            if (translation.getCustomTranslations().getProperty(this.getValueAt(n, 0).toString()) != null) {
                return ChangeType.CUSTOM_TRANSLATION;
            }
            if (n < this.keys.size()) {
                if (translation.getDefaultTranslation(this.keys.get(n)) == null) {
                    return ChangeType.MISSING_TRANSLATION;
                }
                return ChangeType.NOT_CHANGED;
            }
            if ((n -= this.keys.size()) < this.families.size()) {
                if (translation.getDefaultTranslation(this.families.get(n)) == null) {
                    return ChangeType.MISSING_TRANSLATION;
                }
                return ChangeType.NOT_CHANGED;
            }
            if ((n -= this.families.size()) < this.species.size()) {
                if (translation.getDefaultTranslation(this.species.get(n)) == null) {
                    return ChangeType.MISSING_TRANSLATION;
                }
                return ChangeType.NOT_CHANGED;
            }
            if ((n -= this.species.size()) < this.animals.size()) {
                if (translation.getDefaultTranslation(this.animals.get(n)) == null) {
                    return ChangeType.MISSING_TRANSLATION;
                }
                return ChangeType.NOT_CHANGED;
            }
            return ChangeType.NOT_CHANGED;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 != 2) {
                return;
            }
            if (n < this.keys.size()) {
                Translation.getTranslation(this.language).setTranslation(this.keys.get(n).toString(), object.toString());
                return;
            }
            if ((n -= this.keys.size()) < this.families.size()) {
                Translation.getTranslation(this.language).setTranslation(this.families.get(n), object.toString());
                return;
            }
            if ((n -= this.families.size()) < this.species.size()) {
                Translation.getTranslation(this.language).setTranslation(this.species.get(n), object.toString());
                return;
            }
            if ((n -= this.species.size()) < this.animals.size()) {
                Translation.getTranslation(this.language).setTranslation(this.animals.get(n), object.toString());
            }
        }

        public static enum ChangeType {
            NOT_CHANGED,
            MISSING_TRANSLATION,
            CUSTOM_TRANSLATION;

        }
    }
}

