/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.kga.gui.desktop.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import org.sourceforge.kga.Garden;
import org.sourceforge.kga.Plant;
import org.sourceforge.kga.PlantList;
import org.sourceforge.kga.Point;
import org.sourceforge.kga.SeedList;
import org.sourceforge.kga.gui.desktop.Gui;
import org.sourceforge.kga.gui.desktop.PlantComponent;
import org.sourceforge.kga.gui.desktop.SeedFileWithChanges;
import org.sourceforge.kga.translation.Translation;

public class SeedManagerAutogenerate
extends AbstractAction {
    JDialog parent;
    SeedFileWithChanges seedFile;
    LocalDate workingDate;
    DateTimeFormatter dateFormatter = DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM);
    private static Logger log = Logger.getLogger(Garden.class.getName());
    final String prefPath = "/org/sourceforge/kga/gui/seedManager/autogenerate";
    JDialog dialog;
    JTable tableSpecies = new JTable();
    JButton buttonSkip = new JButton();
    JButton buttonDontSkip = new JButton();
    JButton buttonOk = new JButton();
    JButton buttonCancel = new JButton();
    ArrayList<SeedList.Entry.PlantOrUnregistered> toBuy = new ArrayList();
    TreeSet<SeedList.Entry.PlantOrUnregistered> toSkip = new TreeSet<SeedList.Entry.PlantOrUnregistered>(new SeedList.PlantOrUnregisteredComparatorByName());

    public SeedManagerAutogenerate(JDialog jDialog, SeedFileWithChanges seedFileWithChanges, LocalDate localDate) {
        this.parent = jDialog;
        this.seedFile = seedFileWithChanges;
        this.workingDate = localDate;
        this.createComponents();
    }

    private void enableSkipButtons() {
        boolean bl = false;
        boolean bl2 = false;
        for (int n : this.tableSpecies.getSelectedRows()) {
            if (this.toSkip.contains(this.toBuy.get(n))) {
                bl2 = true;
            } else {
                bl = true;
            }
            if (bl && bl2) break;
        }
        this.buttonSkip.setEnabled(bl);
        this.buttonDontSkip.setEnabled(bl2);
    }

    private void createComponents() {
        this.buttonSkip.addActionListener(this);
        this.buttonDontSkip.addActionListener(this);
        this.buttonOk.addActionListener(this);
        this.buttonCancel.addActionListener(this);
        this.enableSkipButtons();
        this.tableSpecies.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                SeedManagerAutogenerate.this.enableSkipButtons();
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.tableSpecies);
        Preferences preferences = Preferences.userRoot().node("/org/sourceforge/kga/gui/seedManager/autogenerate");
        for (String string : preferences.get("skip", "").split(":")) {
            if (string.isEmpty()) continue;
            if (!string.startsWith("'")) {
                Plant plant = PlantList.getResources().getPlant(Integer.parseInt(string));
                this.toSkip.add(new SeedList.Entry.PlantOrUnregistered(plant));
                continue;
            }
            if (!string.endsWith("'")) continue;
            this.toSkip.add(new SeedList.Entry.PlantOrUnregistered(string.substring(1, string.length() - 1)));
        }
        this.dialog = new JOptionPane(jScrollPane, -1, 0, null, new JButton[]{this.buttonSkip, this.buttonDontSkip, this.buttonOk, this.buttonCancel}).createDialog(Translation.getPreferred().action_seed_manager());
        Gui.makeWindowBoundsPersistent(this.dialog, "/org/sourceforge/kga/gui/seedManager/autogenerate", false);
    }

    public int fromGarden(Garden garden) {
        Integer[] integerArray = garden.getYears().toArray(new Integer[0]);
        if (integerArray.length == 0) {
            return 2;
        }
        Translation translation = Translation.getPreferred();
        JLabel jLabel = new JLabel(translation.year());
        JComboBox<Integer> jComboBox = new JComboBox<Integer>(integerArray);
        jComboBox.setSelectedIndex(jComboBox.getItemCount() - 1);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(jLabel);
        jPanel.add(jComboBox);
        int n = JOptionPane.showConfirmDialog(this.dialog, jPanel, translation.seed_manager_options(), 2, -1);
        if (n != 0) {
            return n;
        }
        HashMap<Point, List<Plant>> hashMap = garden.getAllSquares().get(jComboBox.getSelectedItem());
        TreeSet<SeedList.Entry.PlantOrUnregistered> treeSet = new TreeSet<SeedList.Entry.PlantOrUnregistered>(new SeedList.PlantOrUnregisteredComparatorByName());
        for (List<Plant> list : hashMap.values()) {
            if (list == null) continue;
            for (Plant plant : list) {
                if (plant.isItem()) continue;
                treeSet.add(new SeedList.Entry.PlantOrUnregistered(plant));
            }
        }
        this.removeExisting(treeSet);
        this.toBuy.addAll(treeSet);
        this.loadDataToTable();
        return 0;
    }

    private void removeExisting(TreeSet<SeedList.Entry.PlantOrUnregistered> treeSet) {
        for (SeedList seedList : new SeedList[]{this.seedFile.getSeedInventory(), this.seedFile.getSeedShoppingList()}) {
            for (SeedList.Entry entry : seedList.getFilteredEntries()) {
                treeSet.remove(entry.getPlant());
            }
        }
    }

    public int fromInventory() {
        TreeSet<SeedList.Entry.PlantOrUnregistered> treeSet = new TreeSet<SeedList.Entry.PlantOrUnregistered>(new SeedList.PlantOrUnregisteredComparatorByName());
        for (SeedList.Entry entry : this.seedFile.getSeedInventory().getAllEntries()) {
            treeSet.add(entry.getPlant());
        }
        log.info("toBuy1 size=" + treeSet.size());
        this.removeExisting(treeSet);
        log.info("toBuy2 size=" + treeSet.size());
        this.toBuy.addAll(treeSet);
        log.info("toBuy3 size=" + this.toBuy.size());
        this.loadDataToTable();
        return 0;
    }

    private void loadDataToTable() {
        this.tableSpecies.setModel(new AbstractTableModel(){

            @Override
            public int getRowCount() {
                return SeedManagerAutogenerate.this.toBuy.size();
            }

            @Override
            public int getColumnCount() {
                return 1;
            }

            @Override
            public Object getValueAt(int n, int n2) {
                return SeedManagerAutogenerate.this.toBuy.get(n);
            }

            @Override
            public String getColumnName(int n) {
                Translation translation = Translation.getPreferred();
                return translation.name();
            }

            @Override
            public Class<?> getColumnClass(int n) {
                return SeedList.Entry.PlantOrUnregistered.class;
            }
        });
        this.tableSpecies.setDefaultRenderer(SeedList.Entry.PlantOrUnregistered.class, new PlantColumnRenderer());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.buttonSkip) {
            for (int n : this.tableSpecies.getSelectedRows()) {
                this.toSkip.add(this.toBuy.get(n));
            }
            this.tableSpecies.repaint();
            this.enableSkipButtons();
        } else if (actionEvent.getSource() == this.buttonDontSkip) {
            for (int n : this.tableSpecies.getSelectedRows()) {
                this.toSkip.remove(this.toBuy.get(n));
            }
            this.tableSpecies.repaint();
            this.enableSkipButtons();
        } else if (actionEvent.getSource() == this.buttonOk) {
            for (SeedList.Entry.PlantOrUnregistered plantOrUnregistered : this.toBuy) {
                if (this.toSkip.contains(plantOrUnregistered)) continue;
                this.seedFile.getSeedShoppingList().add(plantOrUnregistered, null, null, null, this.workingDate, null);
            }
            this.dialog.setVisible(false);
        } else if (actionEvent.getSource() == this.buttonCancel) {
            this.dialog.setVisible(false);
        } else {
            Translation translation = Translation.getPreferred();
            this.buttonSkip.setText(translation.skip());
            this.buttonDontSkip.setText(translation.dont_skip());
            this.buttonOk.setText(translation.ok());
            this.buttonCancel.setText(translation.cancel());
            this.dialog.setTitle(translation.seed_manager_autogenerate());
            this.dialog.setVisible(true);
            StringBuilder stringBuilder = new StringBuilder();
            for (SeedList.Entry.PlantOrUnregistered plantOrUnregistered : this.toSkip) {
                if (stringBuilder.length() != 0) {
                    stringBuilder.append(":");
                }
                if (plantOrUnregistered.plant != null) {
                    stringBuilder.append(plantOrUnregistered.plant.getId());
                    continue;
                }
                stringBuilder.append("'");
                stringBuilder.append(plantOrUnregistered.unregisteredPlant);
                stringBuilder.append("'");
            }
            Preferences preferences = Preferences.userRoot().node("/org/sourceforge/kga/gui/seedManager/autogenerate");
            preferences.put("skip", stringBuilder.toString());
        }
    }

    public class PlantColumnRenderer
    extends PlantComponent
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        public PlantColumnRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            SeedList.Entry.PlantOrUnregistered plantOrUnregistered = (SeedList.Entry.PlantOrUnregistered)object;
            if (plantOrUnregistered.plant != null) {
                this.setPlant(plantOrUnregistered.plant);
            } else {
                this.setIcon(null);
                this.setText(plantOrUnregistered.unregisteredPlant);
                this.setToolTipText(null);
            }
            this.setSelected(bl);
            if (SeedManagerAutogenerate.this.toSkip.contains(plantOrUnregistered)) {
                this.setText("<html><strike><i>" + this.getText() + "</i><stike></html");
            }
            return this;
        }
    }
}

