/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.kga.gui.desktop.actions;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import org.sourceforge.kga.SeedList;
import org.sourceforge.kga.gui.desktop.Gui;
import org.sourceforge.kga.gui.desktop.SeedFileWithChanges;
import org.sourceforge.kga.gui.desktop.actions.PrintSetup;
import org.sourceforge.kga.translation.Translation;

public class SeedManagerPrintPreview
extends AbstractAction
implements Printable,
AdjustmentListener {
    JDialog parent;
    SeedFileWithChanges seedFile;
    LocalDate workingDate;
    DateTimeFormatter dateFormatter = DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM);
    final String prefPath = "/org/sourceforge/kga/gui/seedManager/printPreview";
    JDialog dialog;
    JButton buttonSetup = new JButton();
    JCheckBox checkInventory = new JCheckBox();
    JCheckBox checkShoppingList = new JCheckBox();
    JCheckBox checkListOnDifferentPage = new JCheckBox();
    JCheckBox checkIcons = new JCheckBox();
    JCheckBox checkVariety = new JCheckBox();
    JCheckBox checkQuantity = new JCheckBox();
    JCheckBox checkComment = new JCheckBox();
    JCheckBox checkValidFrom = new JCheckBox();
    JCheckBox checkValidTo = new JCheckBox();
    JCheckBox checkGrid = new JCheckBox();
    JButton buttonPrint = new JButton();
    JButton buttonCancel = new JButton();
    JLabel labelImage = new JLabel();
    JPanel panel = new JPanel();
    JScrollBar scrollPage = new JScrollBar(1);
    final int BORDER_SIZE = 20;
    final int PREVIEW_MAX_SIZE = 400;
    int entryPrintedFieldsCount = 1;
    int CELL_PADDING = 2;
    int COLUMN_SPACING = 30;
    Font titleFont = new Font("SansSerif", 1, 20);
    Font subtitleFont = new Font("SansSerif", 1, 16);
    Font headerFont = new Font("SansSerif", 1, 12);
    Font entryFont = new Font("SansSerif", 0, 12);
    int[] maxWidths = null;
    int columnWidth;
    int columnsCount = 0;
    int currentPage = 0;
    int pageToPrint = 0;
    boolean pagePrinted = false;

    public SeedManagerPrintPreview(JDialog jDialog, SeedFileWithChanges seedFileWithChanges, LocalDate localDate) {
        this.parent = jDialog;
        this.seedFile = seedFileWithChanges;
        this.workingDate = localDate;
        this.createComponents();
    }

    private void createComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(this.buttonPrint);
        jPanel.add(this.buttonCancel);
        jPanel.setAlignmentX(0.0f);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.add(this.buttonSetup);
        jPanel2.add(this.checkInventory);
        jPanel2.add(this.checkShoppingList);
        jPanel2.add(this.checkListOnDifferentPage);
        jPanel2.add(this.checkIcons);
        jPanel2.add(this.checkVariety);
        jPanel2.add(this.checkQuantity);
        jPanel2.add(this.checkComment);
        jPanel2.add(this.checkValidFrom);
        jPanel2.add(this.checkValidTo);
        jPanel2.add(this.checkGrid);
        jPanel2.add(jPanel);
        this.buttonSetup.addActionListener(this);
        this.checkInventory.addActionListener(this);
        this.checkShoppingList.addActionListener(this);
        this.checkListOnDifferentPage.addActionListener(this);
        this.checkIcons.addActionListener(this);
        this.checkVariety.addActionListener(this);
        this.checkQuantity.addActionListener(this);
        this.checkComment.addActionListener(this);
        this.checkValidFrom.addActionListener(this);
        this.checkValidTo.addActionListener(this);
        this.checkGrid.addActionListener(this);
        this.buttonPrint.addActionListener(this);
        this.buttonCancel.addActionListener(this);
        this.labelImage.setBorder(BorderFactory.createEtchedBorder(0));
        this.scrollPage.setMinimum(0);
        this.scrollPage.setVisibleAmount(1);
        this.scrollPage.setBlockIncrement(1);
        this.scrollPage.setUnitIncrement(1);
        this.scrollPage.addAdjustmentListener(this);
        this.loadPreferences();
        this.panel.setLayout(new BorderLayout());
        this.panel.add((Component)jPanel2, "West");
        this.panel.add((Component)this.labelImage, "Center");
        this.panel.add((Component)this.scrollPage, "East");
        this.panel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.dialog = new JDialog((Window)this.parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.dialog.setContentPane(this.panel);
        Gui.makeWindowBoundsPersistent(this.dialog, "/org/sourceforge/kga/gui/seedManager/printPreview", false);
    }

    void loadPreferences() {
        Preferences preferences = Preferences.userRoot().node("/org/sourceforge/kga/gui/seedManager/printPreview");
        this.checkInventory.setSelected(preferences.getBoolean("Inventory", true));
        this.checkShoppingList.setSelected(preferences.getBoolean("ShoppingList", true));
        this.checkListOnDifferentPage.setSelected(preferences.getBoolean("ListOnDifferentPage", false));
        this.checkIcons.setSelected(preferences.getBoolean("Icons", false));
        this.checkVariety.setSelected(preferences.getBoolean("Variety", true));
        this.checkQuantity.setSelected(preferences.getBoolean("Quantity", false));
        this.checkComment.setSelected(preferences.getBoolean("Comment", false));
        this.checkValidFrom.setSelected(preferences.getBoolean("ValidFrom", false));
        this.checkValidTo.setSelected(preferences.getBoolean("ValidTo", false));
        this.checkGrid.setSelected(preferences.getBoolean("Grid", false));
    }

    void savePreferences() {
        Preferences preferences = Preferences.userRoot().node("/org/sourceforge/kga/gui/seedManager/printPreview");
        preferences.putBoolean("Inventory", this.checkInventory.isSelected());
        preferences.putBoolean("ShoppingList", this.checkShoppingList.isSelected());
        preferences.putBoolean("ListOnDifferentPage", this.checkListOnDifferentPage.isSelected());
        preferences.putBoolean("Icons", this.checkIcons.isSelected());
        preferences.putBoolean("Variety", this.checkVariety.isSelected());
        preferences.putBoolean("Quantity", this.checkQuantity.isSelected());
        preferences.putBoolean("Comment", this.checkComment.isSelected());
        preferences.putBoolean("ValidFrom", this.checkValidFrom.isSelected());
        preferences.putBoolean("ValidTo", this.checkValidTo.isSelected());
        preferences.putBoolean("Grid", this.checkGrid.isSelected());
    }

    void createImage() {
        PageFormat pageFormat = PrintSetup.pageFormat;
        int n = (int)pageFormat.getWidth();
        int n2 = (int)pageFormat.getHeight();
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, n, n2);
        graphics.setColor(Color.BLACK);
        try {
            this.print(graphics, pageFormat, this.scrollPage.getValue());
        }
        catch (PrinterException printerException) {
            printerException.printStackTrace();
        }
        double d = Math.min(400.0 / (double)n, 400.0 / (double)n2);
        Image image = bufferedImage.getScaledInstance((int)((double)n * d), (int)((double)n2 * d), 4);
        this.labelImage.setIcon(new ImageIcon(image));
    }

    void createPreview() {
        this.maxWidths = null;
        PageFormat pageFormat = PrintSetup.pageFormat;
        int n = 0;
        try {
            n = this.getNumberOfPages(pageFormat);
        }
        catch (PrinterException printerException) {
            printerException.printStackTrace();
        }
        this.scrollPage.setMaximum(n);
        this.scrollPage.setVisible(n > 1);
        this.createImage();
        this.dialog.pack();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Translation translation = Translation.getPreferred();
        if (actionEvent.getSource() == this.buttonSetup) {
            PrintSetup.pageFormat = PrintSetup.printerJob.pageDialog(PrintSetup.pageFormat);
            this.createPreview();
        } else if (actionEvent.getSource().getClass() == JCheckBox.class) {
            if (actionEvent.getSource() == this.checkInventory && !this.checkInventory.isSelected()) {
                this.checkShoppingList.setSelected(true);
            } else if (actionEvent.getSource() == this.checkShoppingList && !this.checkShoppingList.isSelected()) {
                this.checkInventory.setSelected(true);
            }
            this.checkListOnDifferentPage.setEnabled(this.checkInventory.isSelected() && this.checkShoppingList.isSelected());
            this.createPreview();
        } else if (actionEvent.getSource() == this.buttonPrint) {
            this.dialog.setVisible(false);
            try {
                Book book = new Book();
                book.append(this, PrintSetup.pageFormat, this.getNumberOfPages(PrintSetup.pageFormat));
                PrintSetup.printerJob.setPageable(book);
                boolean bl = PrintSetup.printerJob.printDialog();
                if (bl) {
                    PrintSetup.printerJob.print();
                }
            }
            catch (PrinterException printerException) {
                JOptionPane.showMessageDialog(this.parent, printerException.toString(), translation.error_print(), 0);
            }
        } else if (actionEvent.getSource() == this.buttonCancel) {
            this.dialog.setVisible(false);
        } else {
            this.dialog.setTitle(translation.action_print());
            this.buttonSetup.setText(translation.action_print_setup());
            this.checkInventory.setText(translation.seed_manager_inventory());
            this.checkShoppingList.setText(translation.seed_manager_shopping_list());
            this.checkListOnDifferentPage.setText(translation.seed_manager_different_page());
            this.checkIcons.setText(translation.image());
            this.checkVariety.setText(translation.variety());
            this.checkQuantity.setText(translation.quantity());
            this.checkComment.setText(translation.comment());
            this.checkValidFrom.setText(translation.valid_from());
            this.checkValidTo.setText(translation.valid_to());
            this.checkGrid.setText(translation.grid());
            this.buttonPrint.setText(translation.action_print());
            this.buttonCancel.setText(translation.cancel());
            this.createPreview();
            this.dialog.setVisible(true);
            this.savePreferences();
        }
    }

    private int getStringWidth(Font font, String string) {
        AffineTransform affineTransform = new AffineTransform();
        FontRenderContext fontRenderContext = new FontRenderContext(affineTransform, true, false);
        return (int)font.getStringBounds(string, fontRenderContext).getWidth();
    }

    private int getFontAscent(Font font) {
        AffineTransform affineTransform = new AffineTransform();
        FontRenderContext fontRenderContext = new FontRenderContext(affineTransform, true, true);
        return (int)font.getLineMetrics("", 0, 0, fontRenderContext).getAscent();
    }

    private int getFontHeight(Font font) {
        AffineTransform affineTransform = new AffineTransform();
        FontRenderContext fontRenderContext = new FontRenderContext(affineTransform, true, true);
        return (int)font.getLineMetrics("", 0, 0, fontRenderContext).getHeight();
    }

    private String quantityToString(SeedList.Entry.Quantity quantity) {
        if (quantity == null || quantity.quantity == 0.0) {
            return "";
        }
        String string = Double.toString(quantity.quantity);
        if (!quantity.unit.isEmpty()) {
            string = string + " " + quantity.unit;
        }
        return string;
    }

    private void printString(Graphics2D graphics2D, String string, Point point, Font font) {
        int n = this.getFontHeight(font);
        if (this.currentPage == this.pageToPrint) {
            this.pagePrinted = true;
            int n2 = this.getFontAscent(font);
            graphics2D.setFont(font);
            graphics2D.drawString(string, point.x, point.y + n2);
        }
        point.y += n;
    }

    private int[] getEntryWidth(SeedList.Entry entry) {
        int[] nArray = new int[this.entryPrintedFieldsCount];
        nArray[0] = this.getStringWidth(this.entryFont, entry.getPlantName(this.checkVariety.isSelected()));
        if (this.checkIcons.isSelected() && entry.getPlant().plant != null) {
            nArray[0] = nArray[0] + (this.getFontHeight(this.entryFont) - this.CELL_PADDING);
        }
        int n = 1;
        if (this.checkQuantity.isSelected()) {
            nArray[n] = this.getStringWidth(this.entryFont, this.quantityToString(entry.getQuantity()));
            ++n;
        }
        if (this.checkComment.isSelected()) {
            if (entry.getComment() != null) {
                nArray[n] = this.getStringWidth(this.entryFont, entry.getComment());
            }
            ++n;
        }
        if (this.checkValidFrom.isSelected() || this.checkValidTo.isSelected()) {
            nArray[n] = this.getStringWidth(this.entryFont, this.getValidFromTo(entry));
            ++n;
        }
        return nArray;
    }

    private void printGrid(Graphics2D graphics2D, Point point, int n) {
        if (this.checkGrid.isSelected() && this.currentPage == this.pageToPrint) {
            Point point2 = new Point(point);
            graphics2D.setColor(Color.LIGHT_GRAY);
            for (int i = 0; i < this.entryPrintedFieldsCount; ++i) {
                graphics2D.drawRect(point2.x, point2.y, this.maxWidths[i], n);
                point2.x += this.maxWidths[i];
            }
            graphics2D.setColor(Color.BLACK);
        }
    }

    private String getValidFromToHeader() {
        Translation translation = Translation.getPreferred();
        String string = "";
        if (this.checkValidFrom.isSelected()) {
            string = string + translation.valid_from();
        }
        if (this.checkValidTo.isSelected()) {
            if (this.checkValidFrom.isSelected()) {
                string = string + " - ";
            }
            string = string + translation.valid_to();
        }
        return string;
    }

    private void printHeader(Graphics2D graphics2D, Point point) {
        if (this.entryPrintedFieldsCount == 1) {
            return;
        }
        int n = this.getFontHeight(this.headerFont);
        if (this.currentPage == this.pageToPrint) {
            this.printGrid(graphics2D, point, n);
            int n2 = this.getFontAscent(this.headerFont);
            Translation translation = Translation.getPreferred();
            Point point2 = new Point(point);
            if (this.checkGrid.isSelected()) {
                point2.x += this.CELL_PADDING;
            }
            graphics2D.setFont(this.headerFont);
            graphics2D.drawString(translation.species(), point2.x, point2.y + n2);
            point2.x += this.maxWidths[0];
            int n3 = 1;
            if (this.checkQuantity.isSelected()) {
                graphics2D.drawString(translation.quantity(), point2.x, point2.y + n2);
                point2.x += this.maxWidths[n3];
                ++n3;
            }
            if (this.checkComment.isSelected()) {
                graphics2D.drawString(translation.comment(), point2.x, point2.y + n2);
                point2.x += this.maxWidths[n3];
                ++n3;
            }
            if (this.checkValidFrom.isSelected() || this.checkValidTo.isSelected()) {
                graphics2D.drawString(this.getValidFromToHeader(), point2.x, point2.y + n2);
                ++n3;
            }
        }
        point.y += n;
    }

    private String getValidFromTo(SeedList.Entry entry) {
        String string = "";
        if (this.checkValidFrom.isSelected()) {
            string = string + entry.getValidFrom().format(this.dateFormatter);
        }
        if (this.checkValidTo.isSelected() && entry.getValidTo() != null) {
            if (this.checkValidFrom.isSelected()) {
                string = string + " - ";
            }
            string = string + entry.getValidTo().format(this.dateFormatter);
        }
        return string;
    }

    private void printEntry(Graphics2D graphics2D, SeedList.Entry entry, Point point) {
        int n = this.getFontHeight(this.entryFont);
        if (this.currentPage == this.pageToPrint) {
            int n2;
            this.pagePrinted = true;
            int n3 = this.getFontAscent(this.entryFont);
            graphics2D.setFont(this.entryFont);
            this.printGrid(graphics2D, point, n);
            Point point2 = new Point(point);
            if (this.checkGrid.isSelected()) {
                point2.x += this.CELL_PADDING;
            }
            if (this.checkIcons.isSelected() && entry.getPlant().plant != null) {
                n2 = this.getFontHeight(this.entryFont) - 2 * this.CELL_PADDING;
                graphics2D.drawImage(entry.getPlant().plant.getImage().get(), point2.x, point2.y, n2, n2, null);
                graphics2D.drawString(entry.getPlantName(this.checkVariety.isSelected()), point2.x + n2 + this.CELL_PADDING, point2.y + n3);
            } else {
                graphics2D.drawString(entry.getPlantName(this.checkVariety.isSelected()), point2.x, point2.y + n3);
            }
            n2 = 1;
            point2.x += this.maxWidths[0];
            if (this.checkQuantity.isSelected()) {
                graphics2D.drawString(this.quantityToString(entry.getQuantity()), point2.x, point2.y + n3);
                point2.x += this.maxWidths[n2];
                ++n2;
            }
            if (this.checkComment.isSelected()) {
                if (entry.getComment() != null) {
                    graphics2D.drawString(entry.getComment(), point2.x, point2.y + n3);
                }
                point2.x += this.maxWidths[n2];
                ++n2;
            }
            if (this.checkValidFrom.isSelected() || this.checkValidTo.isSelected()) {
                graphics2D.drawString(this.getValidFromTo(entry), point2.x, point2.y + n3);
                point2.x += this.maxWidths[n2];
                ++n2;
            }
        }
        point.y += n;
    }

    void computeMaxWidth(Graphics2D graphics2D, PageFormat pageFormat) {
        this.entryPrintedFieldsCount = 1 + (this.checkQuantity.isSelected() ? 1 : 0) + (this.checkComment.isSelected() ? 1 : 0) + (this.checkValidFrom.isSelected() || this.checkValidTo.isSelected() ? 1 : 0);
        this.maxWidths = new int[this.entryPrintedFieldsCount];
        if (this.entryPrintedFieldsCount != 0) {
            SeedList[] seedListArray = Translation.getPreferred();
            this.maxWidths[0] = this.getStringWidth(this.headerFont, seedListArray.species());
            int n = 1;
            if (this.checkQuantity.isSelected()) {
                this.maxWidths[n] = this.getStringWidth(this.headerFont, seedListArray.quantity());
                ++n;
            }
            if (this.checkComment.isSelected()) {
                this.maxWidths[n] = this.getStringWidth(this.headerFont, seedListArray.comment());
                ++n;
            }
            if (this.checkValidFrom.isSelected() || this.checkValidTo.isSelected()) {
                this.maxWidths[n] = this.getStringWidth(this.headerFont, this.getValidFromToHeader());
                ++n;
            }
        } else {
            this.maxWidths[0] = 0;
        }
        for (SeedList seedList : new SeedList[]{this.seedFile.getSeedInventory(), this.seedFile.getSeedShoppingList()}) {
            for (SeedList.Entry entry : seedList.getFilteredEntries()) {
                int[] nArray = this.getEntryWidth(entry);
                for (int i = 0; i < this.entryPrintedFieldsCount; ++i) {
                    this.maxWidths[i] = Math.max(nArray[i], this.maxWidths[i]);
                }
            }
        }
        if (this.checkGrid.isSelected()) {
            int n = 0;
            while (n < this.entryPrintedFieldsCount) {
                int n2 = n++;
                this.maxWidths[n2] = this.maxWidths[n2] + 2 * this.CELL_PADDING;
            }
        } else if (this.entryPrintedFieldsCount > 1) {
            int n = 0;
            while (n < this.entryPrintedFieldsCount - 1) {
                int n3 = n++;
                this.maxWidths[n3] = this.maxWidths[n3] + this.CELL_PADDING;
            }
        }
        this.columnWidth = 0;
        for (int i = 0; i < this.entryPrintedFieldsCount; ++i) {
            this.columnWidth += this.maxWidths[i];
        }
        this.columnsCount = (int)((pageFormat.getImageableWidth() + (double)this.COLUMN_SPACING) / (double)(this.columnWidth + this.COLUMN_SPACING));
        if (this.columnsCount == 0) {
            this.columnsCount = 1;
        }
        if (this.columnsCount > 1) {
            this.columnWidth += (int)((pageFormat.getImageableWidth() - (double)(this.columnsCount * this.columnWidth)) / (double)(this.columnsCount - 1));
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        Translation translation = Translation.getPreferred();
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.maxWidths == null) {
            this.computeMaxWidth(graphics2D, pageFormat);
        }
        this.currentPage = 0;
        this.pageToPrint = n;
        this.pagePrinted = false;
        Point point = new Point((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY());
        int n2 = 0;
        int n3 = 0;
        ArrayList<SeedList> arrayList = new ArrayList<SeedList>();
        if (this.checkInventory.isSelected() && this.seedFile.getSeedInventory().size() != 0) {
            arrayList.add(this.seedFile.getSeedInventory());
        }
        if (this.checkShoppingList.isSelected() && this.seedFile.getSeedInventory().size() != 0) {
            arrayList.add(this.seedFile.getSeedShoppingList());
        }
        for (SeedList seedList : arrayList) {
            point.x = (int)pageFormat.getImageableX();
            if (this.checkListOnDifferentPage.isSelected() && seedList != arrayList.get(0) && point.y != (int)pageFormat.getImageableY()) {
                ++this.currentPage;
                if (this.pagePrinted) break;
                point.y = (int)pageFormat.getImageableY();
            }
            if (this.checkListOnDifferentPage.isSelected() || seedList == arrayList.get(0)) {
                this.printString(graphics2D, this.workingDate.format(this.dateFormatter), point, this.titleFont);
            }
            int n4 = point.y + this.getFontHeight(this.subtitleFont) + 2 * this.getFontHeight(this.entryFont);
            if (point.y != (int)pageFormat.getImageableY()) {
                n4 += this.getFontHeight(this.subtitleFont);
            }
            if ((double)n4 >= pageFormat.getImageableHeight() + pageFormat.getImageableY()) {
                ++this.currentPage;
                if (this.pagePrinted) break;
                point.y = (int)pageFormat.getImageableY();
            }
            if (point.y != (int)pageFormat.getImageableY()) {
                this.printString(graphics2D, "", point, this.subtitleFont);
            }
            this.printString(graphics2D, seedList == this.seedFile.getSeedInventory() ? translation.seed_manager_inventory() : translation.seed_manager_shopping_list(), point, this.subtitleFont);
            this.printString(graphics2D, "", point, this.entryFont);
            n2 = point.y;
            int n5 = 0;
            int n6 = seedList.getFilteredEntries().size();
            int n7 = n6 / this.columnsCount + (n6 % this.columnsCount == 0 ? 0 : 1);
            int n8 = 0;
            for (SeedList.Entry entry : seedList.getFilteredEntries()) {
                if (n2 == point.y) {
                    this.printHeader(graphics2D, point);
                }
                this.printEntry(graphics2D, entry, point);
                --n6;
                ++n8;
                if ((double)(point.y + this.getFontHeight(this.entryFont)) >= pageFormat.getImageableHeight() + pageFormat.getImageableY()) {
                    n3 = point.y;
                    if (++n5 >= this.columnsCount) {
                        ++this.currentPage;
                        if (this.pagePrinted) break;
                        point.x = (int)pageFormat.getImageableX();
                        n3 = point.y = (int)pageFormat.getImageableY();
                        n2 = point.y;
                        n5 = 0;
                        n7 = n6 / this.columnsCount + (n6 % this.columnsCount == 0 ? 0 : 1);
                    } else {
                        point.x += this.columnWidth;
                        point.y = n2;
                    }
                    n8 = 0;
                    continue;
                }
                if (n8 < n7) continue;
                ++n5;
                n3 = point.y;
                point.x += this.columnWidth;
                point.y = n2;
                n8 = 0;
            }
            point.y = n3;
            if (this.currentPage <= n) continue;
            break;
        }
        return this.pagePrinted ? 0 : 1;
    }

    public int getNumberOfPages(PageFormat pageFormat) throws PrinterException {
        this.print(null, pageFormat, Integer.MAX_VALUE);
        return this.currentPage + 1;
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.createImage();
    }
}

