/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.kga.gui.desktop.actions;

import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sourceforge.kga.Plant;
import org.sourceforge.kga.Point;
import org.sourceforge.kga.gui.desktop.Gui;
import org.sourceforge.kga.gui.desktop.actions.KgaAction;
import org.sourceforge.kga.translation.Translation;

public class UploadToWebVersion
extends KgaAction {
    private static final long serialVersionUID = 1L;
    private final String uploadUrl;

    public UploadToWebVersion(Gui gui) {
        this(gui, "http://smigo.org/plant/upload");
    }

    public UploadToWebVersion(Gui gui, String string) {
        super(gui, Translation.getPreferred().action_upload_to_web());
        this.uploadUrl = string;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            File file = this.getUploadFile();
            Desktop.getDesktop().open(file);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public File getUploadFile() throws IOException {
        File file = Files.createTempFile("upload", ".html", new FileAttribute[0]).toFile();
        PrintWriter printWriter = new PrintWriter(file);
        printWriter.print("<!DOCTYPE html>\n<html>\n<head lang=\"en\">\n<meta charset=\"UTF-8\">\n</head>\n<body>\n<form name=\"uploadform\" method=\"post\" action=\"" + this.uploadUrl + "\">\n");
        int n = 0;
        for (Map.Entry<Integer, HashMap<Point, List<Plant>>> entry : this.getGarden().getAllSquares().entrySet()) {
            for (Map.Entry<Point, List<Plant>> entry2 : entry.getValue().entrySet()) {
                for (Plant plant : entry2.getValue()) {
                    if (n >= 10000) continue;
                    printWriter.print("<input type=\"hidden\" name=\"plants[" + n + "].speciesId\" value=\"" + plant.getId() + "\"/>");
                    printWriter.print("<input type=\"hidden\" name=\"plants[" + n + "].year\" value=\"" + entry.getKey() + "\"/>");
                    printWriter.print("<input type=\"hidden\" name=\"plants[" + n + "].x\" value=\"" + entry2.getKey().x + "\"/>");
                    printWriter.print("<input type=\"hidden\" name=\"plants[" + n + "].y\" value=\"" + entry2.getKey().y + "\"/>");
                    ++n;
                }
            }
        }
        printWriter.print("</form>\n<h1>Loading...</h1>\n<script>\nwindow.onload = function () {\nconsole.log('a', document.getElementsByTagName('form'));\ndocument.uploadform.submit();\n}\n</script>\n</body>\n</html>");
        printWriter.flush();
        printWriter.close();
        return file;
    }
}

