/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.kga.io;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import org.sourceforge.kga.Plant;
import org.sourceforge.kga.PlantList;
import org.sourceforge.kga.io.InvalidFormatException;
import org.sourceforge.kga.io.SpeciesListFormatV1;

public class SerializableSpecies {
    private static Logger log = Logger.getLogger(Plant.class.getName());
    private transient File file = null;
    private PlantList speciesList = null;
    static SpeciesListFormatV1 v1 = new SpeciesListFormatV1();

    public SerializableSpecies() {
        this.speciesList = new PlantList();
    }

    public SerializableSpecies(InputStream inputStream) throws IOException, InvalidFormatException {
        this.speciesList = this.loadFrom(inputStream);
    }

    public SerializableSpecies(File file) throws FileNotFoundException, IOException, InvalidFormatException {
        log.info("Loading species list from " + file.getAbsolutePath());
        this.speciesList = this.loadFrom(new FileInputStream(file));
        this.file = file;
    }

    public PlantList getSpeciesList() {
        return this.speciesList;
    }

    public File getFile() {
        return this.file;
    }

    private PlantList loadFrom(InputStream inputStream) throws IOException, InvalidFormatException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[65536];
        while (inputStream.available() > 0) {
            int n = inputStream.read(byArray, 0, 65536);
            byteArrayOutputStream.write(byArray, 0, n);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        return v1.load(byteArrayInputStream);
    }

    public boolean saveToFile() throws FileNotFoundException, IOException {
        if (this.file == null) {
            return false;
        }
        this.saveToFile(this.file);
        return true;
    }

    public void saveToFile(File file) throws FileNotFoundException, IOException {
        log.info("Saving to " + file.getAbsolutePath());
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        v1.save(this.speciesList, dataOutputStream);
        dataOutputStream.close();
        this.file = file;
    }
}

