/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.kga.plant;

import java.util.HashSet;
import java.util.Set;
import org.sourceforge.kga.Plant;
import org.sourceforge.kga.PlantList;
import org.sourceforge.kga.TagList;
import org.sourceforge.kga.TagListener;
import org.sourceforge.kga.Taxon;
import org.sourceforge.kga.plant.Tag;
import org.sourceforge.kga.plant.TagInGarden;
import org.sourceforge.kga.translation.Translation;

public class NotTagged
extends Tag
implements TagListener {
    static NotTagged instance = new NotTagged();

    private NotTagged() {
        super("", null);
        TagList.getInstance().addListener(this);
    }

    @Override
    public String getName() {
        return Translation.getPreferred().not_tagged();
    }

    @Override
    public Set<Plant> getSpecies() {
        HashSet<Plant> hashSet = new HashSet<Plant>();
        for (Plant plant : PlantList.getResources().getPlants()) {
            if (plant.getType().ordinal() <= Taxon.Type.FAMILY.ordinal() || plant.getTags().size() != 0) continue;
            hashSet.add(plant);
        }
        return hashSet;
    }

    public static NotTagged getInstance() {
        return instance;
    }

    @Override
    public void tagAdded(Tag tag) {
        this.tagChanged(null);
    }

    @Override
    public void tagDeleted(Tag tag) {
        this.tagChanged(null);
    }

    @Override
    public void tagChanged(Tag tag) {
        if (tag == TagInGarden.getInstance() || tag == this) {
            return;
        }
        for (TagListener tagListener : TagList.getInstance().getListeners()) {
            if (tagListener == this) continue;
            tagListener.tagChanged(this);
        }
    }
}

