/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.kga.rules;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.sourceforge.kga.Animal;
import org.sourceforge.kga.Garden;
import org.sourceforge.kga.Plant;
import org.sourceforge.kga.Point;
import org.sourceforge.kga.plant.Companion;
import org.sourceforge.kga.plant.ReferenceList;
import org.sourceforge.kga.rules.Hint;
import org.sourceforge.kga.rules.HintList;
import org.sourceforge.kga.rules.Rule;
import org.sourceforge.kga.translation.Translation;

public class Companion
extends Rule {
    private static Logger log = Logger.getLogger(Companion.class.getName());

    @Override
    public void getHints(HintList hintList) {
        Point point;
        int n;
        Garden garden = hintList.getGarden();
        List<Plant> list = garden.getPlants(n = hintList.getYear(), point = hintList.getGrid());
        if (list == null) {
            return;
        }
        for (Plant plant : list) {
            for (org.sourceforge.kga.plant.Companion companion : plant.getCompanions().getInherited()) {
                ArrayList<Garden.FindResult> arrayList = garden.findSquare(n, point, 1, 0, 0, companion.plant, false, true);
                if (arrayList.isEmpty()) continue;
                for (Garden.FindResult findResult : arrayList) {
                    hintList.addCompanionHint(companion, plant, findResult.plant, findResult.coordinate.grid, this);
                }
            }
        }
    }

    private static void appendAnimals(StringBuilder stringBuilder, TreeSet<Animal> treeSet) {
        boolean bl = true;
        for (Animal animal : treeSet) {
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(Translation.getPreferred().translate(animal));
        }
    }

    @Override
    public String getDescription(Hint hint) {
        Translation translation = Translation.getPreferred();
        StringBuilder stringBuilder = new StringBuilder();
        org.sourceforge.kga.plant.Companion companion = hint.getCompanion();
        switch (companion.type) {
            case GOOD: {
                break;
            }
            case IMPROVE: {
                stringBuilder.append(translation.companion_improve()).append(" ");
                boolean bl = true;
                for (Companion.Improve improve : companion.improve) {
                    if (!bl) {
                        stringBuilder.append(", ");
                    }
                    bl = false;
                    stringBuilder.append(improve.translate());
                }
                break;
            }
            case BAD: {
                break;
            }
            case INHIBIT: {
                stringBuilder.append(translation.companion_inhibit()).append(" ");
                break;
            }
            case ATTRACT_PEST: {
                stringBuilder.append(translation.companion_attract_pest()).append(" ");
                break;
            }
            case REPEL_PEST: {
                stringBuilder.append(translation.companion_repel_pest()).append(" ");
                break;
            }
            case ATTRACT_BENEFICIAL: {
                stringBuilder.append(translation.companion_attract_beneficial()).append(" ");
                break;
            }
            case REPEL_BENEFICIAL: {
                stringBuilder.append(translation.companion_repel_beneficial()).append(" ");
                break;
            }
            case TRAP_PEST: {
                stringBuilder.append(translation.companion_trap_pest()).append(" ");
            }
        }
        if (companion.type.withAnimals()) {
            Companion.appendAnimals(stringBuilder, companion.animals);
        }
        return stringBuilder.toString();
    }

    @Override
    public void addReferencesToList(Hint hint, ReferenceList referenceList) {
        referenceList.add(hint.getCompanion().references);
    }
}

