/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.kga.rules;

import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.sourceforge.kga.Garden;
import org.sourceforge.kga.Plant;
import org.sourceforge.kga.Point;
import org.sourceforge.kga.plant.ReferenceList;
import org.sourceforge.kga.plant.RootDeepness;
import org.sourceforge.kga.rules.Hint;
import org.sourceforge.kga.rules.HintList;
import org.sourceforge.kga.rules.Rule;
import org.sourceforge.kga.translation.Translation;

public class RotationRootType
extends Rule {
    private static Logger log = Logger.getLogger(RotationRootType.class.getName());

    private RootComparision compareRoots(Plant plant, Plant plant2) {
        int n = (plant2.getRootDeepness().getMinimum() + plant2.getRootDeepness().getMaximum()) / 2;
        int n2 = (plant.getRootDeepness().getMinimum() + plant.getRootDeepness().getMaximum()) / 2;
        RootComparision rootComparision = new RootComparision();
        rootComparision.sameRootLevel = n > n2 / 2 && n2 > n / 2;
        rootComparision.currentIsDeeper = n2 > n;
        return rootComparision;
    }

    @Override
    public void getHints(HintList hintList) {
        Point point;
        int n;
        Garden garden = hintList.getGarden();
        List<Plant> list = garden.getPlants(n = hintList.getYear(), point = hintList.getGrid());
        if (list == null) {
            return;
        }
        List<Plant> list2 = garden.getPlants(n - 1, point);
        if (list2 == null) {
            return;
        }
        for (Plant plant : list) {
            RootDeepness rootDeepness;
            if (plant.isItem() || (rootDeepness = plant.getRootDeepness()) == null) continue;
            Plant object2 = null;
            Plant object3 = null;
            for (Plant plant2 : list2) {
                RootDeepness rootDeepness2;
                if (plant2 == plant || plant2.getFamily() == plant.getFamily() || (rootDeepness2 = plant2.getRootDeepness()) == null) continue;
                if (this.compareRoots((Plant)plant, (Plant)plant2).sameRootLevel) {
                    object3 = plant2;
                    continue;
                }
                object2 = plant2;
            }
            if ((object3 == null || object2 != null) && (object3 != null || object2 == null)) continue;
            Iterator<Plant> iterator = object3 != null ? object3 : object2;
            Hint.Value value = object3 != null ? Hint.Value.BAD : Hint.Value.GOOD;
            hintList.addRotationHint(value, plant, (Plant)((Object)iterator), n - 1, this);
        }
    }

    @Override
    public String getDescription(Hint hint) {
        Translation translation = Translation.getPreferred();
        StringBuilder stringBuilder = new StringBuilder();
        if (hint.getValue() == Hint.Value.BAD) {
            stringBuilder.append(translation.rotation_root_type_same_level()).append(" ");
            stringBuilder.append(" ( ").append(hint.getCurrentPlant().getRootDeepness().toString()).append(" ) ");
            stringBuilder.append(translation.rotation_after()).append(" ");
            stringBuilder.append(" ( ").append(hint.getNeighborPlant().getRootDeepness().toString()).append(" )");
        } else {
            boolean bl = this.compareRoots((Plant)hint.getCurrentPlant(), (Plant)hint.getNeighborPlant()).currentIsDeeper;
            stringBuilder.append(bl ? translation.rotation_root_type_deep() : translation.rotation_root_type_shallow());
            stringBuilder.append(" ( ").append(hint.getCurrentPlant().getRootDeepness().toString()).append(" ) ");
            stringBuilder.append(translation.rotation_after()).append(" ");
            stringBuilder.append(!bl ? translation.rotation_root_type_deep() : translation.rotation_root_type_shallow());
            stringBuilder.append(" ( ").append(hint.getNeighborPlant().getRootDeepness().toString()).append(" )");
        }
        return stringBuilder.toString();
    }

    @Override
    public void addReferencesToList(Hint hint, ReferenceList referenceList) {
        referenceList.add(hint.getNeighborPlant().getRootDeepness().references);
        referenceList.add(hint.getCurrentPlant().getRootDeepness().references);
    }

    class RootComparision {
        boolean sameRootLevel;
        boolean currentIsDeeper;

        RootComparision() {
        }
    }
}

