/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.kga.rules;

import java.util.ArrayList;
import java.util.logging.Logger;
import org.sourceforge.kga.Garden;
import org.sourceforge.kga.Point;
import org.sourceforge.kga.plant.ReferenceList;
import org.sourceforge.kga.rules.Companion;
import org.sourceforge.kga.rules.Hint;
import org.sourceforge.kga.rules.HintList;
import org.sourceforge.kga.rules.RotationNutritionalNeeds;
import org.sourceforge.kga.rules.RotationRepetition;
import org.sourceforge.kga.rules.RotationRootType;
import org.sourceforge.kga.rules.RotationWeedControl;
import org.sourceforge.kga.wrappers.Image;

public abstract class Rule {
    private static Logger log = Logger.getLogger(Garden.class.getName());
    public static Image GOOD;
    public static Image BAD;
    public static Image EQUAL;
    public static Image TIP;
    public static Image[][] GOOD_ARROWS;
    public static Image[][] BAD_ARROWS;
    public static final int ONE_YEAR_BACK = 1;
    public static final int CLOSEST_NEIGHBOURS = 1;
    public static final int IMAGE_SIZE = 9;
    static ArrayList<Rule> rules;

    public abstract void getHints(HintList var1);

    public abstract String getDescription(Hint var1);

    public abstract void addReferencesToList(Hint var1, ReferenceList var2);

    public ReferenceList getReferences(Hint hint) {
        ReferenceList referenceList = new ReferenceList();
        this.addReferencesToList(hint, referenceList);
        return referenceList;
    }

    public static HintList getHints(Garden garden, int n, Point point, boolean bl) {
        HintList hintList = new HintList(garden, n, point, bl);
        for (Rule rule : rules) {
            rule.getHints(hintList);
        }
        return hintList;
    }

    static {
        GOOD_ARROWS = new Image[3][3];
        BAD_ARROWS = new Image[3][3];
        rules = new ArrayList();
        rules.add(new RotationRepetition());
        rules.add(new RotationNutritionalNeeds());
        rules.add(new RotationRootType());
        rules.add(new RotationWeedControl());
        rules.add(new Companion());
    }
}

