/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.kga.translation;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.Collator;
import java.util.HashMap;
import java.util.InvalidPropertiesFormatException;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.sourceforge.kga.Garden;
import org.sourceforge.kga.Plant;
import org.sourceforge.kga.PlantList;
import org.sourceforge.kga.Taxon;
import org.sourceforge.kga.translation.Iso639_1;
import org.xml.sax.SAXParseException;

public class Translation {
    private static Logger log;
    private static Map<String, Translation> translations;
    private static Translation preferred;
    private static Properties xmlLanguages;
    private Locale locale;
    private Collator collator;
    private Properties translationsMap;
    private Properties customTranslations;
    private String author;

    public static String getLanguageFromPreferences() {
        Preferences preferences = Preferences.userRoot().node("/org/sourceforge/kga/translation");
        return preferences.get("language", "");
    }

    public static Translation getPreferred() {
        if (preferred == null) {
            preferred = translations.get("en");
        }
        return preferred;
    }

    public static void setCurrentLanguage(String string) {
        log.info("Loading translation with " + string);
        preferred = translations.get(string);
        try {
            Preferences preferences = Preferences.userRoot().node("/org/sourceforge/kga/translation");
            preferences.put("language", string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static Translation getTranslation(String string) {
        return translations.get(string);
    }

    private static Properties getXmlFromFile(String string) {
        log.info("Loading translation with " + string);
        Properties properties = new Properties();
        InputStream inputStream = null;
        try {
            inputStream = Translation.class.getResourceAsStream("/resources/translation/" + string + ".xml");
            if (inputStream == null) {
                inputStream = new FileInputStream("resources/translation/" + string + ".xml");
            }
            properties.loadFromXML(inputStream);
        }
        catch (InvalidPropertiesFormatException invalidPropertiesFormatException) {
            SAXParseException sAXParseException = (SAXParseException)invalidPropertiesFormatException.getCause();
            log.info("cause.getColumnNumber(): " + sAXParseException.getColumnNumber() + " cause.getLineNumber(): " + sAXParseException.getLineNumber() + " cause.getPublicId(): " + sAXParseException.getPublicId() + " cause.getSystemId(): " + sAXParseException.getSystemId());
            invalidPropertiesFormatException.printStackTrace();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return properties;
    }

    public static Set<String> getLanguages() {
        return translations.keySet();
    }

    public static Set<Iso639_1.Language> getLanguageItems() {
        TreeSet<Iso639_1.Language> treeSet = new TreeSet<Iso639_1.Language>();
        for (String string : Translation.getLanguages()) {
            treeSet.add(Iso639_1.getLanguage(string));
        }
        return treeSet;
    }

    public static void addTranslation(String string) {
        translations.put(string, new Translation(string, "", new Properties()));
    }

    public Translation(String string, String string2, Properties properties) {
        this.translationsMap = properties;
        this.customTranslations = new Properties();
        this.locale = new Locale(string);
        this.collator = Collator.getInstance(this.locale);
        this.author = string2;
    }

    public String getAuthor() {
        return this.author;
    }

    public boolean hasMissingTranslations() {
        for (Key key : Key.values()) {
            if (this.customTranslations.getProperty(key.toString()) != null || this.translationsMap.getProperty(key.toString()) != null) continue;
            return true;
        }
        for (Plant plant : PlantList.getResources().getPlants()) {
            if (plant.getTranslation("en") == null || plant.getTranslation(this.getLanguage()) != null || this.customTranslations.getProperty(plant.getName()) != null) continue;
            return true;
        }
        return false;
    }

    public void setCustomTranslations(Properties properties) {
        for (String string : properties.stringPropertyNames()) {
            this.setTranslation(string, properties.getProperty(string));
        }
    }

    public Properties getCustomTranslations() {
        return this.customTranslations;
    }

    public String getDefaultTranslation(Key key) {
        return this.translationsMap.getProperty(key.toString());
    }

    public String getDefaultTranslation(Taxon taxon) {
        return taxon == null ? null : taxon.getTranslation(this.getLanguage());
    }

    public String translate(Key key) {
        String string = key.toString();
        String string2 = this.customTranslations.getProperty(string);
        if (string2 == null) {
            string2 = this.translationsMap.getProperty(string);
        }
        if (string2 == null) {
            System.err.println("Cannot translate " + string);
            return string;
        }
        return string2;
    }

    public String translate(Taxon taxon) {
        if (taxon == null) {
            return "null";
        }
        String string = this.customTranslations.getProperty(taxon.getName());
        if (string == null) {
            string = taxon.getTranslation(this.getLanguage());
        }
        if (string == null) {
            string = taxon.getTranslation("en");
        }
        if (string == null) {
            string = taxon.getName();
        }
        return string;
    }

    public void setTranslation(String string, String string2) {
        String string3 = this.translationsMap.getProperty(string);
        if (string2 == null || string2.isEmpty() || string3 != null && string3.compareTo(string2) == 0) {
            this.customTranslations.remove(string);
        } else {
            this.customTranslations.setProperty(string, string2);
        }
        this.saveCustomTranslations();
    }

    public void setTranslation(Taxon taxon, String string) {
        this.customTranslations.remove(taxon.getName());
        String string2 = taxon.getTranslation(this.getLanguage());
        if (!(string == null || string.isEmpty() || string2 != null && string.compareTo(string2) == 0)) {
            this.customTranslations.setProperty(taxon.getName(), string);
        }
        this.saveCustomTranslations();
    }

    private void saveCustomTranslations() {
        Preferences preferences = Preferences.userRoot().node("/org/sourceforge/kga/translation/custom");
        if (this.customTranslations.size() == 0) {
            preferences.remove(this.getLanguage());
            return;
        }
        StringWriter stringWriter = new StringWriter();
        try {
            this.customTranslations.store(stringWriter, "");
            preferences.put(this.getLanguage(), stringWriter.toString());
        }
        catch (IOException iOException) {
            log.warning(iOException.toString());
        }
    }

    public String getLanguage() {
        return this.locale.getLanguage();
    }

    public Collator getCollator() {
        return this.collator;
    }

    public String action_about() {
        return this.translate(Key.action_about);
    }

    public String tag_add() {
        return this.translate(Key.tag_add);
    }

    public String action_check_for_update() {
        return this.translate(Key.action_check_for_update);
    }

    public String action_contact() {
        return this.translate(Key.action_contact);
    }

    public String action_edit_species() {
        return this.translate(Key.action_edit_species);
    }

    public String action_edit_translation() {
        return this.translate(Key.action_edit_translation);
    }

    public String action_exit() {
        return this.translate(Key.action_exit);
    }

    public String action_export() {
        return this.translate(Key.action_export);
    }

    public String action_export_translation() {
        return this.translate(Key.action_export_translation);
    }

    public String action_garden_statistics() {
        return this.translate(Key.action_garden_statistics);
    }

    public String action_tags() {
        return this.translate(Key.action_tags);
    }

    public String action_help() {
        return this.translate(Key.action_help);
    }

    public String action_language() {
        return this.translate(Key.action_language);
    }

    public String action_new_garden() {
        return this.translate(Key.action_new_garden);
    }

    public String action_new_seed_list() {
        return this.translate(Key.action_new_seed_list);
    }

    public String action_new_year() {
        return this.translate(Key.action_new_year);
    }

    public String action_open() {
        return this.translate(Key.action_open);
    }

    public String action_print() {
        return this.translate(Key.action_print);
    }

    public String action_print_setup() {
        return this.translate(Key.action_print_setup);
    }

    public String action_review() {
        return this.translate(Key.action_review);
    }

    public String action_save() {
        return this.translate(Key.action_save);
    }

    public String action_save_as() {
        return this.translate(Key.action_save_as);
    }

    public String action_seed_manager() {
        return this.translate(Key.action_seed_manager);
    }

    public String action_show_an_example() {
        return this.translate(Key.action_show_an_example);
    }

    public String action_show_another_example() {
        return this.translate(Key.action_show_another_example);
    }

    public String action_species_properties() {
        return this.translate(Key.action_species_properties);
    }

    public String action_upload_to_web() {
        return this.translate(Key.action_upload_to_web);
    }

    public String action_year_add() {
        return this.translate(Key.action_year_add);
    }

    public String action_year_delete() {
        return this.translate(Key.action_year_delete);
    }

    public String action_zoom() {
        return this.translate(Key.action_zoom);
    }

    public String add() {
        return this.translate(Key.add);
    }

    public String all() {
        return this.translate(Key.all);
    }

    public String allowed_repetitions() {
        return this.translate(Key.allowed_repetitions);
    }

    public String ask_review() {
        return this.translate(Key.ask_review);
    }

    public String automatically_check() {
        return this.translate(Key.automatically_check);
    }

    public String cancel() {
        return this.translate(Key.cancel);
    }

    public String cannot_add_year() {
        return this.translate(Key.cannot_add_year);
    }

    public String choose_year_to_add() {
        return this.translate(Key.choose_year_to_add);
    }

    public String choose_year_to_delete() {
        return this.translate(Key.choose_year_to_delete);
    }

    public String comment() {
        return this.translate(Key.comment);
    }

    public String companion_attract_beneficial() {
        return this.translate(Key.companion_attract_beneficial);
    }

    public String companion_attract_pest() {
        return this.translate(Key.companion_attract_pest);
    }

    public String companion_bad() {
        return this.translate(Key.companion_bad);
    }

    public String companion_dislike() {
        return this.translate(Key.companion_dislike);
    }

    public String companion_good() {
        return this.translate(Key.companion_good);
    }

    public String companion_helped_by() {
        return this.translate(Key.companion_helped_by);
    }

    public String companion_improve() {
        return this.translate(Key.companion_improve);
    }

    public String companion_improve_flavor() {
        return this.translate(Key.companion_improve_flavor);
    }

    public String companion_improve_growth() {
        return this.translate(Key.companion_improve_growth);
    }

    public String companion_improve_health() {
        return this.translate(Key.companion_improve_health);
    }

    public String companion_improve_pest_resistance() {
        return this.translate(Key.companion_improve_pest_resistance);
    }

    public String companion_improve_soil_fertility() {
        return this.translate(Key.companion_improve_soil_fertility);
    }

    public String companion_improve_vigor() {
        return this.translate(Key.companion_improve_vigor);
    }

    public String companion_inhibit() {
        return this.translate(Key.companion_inhibit);
    }

    public String companion_repel_beneficial() {
        return this.translate(Key.companion_repel_beneficial);
    }

    public String companion_repel_pest() {
        return this.translate(Key.companion_repel_pest);
    }

    public String companion_trap_pest() {
        return this.translate(Key.companion_trap_pest);
    }

    public String delete() {
        return this.translate(Key.delete);
    }

    public String tag_delete() {
        return this.translate(Key.tag_delete);
    }

    public String tag_delete_confirmation() {
        return this.translate(Key.tag_delete_confirmation);
    }

    public String delete_square() {
        return this.translate(Key.delete_square);
    }

    public String disadvantageous() {
        return this.translate(Key.disadvantageous);
    }

    public String do_you_want_to_save() {
        return this.translate(Key.do_you_want_to_save);
    }

    public String error() {
        return this.translate(Key.error);
    }

    public String error_loading_file() {
        return this.translate(Key.error_loading_file);
    }

    public String error_print() {
        return this.translate(Key.error_print);
    }

    public String error_saving_file() {
        return this.translate(Key.error_saving_file);
    }

    public String family() {
        return this.translate(Key.family);
    }

    public String file() {
        return this.translate(Key.file);
    }

    public String garden() {
        return this.translate(Key.garden);
    }

    public String go_to_download() {
        return this.translate(Key.go_to_download);
    }

    public String tag() {
        return this.translate(Key.tag);
    }

    public String import_csv() {
        return this.translate(Key.import_csv);
    }

    public String in() {
        return this.translate(Key.in);
    }

    public String invalid_file_format() {
        return this.translate(Key.invalid_file_format);
    }

    public String tag_invalid_name() {
        return this.translate(Key.tag_invalid_name);
    }

    public String invert() {
        return this.translate(Key.invert);
    }

    public String lifetime_annual() {
        return this.translate(Key.lifetime_annual);
    }

    public String lifetime_biennial() {
        return this.translate(Key.lifetime_biennial);
    }

    public String lifetime_perennial() {
        return this.translate(Key.lifetime_perennial);
    }

    public String measurement_unit_grams() {
        return this.translate(Key.measurement_unit_grams);
    }

    public String measurement_unit_pieces() {
        return this.translate(Key.measurement_unit_pieces);
    }

    public String missing_translations() {
        return this.translate(Key.missing_translations);
    }

    public String modify() {
        return this.translate(Key.modify);
    }

    public String tag_modify() {
        return this.translate(Key.tag_modify);
    }

    public String name() {
        return this.translate(Key.name);
    }

    public String new_language() {
        return this.translate(Key.new_language);
    }

    public String new_version_available() {
        return this.translate(Key.new_version_available);
    }

    public String no_new_version_available() {
        return this.translate(Key.no_new_version_available);
    }

    public String none() {
        return this.translate(Key.none);
    }

    public String not_tagged() {
        return this.translate(Key.not_tagged);
    }

    public String nothing_found() {
        return this.translate(Key.nothing_found);
    }

    public String nutritional_needs() {
        return this.translate(Key.nutritional_needs);
    }

    public String nutritional_needs_high() {
        return this.translate(Key.nutritional_needs_high);
    }

    public String nutritional_needs_low() {
        return this.translate(Key.nutritional_needs_low);
    }

    public String nutritional_needs_soil_improver() {
        return this.translate(Key.nutritional_needs_soil_improver);
    }

    public String ok() {
        return this.translate(Key.ok);
    }

    public String only_missing_translations() {
        return this.translate(Key.only_missing_translations);
    }

    public String page() {
        return this.translate(Key.page);
    }

    public String quantity() {
        return this.translate(Key.quantity);
    }

    public String pick_species() {
        return this.translate(Key.pick_species);
    }

    public String recent_files() {
        return this.translate(Key.recent_files);
    }

    public String remove() {
        return this.translate(Key.remove);
    }

    public String repetition_gap() {
        return this.translate(Key.repetition_gap);
    }

    public String replace() {
        return this.translate(Key.replace);
    }

    public String replace_all() {
        return this.translate(Key.replace_all);
    }

    public String rotation_after() {
        return this.translate(Key.rotation_after);
    }

    public String rotation_bad() {
        return this.translate(Key.rotation_bad);
    }

    public String rotation_good() {
        return this.translate(Key.rotation_good);
    }

    public String rotation_repetition_family() {
        return this.translate(Key.rotation_repetition_family);
    }

    public String rotation_repetition_species() {
        return this.translate(Key.rotation_repetition_species);
    }

    public String rotation_root_type_deep() {
        return this.translate(Key.rotation_root_type_deep);
    }

    public String rotation_root_type_same_level() {
        return this.translate(Key.rotation_root_type_same_level);
    }

    public String rotation_root_type_shallow() {
        return this.translate(Key.rotation_root_type_shallow);
    }

    public String rotation_weed_control_bad() {
        return this.translate(Key.rotation_weed_control_bad);
    }

    public String rotation_weed_control_good() {
        return this.translate(Key.rotation_weed_control_good);
    }

    public String search() {
        return this.translate(Key.search);
    }

    public String search_case_insensitive() {
        return this.translate(Key.search_case_insensitive);
    }

    public String search_direction_by_column() {
        return this.translate(Key.search_direction_by_column);
    }

    public String search_direction_reverse() {
        return this.translate(Key.search_direction_reverse);
    }

    public String search_whole_text() {
        return this.translate(Key.search_whole_text);
    }

    public String seed_manager_inventory() {
        return this.translate(Key.seed_manager_inventory);
    }

    public String seed_manager_shopping_list() {
        return this.translate(Key.seed_manager_shopping_list);
    }

    public String select_species_first() {
        return this.translate(Key.select_species_first);
    }

    public String species() {
        return this.translate(Key.species);
    }

    public String species_in_garden() {
        return this.translate(Key.species_in_garden);
    }

    public String species_in_inventory() {
        return this.translate(Key.species_in_inventory);
    }

    public String total_squares() {
        return this.translate(Key.total_squares);
    }

    public String total_years() {
        return this.translate(Key.total_years);
    }

    public String tutorial() {
        return this.translate(Key.tutorial);
    }

    public String unknown() {
        return this.translate(Key.unknown);
    }

    public String update_missing_translations() {
        return this.translate(Key.update_missing_translations);
    }

    public String variety() {
        return this.translate(Key.variety);
    }

    public String weed_control_clear() {
        return this.translate(Key.weed_control_clear);
    }

    public String weed_control_weedy() {
        return this.translate(Key.weed_control_weedy);
    }

    public String year() {
        return this.translate(Key.year);
    }

    public String years() {
        return this.translate(Key.years);
    }

    public String changes_date() {
        return this.translate(Key.changes_date);
    }

    public String working_date() {
        return this.translate(Key.working_date);
    }

    public String now() {
        return this.translate(Key.now);
    }

    public String move() {
        return this.translate(Key.move);
    }

    public String copy() {
        return this.translate(Key.copy);
    }

    public String seed_manager_tools() {
        return this.translate(Key.seed_manager_tools);
    }

    public String seed_manager_options() {
        return this.translate(Key.seed_manager_options);
    }

    public String seed_manager_autogenerate() {
        return this.translate(Key.seed_manager_autogenerate);
    }

    public String seed_manager_from_garden() {
        return this.translate(Key.seed_manager_from_garden);
    }

    public String seed_manager_from_inventory() {
        return this.translate(Key.seed_manager_from_inventory);
    }

    public String seed_manager_view_variety() {
        return this.translate(Key.seed_manager_view_variety);
    }

    public String seed_manager_view_quantity() {
        return this.translate(Key.seed_manager_view_quantity);
    }

    public String seed_manager_view_comment() {
        return this.translate(Key.seed_manager_view_comment);
    }

    public String seed_manager_view_valid_from() {
        return this.translate(Key.seed_manager_view_valid_from);
    }

    public String seed_manager_view_valid_to() {
        return this.translate(Key.seed_manager_view_valid_to);
    }

    public String valid_from() {
        return this.translate(Key.valid_from);
    }

    public String valid_to() {
        return this.translate(Key.valid_to);
    }

    public String image() {
        return this.translate(Key.image);
    }

    public String grid() {
        return this.translate(Key.grid);
    }

    public String seed_manager_different_page() {
        return this.translate(Key.seed_manager_different_page);
    }

    public String skip() {
        return this.translate(Key.skip);
    }

    public String dont_skip() {
        return this.translate(Key.dont_skip);
    }

    static {
        Object object2;
        log = Logger.getLogger(Garden.class.getName());
        preferred = null;
        log.info("Loading available translations");
        xmlLanguages = Translation.getXmlFromFile("languages");
        translations = new HashMap<String, Translation>();
        for (Object object2 : xmlLanguages.keySet()) {
            translations.put(object2.toString(), new Translation(object2.toString(), xmlLanguages.getProperty(object2.toString()), Translation.getXmlFromFile(object2.toString())));
        }
        log.info("Loading custom translations");
        Preferences preferences = Preferences.userRoot().node("/org/sourceforge/kga/translation/custom");
        try {
            for (String string : preferences.keys()) {
                Translation translation = translations.get(string);
                if (translation == null) {
                    translation = new Translation(string, "", new Properties());
                    translations.put(string, translation);
                }
                Properties properties = new Properties();
                properties.load(new StringReader(preferences.get(string, "")));
                translation.setCustomTranslations(properties);
            }
        }
        catch (IOException iOException) {
            log.warning(iOException.toString());
        }
        catch (BackingStoreException backingStoreException) {
            log.warning(backingStoreException.toString());
        }
        object2 = Translation.getLanguageFromPreferences();
        if (!((String)object2).isEmpty()) {
            Translation.setCurrentLanguage((String)object2);
        }
    }

    public static enum Key {
        action_about,
        tag_add,
        action_check_for_update,
        action_contact,
        action_edit_species,
        action_edit_translation,
        action_exit,
        action_export,
        action_export_translation,
        action_garden_statistics,
        action_tags,
        action_help,
        action_language,
        action_new_garden,
        action_new_seed_list,
        action_new_year,
        action_open,
        action_print,
        action_print_setup,
        action_review,
        action_save,
        action_save_as,
        action_seed_manager,
        action_show_an_example,
        action_show_another_example,
        action_species_properties,
        action_upload_to_web,
        action_year_add,
        action_year_delete,
        action_zoom,
        add,
        all,
        allowed_repetitions,
        ask_review,
        automatically_check,
        cancel,
        cannot_add_year,
        choose_year_to_add,
        choose_year_to_delete,
        comment,
        companion_attract_beneficial,
        companion_attract_pest,
        companion_bad,
        companion_dislike,
        companion_good,
        companion_helped_by,
        companion_improve,
        companion_improve_flavor,
        companion_improve_growth,
        companion_improve_health,
        companion_improve_pest_resistance,
        companion_improve_soil_fertility,
        companion_improve_vigor,
        companion_inhibit,
        companion_repel_beneficial,
        companion_repel_pest,
        companion_trap_pest,
        delete,
        tag_delete,
        tag_delete_confirmation,
        delete_square,
        disadvantageous,
        do_you_want_to_save,
        error,
        error_loading_file,
        error_print,
        error_saving_file,
        family,
        file,
        garden,
        go_to_download,
        tag,
        import_csv,
        in,
        invalid_file_format,
        tag_invalid_name,
        invert,
        lifetime_annual,
        lifetime_biennial,
        lifetime_perennial,
        missing_translations,
        measurement_unit_grams,
        measurement_unit_pieces,
        modify,
        tag_modify,
        name,
        new_language,
        new_version_available,
        no_new_version_available,
        none,
        not_tagged,
        nothing_found,
        nutritional_needs,
        nutritional_needs_high,
        nutritional_needs_low,
        nutritional_needs_soil_improver,
        ok,
        only_missing_translations,
        page,
        pick_species,
        quantity,
        recent_files,
        remove,
        repetition_gap,
        replace,
        replace_all,
        rotation_after,
        rotation_bad,
        rotation_good,
        rotation_repetition_family,
        rotation_repetition_species,
        rotation_root_type_deep,
        rotation_root_type_same_level,
        rotation_root_type_shallow,
        rotation_weed_control_bad,
        rotation_weed_control_good,
        search,
        search_case_insensitive,
        search_direction_by_column,
        search_direction_reverse,
        search_whole_text,
        seed_manager_inventory,
        seed_manager_shopping_list,
        select_species_first,
        species,
        species_in_garden,
        species_in_inventory,
        total_squares,
        total_years,
        tutorial,
        unknown,
        update_missing_translations,
        variety,
        weed_control_clear,
        weed_control_weedy,
        year,
        years,
        changes_date,
        working_date,
        now,
        move,
        copy,
        seed_manager_tools,
        seed_manager_options,
        seed_manager_autogenerate,
        seed_manager_from_garden,
        seed_manager_from_inventory,
        seed_manager_view_variety,
        seed_manager_view_quantity,
        seed_manager_view_comment,
        seed_manager_view_valid_from,
        seed_manager_view_valid_to,
        valid_from,
        valid_to,
        image,
        grid,
        seed_manager_different_page,
        skip,
        dont_skip;

    }
}

