<?php // ЮТФ-8

$dbcolls=$dbpref.'_collections';
$dbcollslang=$dbpref.'_collections_lang';
$dbevents=$dbpref.'_events';
$dbfields=$dbpref.'_fields';
$dbfieldslang=$dbpref.'_fields_lang';
$dbfiles=$dbpref.'_files';
$dbholders=$dbpref.'_holders';
$dbholderslang=$dbpref.'_holders_lang';
$dbitems=$dbpref.'_items';
$dbitemsdata=$dbpref.'_items_data';
$dbitemsconn=$dbpref.'_itemsconn';
$dblangs=$dbpref.'_langs';
$dbmarc=$dbpref.'_marc';
$dbmarcadd=$dbpref.'_marc_add';
$dbsetts=$dbpref.'_settings';
$dbtypes=$dbpref.'_types';
$dbtypeslang=$dbpref.'_types_lang';
$dbtypesadd=$dbpref.'_types_add';
$dbusers=$dbpref.'_users';


function dcinitsystem() {
	define('dcnameversion','Digrary');
	define('dcversion','2.0.21');
	define('dcsubversion','20170101');
	$sett=dcsettload('return','2');
	global $dctimezone,$modulesfulllistbyprog,$dbblockip,$sett;
	$GLOBALS['dcservername']=$dcservername=$_SERVER['HTTP_HOST'];
	$_SESSION['dcserversite']='http://'.$dcservername.$_SESSION['urlfolder'];
	//date_default_timezone_set($sett['timezone']);
	$GLOBALS['ndate']=$ndate=ndate();
	$GLOBALS['ndatesql']=date('Y-m-d H:i:s',$ndate);
	$GLOBALS['nhour']=date('H',$ndate);
	$GLOBALS['nmin']=date('i',$ndate);
	$GLOBALS['nsec']=date('s',$ndate);
	$GLOBALS['nday']=date('j',$ndate);
	$GLOBALS['nmonth']=date('n',$ndate);
	$GLOBALS['nmontho']=date('m',$ndate);
	$GLOBALS['nyear']=date('Y',$ndate);
	$_SESSION['webref']=dcisset($_SERVER['HTTP_REFERER']);
	$_SESSION['fullweburi']=$_SESSION['weburi']=dcisset($_SERVER['REQUEST_URI']);
	if ($_SESSION['urlfolder']<>'' and $_SESSION['weburi']<>'' and substr($_SESSION['weburi'],0,strlen($_SESSION['urlfolder']))==$_SESSION['urlfolder']) $_SESSION['weburi']=substr($_SESSION['weburi'],strlen($_SESSION['urlfolder']));
}


function ndate() {
	global $sett;
	return (time()+($sett['timeshift']*60));
}


function ndatesql() {
	global $sett;
	return date('Y-m-d H:i:s',(time()+($sett['timeshift']*60)));
}


function dcmetaclear($str) {
	$str=str_replace(array("\n","\t",'"'),array(' ',' ','&quote;'),$str);
	$str=str_replace('  ',' ',$str);
	$str=str_replace('  ',' ',$str);
	return $str;
}


function redir($gourl='?') {
	$gourl=trim($gourl);
	header("location: ".$gourl);
	exit(); 
}


function dcisset(&$var) {
	if (isset($var)) return $var;
	else return '';
}


function getmicrotime(){ 
	list($usec, $sec) = explode(" ",microtime()); 
	return ((float)$usec + (float)$sec); 
}


function dcgetip() {
	if (getenv("HTTP_CLIENT_IP")) $ip=getenv("HTTP_CLIENT_IP");
	elseif (getenv("HTTP_X_FORWARDED_FOR")) $ip=getenv("HTTP_X_FORWARDED_FOR");
	else $ip=getenv("REMOTE_ADDR");
	$_SESSION['webip']=$ip;
	foreach (explode(',',$ip) AS $value) $_SESSION['webiparr'][]=trim($value);
}


function dcgethost() {
	for ($i=0; $i<count($_SESSION['webiparr']); $i++) $host[]=@gethostbyaddr($_SESSION['webiparr'][$i]);
	$_SESSION['webhost']=implode(',',$host);
}


function getcountrybyip($ip) {
	if (substr($ip,0,7)=="192.168" or substr($ip,0,3)=="10." or substr($ip,0,4)=="127.") {
		return 'loc';
	} else {
		$ipvalue=explode(".",$ip);
		$ipnum=($ipvalue[0]*16777216)+($ipvalue[1]*65536)+($ipvalue[2]*256)+($ipvalue[3]);
		if ($fp=fopen($_SESSION['baseurl'].'system/ip2country4.csv','r')) {
			while ($data=fgetcsv($fp,30,",")) {
				if ($ipnum>=$data[1] and $ipnum<($data[1]+$data[2])) return $data[0];
			}
			fclose ($fp);
		} else {
			adderror('Невозможно открыть файл ip2country');
			return false;
		}
	}
	return 'n/a';
}




function dcimagecopy($from,$to,$tech='') {
	if (dcisset($tech['quality'])=='') $tech['quality']=90;

	unset($im,$im2);
	$fromext=strtolower(substr($from,strripos($from,'.')));
	$toext=strtolower(substr($to,strripos($to,'.')));
	
	if ($fromext==$toext and dcisset($tech['mode'])=='') {
		if (copy($from,$to)) return true;
		else return false;
	} else {
		if ($size=@getimagesize($from)) {
			unset($im);
			if ($size["mime"]=='image/gif') $im=imagecreatefromgif($from); //gif file
			elseif ($size["mime"]=='image/jpeg') $im=imagecreatefromjpeg($from); //jpeg file
			elseif ($size["mime"]=='image/png') $im=imagecreatefrompng($from); //png file
			else return false;
			
			if (isset($im)) {
				if (empty($tech['width'])) $tech['width']=$size[0];
				if (empty($tech['height'])) $tech['height']=$size[1];
				
				$wfrom=$wto=$size[0];
				$hfrom=$hto=$size[1];
				$lfrom=0;
				$tfrom=0;
				$div=$wfrom/$hfrom;
				
				if (dcisset($tech['mode'])=='resize') {
					$wto=dcisset($tech['width']);
					$hto=dcisset($tech['height']);
					if ($wto>0 and $hto>0) {
						if ($wfrom>$hfrom) $hto=round($wto/$div);
						if ($wfrom<=$hfrom) $wto=round($hto*$div);
					} elseif ($wto>0) {
						$hto=round($wto/$div);
					} elseif ($hto>0) {
						$wto=round($hto*$div);
					}
				}
				
				if (dcisset($tech['mode'])=='resizemax') {
					$wto=dcisset($tech['width']);
					$hto=dcisset($tech['height']);
					if ($wto>0 and $hto>0) {
						if ($wfrom>$hfrom)  $wto=round($hto*$div);
						if ($wfrom<=$hfrom) $hto=round($wto/$div);
					} elseif ($wto>0) {
						$hto=round($wto/$div);
					} elseif ($hto>0) {
						$wto=round($hto*$div);
					}
				}
				
				if (dcisset($tech['mode'])=='cut') {
					$wto=dcisset($tech['width']);
					if ($wto>0 and $hto>0) {
						$divto=$wto/$hto;
					} elseif ($wto>0) {
						$divto=$wfrom/$hfrom;
						$hto=round($wto/$div);
					} elseif ($hto>0) {
						$wto=round($hto*$div);
					}
					if ($size[0]>round($size[1]*$divto)) {
						$wfrom=round($size[1]*$divto);
						$lfrom=round(($size[0]-$wfrom)/2);
					} elseif ($size[1]>round($size[0]/$divto)) {
						$hfrom=round($size[0]/$divto);
						$tfrom=round($size[1]/2)-round($hfrom/2);
					}
				}

				$im2=ImageCreateTrueColor($wto,$hto);
				imagefill($im2, 0, 0, imagecolorallocate($im2, 255, 255, 255));
				imagealphablending($im2, TRUE);
				//imagecopy($im2, $im, 0, 0, 0, 0, $wto, $hto); // просто копирование
				imagecopyResampled($im2, $im, 0, 0, $lfrom, $tfrom, $wto, $hto, $wfrom, $hfrom ); // для изменения размеров
				imagedestroy($im);
				if (!isset($im2)) return false;
				if ($toext=='.png') imagepng($im2, $to, round($tech['quality']/11));
				elseif ($toext=='.gif') imagegif($im2, $to);
				else imagejpeg($im2, $to, $tech['quality']);
				imagedestroy($im2);
			}
		} else {
			return false;
		}
	}
	return true;
}




function gtranslate($string,$fromlang="auto",$tolang="en") {
	$url='http://translate.google.com/translate_a/t?client=t&js=n&hl=ru&ie=UTF-8&oe=UTF-8&sl='.$fromlang.'&tl='.$tolang.'&multires=0&prev=btn&ssel=0&tsel=0&sc=1&layout=1&eotf=1&c_ad=1';
	$query='';
	if (is_array($string)) {
		for ($i=0; $i<count($string); $i++) {
			$query.='q='.rawurlencode($string[$i]);
			if (($i<count($string)-1)) $query.='&';
		}
	} else {
		$query.='q='.rawurlencode($string);
	}
	$query.='&sl='.$fromlang.'&tl='.$tolang.'&tc=1';
	$result=sendrequest($url,$query,"http://translate.google.com/#",'','','POST');
	$result=str_replace('\"','&quot;',$result);
	if (preg_match_all("#\[\[\[\"(.*)\"#isU", $result, $regs)) { 
		return $regs[1];
	} else {
		printr($result);
		return 'ERROR';
	}
}





// ---------------------- DIGRARY

function difilesadd($itemid,$path,$name,$cover='',$title='') {
	global $dbfiles;
	
	$number=getnumbertruedate();
	$data['file']=$name;
	$data['file']=str_replace(' ','_',$data['file']);
	$extstart=strripos($data['file'],'.')+1;
	$data['filename']=substr($data['file'],0,$extstart-1);
	$data['fileext']=substr($data['file'],$extstart);
	if (isset($sett['directlink']) and $sett['directlink']=='on') {
		$thisfile=$data['file'];
		$data['type']='filedirect';
	} else {
		$thisfile='file'.$number.'.'.$data['fileext'];
		$data['type']='filedinamic';
	}

	$pathfile=$_SESSION['baseurl'].$_SESSION['filesfolder'].$thisfile;
	
	
	if (!rename($path,$pathfile)) {
		return false;
	} else {
		dcquery("INSERT INTO `".$dbfiles."` (`itemid`,`number`) VALUES ('".$itemid."','".$number."');");
		$fileid=dcdbinsertid();
		$data['filemime']=mime_content_type($_SESSION['filesfolder'].$thisfile);
		$data['filesize']=filesize($_SESSION['filesfolder'].$thisfile);
		$data['cover']='';
		$data['coverfull']='';
		if (!empty($cover)) {
			if (@dcimagecopy($cover,$_SESSION['coversfolder'].'cover'.$fileid.'.jpg',array('width'=>180,'quality'=>70,'mode'=>'resize'))) $data['cover']=$fileid;
			if (@dcimagecopy($cover,$_SESSION['coversfolder'].'cover'.$fileid.'full.jpg',array('width'=>600,'height'=>600,'quality'=>70,'mode'=>'resize'))) $data['coverfull']=$fileid;
		} else {
			if (in_array($data['filemime'],array('image/gif','image/jpeg','image/png'))) {
				if (@dcimagecopy($pathfile,$_SESSION['coversfolder'].'cover'.$fileid.'.jpg',array('width'=>180,'quality'=>70,'mode'=>'resize'))) $data['cover']=$fileid;
				if (@dcimagecopy($pathfile,$_SESSION['coversfolder'].'cover'.$fileid.'full.jpg',array('width'=>600,'height'=>600,'quality'=>70,'mode'=>'resize'))) $data['coverfull']=$fileid;
			}
			if ($data['filemime']=='video/mp4') {
				exec("ffmpeg -ss 15 -i ".$pathfile." -vframes 1 -vf scale=180:-1 ".$_SESSION['baseurl'].$_SESSION['coversfolder'].'cover'.$fileid.'.jpg');
				$data['cover']=$fileid;
				exec("ffmpeg -ss 15 -i ".$pathfile." -vframes 1 -vf scale=600:-1 ".$_SESSION['baseurl'].$_SESSION['coversfolder'].'cover'.$fileid.'full.jpg');
				$data['coverfull']=$fileid;
			}
			if ($data['filemime']=='application/pdf') {
				$im = new Imagick();
				$im->readImage($pathfile.'[0]');
				$im->setImageBackgroundColor('white');
				$im->setImageAlphaChannel(imagick::ALPHACHANNEL_REMOVE);
				$im->mergeImageLayers(imagick::LAYERMETHOD_FLATTEN);
				$im->resizeImage(180,0,Imagick::FILTER_TRIANGLE,0.5);
				$im->setImageFormat('jpeg');
				$im->writeImages($_SESSION['baseurl'].$_SESSION['coversfolder'].'cover'.$fileid.'.jpg', false); 
				$im->clear(); 
				$im->destroy();
				$data['cover']=$fileid;
				$im = new Imagick();
				$im->readImage($pathfile.'[0]');
				$im->setImageBackgroundColor('white');
				$im->setImageAlphaChannel(imagick::ALPHACHANNEL_REMOVE);
				$im->mergeImageLayers(imagick::LAYERMETHOD_FLATTEN);
				$im->resizeImage(600,600,Imagick::FILTER_TRIANGLE,0.5,true);
				$im->setImageFormat('jpeg');
				$im->writeImages($_SESSION['baseurl'].$_SESSION['coversfolder'].'cover'.$fileid.'full.jpg', false); 
				$im->clear(); 
				$im->destroy();
				$data['coverfull']=$fileid;
			}
		}
		//$data['title']=@$_REQUEST['filetitle'];
		$data['title']=$title;
		
		dcquery("UPDATE `".$dbfiles."` SET 
		`sort`='".$fileid."',
		`date`='".ndatesql()."',
		`filename`='".string2sql($data['filename'])."', 
		`fileext`='".string2sql($data['fileext'])."', 
		`filemime`='".string2sql($data['filemime'])."', 
		`filesize`='".string2sql($data['filesize'])."', 
		`title`='".string2sql($data['title'])."', 
		`type`='".$data['type']."', 
		`cover`='".string2sql($data['cover'])."',
		`coverfull`='".string2sql($data['coverfull'])."'
		WHERE `id`='".$fileid."'");
	}
	return true;
}



function difilesdeleteitemid($itemid) {
	global $dbfiles;
	unset($ress);
	$qresult=dcquery("SELECT * FROM `".$dbfiles."` WHERE `itemid`='".$itemid."'");
	while ($ress=mysqli_fetch_assoc($qresult)) {
		if (!empty($ress['cover']) and file_exists($_SESSION['coversfolder'].'cover'.$ress['cover'].'.jpg')) unlink($_SESSION['coversfolder'].'cover'.$ress['cover'].'.jpg');
		if (!empty($ress['coverfull']) and file_exists($_SESSION['coversfolder'].'cover'.$ress['coverfull'].'full.jpg')) unlink($_SESSION['coversfolder'].'cover'.$ress['coverfull'].'full.jpg');
		if (file_exists($_SESSION['filesfolder'].'file'.$ress['number'].'.'.$ress['fileext'])) unlink($_SESSION['filesfolder'].'file'.$ress['number'].'.'.$ress['fileext']);
		if (file_exists($_SESSION['filesfolder'].$ress['filename'].'.'.$ress['fileext'])) unlink($_SESSION['filesfolder'].$ress['filename'].'.'.$ress['fileext']);
	}
	dcquery("DELETE FROM `".$dbfiles."` WHERE `itemid`=".$itemid);
	return true;
}



function difilesdelete($id) {
	global $dbfiles;
	unset($ress);
	$qresult=dcquery("SELECT * FROM `".$dbfiles."` WHERE `id`='".$id."'");
	while ($ress=mysqli_fetch_assoc($qresult)) {
		if (!empty($ress['cover']) and file_exists($_SESSION['coversfolder'].'cover'.$ress['cover'].'.jpg')) unlink($_SESSION['coversfolder'].'cover'.$ress['cover'].'.jpg');
		if (!empty($ress['coverfull']) and file_exists($_SESSION['coversfolder'].'cover'.$ress['coverfull'].'full.jpg')) unlink($_SESSION['coversfolder'].'cover'.$ress['coverfull'].'full.jpg');
		if (file_exists($_SESSION['filesfolder'].'file'.$ress['number'].'.'.$ress['fileext'])) unlink($_SESSION['filesfolder'].'file'.$ress['number'].'.'.$ress['fileext']);
	}
	dcquery("DELETE FROM `".$dbfiles."` WHERE `id`=".$id);
	return true;
}



function diviewitem($itemid) {
	global $dbitemsdata,$dbcolls,$dbcollslang,$dbtypes,$dbtypeslang,$dbfiles,$blist;
	global $nlang,$tl;
	
	unset($ress,$data);
	$qresult = dcquery("SELECT * FROM `".$dbitemsdata."` WHERE `itemid`='".$itemid."'");
	while ($ress=mysqli_fetch_assoc($qresult)) { $data[$ress['typename']][]=$ress['value']; }

	if (isset($data['collection'])) {
		unset($ress,$colls);
		$result = dcquery("SELECT *,a.id AS uid FROM `".$dbcolls."` a LEFT JOIN `".$dbcollslang."` b ON a.id=b.collid AND b.`lang`='".$nlang."' WHERE a.`id` IN (".implode(',',$data['collection']).")");
		while ($ress = mysqli_fetch_assoc($result)) { $colls[]=$ress['name']; }
	}

	unset($ress,$types);
	$result = dcquery("SELECT *,a.id AS uid FROM `".$dbtypes."` a LEFT JOIN `".$dbtypeslang."` b ON a.id=b.typeid AND b.`lang`='".$nlang."'");
	while ($ress = mysqli_fetch_assoc($result)) { $types[$ress['uid']]=$ress['name']; }

	if (!empty($data['title'])) {
		for ($i=0; $i<count($data['title']); $i++) {
			if ($i==0) echo '<h1>'.$data['title'][$i].'</h1>';
			else echo '<h2>'.$data['title'][$i].'</h2>';
		}
	}
	
	echo '<div class="row">';
	echo '<div class="col-sm-4">';
	
		unset($ress,$files);
		$qresult = dcquery("SELECT * FROM `".$dbfiles."` WHERE `itemid`='".$itemid."' ORDER BY `sort` ASC");
		while ($ress= mysqli_fetch_assoc($qresult)) { $files[]=$ress; }
		if (isset($files)) {
			for ($i=0; $i<count($files); $i++) {
				$file='';
				if ($files[$i]['type']=='url') $file=$files[$i]['url'];
				elseif ($files[$i]['type']=='filedirect') $file=$_SESSION['filesfolder'].$files[$i]['filename'].'.'.$files[$i]['fileext'];
				elseif ($files[$i]['type']=='filedinamic') $file=$_SESSION['filesfolder'].'file'.$files[$i]['number'].'.'.$files[$i]['fileext'];
				if ($file<>'') {
					$title=$tl['open'];
					if (!empty($files[$i]['title'])) $title=$files[$i]['title'];
					echo '<div style="margin-bottom: 20px; border: 1px dotted silver;">';
						if (file_exists($_SESSION['coversfolder'].'cover'.$files[$i]['id'].'.jpg')) {
							//echo '<a href="'.links('download,'.@$files[$i]['id']).'" target="_blank" class="thumb coverblock" style="background: url(\'/'.$_SESSION['coversfolder'].'cover'.$files[$i]['id'].'.jpg\') no-repeat; background-size: cover; background-position: center 15%;">';
							echo '<a href="'.links('view,'.$itemid.','.@$files[$i]['id']).'" class="coverblock" style="background: url(\''.$_SESSION['urlfolder'].'/'.$_SESSION['coversfolder'].'cover'.$files[$i]['id'].'.jpg\') no-repeat; background-size: cover; background-position: center 15%;">';
								echo '<div style="position: absolute; bottom: 0; width: 100%; background: rgba(0,0,0,0.6); padding: 2px 5px;">'.$title.'</div>';
							echo '</a>';
						} else {
							//echo '<p style="margin: 5px;"><a href="'.links('download,'.@$files[$i]['id']).'" target="_blank" class="thumb"><strong>'.$title.'</strong></a></p>';
							//echo '<p style="margin: 5px;"><a href="'.links('view,'.$itemid.','.@$files[$i]['id']).'"><strong>'.$title.'</strong></a></p>';
							echo '<p style="margin: 5px;"><a href="'.links('download,'.@$files[$i]['id'].',download').'"><strong>'.$title.'</strong></a></p>';
						}
						
						echo '<p style="margin: 5px;"><a href="'.links('download,'.@$files[$i]['id'].',download').'" download>'.$tl['download'].'</a> <span style="font-size: 11px;">('.$files[$i]['fileext'].', '.fsize(@$files[$i]['filesize']).')</span></p>';
					echo '</div>';
				}
			}
		}
	
	echo '</div>';
	echo '<div class="col-sm-8">';

		echo '<table class="table table-striped">';
			foreach ($data AS $key=>$var) {
				if (!in_array($key,array('title','collection'))) {
					echo '<tr>';
					echo '<td><strong>'.@$tl['bfields_'.$key].'</strong></td>';
					echo '<td>';
					foreach ($var AS $var2) {
						if ($key=='type') { echo '<p>'.$types[$var2].'</p>'; }
						elseif ($key=='language') { echo '<p>'.$tl['blangs_'.$var2].'</p>'; }
						elseif ($key=='holders' and isset($blist['holders'][$var2])) { echo '<p>'.$blist['holders'][$var2].'</p>'; }
						else echo '<p>'.@$var2.'</p>';
					}
					echo '</td>';
					echo '</tr>';
				}
			}
			if (isset($colls)) {
				echo '<tr><td><strong>'.$tl['collection'].'</strong></td><td>';
				foreach($colls AS $var) echo '<p>'.$var.'</p>';
				echo '</td></tr>';
			}
		echo '</table>';
		
	echo '</div>';
	echo '</div>';
}






function dimenucollections($templine,$itde) {
	global $line,$colls,$itemdata;
	for ($i=0; $i<count($templine); $i++) {
		echo '<div class="checkbox"><label style="margin: 0 '.($itde*16+3).'px;"><input type="checkbox" name="coll[]" value="'.$templine[$i]['uid'].'" '.((isset($itemdata['collection']) and in_array($templine[$i]['uid'],$itemdata['collection']))?'checked':'').'>&nbsp;'.$templine[$i]['name'].'</label></div>';
		if (@$line[$templine[$i]['uid']]<>"") dimenucollections($line[$templine[$i]['uid']],($itde+1));
	}
}



function dishowfield($key,$data='') {
	global $tl,$bfields,$blist,$nlang;
	$bf=$key['name'];
	
	if ($bfields[$bf]['type']=='textline' OR $bfields[$bf]['type']=='date') {
		if (empty($data)) $data[]='';
		foreach ($data as $idata) echo '<input type="text" class="form-control" name="metadata['.$bf.'][]" value="'.@htmlspecialchars($idata).'" placeholder="'.$tl['bfields_'.$bf].'">';
	}
	if ($bfields[$bf]['type']=='textarea') {
		$rows=5;
		echo '<textarea class="form-control" name="metadata['.$bf.'][]" placeholder="'.$tl['bfields_'.$bf].'" rows="'.$rows.'" id="qwer">'.@$data[0].'</textarea>';
	}
	if ($bfields[$bf]['type']=='textlinemulti') {
		$rows=3;
		if (!empty($data) and count($data)>$rows) $rows=count($data);
		echo '<textarea class="form-control" name="metadata['.$bf.'][]" placeholder="'.$tl['bfields_'.$bf].'" rows="'.$rows.'">';
		if (!empty($data)) {
			$ch=false;
			foreach ($data as $idata) {
				if ($ch==true) echo "\n";
				echo $idata;
				$ch=true;
			}
		}
		echo '</textarea>';
	}
	if ($bfields[$bf]['type']=='select') {
		if (isset($blist[$bfields[$bf]['listvalues']])) {
			$bcount=(count($blist[$bfields[$bf]['listvalues']])+1);
			if ($bcount>10) $bcount=10;
			echo '<select size="'.$bcount.'" multiple name="metadata['.$bf.'][]">';
			if ($key['need']<>'1') echo '<option value="" '.(empty($data)?'selected':'').'></option>';
				foreach($blist[$bfields[$bf]['listvalues']] AS $lkey=>$lvar) echo '<option value="'.$lkey.'" '.((!empty($data) and in_array($lkey,$data))?'selected':'').'>'.$lvar.'</option>';
			echo '</select>';
		}
	}
	
	if (dcisset($bfields[$bf]['hint'])<>'') echo '<p style="color: gray; font-size: 13px;">'.$bfields[$bf]['hint'].'</p>';
}

	
	




// ---------------------- ERRORS

	function extraerror($num='',$text='') {
		$maintext[1]='ОШИБКА ПОДКЛЮЧЕНИЯ CORE-МОДУЛЯ';
		$maintext[2]='ОШИБКА ПОДКЛЮЧЕНИЯ К БАЗЕ ДАННЫХ';
		$maintext[3]='ОШИБКА ПОДКЛЮЧЕНИЯ К ТАБЛИЦЕ БАЗЫ ДАННЫХ';
		$maintext[4]='ОШИБКА БАЗЫ ДАННЫХ';
		$maintext[5]='ДОСТУП К САЙТУ ЗАКРЫТ';
		echo '<div style="background: #d40d2e; padding: 10px; width: 20%; min-width: 300px;">';
		if ($num<>'' and isset($maintext[$num])) echo '<p style="font-family: Arial, Tahoma, Verdana; color: white; font-weight: bold; font-size: 16px;">'.$maintext[$num].'</p>';
		if ($text<>'') echo '<p style="font-family: Tahoma, Verdana, Arial; color: #eee; font-weight: normal; font-size: 12px;">'.$text.'</p>';
		echo '</div>';
		exit;
	}

	function dcerrorhandler($errno, $errstr, $errfile=__FILE__, $errline=__LINE__, $errcontext='') {
		if (!(error_reporting() & $errno)) return; // This error code is not included in error_reporting
		
		$maintext[1]='ОШИБКА ПОДКЛЮЧЕНИЯ CORE-МОДУЛЯ';
		$maintext[2]='ОШИБКА ПОДКЛЮЧЕНИЯ К БАЗЕ ДАННЫХ';
		$maintext[4]='ОШИБКА БАЗЫ ДАННЫХ';
		$maintext[5]='ДОСТУП К САЙТУ ЗАКРЫТ';
		
		if ($errno==E_USER_ERROR) {
			echo 'sdvsdvsdv';
			echo '<div style="background: #d40d2e; padding: 10px;">';
			echo '<p style="font-family: Arial, Tahoma, Verdana; color: white; font-weight: bold; font-size: 14px;">'.$maintext[$errstr].'</p>';
			//echo '<p style="font-family: Arial, Tahoma, Verdana; color: white; font-weight: bold; font-size: 14px;">'.strip_tags($errstr).'</p>';
			//echo '<p style="font-family: Tahoma, Verdana, Arial; color: #eee; font-weight: normal; font-size: 12px;"><strong>'.$errfile.'</strong>, Строка: <strong>'.$errline.'</strong></p>';		
			echo '</div>';
			exit;
		} elseif ($errno==1 or $errno==2) {
			echo '<div style="background: #d40d2e; padding: 10px;">';
			echo '<p style="font-family: Arial, Tahoma, Verdana; color: white; font-weight: bold; font-size: 14px;">'.strip_tags($errstr).'</p>';
			echo '<p style="font-family: Tahoma, Verdana, Arial; color: #eee; font-weight: normal; font-size: 12px;"><strong>'.$errfile.'</strong>, Строка: <strong>'.$errline.'</strong></p>';		
			echo '</div>';
			exit;
		} else {
			echo '<div style="background: #f8e2e5; border-top: 1px solid red; margin: 5px 0; padding: 3px 5px;">';
			echo '<p style="font-family: Tahoma, Verdana, Arial; font-size: 12px;"><strong>'.strip_tags($errstr).'</strong></p>';
			echo '<p style="font-family: Tahoma, Verdana, Arial; font-size: 12px;"><strong>Ошибка №'.$errno.'</strong>, Файл: <strong>'.$errfile.'</strong>, Строка: <strong>'.$errline.'</strong></b></p>';
			echo '</div>';
		}
		return true;
	}




// ---------------------- DATABASE

	function dcdbconnect($type='incore', $host='',$user='',$password='',$base='',$port='',$socket='',$encode='utf8',$encode2='utf8_general_ci') {
		if ($port<>'') $dbconn=mysqli_connect($host,$user,$password,$base,$port) OR trigger_error(2,E_USER_ERROR);
		elseif ($port<>'' and $socket<>'') $dbconn=mysqli_connect($host,$user,$password,$base,$port) OR trigger_error(2,E_USER_ERROR);
		else $dbconn=mysqli_connect($host,$user,$password,$base) OR trigger_error(2,E_USER_ERROR);
		mysqli_query($dbconn,"set character_set_client='".$encode."'");
		mysqli_query($dbconn,"set character_set_results='".$encode."'");
		mysqli_query($dbconn,"set collation_connection='".$encode2."'");
		if ($type=='incore') $_SESSION['dbconn']=$dbconn;
		else return $dbconn;
	}

	
	function dcquery($query,$connect='') {
		if ($connect=='') $connect=$_SESSION['dbconn'];
		$result=mysqli_query($connect,$query) or extraerror(4,mysqli_error($connect));
		return $result;
	}
	

	function dcquerygetcontent($query,$connect='',$vars, $text) {
		if ($vars<>'') eval('global '.$vars.';');
		if ($connect=='') $connect=$_SESSION['dbconn'];
		$result=dcquery($query,$connect) or extraerror(4,mysqli_error($connect));
		while ($line=mysqli_fetch_array($result)) { eval($text); }
	}
	

	function dcqueryescape($query,$connect='') {
		if ($connect=='') $connect=$_SESSION['dbconn'];
		$result=mysqli_real_escape_string($connect,$query);
		return $result;
	}

	
	function dcdbinsertid($connect='') {
		if ($connect=='') $connect=$_SESSION['dbconn'];
		$id=mysqli_insert_id($connect);
		return $id;
	}

	
	function dcdbclose($connect='') {
		if ($connect=='') $connect=$_SESSION['dbconn'];
		mysqli_close($connect);
	}
	

	function dccreatquery($arr,$type,$dbname,$where="1",$connect='') {
		if ($connect=='') $connect=$_SESSION['dbconn'];
		$que1='';
		$que2='';
		if (strtolower($type)=='update') {
			foreach ($arr AS $key=>$value) {
				$que1.="`".$key."`='".$value."',";
			}
			$que1=substr($que1,0,-1);
			$result=dcquery("UPDATE `".$dbname."` SET ".$que1." WHERE ".$where.";",$connect) or extraerror(4,mysqli_error($connect));
			return true;
		} else {
			foreach ($arr AS $key=>$value) {
				$que1.="`".$key."`,";
				$que2.="'".$value."',";
			}
			$que1=substr($que1,0,-1);
			$que2=substr($que2,0,-1);
			$result=dcquery("INSERT INTO `".$dbname."` (".$que1.") VALUES (".$que2.");",$connect) or extraerror(4,mysqli_error($connect));
			return mysqli_insert_id($connect);
		}
	}

	
	function loadmaterials($where='',$order='',$limit='799') {
		global $dbitems,$dbitemsdata;
		$query1=$query2=$query3=$query4=$query5='';
		
		$num=0;
		if (is_array($where)) $num=$num+count($where);
		if (is_array($order)) $num=$num+count($order);
		$num=$num-1;

		if ($num>0) {
			for ($i=1; $i<=$num; $i++) {
				$query1.=",`".$dbitemsdata."` t".$i."\n";
				$query2.="t0.itemid=t".$i.".itemid"."\n";
				if ($i<$num) $query2.=" AND ";
			}
		}
		
		$num=0;
		
		if (is_array($order)) {
			if ($query3<>'') $query3.=" AND ";
			for ($i=0; $i<count($order); $i++) {
				$query3.="(t".$num.".`typename`='".$order[$i][0]."' OR  t".$num.".`typename` IS NULL)"."\n";
				if ($i<(count($order)-1)) $query3.=", ";
				$query4.="t".$num.".`valuesearch` ".$order[$i][1]."\n";
				if ($i<(count($order)-1)) $query4.=", ";
				$num++;
			}
		}
		
		if (is_array($where)) {
			if ($query3<>'') $query3.=" AND ";
			for ($i=0; $i<count($where); $i++) {
				if (count($where[$i])==1) $query3.="(t".$num.".".$where[$i][0].")"."\n";
				elseif (count($where[$i])==2) $query3.="(t".$num.".`typename`='".$where[$i][0]."' AND t".$num.".`valuesearch` ".$where[$i][1].")"."\n";
				if ($i<(count($where)-1)) $query3.=" AND ";
				$num++;
			}
		}

		if ($limit<>'') {
			$query5.=" LIMIT ".$limit;
		}
		
		$query="SELECT DISTINCT(t0.itemid) FROM `".$dbitemsdata."` t0"."\n";
		if ($query1<>'') $query.=$query1;								// `dc_users_data` t0				подключаемые таблицы
		if ($query2<>'' OR $query3<>'') $query.=' WHERE ';	// WHERE t0.itemid=t1.itemid		связывание подлючаемых таблиц
		if ($query2<>'') $query.=$query2;								// WHERE t0.itemid=t1.itemid		связывание подлючаемых таблиц
		if ($query2<>'' AND $query3<>'') $query.=' AND ';		// WHERE (t1.`typename`='type' AND t1.`value`='moder')	
		if ($query3<>'') $query.=$query3;								// WHERE (t1.`typename`='type' AND t1.`value`='moder')	
		if ($query4<>'') $query.=' ORDER BY '.$query4;			// ORDER BY
		if ($query5<>'') $query.=$query5;								// LIMIT
		
		$querymain="SELECT tmain.* FROM ("."\n";
		$querymain.=$query."\n";
		$querymain.=") tadd, `".$dbitemsdata."` tmain LEFT JOIN `".$dbitems."` it ON tmain.itemid=it.id WHERE tadd.itemid=tmain.itemid AND it.status='online'";
		//echo $querymain;
		unset($temp);
		$qresult=dcquery($querymain);
		while ($ress=mysqli_fetch_assoc($qresult)) { $temp[$ress['itemid']][$ress['typename']][]=$ress['value']; }
		
		if (isset($temp)) return $temp;
	}

	
	

	function countmaterials($where='') {
		global $dbitemsdata;
		$query1=$query2=$query3=$query4=$query5='';

		$num=0;
		if (is_array($where)) $num=$num+count($where);
		$num=$num-1;

		if ($num>0) {
			for ($i=1; $i<=$num; $i++) {
				$query1.=",`".$dbitemsdata."` t".$i."\n";
				$query2.="t0.itemid=t".$i.".itemid"."\n";
				if ($i<$num) $query2.=" AND ";
			}
		}
		
		$num=0;
		if (is_array($where)) {
			if ($query3<>'') $query3.=" AND ";
			for ($i=0; $i<count($where); $i++) {
				$query3.="(t".$num.".`typename`='".$where[$i][0]."' AND t".$num.".`valuesearch` ".$where[$i][1].")"."\n";
				if ($i<(count($where)-1)) $query3.=" AND ";
				$num++;
			}
		}
		
		$query="SELECT COUNT(DISTINCT(t0.itemid)) AS `count` FROM `".$dbitemsdata."` t0"."\n";
		if ($query1<>'') $query.=$query1;								// `dc_users_data` t0				подключаемые таблицы
		if ($query2<>'' OR $query3<>'') $query.=' WHERE ';	// WHERE t0.itemid=t1.itemid		связывание подлючаемых таблиц
		if ($query2<>'') $query.=$query2;								// WHERE t0.itemid=t1.itemid		связывание подлючаемых таблиц
		if ($query2<>'' AND $query3<>'') $query.=' AND ';		// WHERE (t1.`typename`='type' AND t1.`value`='moder')	
		if ($query3<>'') $query.=$query3;								// WHERE (t1.`typename`='type' AND t1.`value`='moder')	
		
		unset($temp);
		$qresult=dcquery($query);
		while ($ress=mysqli_fetch_assoc($qresult)) { $temp=$ress['count']; }
		
		if (isset($temp)) return $temp;
		else return FALSE;
	}




// ---------------------- STRINGS

	function changenum($str) {
		global $tl;
		if (substr($str,-2)>=11 and substr($str,-2)<=19) $newstr=$str.' '.$tl['declensionother'];
		elseif (substr($str,-1)=='1') $newstr=$str.' '.$tl['declension1'];
		elseif (substr($str,-1)=='2' or substr($str,-1)=='3' or substr($str,-1)=='4') $newstr=$str.' '.$tl['declension234'];
		else $newstr=$str.' '.$tl['declensionother'];
		return $newstr;
	}


	function slug($z) {
		$strarray='ABCDEFGHIJKLMNOPQRSTUVWXYZ'.'abcdefghijklmnopqrstuvwxyz'.'АБВГДЕЁЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯ'.'абвгдеёжзийклмнопрстуфхцчшщъыьэюя'.'ҢӨҮ'.'ңөү'.'1234567890';
		//$z = strtolower($z);
		$z = preg_replace('/[^'.$strarray.' ]+/u', ' ', $z);
		$z=trim($z);
		//$z = str_replace(' ', '-', $z); $z = preg_replace('/-+/', '-', $z);
		$z = preg_replace('/ +/', ' ', $z);
		return $z;
	}


	function escape($str){    
		$escape_chars = "%u0410 %u0430 %u0411 %u0431 %u0412 %u0432 %u0413 %u0433 %u0490 %u0491 %u0414 %u0434 %u0415 %u0435 %u0401 %u0451 %u0404 %u0454 %u0416 %u0436 %u0417 %u0437 %u0418 %u0438 %u0406 %u0456 %u0419 %u0439 %u041A %u043A %u041B %u043B %u041C %u043C %u041D %u043D %u041E %u043E %u041F %u043F %u0420 %u0440 %u0421 %u0441 %u0422 %u0442 %u0423 %u0443 %u0424 %u0444 %u0425 %u0445 %u0426 %u0446 %u0427 %u0447 %u0428 %u0448 %u0429 %u0449 %u042A %u044A %u042B %u044B %u042C %u044C %u042D %u044D %u042E %u044E %u042F %u044F";    
		$russian_chars = "А а Б б В в Г г Ґ ґ Д д Е е Ё ё Є є Ж ж З з И и І і Й й К к Л л М м Н н О о П п Р р С с Т т У у Ф ф Х х Ц ц Ч ч Ш ш Щ щ Ъ ъ Ы ы Ь ь Э э Ю ю Я я";    
		$e = explode(" ",$escape_chars);    
		$r = explode(" ",$russian_chars);    
		$rus_array = str_split($str);    
		$new_word = str_replace($r,$e,$rus_array);    
		$new_word = str_replace(" ","%20",$new_word);    
		$new_word = implode("",$new_word);    
		return ($new_word);    
	}    


	function unescape($str){    
		$escape_chars = "0410 0430 0411 0431 0412 0432 0413 0433 0490 0491 0414 0434 0415 0435 0401 0451 0404 0454 0416 0436 0417 0437 0418 0438 0406 0456 0419 0439 041A 043A 041B 043B 041C 043C 041D 043D 041E 043E 041F 043F 0420 0440 0421 0441 0422 0442 0423 0443 0424 0444 0425 0445 0426 0446 0427 0447 0428 0448 0429 0449 042A 044A 042B 044B 042C 044C 042D 044D 042E 044E 042F 044F";    
		$russian_chars = "А а Б б В в Г г Ґ ґ Д д Е е Ё ё Є є Ж ж З з И и І і Й й К к Л л М м Н н О о П п Р р С с Т т У у Ф ф Х х Ц ц Ч ч Ш ш Щ щ Ъ ъ Ы ы Ь ь Э э Ю ю Я я";    
		$e = explode(" ",$escape_chars);    
		$r = explode(" ",$russian_chars);    
		$rus_array = explode("%u",$str);    
		$new_word = str_replace($e,$r,$rus_array);    
		$new_word = str_replace("%20"," ",$new_word);    
		return (implode("",$new_word));    
	}  


	function hideEmail($email) {
		$character_set = '+-.0123456789@ABCDEFGHIJKLMNOPQRSTUVWXYZ_abcdefghijklmnopqrstuvwxyz';
		$key = str_shuffle($character_set);
		$cipher_text = '';
		$id = 'e'.rand(1,999999999);
		for ($i=0;$i<strlen($email);$i+=1) $cipher_text.= $key[strpos($character_set,$email[$i])];
		$script = 'var a="'.$key.'";var b=a.split("").sort().join("");var c="'.$cipher_text.'";var d="";';
		$script.= 'for(var e=0;e<c.length;e++)d+=b.charAt(a.indexOf(c.charAt(e)));';
		$script.= 'document.getElementById("'.$id.'").innerHTML="<a href=\\"mailto:"+d+"\\">"+d+"</a>"';
		$script = "eval(\"".str_replace(array("\\",'"'),array("\\\\",'\"'), $script)."\")";
		$script = '<script type="text/javascript">/*<![CDATA[*/'.$script.'/*]]>*/</script>';
		return '<span id="'.$id.'">[javascript protected email address]</span>'.$script;
	}


	function getnumber() {
		return (string)(ndate()*2).(string)mt_rand(10000,99999);
	}


	function getnumbertruedate() {
		return (string)date_unixtodc(ndate()).(string)mt_rand(10000,99999);
	}


	function croptext($text,$num=500) {
		$text=trim($text);
		$total=strlen($text);
		while ($num<$total and $text[$num]<>'.') { $num++; }
		$temp=substr($text,0,$num+1);
		return $temp;
	}


	function printr($string) {
		echo '<pre>';
		print_r($string);
		echo '</pre>';
	}

	function addzero($str,$dig=2) {
		$temp=$str;
		if (strlen($str)<$dig) $temp=str_repeat("0",($dig-strlen($str))).$str;
		return $temp;
	}


	function string2sql($str,$connect='') {
		if (ini_get('magic_quotes_gpc')) $str=stripslashes($str);
		$str=dcqueryescape($str,$connect);
		return $str;
	}


	function strips(&$el) { 
		if (is_array($el)) foreach($el as $k=>$v) strips($el[$k]); 
		else $el = stripslashes($el); 
	} 


	function gendigits($num=8) {
		$ret='';
		for ($i=0; $i<$num; $i++) $ret.=mt_rand(0,9);
		return $ret;
	}


	function translateHtml($content)	{
		$charArray = array("\r\n", "\r");
		$content = str_replace($charArray, "\n", $content); // win32
		$content = preg_replace("/[\n]{3,}/", "\n\n", $content);
		$content = str_replace("\n", "<br />", $content); // unix
		$content = preg_replace("/[ ]{2,}/", " ", $content);
		$content = str_replace("\"", "&quot;", $content);
		$content = str_replace("\'", "&#39;", $content);
		$content = str_replace("\$", "&#36;", $content);
		$content = wordwrap($content, 50, " ", 1);
		$content = trim($content);
		return $content;
	}


	function tl($name,$numarr='') {
		global $tl;
		if (!isset($tl[$name])) {
			return '<span style="color: red;">'.$name.'</span>';
		} else {
			$temp=$tl[$name];
			if (isset($numarr) and is_array($numarr)) {
				for ($i=0; $i<count($numarr); $i++) {
					$temp=str_replace('{'.$i.'}',$numarr[$i],$temp);
				}	
			}
			return $temp;
		}
	}


	function validEmail($email)	{
		return (@ereg('^[-!#$%&\'*+\\./0-9=?A-Z^_`a-z{|}~]+'.'@'.'[-!#$%&\'*+\\/0-9=?A-Z^_`a-z{|}~]+\.'.'[-!#$%&\'*+\\./0-9=?A-Z^_`a-z{|}~]+$',$email));
	}

	
	

// ---------------------- DATE

	function datetime_unixtomysql($udate) {
		return date('Y-m-j H:i:s',$udate);
	}


	function date_unixtomysql($udate) {
		return date('Y-m-j',$udate);
	}


	function time_unixtomysql($udate) {
		return date('H:i:s',$udate);
	}


	function datetime_datetomysql($year,$month='00',$day='00',$hour='00',$min='00',$sec='00') {
		if (is_array($year)) return @$year['year'].'-'.@$year['month'].'-'.@$year['day'].' '.@$year['hour'].':'.@$year['min'].':'.@$year['sec'];
		else return $year.'-'.$month.'-'.$day.' '.$hour.':'.$min.':'.$sec;
	}
	function date_datetomysql($year,$month='00',$day='00') {
		if (is_array($year)) return @$year['year'].'-'.@$year['month'].'-'.@$year['day'];
		else return $year.'-'.$month.'-'.$day;
	}
	function time_datetomysql($hour,$min='00',$sec='00') {
		if (is_array($hour)) return @$hour['hour'].':'.@$hour['min'].':'.@$hour['sec'];
		else return $hour.':'.$min.':'.$sec;
	}


	function date_unixtodate($date) {
		$temp['year']=(int)date("Y",$date);
		$temp['month']=(int)date("n",$date);
		$temp['day']=(int)date("j",$date);
		$temp['hour']=(int)date("G",$date);
		$temp['min']=(int)date("i",$date);
		$temp['sec']=(int)date("s",$date);
		return $temp;
	}


	function datetime_mysqltodate($date) {
		$temp['year']=(int)substr($date,0,4);
		$temp['month']=(int)substr($date,5,2);
		$temp['day']=(int)substr($date,8,2);
		$temp['hour']=(int)substr($date,11,2);
		$temp['min']=(int)substr($date,14,2);
		$temp['sec']=(int)substr($date,17,2);
		return $temp;
	}
	function date_mysqltodate($date) {
		$temp['year']=(int)substr($date,0,4);
		$temp['month']=(int)substr($date,5,2);
		$temp['day']=(int)substr($date,8,2);
		return $temp;
	}
	function time_mysqltodate($time) {
		$temp['hour']=(int)substr($time,0,2);
		$temp['min']=(int)substr($time,3,2);
		$temp['sec']=(int)substr($time,6,2);
		return $temp;
	}


	function date_mysqltodc($date) {
		return (string)substr($date,0,4).(string)substr($date,5,2).(string)substr($date,8,2).(string)substr($date,11,2).(string)substr($date,14,2).(string)substr($date,17,2);
	}


	function date_unixtodc($udate,$time='on') {
		if ($time=='on') return date('YmdHis',$udate);
		else return date('Ymd',$udate);
	}


	function date_datetodc($year='0000',$month='00',$day='00',$hour='00',$min='00',$sec='00') {
		$temp=addzero($year,4).addzero($month).addzero($day).addzero($hour).addzero($min).addzero($sec);
		return $temp;
	}


	function date_dctodate($date) {
		$temp['year']=(int)substr($date,0,4);
		$temp['month']=(int)substr($date,4,2);
		$temp['day']=(int)substr($date,6,2);
		$temp['hour']=(int)substr($date,8,2);
		$temp['min']=(int)substr($date,10,2);
		$temp['sec']=(int)substr($date,12,2);
		return $temp;
	}


	function showdateunix($date,$showtime='',$type='') {
		global $nlang,$textlang,$monthsname,$monthsname2;
		if ($type=='') $type=$textlang['dateoption'];
		$retdate='';
		if ($type=='1') $retdate.=date("j",$date).'&nbsp;'.$monthsname2[date("n",$date)].'&nbsp;'.date("Y",$date);
		elseif ($type=='2') $retdate.=$monthsname2[date("n",$date)].'&nbsp;'.date("j",$date).',&nbsp;'.date("Y",$date);
		else $retdate='Неверный тип';
		if ($showtime<>'') $retdate.=', '.date("G:i",$date);
		return $retdate;
	}


	function showdatemysql($sql_date,$showtime='',$type='') {
		global $nlang,$textlang,$monthsname,$monthsname2;
		$date=strtotime($sql_date);
		if ($type=='') $type=$textlang['dateoption'];
		$retdate='';
		if ($type=='1') $retdate.=date("j",$date).'&nbsp;'.$monthsname2[date("n",$date)].'&nbsp;'.date("Y",$date);
		elseif ($type=='2') $retdate.=$monthsname2[date("n",$date)].'&nbsp;'.date("j",$date).',&nbsp;'.date("Y",$date);
		else $retdate='Неверный тип';
		if ($showtime<>'') $retdate.=', '.date("G:i",$date);
		return $retdate;
	}


	function showdate($day,$month,$year,$lang='',$type='1') {
		global $nlang,$textlang,$monthsname,$monthsname2;
		if ($lang=='') $lang=$nlang;
		if ($type=='') $type=$textlang['dateoption'];
		$retdate='Неверный тип';
		if ($type=='1') $retdate=$day.'&nbsp;'.$monthsname2[$month].'&nbsp;'.$year;
		if ($type=='2') $retdate=$monthsname2[$month].'&nbsp;'.$day.',&nbsp;'.$year;
		return $retdate;
	}


	
	
// ---------------------- ACTIONS

	function langs($lang) {
		global $npage,$nadd,$sett;
		$enterlink=$_SESSION['dcserversite'].'/';
		if ($sett['modrewrite']=="on") {
			$enterlink.=$lang.'/';
			if ($npage<>"") $enterlink.=$npage.'/';
			if ($nadd<>"") $enterlink.=$nadd.'/';
		} else {
			if ($lang=="") $lang=$nlang;
			$enterlink.='?nlang='.$lang;
			if ($npage<>"") $enterlink.='&npage='.$npage;
			if ($nadd<>"") $enterlink.='&nadd='.$nadd;
		}
		return $enterlink;
	}


	function links($arrtext='',$exttext="",$nlang='') {
		global $sett;
		if ($nlang=='' and isset($_SESSION['nlang'])) $nlang=$_SESSION['nlang'];
		$exttext=str_replace('&','&amp;',$exttext);
		$enterlink=$_SESSION['dcserversite'].'/';
		if ($sett['modrewrite']=="on") {
			if ($arrtext<>'') $enterlink.=$nlang.'/'.str_replace(',','/',$arrtext).'/';
			if ($exttext<>"") $enterlink.='?'.$exttext;
		} else {
			$enterlink.='?';
			if ($arrtext<>"") {
				$enterlink.='nlang='.$nlang;
				$arrtextexp=explode(',',$arrtext);
				for ($i=0; $i<count($arrtextexp); $i++) { 
					if ($i==0) $enterlink.='&npage='.$arrtextexp[$i];
					elseif ($i==1) $enterlink.='&nadd='.$arrtextexp[$i];
					else $enterlink.='&url'.($i+2).'='.$arrtextexp[$i];
				}
			}
			if ($exttext<>"") $enterlink.='&'.$exttext;
		}
		return str_replace(' ','',$enterlink);
	}


	function insertevent($type,$error='',$user='') {
		global $dbevents;
		if ($user=='') {
			if (isset($_SESSION['admin']['login'][0])) $user=$_SESSION['admin']['login'][0];
			elseif (isset($_SESSION['user']['login'][0])) $user=$_SESSION['user']['login'][0];
		}
		dcquery("INSERT INTO `".$dbevents."` VALUES ('','".$type."','".ndatesql()."','".@$_SESSION['webip']."','".@$_SESSION['webhost']."','".@$_SESSION['webcountry']."','".@$_SERVER['REQUEST_URI']."','".$user."','".@$_SERVER['HTTP_REFERER']."','".$error."');"); 
	}


	function showerror() {
		if (isset($_SESSION['serror'])) {
			echo '<div style="overflow: hidden; width: 100%;">';
			foreach ($_SESSION['serror'] AS $text) echo '<div class="alert alert-danger">'.$text.'</div>';
			echo '</div>';
			unset($_SESSION['serror']);
		}
	}

	function showalert() {
		if (isset($_SESSION['salert'])) {
			echo '<div style="overflow: hidden; width: 100%;">';
			foreach ($_SESSION['salert'] AS $text) echo '<div class="alert alert-success">'.$text.'</div>';
			echo '</div>';
			unset($_SESSION['salert']);
		}
	}

	function adderror($str) {
		$_SESSION['serror'][]=$str;
	}

	function addalert($str) {
		$_SESSION['salert'][]=$str;
	}

	
	
	
// ---------------------- SETTINGS

	function dcloadsett($ptid='_core') {
		global $dbsetts;
		$temp=array();
		$result=dcquery("SELECT * FROM `".$dbsetts."` WHERE `ptid`='".$ptid."'");
		while ($line=mysqli_fetch_assoc($result)) { $temp[$line['name']]=$line['value']; }
		return $temp;
	}

	function dcsettload($type='in',$module='_core') {
		global $dbsetts,$sett;
		unset($GLOBALS['sett'],$sett);
		dcquerygetcontent("SELECT * FROM `".$dbsetts."` WHERE `ptid`='".$module."'",'','','$sett=$GLOBALS["sett"][$line["name"]]=$line["value"];');
		$sett=$GLOBALS["sett"];
		if ($type=='return') return $sett;
	}

	function dcsettchange($var,$value,$ptid='_core') {
		global $dbsetts,$sett;
		$thissett=dcloadsett($ptid);
		if (isset($thissett[$var])) dcquery("UPDATE `".$dbsetts."` SET `value`='".$value."',`editdate`='".ndate()."' WHERE `name` ='".$var."' AND `ptid`='".$ptid."' LIMIT 1;");
		else dcquery("INSERT INTO `".$dbsetts."` (`name`,`value`,`ptid`,`editdate`) VALUES ('".$var."','".$value."','".$ptid."','".ndate()."');");
		$sett[$var]=$value;
	}

	function dcsettdelete($var='',$ptid='') {
		global $dbsetts,$sett;
		if ($var<>'' and $ptid<>'') dcquery("DELETE FROM `".$dbsetts."` WHERE `name` ='".$var."' AND `ptid` ='".$ptid."' LIMIT 1;");
		elseif ($var<>'') dcquery("DELETE FROM `".$dbsetts."` WHERE `name` ='".$var."' LIMIT 1;");
		elseif ($ptid<>'') dcquery("DELETE FROM `".$dbsetts."` WHERE `ptid` ='".$ptid."' LIMIT 1;");
		unset($sett[$var]);
	}


// ---------------------- FILES

	function dirToArray($dir='') {
		global $result;
		$cdir = scandir($dir);
		foreach ($cdir as $key => $value) {
			if (!in_array($value,array(".",".."))) {
				if (is_dir($dir.'/'.$value))	dirToArray($dir.'/'.$value);
				else $result[]=array('dir'=>$dir,'file'=>$value);
			}
		}
	   return $result;
	}

	
	function parseindexarray($array) {
		unset($data);
		for ($i=0; $i<count($array); $i++) {
			unset($regs);
			if (preg_match("#//!dc(.*):(.*)\n#isU", $array[$i], $regs)) {
				$regs[1]=trim($regs[1]);
				$regs[2]=trim($regs[2]);
				$data[$regs[1]]=$regs[2];
			}
		}
		if (isset($data)) return $data;
		else return false;
	}


	function parseindexfiles($path) {
		$data=array();
		if ($buffer=file_get_contents($path)) {
			if (preg_match_all("#//!dc(.*):(.*)\n#isU", $buffer, $regs)) {
				for ($i = 0; $i<count($regs[1]); $i++)  $data[trim($regs[1][$i])]=trim($regs[2][$i]);
				return $data;
			}
		}
		return false;
	}



	function dcfilestree($dir) {
		$result = array();
		$cdir = scandir($dir);
		foreach ($cdir as $key => $value) {
			if (!in_array($value,array(".",".."))) {
				if (is_dir($dir.DIRECTORY_SEPARATOR.$value)) $result[$value] = dirToArray($dir.DIRECTORY_SEPARATOR.$value);
				else $result[] = $value;
			}
		}
		return $result;
	} 


	function gopath($path) {
		if ($path[0]<>'/') $path='/'.$path;
		return $_SESSION['urlfolder'].$path;
	}
		
	function makesitemap($data,$file='sitemap.xml') {
		if ($fp=fopen($file,'w')) {
			fwrite($fp,'<?xml version="1.0" encoding="UTF-8"?>');
			fwrite($fp,"\n".'<urlset
		  xmlns="http://www.sitemaps.org/schemas/sitemap/0.9"
		  xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
		  xsi:schemaLocation="http://www.sitemaps.org/schemas/sitemap/0.9
				http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd">');
			for ($i=0; $i<count($data); $i++) {
				fwrite($fp,"\n".'<url>');
				fwrite($fp,"\n".'<loc>'.$data[$i]['loc'].'</loc>');
				fwrite($fp,"\n".'<changefreq>'.$data[$i]['changefreq'].'</changefreq>');
				fwrite($fp,"\n".'<priority>'.number_format($data[$i]['priority'],2).'</priority>');
				fwrite($fp,"\n".'</url>');
			}
			fwrite($fp,"\n".'</urlset>');
			fclose($fp);
		}
	}


	function dczipfiles($filename, $dcfileslist) {
		if (!class_exists('ZipArchive')) {
			echo 'Класс ZipArchive не установлен';
		} else {
			$zip = new ZipArchive();
			if ($zip->open($filename, ZIPARCHIVE::CREATE | ZIPARCHIVE::OVERWRITE) !== true) {
				echo 'Ошибка создания архива';
			} else {
				for ($i=0; $i<count($dcfileslist); $i++) {
					$zip->addFile($dcfileslist[$i]);
				}
				$zip->close();
			}
		}
	}

	function deletefiles($dir) {
		if (is_dir($dir)) {
			if ($dirhandle = opendir($dir)) {
				while (false !== ($file = readdir($dirhandle))) {
					if ($file<>'.' and $file<>'..') {
						if (substr($dir.$file,0,2)=='./') $fname=substr($dir.$file,2);
						else $fname=$dir.$file;
						if (is_dir($fname)) {
							deletefiles($fname.'/');
							rmdir($fname);
						} elseif (is_file($fname)) {
							unlink($fname);
						}
					}
				}
				closedir($dirhandle);
			}
		} else {
			if (substr($dir,0,2)=='./') $fname=substr($dir,2);
			else $fname=$dir;
			unlink($fname);
		}
	}

	function dcloadfulldir($dir='./',$type='simple',&$dcfileslist) {
		if (is_dir($dir)) {
			if ($dirhandle=opendir($dir)) {
				while (false !== ($file=readdir($dirhandle))) {
					if ($file<>'.' and $file<>'..') {
						if (substr($dir.$file,0,2)=='./') $fname=substr($dir.$file,2);
						else $fname=$dir.$file;
						if (is_dir($fname)) {
							dcloadfulldir($fname.'/', $type, $dcfileslist);
						} else {
							if ($type=='simple') $dcfileslist[]=$fname;
							if ($type=='array') $dcfileslist[]=array('name'=>$fname,'type'=>'file','file'=>$file);
						}
					}
				}
				closedir($dirhandle);
			}
		} else {
			if (substr($dir,0,2)=='./') $fname=substr($dir,2);
			else $fname=$dir;
			if ($type=='simple') $dcfileslist[]=$fname;
			if ($type=='array') $dcfileslist[]=array('name'=>$fname,'type'=>'file');
		}
	}


	function dcloaddir($path='./') {
		if ($dirhandle=opendir($path)) {
			while (false !== ($file=readdir($dirhandle))) {
				if (is_dir($path.$file)) $files['dir'][]=$file;
				if (is_file($path.$file)) $files['file'][]=$file;
			}
			closedir($dirhandle);
		}
		if (isset($files)) return $files;
		else return false;
	}


	function fsize($value,$digs=2) { 
		if ($value>999999999) $exitvalue=round(($value/1073741824),$digs).' Gb';
		elseif ($value>999999) $exitvalue=round(($value/1048576),$digs).' Mb';
		elseif ($value>999) $exitvalue=round(($value/1024),$digs).' Kb';
		else $exitvalue=$value.' b';
		return $exitvalue; 
	}


	function savefile($data,$file) {
		if ($fp=fopen($file,'w')) {
			fwrite($fp,$data);
			fclose($fp);
			return true;
		} else {
			return false;
		}
	}


	function dcgeturl($url,$add='') {
		$ch = curl_init($url);
		if (dcisset($add['method'])=='') $add['method']='GET';
		if (!isset($add['agent'])) $add['agent']="Mozilla/5.0 (Windows NT 6.1; WOW64; rv:36.0) Gecko/20100101 Firefox/36.0";
		if (!isset($add['cookie'])) $add['cookie']='cookie.txt';
		if (!isset($add['timeout'])) $add['timeout']=40;
		if (!isset($add['lowspeedtime'])) $add['lowspeedtime']=4;
		if (!isset($add['returntransfer'])) $add['returntransfer']=1;
		if (!isset($add['followlocation'])) $add['followlocation']=1;
		if (!isset($add['verbose'])) $add['verbose']=1;
		curl_setopt($ch, CURLOPT_URL, "$url");
		if (dcisset($add['showheaders'])=='on') {
			curl_setopt($ch, CURLOPT_HEADER, 1);
			curl_setopt($ch, CURLOPT_NOBODY, 0);
		} elseif (dcisset($add['showheaders'])=='only') {
			curl_setopt($ch, CURLOPT_HEADER, 1);
			curl_setopt($ch, CURLOPT_NOBODY, 1);
		} else {
			curl_setopt($ch, CURLOPT_HEADER, 0);
			curl_setopt($ch, CURLOPT_NOBODY, 0);
		}
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, $add['followlocation']);
		curl_setopt($ch, CURLOPT_VERBOSE, $add['verbose']);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, $add['returntransfer']); 
		curl_setopt($ch, CURLOPT_LOW_SPEED_TIME, $add['lowspeedtime']);
		curl_setopt($ch, CURLOPT_TIMEOUT, $add['timeout']);
		if ($add['cookie']<>'') {
			curl_setopt($ch, CURLOPT_COOKIEJAR, $add['cookie']);
			curl_setopt($ch, CURLOPT_COOKIEFILE, $add['cookie']); 
		}
		if ($add['agent']<>'') curl_setopt($ch, CURLOPT_USERAGENT, $add['agent']);
		if (dcisset($add['referer'])<>'') curl_setopt($ch, CURLOPT_REFERER, $add['referer']);
		if (dcisset($add['proxy'])<>'') curl_setopt($ch, CURLOPT_PROXY, $add['proxy']);
		if (dcisset($add['headers'])<>'') {
			if (is_array($add['headers'])) curl_setopt($ch, CURLOPT_HTTPHEADER, $add['headers']);
			else curl_setopt($ch, CURLOPT_HTTPHEADER, array($add['headers']));
		}
		if ($add['method']=='POST') {
			curl_setopt($ch, CURLOPT_POST, TRUE);
			if (dcisset($add['data'])<>'') curl_setopt($ch, CURLOPT_POSTFIELDS, dcisset($add['data']));
		}
		$result=curl_exec($ch);
		curl_close($ch);
		return $result; 
	}


	// sendrequest('http://www.torrents.kg/takelogin.php','username=admin','http://www.torrents.kg/','','','GET','on');
	function sendrequest($url,$data,$referer,$proxy,$proxystatus,$method='POST',$header='') {
		$cookie_jar = "cookie.txt";
		$ch = curl_init("$url");
		if ($header=='on') {
			curl_setopt($ch, CURLOPT_HEADER, 1);
			curl_setopt($ch, CURLOPT_NOBODY, 0);
		} elseif ($header=='only') {
			curl_setopt($ch, CURLOPT_HEADER, 1);
			curl_setopt($ch, CURLOPT_NOBODY, 1);
		} else {
			curl_setopt($ch, CURLOPT_HEADER, 0);
			curl_setopt($ch, CURLOPT_NOBODY, 0);
		}
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
		curl_setopt($ch, CURLOPT_VERBOSE, 1);
		//curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible;MSIE 5.01; Windows NT 5.0)");
		curl_setopt($ch, CURLOPT_COOKIEJAR, "$cookie_jar");
		curl_setopt($ch, CURLOPT_COOKIEFILE, "$cookie_jar"); 
		curl_setopt($ch, CURLOPT_URL, "$url");  
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1); 
		curl_setopt($ch, CURLOPT_REFERER, $referer);
		if ($method=='POST') {
			curl_setopt($ch, CURLOPT_POST, TRUE);
			if ($data<>'') curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
		}
		curl_setopt($ch, CURLOPT_TIMEOUT, 40);
		curl_setopt($ch, CURLOPT_LOW_SPEED_TIME, 4);
		$result=curl_exec($ch);
		curl_close($ch);
		return $result; 
	}

	


// ---------------------- DESIGN

	function dcbutton($title='',$hint='',$link='',$pict='',$style='') {
		global $tl;
		if ($style=='') {
			if ($link<>'') $style='btn-action';
			else $style='btn-action-disable';
		}
		$text='';
		if ($title<>'') $title=' '.$title;
		if ($link<>'') {
			$text.='<a href="'.$link.'" class="'.$style.'" title="'.$tl[$hint].'">';
			if ($pict<>'') $text.='<span class="glyphicon glyphicon-'.$pict.'"></span>';
			$text.=$title.'</a>';
		} else {
			$text.='<span class="'.$style.'">';
			if ($pict<>'') $text.='<span class="glyphicon glyphicon-'.$pict.'"></span>';
			$text.=$title.'</span>';
		}
		return $text;
	}


	function showdeletemess($str='',$address='',$noaddress='') {
		global $mainsec,$section,$tl,$npage;
		if ($str=='') $str=$tl['areyousureyouwanttodelete'];
		if ($noaddress=='') $noaddress=links($npage);
		echo '<div style="margin: 20px auto; overflow: hidden; text-align: center;">';
			echo '<div class="form" style="display: inline-block;">';
				echo '<p style="color: red; font-size: 24px; text-align: left;"><span class="glyphicon glyphicon-warning-sign"></span> '.$tl['attention'].'!</p>';
				echo '<p style="text-align: left;">'.$str.'</p>';
			echo '</div>';
		echo '</div>';
		if ($address=='') {
			echo '<p style="text-align: center;">';
				echo '<a href="'.links($npage).'" class="btn btn-default">'.$tl['cancel'].'</a>';
			echo '</p>';
		} else {
			echo '<form action="'.$address.'" method="post" style="text-align: center;">';
			echo '<button tyle="submit" class="btn btn-danger">'.$tl['yes'].'</button>';
			echo '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
			echo '<a href="'.$noaddress.'" class="btn btn-default">'.$tl['no'].'</a>';
			echo '</form>';
		}
	}
	
	function showpages($thislink,$page=1,$pagesall=1,$minuspage=3) {
		$e=0;
		echo '<nav class="text-center">';
		echo '<ul class="pagination">';
		if ($page>1) echo '<li><a href="'.$thislink.($page-1).'" aria-label="Previous"><span aria-hidden="true">&laquo;</span></a></li>';
		for ($i=1; $i<=$pagesall; $i++) {
			if ($i<=$minuspage or $i>=($pagesall-$minuspage+1) or ($i>=($page-$minuspage) and $i<=($page+$minuspage))) {
				echo '<li'.($i==$page?' class="active"':'').'><a href="'.$thislink.$i.'">'.$i.'</a></li>';
				$e=1;
			} elseif ($e==1) {
				echo '<li class="disabled"><a href="#">...</a></li>';
				$e=0;
			}
		}
		if ($page<$pagesall) echo '<li><a href="'.$thislink.($page+1).'" aria-label="Next"><span aria-hidden="true">&raquo;</span></a></li>';
		echo '</ul>';
		echo '</nav>';
	}

?>