<?php // ЮТФ-8

unset($formstypes);
$formstypes['string']='Текстовая строка';
$formstypes['text']='Текстовое поле';
$formstypes['radio']='Выбор одного из списка';
$formstypes['list']='Выпадающий список';
$formstypes['checklist']='Выбор множества из списка';
$formstypes['calendar']='Календарь';
$formstypes['time']='Время';
$formstypes['date']='Дата';
$formstypes['email']='Email';
$formstypes['password']='Пароль';
$formstypes['file']='Файл';
$formstypes['label']='Метка';
$formstypes['separ']='Разделитель';
$formstypes['securecode']='Проверочный код';

/*
$showfields['phone']=array('type'=>'string','title'=>'Мобильный телефон','style'=>'width: 350px;','obligatory'=>true,'changestr'=>true,'minlen'=>20,'maxlen'=>30,'value'=>'','help'=>'Телефон нужен для уведомлений и не отражается.');
'type'=>'string'							тип [string, text, radio, list, checklist, calendar, time, date, email, password, file, label, separ, securecode]
'title'=>'Мобильный телефон'		заголовок
'style'=>'width: 350px;'				стиль поля
'obligatory'=>false						обязательное поле
'changestr'=>false						кодировать текстовые значения
'minlen'=>20								минимальное количество символов
'maxlen'=>30							максимальное количество символов
'string'=>'abcdefg'						допустимые символы в поле
'value'=>''									указанное значение для редактирования или по-умолчанию
'help'=>'Конфедициально'			помощь для поля
'list'=>array('1'=>'One','2'=>'Two')		список для списков
'attrs'=>'id="host"'		дополнительные данные, наприер: id="host"
*/


function formsinit(&$data,$name) {
	if (!isset($data['type'])) $data['type']='string';
	if (!isset($data['title'])) $data['title']='';
	if (!isset($data['style'])) $data['style']='';
	if (!isset($data['obligatory'])) $data['obligatory']=false;
	if (!isset($data['changestr'])) $data['changestr']=false;
	if (!isset($data['minlen'])) $data['minlen']=0;
	if (!isset($data['maxlen'])) $data['maxlen']=0;
	if (!isset($data['string'])) $data['string']='';
	if (!isset($data['attrs'])) $data['attrs']='';
	if (!isset($data['help'])) $data['help']='';
	if (isset($_SESSION['fv'][$name])) $data['value']=$_SESSION['fv'][$name];
	elseif (isset($data['value']) and is_array($data['value'])) $data['value']=$data['value'];
	elseif (isset($data['value']) and !is_array($data['value'])) $data['value'][0]=$data['value'];
	else $data['value'][0]='';
}


function formlayout($title,$input='',$options='') {
	if (dcisset($options['layouttype'])=='') $options['layouttype']='inline';
	if (dcisset($options['layoutfield'])=='') $options['layoutfield']=='';
	if (dcisset($options['layouttitle'])=='') $options['layouttitle']=='';
	if ($options['layouttype']=='block') {
		echo '<div>';
			if ($options['layouttitle']<>'no') echo $title;
			echo $input;
		echo '</div>';
	} else {
		if ($options['layoutfield']=='wide') {
			echo '<div class="form-group">';
				echo '<div class="col-sm-12">';
					echo $title;
				echo '</div>';
			echo '</div>';
		} else {
			echo '<div class="form-group">';
				echo '<div class="col-sm-3 control-label">';
					echo $title;
				echo '</div>';
				echo '<div class="col-sm-9">';
					echo $input;
				echo '</div>';
			echo '</div>';
		}
	}

}
	




function formbuild($action="",$showfields,$sendbutton,$options='') {
	global $npage,$textlang,$dcformsettings;

	if ($action=='') $action=links($npage);

	echo '<form action="'.$action.'" method="post" enctype="multipart/form-data" class="form-horizontal" role="form">';
		echo '<input type="hidden" name="sendformdata" value="true">';

		foreach($showfields AS $key=>$var) {
			if (dcisset($var['visible'])<>'1') formsshowfield($var,$key,$value,$options);
		}
		
		if (!isset($dcformsettings['noneedfieldtext'])) formlayout('&nbsp;','<p><span style="color: red;">*</span> - <span style="color: gray;">'.@$textlang['formsplus_needfield'].'</span></p>',$options);
		
		$temp1='<button class="btn btn-primary" type="submit">'.$sendbutton.'</button>';
		if (!isset($dcformsettings['nocancelbutton'])) $temp1.=' &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <a href="'.links($npage).'" class="btn btn-default">Отмена</a>';
		formlayout('&nbsp;',$temp1,$options);
	
	echo '</form>';
}



function checkformdata($showfields) {
	global $textlang,$error;
	$fieldsarray=array_keys($showfields);
	if (strpos($_SESSION['webref'],$_SERVER['HTTP_HOST'])===false) {
		adderror($textlang['formsplus_alert5']);
		$error='true';
	}
	for ($a=0; $a<count($fieldsarray); $a++) {
		if (dcisset($showfields[$fieldsarray[$a]]['visible'])<>'1') formscheckdata($showfields[$fieldsarray[$a]],$fieldsarray[$a]);
	}
	if ($error=='true') $_SESSION['forms_error']='true';
	return $error;
}



function createtextdata($showfields) {
	$textdata='';
	$fieldsarray=array_keys($showfields);
	for ($a=0; $a<count($fieldsarray); $a++) {
		if (dcisset($showfields[$fieldsarray[$a]]['visible'])<>'1') $textdata.=formscreatetext($showfields[$fieldsarray[$a]],$fieldsarray[$a]);
	}
	return $textdata;
}



function formscreatetext($data,$name) {
	
	if ($name<>'') {
		formsinit($data,$name);
		$text='';
		
		if ($data['type']=='string') {
			$text=nl2br(htmlspecialchars($_SESSION['fv'][$name][0],ENT_QUOTES));
		}
		if ($data['type']=='text') {
			$text=nl2br(htmlspecialchars($_SESSION['fv'][$name][0],ENT_QUOTES));
		}
		if ($data['type']=='radio') {
			$text=htmlspecialchars($data['list'][$_SESSION['fv'][$name][0]],ENT_QUOTES);
		}
		if ($data['type']=='list') {
			$text=htmlspecialchars($data['list'][$_SESSION['fv'][$name][0]],ENT_QUOTES);
		}
		if ($data['type']=='checklist') {
			$temp=dcisset($_SESSION['fv'][$name]);
			for ($e=0; $e<count($temp); $e++) {
				$text.=htmlspecialchars($data['list'][$temp[$e]],ENT_QUOTES);
				if ($e<(count($temp)-1)) $text.='<br>';
			}
		}
		if ($data['type']=='calendar') {
			$text=nl2br(htmlspecialchars($_SESSION['fv'][$name][0],ENT_QUOTES));
		}
		if ($data['type']=='time') {
			$text=nl2br(htmlspecialchars($_SESSION['fv'][$name]['0'],ENT_QUOTES)).':'.nl2br(htmlspecialchars($_SESSION['fv'][$name]['1'],ENT_QUOTES));
		}
		if ($data['type']=='date') {
			$text=nl2br(htmlspecialchars($_SESSION['fv'][$name]['0'],ENT_QUOTES)).'/'.nl2br(htmlspecialchars($_SESSION['fv'][$name]['1'],ENT_QUOTES)).'/'.nl2br(htmlspecialchars($_SESSION['fv'][$name]['2'],ENT_QUOTES));
		}
		if ($data['type']=='email') {
			$text=nl2br(htmlspecialchars($_SESSION['fv'][$name][0],ENT_QUOTES));
			$text='<a href="mailto:'.$text.'">'.$text.'</a>';
		}
		if ($data['type']=='file') {
			$text=nl2br(htmlspecialchars($_SESSION['fv'][$name][0],ENT_QUOTES));
			$text='<a href="'.$_SESSION['dcserversite'].'/system/temp/'.$text.'" target="_blank">'.$text.'</a>';
		}
		
		if ($text<>'') return '<p><strong>'.$data['title'].':</strong> '.$text.'</p>';
	}
}





function formscheckdata($data,$name) {
	global $textlang,$error;
	
	if ($name<>'') {
		formsinit($data,$name);
		unset($_SESSION['fv'][$name]);
		
		if (isset($_POST[$name])) {
			for ($i=0; $i<count($_POST[$name]); $i++) {
				$temp[]=trim($_POST[$name][$i]);
			}
		}
		
		if ($data['type']=='string') {
			if ($data['obligatory']==true and $temp[0]=='') { adderror($textlang['formsplus_alert2'].' "'.$data['title'].'"'); $error='true'; }
			if ($data['minlen']>0 and $temp[0]<>'' and strlen($temp[0])<$data['minlen']) { adderror($textlang['formsplus_alert11'].' "'.$data['title'].'" (<'.$data['minlen'].')'); $error='true'; }
			if ($data['maxlen']>0 and $temp[0]<>'' and strlen($temp[0])>$data['maxlen']) { adderror($textlang['formsplus_alert1'].' "'.$data['title'].'" (>'.$data['maxlen'].')'); $error='true'; }
			if ($data['string']<>'' and $temp[0]<>'') { for ($y=0; $y<strlen($temp[0]); $y++) { if (strpos($data['string'], $temp[0][$y])===false) { adderror('"'.$data['title'].'" '.$textlang['formsplus_alert12'].' ('.$data['string'].')'); $error='true'; break; } } }
			if ($data['changestr']==true and $temp[0]<>'') { $temp[0]=string2sql($temp[0]); }
		}
		if ($data['type']=='text') {
			if ($data['obligatory']==true and $temp[0]=='') { adderror($textlang['formsplus_alert2'].' "'.$data['title'].'"'); $error='true'; }
			if ($data['minlen']>0 and $temp[0]<>'' and strlen($temp[0])<$data['minlen']) { adderror($textlang['formsplus_alert11'].' "'.$data['title'].'" (<'.$data['minlen'].')'); $error='true'; }
			if ($data['maxlen']>0 and $temp[0]<>'' and strlen($temp[0])>$data['maxlen']) { adderror($textlang['formsplus_alert1'].' "'.$data['title'].'" (>'.$data['maxlen'].')'); $error='true'; }
			if ($data['string']<>'' and $temp[0]<>'') { for ($y=0; $y<strlen($temp[0]); $y++) { if (strpos($data['string'], $temp[0][$y])===false) { adderror('"'.$data['title'].'" '.$textlang['formsplus_alert12'].' ('.$data['string'].')'); $error='true'; break; } } }
			if ($data['changestr']==true and $temp[0]<>'') { $temp[0]=string2sql($temp[0]); }
		}
		if ($data['type']=='radio') {
			if ($data['obligatory']==true and @$temp[0]=='') { adderror($textlang['formsplus_alert2'].' "'.$data['title'].'"'); $error='true'; }
		}
		if ($data['type']=='list') {
			if ($data['obligatory']==true and @$temp[0]=='') { adderror($textlang['formsplus_alert2'].' "'.$data['title'].'"'); $error='true'; }
		}
		if ($data['type']=='checklist') {
			if ($data['obligatory']==true and !isset($temp)) { adderror($textlang['formsplus_alert2'].' "'.$data['title'].'"'); $error='true'; }
		}
		if ($data['type']=='calendar') {
			if ($data['obligatory']==true and $temp[0]=='') { adderror($textlang['formsplus_alert2'].' "'.$data['title'].'"'); $error='true'; }
		}
		if ($data['type']=='time') {
			if ($data['obligatory']==true and ($temp[0]=='' or $temp[1]=='')) { adderror($textlang['formsplus_alert2'].' "'.$data['title'].'"'); $error='true'; }
			if (($temp[0]<>'' and !is_numeric($temp[0])) or ($temp[1]<>'' and !is_numeric($temp[1]))) { adderror('"'.$data['title'].'" '.$textlang['formsplus_alert12']); $error='true'; break; }
		}
		if ($data['type']=='date') {
			if ($data['obligatory']==true and ($temp[0]=='' or $temp[1]=='' or $temp[2]=='')) { adderror($textlang['formsplus_alert2'].' "'.$data['title'].'"'); $error='true'; }
			if (($temp[0]<>'' and !is_numeric($temp[0])) or ($temp[1]<>'' and !is_numeric($temp[1])) or ($temp[2]<>'' and !is_numeric($temp[2]))) { adderror('"'.$data['title'].'" '.$textlang['formsplus_alert12']); $error='true'; break; }
		}
		if ($data['type']=='email') {
			if ($data['obligatory']==true and $temp[0]=='') { adderror($textlang['formsplus_alert2'].' "'.$data['title'].'"'); $error='true'; }
			if ($data['minlen']>0 and $temp[0]<>'' and strlen($temp[0])<$data['minlen']) { adderror($textlang['formsplus_alert11'].' "'.$data['title'].'" (<'.$data['minlen'].')'); $error='true'; }
			if ($data['maxlen']>0 and $temp[0]<>'' and strlen($temp[0])>$data['maxlen']) { adderror($textlang['formsplus_alert1'].' "'.$data['title'].'" (>'.$data['maxlen'].')'); $error='true'; }
			if ($data['string']<>'' and $temp[0]<>'') { for ($y=0; $y<strlen($temp[0]); $y++) { if (strpos($data['string'], $temp[0][$y])===false) { adderror('"'.$data['title'].'" '.$textlang['formsplus_alert12'].' ('.$data['string'].')'); $error='true'; break; } } }
			if ($temp[0]<>'' and !validEmail($temp[0])) { adderror($textlang['formsplus_alert3'].' "'.$data['title'].'"'); $error='true'; }
			if ($data['changestr']==true and $temp[0]<>'') { $temp[0]=string2sql($temp[0]); }
		}
		if ($data['type']=='password') {
			if ($data['obligatory']==true and $temp[0]=='') { adderror($textlang['formsplus_alert2'].' "'.$data['title'].'"'); $error='true'; }
			if ($data['minlen']>0 and $temp[0]<>'' and strlen($temp[0])<$data['minlen']) { adderror($textlang['formsplus_alert11'].' "'.$data['title'].'" (<'.$data['minlen'].')'); $error='true'; }
			if ($data['maxlen']>0 and $temp[0]<>'' and strlen($temp[0])>$data['maxlen']) { adderror($textlang['formsplus_alert1'].' "'.$data['title'].'" (>'.$data['maxlen'].')'); $error='true'; }
			if ($data['string']<>'' and $temp[0]<>'') { for ($y=0; $y<strlen($temp[0]); $y++) { if (strpos($data['string'], $temp[0][$y])===false) { adderror('"'.$data['title'].'" '.$textlang['formsplus_alert12'].' ('.$data['string'].')'); $error='true'; break; } } }
			if ($data['changestr']==true and $temp[0]<>'') { $temp[0]=string2sql($temp[0]); }
		}
		if ($data['type']=='file') {
			if (dcisset($data['optionpath'])<>'') $path=$data['optionpath'];
			else $path='system/temp';
			if ($data['obligatory']==true and @$temp[0]=='' and (!isset($_FILES[$name]['tmp_name']) or $_FILES[$name]['tmp_name']=='')) { adderror($textlang['formsplus_alert2'].' "'.$data['title'].'"'); $error='true'; }
			if (!file_exists($_SESSION['baseurl'].$path)) {
				if (mkdir($_SESSION['baseurl'].$path,0777)) addalert('Папка '.$path.' создана');
				else adderror('Папка '.$path.' не существует и создать не удалось');
			}
			if (isset($_FILES[$name]['tmp_name']) and $_FILES[$name]['tmp_name']<>'' and file_exists($_SESSION['baseurl'].$path)) {
				if (dcisset($data['optionrename'])==false) {
					$newname=$_FILES[$name]['name'];
				} else {
					$number=getnumbertruedate();
					$ext=strrchr($_FILES[$name]['name'],'.');
					$newname=$number.$ext;
				}
				if (copy($_FILES[$name]['tmp_name'],$_SESSION['baseurl'].$path.'/'.$newname)) {
					$temp[0]=$newname;
					$temp[1]=$_FILES[$name]['name'];
				}
			}
		}
		if ($data['type']=='securecode') {
			if ($data['obligatory']==true and $temp[0]=='') { adderror($textlang['formsplus_alert2'].' "'.$data['title'].'"'); $error='true'; }
			if ($temp[0]<>'') {
				include_once $_SESSION['baseurl']."components/securecode/securimage.php";
				$img = new Securimage();
				if (!$img->check($temp[0])) { adderror($textlang['formsplus_alert4']); $error='true'; }
			}
		}
		
		if (isset($temp)) $_SESSION['fv'][$name]=$temp;
	}
}




function formsshowfield($data,$name,&$value='',$options='') {
	global $textlang,$monthsname2,$dcformsettings;
	
	formsinit($data,$name);
	
	if ($data['type']=='label') {
		$options['layoutfield']='wide';
		formlayout($data['title'],'',$options);
	} elseif ($data['type']=='separ') {
		$options['layoutfield']='wide';
		formlayout('&nbsp;','',$options);
	} else {
		if (!isset($dcformsettings['notitle']) and $data['title']<>'') {
			$temp1=$data['title'];
			if ($data['obligatory']==true) $temp1.='&nbsp;<span style="color: red;">*</span>';
		} else {
			$temp1='&nbsp;';
		}
		$temp2=formsshowfieldtype($data,$name,$value);
		if ($data['help']<>'') $temp2.='<p style="font-size: 12px; color: #555;">'.$data['help'].'</p>';
		formlayout($temp1,$temp2,$options);
	}
	
}




function formsshowfieldtype($data,$name,&$value='') {
	global $textlang,$monthsname2;
	
	formsinit($data,$name);
	$temp='';
	
	if ($data['type']=='string') {
		$data['value'][0]=htmlspecialchars($data['value'][0],ENT_QUOTES);
		$temp.='<input type="text" name="'.$name.'[]" value="'.$data['value'][0].'" class="form-control" id="'.$name.'" placeholder="'.$data['title'].'" style="'.$data['style'].'" '.$data['attrs'].' '.($data['obligatory']==true?'required':'').'>';
	}
	if ($data['type']=='text') {
		$data['value'][0]=htmlspecialchars($data['value'][0],ENT_QUOTES);
		$temp.='<textarea name="'.$name.'[]" class="form-control" style="'.$data['style'].'" id="'.$name.'" placeholder="'.$data['title'].'" '.($data['obligatory']==true?'required':'').'>'.$data['value'][0].'</textarea>';
	}
	if ($data['type']=='radio') {
		if (isset($data['list'])) {
			$listarr=array_keys($data['list']);
			for ($l=0; $l<count($listarr); $l++) {
				$temp.='<label><input type="radio" name="'.$name.'[0]" value="'.$listarr[$l].'" id="'.$name.'" '.((isset($data['value'][0]) and $data['value'][0]==$listarr[$l])?'checked':'').' '.($data['obligatory']==true?'required':'').'> '.$data['list'][$listarr[$l]].'</label>';
				if ($l<(count($listarr)-1)) $temp.='<br>';
			}
		}
	}
	if ($data['type']=='list') {
		$temp.='<select size="1" name="'.$name.'[]" class="form-control" id="'.$name.'" placeholder="'.$data['title'].'" style="'.$data['style'].'" '.($data['obligatory']==true?'required':'').'>';
		if ($data['obligatory']<>true) $temp.='<option value=""></option>';
		if (isset($data['list'])) {
			$listarr=array_keys($data['list']);
			for ($l=0; $l<count($listarr); $l++) {
				$temp.='<option value="'.$listarr[$l].'" '.((isset($data['value'][0]) and $data['value'][0]==$listarr[$l])?'selected':'').'>'.$data['list'][$listarr[$l]].'</option>';
			}
		}
		$temp.='</select>';
	}
	if ($data['type']=='checklist') {
		if (isset($data['list'])) {
			$listarr=array_keys($data['list']);
			for ($l=0; $l<count($listarr); $l++) {
				$temp.='<label><input type="checkbox" name="'.$name.'[]" id="'.$name.'" value="'.$listarr[$l].'" '.((isset($data['value']) and in_array($listarr[$l],$data['value']))?'checked':'').' '.($data['obligatory']==true?'required':'').'> '.$data['list'][$listarr[$l]].'</label>';
				if ($l<(count($listarr)-1)) $temp.='<br>';
			}
		}
	}
	if ($data['type']=='calendar') {
		$data['value'][0]=htmlspecialchars($data['value'][0],ENT_QUOTES);
		$temp.='<input type="text" name="'.$name.'" id="'.$name.'[]" class="form-control jdpicker" value="'.$data['value'][0].'" style="width: 130px;" '.($data['obligatory']==true?'required':'').'>';
	}
	if ($data['type']=='time') {
		$dhour=dcisset($data['value'][0]);
		$dmin=dcisset($data['value'][1]);
		$temp.='<input type="text" name="'.$name.'[0]" value="'.$dhour.'" class="form-control" style="width: 30px;" '.($data['obligatory']==true?'required':'').'>';
		$temp.=' : ';
		$temp.='<input type="text" name="'.$name.'[1]" value="'.$dmin.'" class="form-control" style="width: 30px;" '.($data['obligatory']==true?'required':'').'>';
	}
	if ($data['type']=='date') {
		$dday=dcisset($data['value']['0']);
		$dmonth=dcisset($data['value']['1']);
		$dyear=dcisset($data['value']['2']);
		$temp.='<span style="color: gray;">'.$textlang['day'].':</span> ';
		$temp.='<input type="text" name="'.$name.'[0]" value="'.$dday.'" class="form-control" style="width: 30px;">';
		$temp.='&nbsp;&nbsp;';
		$temp.='<span style="color: gray;">'.$textlang['month'].':</span> ';
		$temp.='<select size="1" name="'.$name.'[1]" class="form-control">';
		$temp.='<option value=""></option>'."\n";
		for ($mo=1; $mo<=12; $mo++) $temp.='<option value="'.$mo.'"'.(($mo==$dmonth)?' selected':'').'>'.$monthsname2[$mo].'</option>'."\n";
		$temp.='</select>';
		$temp.='&nbsp;&nbsp;';
		$temp.='<span style="color: gray;">'.$textlang['year'].':</span> ';
		$temp.='<input type="text" name="'.$name.'[2]" value="'.$dyear.'" class="form-control" style="width: 60px;">';
	}
	if ($data['type']=='email') {
		$data['value'][0]=htmlspecialchars($data['value'][0],ENT_QUOTES);
		$temp.='<input type="text" name="'.$name.'[]" value="'.$data['value'][0].'" class="form-control" id="'.$name.'" placeholder="'.$data['title'].'" style="'.$data['style'].'" '.($data['obligatory']==true?'required':'').'>';
	}
	if ($data['type']=='password') {
		$data['value'][0]=htmlspecialchars($data['value'][0],ENT_QUOTES);
		$temp.='<input type="password" name="'.$name.'[]" value="'.$data['value'][0].'" class="form-control" id="'.$name.'" placeholder="'.$data['title'].'" style="'.$data['style'].'" '.($data['obligatory']==true?'required':'').'>';
	}
	if ($data['type']=='securecode') {
		$temp.='<div class="form-group">';
			$temp.='<div class="col-sm-3">';
				//$temp.='<img id="scode" src="'.$_SESSION['dcserversite'].'/components/securecode/securimage_show.php?sid='.md5(uniqid(time())).'" alt="" align="absmiddle">';
				//$temp.='<a tabindex="-1" style="border-style: none" href="#" title="Refresh Image" onclick="document.getElementById(\'scode\').src = \''.$_SESSION['dcserversite'].'/components/securecode/securimage_show.php?sid=\'+Math.random(); return false"><img src="'.$_SESSION['dcserversite'].'/components/securecode/refresh.gif" alt="Reload Image" border="0" onclick="this.blur()" align="bottom" /></a>';
				$temp.='<a tabindex="-1" style="border-style: none" href="#" title="Refresh Image" onclick="document.getElementById(\'scode\').src = \''.$_SESSION['dcserversite'].'/components/securecode/securimage_show.php?sid=\'+Math.random(); return false"><img id="scode" src="'.$_SESSION['dcserversite'].'/components/securecode/securimage_show.php?sid='.md5(uniqid(time())).'" alt="" align="absmiddle"></a>';
			$temp.='</div>';
			$temp.='<div class="col-sm-9">';
				$temp.='<input type="text" name="'.$name.'[]" class="form-control" id="'.$name.'" placeholder="'.$data['title'].'" style="float: left; min-width: 100px; '.$data['style'].'" value="" '.($data['obligatory']==true?'required':'').'>';
			$temp.='</div>';
		$temp.='</div>';
	}
	if ($data['type']=='file') {
		if ($data['value'][0]<>'') {
			if (dcisset($data['optionpath'])<>'') $path=$data['optionpath'];
			else $path='system/temp';
			if (dcisset($data['value'][1])<>'') $thisname=$data['value'][1];
			else $thisname=$data['value'][0];
			$temp.='<a href="'.$_SESSION['dcserversite'].'/'.$path.'/'.$data['value'][0].'" target="_blank">'.$thisname.'</a>';
			$temp.='<input type="hidden" name="'.$name.'[0]" value="'.$data['value'][0].'">';
			$temp.='<input type="hidden" name="'.$name.'[1]" value="'.$data['value'][1].'">';
			$temp.='<br><input type="file" name="'.$name.'" value="'.$data['value'][0].'" class="form-control" style="'.$data['style'].'">';
		} else {
			$temp.='<input type="file" name="'.$name.'" value="'.$data['value'][0].'" class="form-control" style="'.$data['style'].'">';
		}
	}
	
	return $temp;
}


?>