/*
 * Decompiled with CFR 0.152.
 */
package org.verus.ngl.indexing;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.Adler32;
import java.util.zip.CheckedInputStream;
import java.util.zip.CheckedOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import newgenlib.marccomponent.conversion.Converter;
import newgenlib.marccomponent.marcmodel.CatalogMaterialDescription;
import newgenlib.marccomponent.marcmodel.ControlField;
import newgenlib.marccomponent.marcmodel.Field;
import newgenlib.marccomponent.marcmodel.FixedField;
import newgenlib.marccomponent.marcmodel.SubField;
import org.apache.solr.client.solrj.impl.CommonsHttpSolrServer;
import org.apache.solr.common.SolrInputDocument;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.json.JSONArray;
import org.json.JSONObject;
import org.verus.ngl.indexing.NewClass;
import org.verus.ngl.util.DBConnector;
import org.verus.ngl.util.SimpleUtility;
import org.verus.ngl.util.SystemFilesLoader;

public class NewBibliographicSolrIndexCreator {
    private static NewBibliographicSolrIndexCreator instance = null;

    public static final NewBibliographicSolrIndexCreator getInstance() {
        if (instance == null) {
            instance = new NewBibliographicSolrIndexCreator();
        }
        return instance;
    }

    public void deleteData() {
        try {
            System.out.println("-----------Deleting bibliographic index data--------");
            Properties pro = SystemFilesLoader.getInstance().getNewgenlibProperties();
            String solrUrl = pro.getProperty("SOLR_SERVER_URL_FOR_BIBLIOGRAPHIC_DATA");
            CommonsHttpSolrServer server = new CommonsHttpSolrServer(solrUrl);
            server.deleteByQuery("*:*");
            server.commit();
            System.out.println("-----------Deleting authority index data--------");
            String solrUrlAuth = pro.getProperty("SOLR_SERVER_URL_FOR_AUTHORITY_DATA");
            server = new CommonsHttpSolrServer(solrUrlAuth);
            server.deleteByQuery("*:*");
            server.commit();
            System.out.println("Old Index data deleted --- Reindexing data started");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void deleteAuthorityData() {
        try {
            Properties pro = SystemFilesLoader.getInstance().getNewgenlibProperties();
            System.out.println("-----------Deleting authority index data--------");
            String solrUrlAuth = pro.getProperty("SOLR_SERVER_URL_FOR_AUTHORITY_DATA");
            CommonsHttpSolrServer server = new CommonsHttpSolrServer(solrUrlAuth);
            server.deleteByQuery("*:*");
            server.commit();
            System.out.println("Old Index data deleted --- Reindexing data started");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        NewBibliographicSolrIndexCreator bc = new NewBibliographicSolrIndexCreator();
        bc.indexingData();
        bc.deleteData();
    }

    public CatalogMaterialDescription buildCatalogRecord(String marcxml) {
        CatalogMaterialDescription cmd = new CatalogMaterialDescription();
        ArrayList<ControlField> cfs = new ArrayList<ControlField>();
        ArrayList<Field> dfs = new ArrayList<Field>();
        Document doc = null;
        try {
            doc = new SAXBuilder().build((Reader)new StringReader(marcxml));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (doc != null) {
            FixedField ff;
            String leader;
            Namespace ns = doc.getRootElement().getNamespace();
            Element elerec = doc.getRootElement().getChild("record", ns);
            List eledat = elerec.getChildren("datafield", ns);
            for (int i = 0; i < eledat.size(); ++i) {
                Element eleone = (Element)eledat.get(i);
                List elesub = eleone.getChildren("subfield", ns);
                if (elesub == null || elesub.size() <= 0) continue;
                String ind1 = eleone.getAttributeValue("ind1");
                String ind2 = eleone.getAttributeValue("ind2");
                char i1 = ' ';
                char i2 = ' ';
                if (ind1.length() > 0) {
                    i1 = ind1.charAt(0);
                }
                if (ind2.length() > 0) {
                    i2 = ind2.charAt(0);
                }
                Field field = new Field(eleone.getAttributeValue("tag"), i1, i2);
                ArrayList<SubField> sls = new ArrayList<SubField>();
                for (int j = 0; j < elesub.size(); ++j) {
                    Element elesubone = (Element)elesub.get(j);
                    String iden = elesubone.getAttributeValue("code");
                    String data = elesubone.getText();
                    char identich = ' ';
                    if (iden.length() > 0) {
                        identich = iden.charAt(0);
                    }
                    SubField sf = new SubField(identich, data);
                    sls.add(sf);
                }
                field.addSubField(sls);
                dfs.add(field);
            }
            List elecf = elerec.getChildren("controlfield", ns);
            for (int i = 0; i < elecf.size(); ++i) {
                Element eleone = (Element)elecf.get(i);
                String tag = eleone.getAttributeValue("tag");
                String data = eleone.getText();
                ControlField field = new ControlField(tag, data);
                cfs.add(field);
            }
            Element elelead = elerec.getChild("leader", ns);
            if (elelead == null) {
                leader = "00784nam#a0000157ua#124 ";
                ff = new FixedField();
                ff.setLeader(leader);
                cmd.setFixedField(ff);
            } else if (elelead.getText().length() != 24) {
                leader = "00784nam#a0000157ua#124 ";
                ff = new FixedField();
                ff.setLeader(leader);
                cmd.setFixedField(ff);
            } else {
                FixedField ff2 = new FixedField();
                ff2.setLeader(elelead.getText());
                cmd.setFixedField(ff2);
            }
        }
        cmd.addControlField(cfs);
        cmd.addField(dfs);
        return cmd;
    }

    public void indexingData() {
        block89: {
            try {
                int quantum = 500;
                System.out.println("..............solrIndexingCreator.............................. build 29th Jan 2013 with Tika");
                Properties pro = SystemFilesLoader.getInstance().getNewgenlibProperties();
                String solrUrl = pro.getProperty("SOLR_SERVER_URL_FOR_BIBLIOGRAPHIC_DATA");
                CommonsHttpSolrServer server = new CommonsHttpSolrServer(solrUrl);
                Connection con = DBConnector.getInstance().getDBConnection();
                if (NewClass.cure.equals("true")) {
                    Statement statForUp = con.createStatement();
                    System.out.println("Curing XML Records......");
                    statForUp.executeUpdate("update searchable_cataloguerecord set xml_wholerecord=replace(xml_wholerecord,'&#0;',' ')");
                    statForUp.close();
                    System.out.println("Curing XML Records......complete");
                }
                String bibRecCount = "select count(*) from searchable_cataloguerecord";
                int bibCount = 0;
                Statement statx = con.createStatement();
                ResultSet rsCount = statx.executeQuery(bibRecCount);
                while (rsCount.next()) {
                    bibCount = rsCount.getInt(1);
                }
                rsCount.close();
                statx.close();
                if (bibCount > 0) {
                    int iterationVal = bibCount / quantum;
                    if (bibCount / quantum != 0) {
                        ++iterationVal;
                    }
                    if (bibCount < quantum) {
                        ++iterationVal;
                    }
                    boolean incrementVal = false;
                    String query = "Begin work;declare catalogue cursor for select * from searchable_cataloguerecord order by cataloguerecordid";
                    statx = con.createStatement();
                    statx.execute(query);
                    int count = 0;
                    for (int x = 0; x < iterationVal; ++x) {
                        String newQuery = "fetch forward " + quantum + " from catalogue";
                        Statement stat = con.createStatement();
                        ResultSet rs = stat.executeQuery(newQuery);
                        Vector<SolrInputDocument> vecFlush = new Vector<SolrInputDocument>();
                        System.out.println("Pooling " + quantum + " records.... A total of " + count + " out of " + bibCount + " are indexed so far");
                        while (rs.next()) {
                            Integer cataloguerecordid = rs.getInt("cataloguerecordid");
                            Integer owner_library_id = rs.getInt("owner_library_id");
                            query = "select * from searchable_cataloguerecord where cataloguerecordid=" + cataloguerecordid + " and owner_library_id=" + owner_library_id;
                            Statement tsta1 = con.createStatement();
                            ResultSet rs1 = tsta1.executeQuery(query);
                            String wholeXml = "";
                            String wholerec = "";
                            while (rs1.next()) {
                                wholeXml = rs1.getString("xml_wholerecord");
                                wholerec = rs1.getString("wholecataloguerecord");
                            }
                            rs1.close();
                            tsta1.close();
                            if (wholeXml == null) continue;
                            Converter c = Converter.getInstance();
                            CatalogMaterialDescription[] cat = null;
                            if (cat == null || cat.length == 0) {
                                cat = new CatalogMaterialDescription[]{this.buildCatalogRecord(wholeXml)};
                            }
                            if (cat != null && cat.length >= 1) {
                                ArrayList<String> alUrls = new ArrayList<String>();
                                SolrInputDocument solrInputDocument = new SolrInputDocument();
                                solrInputDocument.addField("CatalogueRecordID", (Object)cataloguerecordid);
                                solrInputDocument.addField("OwnerLibraryID", (Object)owner_library_id);
                                solrInputDocument.addField("ID", (Object)(cataloguerecordid + "_" + owner_library_id));
                                ControlField[] controlField = cat[0].getControlField();
                                for (int j = 0; j < controlField.length; ++j) {
                                    ControlField field = controlField[j];
                                    String tagno = field.getTag();
                                    if (tagno == null || !tagno.equalsIgnoreCase("008")) continue;
                                    String lang = field.getData().toString();
                                    String language = "";
                                    if (lang.length() >= 36) {
                                        language = language + lang.charAt(35);
                                    }
                                    if (lang.length() >= 37) {
                                        language = language + lang.charAt(36);
                                    }
                                    if (lang.length() >= 38) {
                                        language = language + lang.charAt(37);
                                    }
                                    if (language.trim() != null && language.trim().length() > 1) {
                                        solrInputDocument.addField("langcode", (Object)language.trim());
                                    }
                                    if (lang.length() > 15) {
                                        String ystr1 = lang.substring(7, 11);
                                        String ystr2 = lang.substring(11, 15);
                                        int int1 = this.parseInteger(ystr1);
                                        int int2 = this.parseInteger(ystr2);
                                        if (int1 != 0) {
                                            solrInputDocument.addField("Year", (Object)int1);
                                        }
                                        if (int2 != 0) {
                                            solrInputDocument.addField("Year", (Object)int2);
                                        }
                                    }
                                    if (lang.length() != 40) continue;
                                    char[] str008charr = lang.toCharArray();
                                    if (str008charr[24] != ' ') {
                                        solrInputDocument.addField("NatureOfContents", (Object)(str008charr[24] + ""));
                                    }
                                    if (str008charr[25] != ' ') {
                                        solrInputDocument.addField("NatureOfContents", (Object)(str008charr[25] + ""));
                                    }
                                    if (str008charr[26] != ' ') {
                                        solrInputDocument.addField("NatureOfContents", (Object)(str008charr[26] + ""));
                                    }
                                    if (str008charr[27] != ' ') {
                                        solrInputDocument.addField("NatureOfContents", (Object)(str008charr[27] + ""));
                                    }
                                    if (str008charr[29] != ' ') {
                                        solrInputDocument.addField("ConferencePublication", (Object)(str008charr[29] + ""));
                                    }
                                    if (str008charr[18] != ' ') {
                                        solrInputDocument.addField("008_18_21", (Object)(str008charr[18] + ""));
                                    }
                                    if (str008charr[19] != ' ') {
                                        solrInputDocument.addField("008_18_21", (Object)(str008charr[19] + ""));
                                    }
                                    if (str008charr[20] != ' ') {
                                        solrInputDocument.addField("008_18_21", (Object)(str008charr[20] + ""));
                                    }
                                    if (str008charr[21] != ' ') {
                                        solrInputDocument.addField("008_18_21", (Object)(str008charr[21] + ""));
                                    }
                                    if (str008charr[22] != ' ') {
                                        solrInputDocument.addField("008_22", (Object)(str008charr[22] + ""));
                                    }
                                    if (str008charr[23] != ' ') {
                                        solrInputDocument.addField("008_23", (Object)(str008charr[23] + ""));
                                    }
                                    if (str008charr[28] != ' ') {
                                        solrInputDocument.addField("008_28", (Object)(str008charr[28] + ""));
                                    }
                                    if (str008charr[30] != ' ') {
                                        solrInputDocument.addField("008_30", (Object)(str008charr[30] + ""));
                                    }
                                    if (str008charr[31] != ' ') {
                                        solrInputDocument.addField("008_31", (Object)(str008charr[31] + ""));
                                    }
                                    if (str008charr[33] != ' ') {
                                        solrInputDocument.addField("008_33", (Object)(str008charr[33] + ""));
                                    }
                                    if (str008charr[34] == ' ') continue;
                                    solrInputDocument.addField("008_34", (Object)(str008charr[34] + ""));
                                }
                                Field[] fieldArr = cat[0].getFields();
                                for (int j = 0; j < fieldArr.length; ++j) {
                                    SubField[] subFldsArr;
                                    Field field = fieldArr[j];
                                    String tagno = field.getTag();
                                    if (tagno != null) {
                                        String subFldsData = "";
                                        SubField[] subFldsArr2 = field.getSubFields();
                                        if (subFldsArr2 != null) {
                                            for (int k = 0; k < subFldsArr2.length; ++k) {
                                                SubField subfld = subFldsArr2[k];
                                                if (String.valueOf(subfld.getIdentifier()).equalsIgnoreCase("a")) {
                                                    solrInputDocument.addField(tagno + "_Tag", (Object)subfld.getData().trim());
                                                }
                                                if (tagno.equals("245") && String.valueOf(subfld.getIdentifier()).equalsIgnoreCase("c")) continue;
                                                subFldsData = subFldsData + subfld.getData() + " ";
                                            }
                                            solrInputDocument.addField(tagno + "_Text", (Object)subFldsData.trim());
                                        }
                                        if (tagno.equals("880")) {
                                            String dat;
                                            String[] splitt;
                                            String tagToUse = "";
                                            SubField[] subField6 = field.getSubFields('6');
                                            if (subField6 != null && subField6.length > 0 && (splitt = (dat = subField6[0].getData()).split("\\-")).length > 0) {
                                                tagToUse = splitt[0];
                                            }
                                            if (!tagToUse.equals("")) {
                                                String subFldsDatax = "";
                                                SubField[] subFldsArrx = field.getSubFields();
                                                if (subFldsArrx != null) {
                                                    for (int k = 0; k < subFldsArrx.length; ++k) {
                                                        SubField subfld = subFldsArrx[k];
                                                        if (String.valueOf(subfld.getIdentifier()).equalsIgnoreCase("a")) {
                                                            solrInputDocument.addField("880_" + tagToUse + "_Tag", (Object)subfld.getData().trim());
                                                        }
                                                        subFldsDatax = subFldsDatax + subfld.getData() + " ";
                                                    }
                                                }
                                                solrInputDocument.addField("880_" + tagToUse + "_Text", (Object)subFldsData.trim());
                                            }
                                        }
                                    }
                                    if (tagno.equalsIgnoreCase("100")) {
                                        subFldsArr = field.getSubFields();
                                        if (subFldsArr == null) continue;
                                        for (int k = 0; k < subFldsArr.length; ++k) {
                                            SubField subfld = subFldsArr[k];
                                            String localTag = tagno + "_" + subfld.getIdentifier();
                                            if (!localTag.equalsIgnoreCase("100_a")) continue;
                                            solrInputDocument.addField("authorStr", (Object)subfld.getData().trim());
                                        }
                                        continue;
                                    }
                                    if (tagno.equalsIgnoreCase("110")) {
                                        subFldsArr = field.getSubFields();
                                        if (subFldsArr == null) continue;
                                        for (int k = 0; k < subFldsArr.length; ++k) {
                                            SubField subfld = subFldsArr[k];
                                            String localTag = tagno + "_" + subfld.getIdentifier();
                                            if (!localTag.equalsIgnoreCase("110_a")) continue;
                                            solrInputDocument.addField("authorStr", (Object)subfld.getData().trim());
                                        }
                                        continue;
                                    }
                                    if (tagno.equalsIgnoreCase("111")) {
                                        subFldsArr = field.getSubFields();
                                        if (subFldsArr == null) continue;
                                        for (int k = 0; k < subFldsArr.length; ++k) {
                                            SubField subfld = subFldsArr[k];
                                            String localTag = tagno + "_" + subfld.getIdentifier();
                                            if (!localTag.equalsIgnoreCase("111_a")) continue;
                                            solrInputDocument.addField("authorStr", (Object)subfld.getData().trim());
                                        }
                                        continue;
                                    }
                                    if (tagno.equalsIgnoreCase("700")) {
                                        subFldsArr = field.getSubFields();
                                        if (subFldsArr == null) continue;
                                        for (int k = 0; k < subFldsArr.length; ++k) {
                                            SubField subfld = subFldsArr[k];
                                            String localTag = tagno + "_" + subfld.getIdentifier();
                                            if (!localTag.equalsIgnoreCase("700_a")) continue;
                                            solrInputDocument.addField("authorStr", (Object)subfld.getData().trim());
                                        }
                                        continue;
                                    }
                                    if (tagno.equalsIgnoreCase("710")) {
                                        subFldsArr = field.getSubFields();
                                        if (subFldsArr == null) continue;
                                        for (int k = 0; k < subFldsArr.length; ++k) {
                                            SubField subfld = subFldsArr[k];
                                            String localTag = tagno + "_" + subfld.getIdentifier();
                                            if (!localTag.equalsIgnoreCase("710_a")) continue;
                                            solrInputDocument.addField("authorStr", (Object)subfld.getData().trim());
                                        }
                                        continue;
                                    }
                                    if (tagno.equalsIgnoreCase("711")) {
                                        subFldsArr = field.getSubFields();
                                        if (subFldsArr == null) continue;
                                        for (int k = 0; k < subFldsArr.length; ++k) {
                                            SubField subfld = subFldsArr[k];
                                            String localTag = tagno + "_" + subfld.getIdentifier();
                                            if (!localTag.equalsIgnoreCase("711_a")) continue;
                                            solrInputDocument.addField("authorStr", (Object)subfld.getData().trim());
                                        }
                                        continue;
                                    }
                                    if (tagno.equalsIgnoreCase("800")) {
                                        subFldsArr = field.getSubFields();
                                        if (subFldsArr == null) continue;
                                        for (int k = 0; k < subFldsArr.length; ++k) {
                                            SubField subfld = subFldsArr[k];
                                            String localTag = tagno + "_" + subfld.getIdentifier();
                                            if (!localTag.equalsIgnoreCase("800_a")) continue;
                                            solrInputDocument.addField("authorStr", (Object)subfld.getData().trim());
                                        }
                                        continue;
                                    }
                                    if (tagno.equalsIgnoreCase("810")) {
                                        subFldsArr = field.getSubFields();
                                        if (subFldsArr == null) continue;
                                        for (int k = 0; k < subFldsArr.length; ++k) {
                                            SubField subfld = subFldsArr[k];
                                            String localTag = tagno + "_" + subfld.getIdentifier();
                                            if (!localTag.equalsIgnoreCase("810_a")) continue;
                                            solrInputDocument.addField("authorStr", (Object)subfld.getData().trim());
                                        }
                                        continue;
                                    }
                                    if (tagno.equalsIgnoreCase("811")) {
                                        subFldsArr = field.getSubFields();
                                        if (subFldsArr == null) continue;
                                        for (int k = 0; k < subFldsArr.length; ++k) {
                                            SubField subfld = subFldsArr[k];
                                            String localTag = tagno + "_" + subfld.getIdentifier();
                                            if (!localTag.equalsIgnoreCase("811_a")) continue;
                                            solrInputDocument.addField("authorStr", (Object)subfld.getData().trim());
                                        }
                                        continue;
                                    }
                                    if (tagno.equalsIgnoreCase("650")) {
                                        subFldsArr = field.getSubFields();
                                        if (subFldsArr == null) continue;
                                        for (int k = 0; k < subFldsArr.length; ++k) {
                                            SubField subfld = subFldsArr[k];
                                            String localTag = tagno + "_" + subfld.getIdentifier();
                                            if (!localTag.equalsIgnoreCase("650_a")) continue;
                                            solrInputDocument.addField("topicStr", (Object)subfld.getData().trim());
                                        }
                                        continue;
                                    }
                                    if (tagno.equalsIgnoreCase("600")) {
                                        subFldsArr = field.getSubFields();
                                        String subjectStr = "";
                                        if (subFldsArr == null) continue;
                                        for (int k = 0; k < subFldsArr.length; ++k) {
                                            SubField subfld = subFldsArr[k];
                                            String localTag = tagno + "_" + subfld.getIdentifier();
                                            if (!localTag.equalsIgnoreCase("600_a") && !localTag.equalsIgnoreCase("600_v") && !localTag.equalsIgnoreCase("600_x") && !localTag.equalsIgnoreCase("600_y") && !localTag.equalsIgnoreCase("600_z")) continue;
                                            subjectStr = subjectStr + subfld.getData().trim() + " --";
                                        }
                                        solrInputDocument.addField(tagno + "_Tag", (Object)subjectStr.trim());
                                        continue;
                                    }
                                    if (tagno.equalsIgnoreCase("610")) {
                                        subFldsArr = field.getSubFields();
                                        if (subFldsArr == null) continue;
                                        String subjectStr = "";
                                        for (int k = 0; k < subFldsArr.length; ++k) {
                                            SubField subfld = subFldsArr[k];
                                            String localTag = tagno + "_" + subfld.getIdentifier();
                                            if (!localTag.equalsIgnoreCase("610_a") && !localTag.equalsIgnoreCase("610_v") && !localTag.equalsIgnoreCase("610_x") && !localTag.equalsIgnoreCase("610_y") && !localTag.equalsIgnoreCase("610_z")) continue;
                                            subjectStr = subjectStr + subfld.getData().trim() + " --";
                                        }
                                        solrInputDocument.addField(tagno + "_Tag", (Object)subjectStr.trim());
                                        continue;
                                    }
                                    if (tagno.equalsIgnoreCase("611")) {
                                        subFldsArr = field.getSubFields();
                                        if (subFldsArr == null) continue;
                                        String subjectStr = "";
                                        for (int k = 0; k < subFldsArr.length; ++k) {
                                            SubField subfld = subFldsArr[k];
                                            String localTag = tagno + "_" + subfld.getIdentifier();
                                            if (!localTag.equalsIgnoreCase("611_a") && !localTag.equalsIgnoreCase("611_v") && !localTag.equalsIgnoreCase("611_x") && !localTag.equalsIgnoreCase("611_y") && !localTag.equalsIgnoreCase("611_z")) continue;
                                            subjectStr = subjectStr + subfld.getData().trim() + " --";
                                        }
                                        solrInputDocument.addField(tagno + "_Tag", (Object)subjectStr.trim());
                                        continue;
                                    }
                                    if (tagno.equalsIgnoreCase("630")) {
                                        subFldsArr = field.getSubFields();
                                        String subjectStr = "";
                                        if (subFldsArr == null) continue;
                                        for (int k = 0; k < subFldsArr.length; ++k) {
                                            SubField subfld = subFldsArr[k];
                                            String localTag = tagno + "_" + subfld.getIdentifier();
                                            if (!localTag.equalsIgnoreCase("630_a") && !localTag.equalsIgnoreCase("630_v") && !localTag.equalsIgnoreCase("630_x") && !localTag.equalsIgnoreCase("630_y") && !localTag.equalsIgnoreCase("630_z")) continue;
                                            subjectStr = subjectStr + subfld.getData().trim() + " --";
                                        }
                                        solrInputDocument.addField(tagno + "_Tag", (Object)subjectStr.trim());
                                        continue;
                                    }
                                    if (tagno.equalsIgnoreCase("650")) {
                                        subFldsArr = field.getSubFields();
                                        String subjectStr = "";
                                        if (subFldsArr == null) continue;
                                        for (int k = 0; k < subFldsArr.length; ++k) {
                                            SubField subfld = subFldsArr[k];
                                            String localTag = tagno + "_" + subfld.getIdentifier();
                                            if (!localTag.equalsIgnoreCase("650_a") && !localTag.equalsIgnoreCase("650_v") && !localTag.equalsIgnoreCase("650_x") && !localTag.equalsIgnoreCase("650_y") && !localTag.equalsIgnoreCase("650_z")) continue;
                                            subjectStr = subjectStr + subfld.getData().trim() + " --";
                                        }
                                        solrInputDocument.addField(tagno + "_Tag", (Object)subjectStr.trim());
                                        continue;
                                    }
                                    if (tagno.equalsIgnoreCase("651")) {
                                        subFldsArr = field.getSubFields();
                                        String subjectStr = "";
                                        if (subFldsArr == null) continue;
                                        for (int k = 0; k < subFldsArr.length; ++k) {
                                            SubField subfld = subFldsArr[k];
                                            String localTag = tagno + "_" + subfld.getIdentifier();
                                            if (!localTag.equalsIgnoreCase("651_a") && !localTag.equalsIgnoreCase("651_v") && !localTag.equalsIgnoreCase("651_x") && !localTag.equalsIgnoreCase("651_y") && !localTag.equalsIgnoreCase("651_z")) continue;
                                            subjectStr = subjectStr + subfld.getData().trim() + " --";
                                        }
                                        solrInputDocument.addField(tagno + "_Tag", (Object)subjectStr.trim());
                                        continue;
                                    }
                                    if (tagno.equalsIgnoreCase("655")) {
                                        subFldsArr = field.getSubFields();
                                        String subjectStr = "";
                                        if (subFldsArr == null) continue;
                                        for (int k = 0; k < subFldsArr.length; ++k) {
                                            SubField subfld = subFldsArr[k];
                                            String localTag = tagno + "_" + subfld.getIdentifier();
                                            if (!localTag.equalsIgnoreCase("655_a") && !localTag.equalsIgnoreCase("655_v") && !localTag.equalsIgnoreCase("655_x") && !localTag.equalsIgnoreCase("655_y") && !localTag.equalsIgnoreCase("655_z")) continue;
                                            subjectStr = subjectStr + subfld.getData().trim() + " --";
                                        }
                                        solrInputDocument.addField(tagno + "_Tag", (Object)subjectStr.trim());
                                        continue;
                                    }
                                    if (tagno.equalsIgnoreCase("260")) {
                                        subFldsArr = field.getSubFields();
                                        String subjectStr = "";
                                        if (subFldsArr == null) continue;
                                        for (int k = 0; k < subFldsArr.length; ++k) {
                                            String dataSF;
                                            SubField subfld = subFldsArr[k];
                                            String localTag = tagno + "_" + subfld.getIdentifier();
                                            if (localTag.equalsIgnoreCase("260_c")) {
                                                dataSF = subfld.getData().trim();
                                                String[] tsr = dataSF.split("-?:?,");
                                                for (int i = 0; i < tsr.length; ++i) {
                                                    String string = tsr[i];
                                                    int valInt = this.extractInteger(string);
                                                    if (valInt == 0) continue;
                                                    solrInputDocument.addField("Year", (Object)valInt);
                                                }
                                                continue;
                                            }
                                            if (!localTag.equalsIgnoreCase("260_b")) continue;
                                            dataSF = subfld.getData().trim();
                                            solrInputDocument.addField("Publisher_Name", (Object)dataSF);
                                        }
                                        solrInputDocument.addField(tagno + "_Tag", (Object)subjectStr.trim());
                                        continue;
                                    }
                                    if (tagno.equalsIgnoreCase("082") || tagno.equalsIgnoreCase("080") || tagno.equalsIgnoreCase("083") || tagno.equalsIgnoreCase("084") || tagno.equalsIgnoreCase("085") || tagno.equalsIgnoreCase("086") || tagno.equalsIgnoreCase("055") || tagno.equalsIgnoreCase("060") || tagno.equalsIgnoreCase("070")) {
                                        subFldsArr = field.getSubFields();
                                        if (subFldsArr == null) continue;
                                        for (int k = 0; k < subFldsArr.length; ++k) {
                                            SubField subfld = subFldsArr[k];
                                            char sfident = subfld.getIdentifier();
                                            String localTag = tagno + "_" + subfld.getIdentifier();
                                            if (sfident != 'a') continue;
                                            solrInputDocument.addField("classificationNumber", (Object)subfld.getData().trim());
                                        }
                                        continue;
                                    }
                                    if (!tagno.equalsIgnoreCase("856") || (subFldsArr = field.getSubFields()) == null) continue;
                                    for (int k = 0; k < subFldsArr.length; ++k) {
                                        String dataInSF;
                                        SubField subfld = subFldsArr[k];
                                        String localTag = tagno + "_" + subfld.getIdentifier();
                                        if (!localTag.equalsIgnoreCase("856_u") || (dataInSF = subfld.getData()).trim().equals("")) continue;
                                        alUrls.add(dataInSF);
                                    }
                                }
                                solrInputDocument = this.getCatalogueRecordData(cataloguerecordid, owner_library_id, con, solrInputDocument);
                                solrInputDocument = this.getAttachmentsData(cataloguerecordid, owner_library_id, solrInputDocument, alUrls);
                                vecFlush.addElement(solrInputDocument);
                                ++count;
                                continue;
                            }
                            System.out.println("cats is null ###################################:  " + cataloguerecordid);
                            System.exit(0);
                        }
                        rs.close();
                        stat.close();
                        System.out.println("Committing: " + vecFlush.size());
                        server.add(vecFlush);
                        try {
                            server.commit();
                            continue;
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    statx.close();
                    statx = con.createStatement();
                    statx.execute("CLOSE catalogue");
                    statx.close();
                    con.close();
                    break block89;
                }
                System.out.println("########### There is no data is available in the Database ##############");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private SolrInputDocument getAttachmentsData(Integer cataloguerecordid, Integer owner_library_id, SolrInputDocument doc, ArrayList alURLS) {
        Properties pro = SystemFilesLoader.getInstance().getNewgenlibProperties();
        String urlsUp = pro.getProperty("INDEX_URLS", "NO");
        String attachUp = pro.getProperty("INDEX_ATTACHMENTS", "NO");
        if (urlsUp.equals("YES") || attachUp.equals("YES")) {
            try {
                JSONObject job = new JSONObject();
                job.put("CatalogueRecordId", (Object)cataloguerecordid.toString()).put("OwnerLibraryId", (Object)owner_library_id.toString());
                if (urlsUp.equals("YES")) {
                    job.put("URLS", (Collection)alURLS);
                } else {
                    job.put("URLS", new ArrayList());
                }
                URL url = new URL("http://localhost:" + pro.getProperty("PORT", "8080") + "/NGLFTE/FTEServlet");
                URLConnection urlconn = url.openConnection();
                urlconn.setDoOutput(true);
                urlconn.setRequestProperty("Content-type", "text/xml; charset=UTF-8");
                OutputStream os = urlconn.getOutputStream();
                String req1xml = job.toString();
                CheckedOutputStream cos = new CheckedOutputStream(os, new Adler32());
                GZIPOutputStream gop = new GZIPOutputStream(cos);
                OutputStreamWriter dos = new OutputStreamWriter((OutputStream)gop, "UTF-8");
                dos.write(req1xml);
                dos.flush();
                dos.close();
                InputStream ios = urlconn.getInputStream();
                CheckedInputStream cis = new CheckedInputStream(ios, new Adler32());
                GZIPInputStream gip = new GZIPInputStream(cis);
                BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)gip, "UTF-8"));
                String resjson = "";
                while (br.ready()) {
                    String line = br.readLine();
                    if (SimpleUtility.getTestedString(line).equals("")) continue;
                    resjson = resjson + line;
                }
                JSONArray jobres = new JSONArray(resjson);
                for (int i = 0; i < jobres.length(); ++i) {
                    JSONObject job1 = jobres.getJSONObject(i);
                    doc.addField("AttachmentType", (Object)job1.getString("Type"));
                    doc.addField("AttachmentContent", (Object)job1.getString("Content"));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return doc;
    }

    public int parseInteger(String str) {
        int retint = 0;
        try {
            retint = Integer.parseInt(str);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retint;
    }

    public int extractInteger(String str) {
        int retint = 0;
        String val = "";
        try {
            char[] avsl = str.toCharArray();
            for (int i = 0; i < avsl.length; ++i) {
                char c = avsl[i];
                if (!Character.isDigit(c)) continue;
                val = val + c;
            }
            retint = Integer.parseInt(val);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retint;
    }

    private SolrInputDocument getCatalogueRecordData(Integer cataloguerecordid, Integer owner_library_id, Connection con, SolrInputDocument doc) {
        try {
            Integer uniformtitle_library_id;
            Integer uniform_title_id;
            Integer meetingname_library_id;
            Integer meeting_name_id;
            Integer corporatename_library_id;
            Integer corporate_name_id;
            Integer personalname_library_id;
            Integer personal_name_id;
            String query = "select * from cataloguerecord where cataloguerecordid=" + cataloguerecordid + " and owner_library_id=" + owner_library_id;
            ResultSet rs = con.createStatement().executeQuery(query);
            boolean bibFlag = true;
            while (rs.next()) {
                while (bibFlag) {
                    Integer bibliograId = rs.getInt("bibiliographic_level_id");
                    Integer matTypeId = rs.getInt("material_type_id");
                    doc.addField("BibliographicLevelID", (Object)bibliograId);
                    doc.addField("MaterialTypeID", (Object)matTypeId);
                    bibFlag = false;
                }
            }
            query = "select * from cat_volume where cataloguerecordid=" + cataloguerecordid + " and owner_library_id=" + owner_library_id;
            rs = con.createStatement().executeQuery(query);
            HashSet<String> complexVolumeId = new HashSet<String>();
            while (rs.next()) {
                Integer volume_id = rs.getInt("volume_id");
                String query2 = "select * from document where volume_id=" + volume_id;
                ResultSet rs2 = con.createStatement().executeQuery(query2);
                while (rs2.next()) {
                    String accession_number = rs2.getString("accession_number");
                    String barcode = rs2.getString("barcode");
                    Integer library_id = rs2.getInt("library_id");
                    Integer location_id = rs2.getInt("location_id");
                    String call_number = rs2.getString("call_number");
                    doc.addField("ShelvingLocationID", (Object)(location_id + "_" + library_id));
                    doc.addField("AccessionNumber", (Object)accession_number.trim());
                    doc.addField("BarcodeNumber", (Object)barcode.trim());
                    doc.addField("callnumber", (Object)call_number.trim());
                    String subLocationId = SimpleUtility.getTestedString(rs2.getString("sub_location_id"));
                    if (!subLocationId.equals("")) {
                        doc.addField("SubLocationID", (Object)(subLocationId + "_" + library_id));
                    }
                    StringTokenizer stk = new StringTokenizer(call_number, " ");
                    while (stk.hasMoreTokens()) {
                        String calsifNo = stk.nextToken();
                        doc.addField("classificationNumber", (Object)calsifNo.trim());
                    }
                }
                rs2.close();
                query = "select * from complex_volumes where volume_id=" + volume_id;
                rs2 = con.createStatement().executeQuery(query);
                while (rs2.next()) {
                    complexVolumeId.add(rs2.getString("complex_volume_id"));
                }
                rs2.close();
            }
            Iterator it = complexVolumeId.iterator();
            while (it.hasNext()) {
                String comVolId = it.next().toString();
                query = "select * from document where complex_volume_id=" + comVolId;
                rs = con.createStatement().executeQuery(query);
                while (rs.next()) {
                    String accession_number = rs.getString("accession_number");
                    String barcode = rs.getString("barcode");
                    Integer library_id = rs.getInt("library_id");
                    Integer location_id = rs.getInt("location_id");
                    String call_number = rs.getString("call_number");
                    String subLocationId = SimpleUtility.getTestedString(rs.getString("sub_location_id"));
                    if (!subLocationId.equals("")) {
                        doc.addField("SubLocationID", (Object)(subLocationId + "_" + library_id));
                    }
                    doc.addField("ShelvingLocationID", (Object)(location_id + "_" + library_id));
                    doc.addField("AccessionNumber", (Object)accession_number.trim());
                    doc.addField("BarcodeNumber", (Object)barcode.trim());
                    doc.addField("HoldingsLibraryID", (Object)library_id);
                    doc.addField("callnumber", (Object)call_number.trim());
                }
                rs.close();
            }
            query = "select * from library_holdings where cataloguerecordid=" + cataloguerecordid + " and owner_library_id=" + owner_library_id;
            rs = con.createStatement().executeQuery(query);
            while (rs.next()) {
                Integer holdings_library_id = rs.getInt("holdings_library_id");
                Integer sub_loc_id = rs.getInt("sublocation_id");
                doc.addField("SubLocationID", (Object)(sub_loc_id + "_" + holdings_library_id));
                doc.addField("HoldingsLibraryID", (Object)holdings_library_id);
            }
            query = "select * from cataloguerecord where cataloguerecordid=" + cataloguerecordid + " and owner_library_id=" + owner_library_id;
            rs = con.createStatement().executeQuery(query);
            while (rs.next()) {
                String open_archive = rs.getString("open_archive");
                if (open_archive == null) {
                    doc.addField("OpenArchive", (Object)"B");
                    continue;
                }
                doc.addField("OpenArchive", (Object)open_archive.trim());
            }
            query = "select * from keywords where cataloguerecordid=" + cataloguerecordid + " and owner_library=" + owner_library_id;
            rs = con.createStatement().executeQuery(query);
            while (rs.next()) {
                String keyword = rs.getString("keyword");
                doc.addField("Keywords", (Object)keyword.trim());
            }
            query = "select * from searchable_cataloguerecord where cataloguerecordid=" + cataloguerecordid + " and owner_library_id=" + owner_library_id;
            rs = con.createStatement().executeQuery(query);
            while (rs.next()) {
                personal_name_id = rs.getInt("personal_name_id");
                personalname_library_id = rs.getInt("personalname_library_id");
                if (personal_name_id == null || personal_name_id == 0 || personalname_library_id == null || personalname_library_id == 0) continue;
                doc.addField("PN_IDS", (Object)(personal_name_id + "_" + personalname_library_id));
            }
            query = "select * from searchable_personalnameae_ass where cataloguerecordid=" + cataloguerecordid + " and owner_library_id=" + owner_library_id;
            rs = con.createStatement().executeQuery(query);
            while (rs.next()) {
                personal_name_id = rs.getInt("personal_name_id");
                personalname_library_id = rs.getInt("personalname_library_id");
                if (personal_name_id == null || personal_name_id == 0 || personalname_library_id == null || personalname_library_id == 0) continue;
                doc.addField("PN_IDS", (Object)(personal_name_id + "_" + personalname_library_id));
            }
            query = "select * from searchable_personalsae_ass where cataloguerecordid=" + cataloguerecordid + " and owner_library_id=" + owner_library_id;
            rs = con.createStatement().executeQuery(query);
            while (rs.next()) {
                personal_name_id = rs.getInt("personal_name_id");
                personalname_library_id = rs.getInt("personalname_library_id");
                if (personal_name_id == null || personal_name_id == 0 || personalname_library_id == null || personalname_library_id == 0) continue;
                doc.addField("PN_IDS", (Object)(personal_name_id + "_" + personalname_library_id));
            }
            query = "select * from searchable_personalsh_ass where cataloguerecordid=" + cataloguerecordid + " and owner_library_id=" + owner_library_id;
            rs = con.createStatement().executeQuery(query);
            while (rs.next()) {
                personal_name_id = rs.getInt("subpersonalname_id");
                personalname_library_id = rs.getInt("subpersonalname_libraryid");
                if (personal_name_id == null || personal_name_id == 0 || personalname_library_id == null || personalname_library_id == 0) continue;
                doc.addField("PN_IDS", (Object)(personal_name_id + "_" + personalname_library_id));
            }
            query = "select * from searchable_cataloguerecord where cataloguerecordid=" + cataloguerecordid + " and owner_library_id=" + owner_library_id;
            rs = con.createStatement().executeQuery(query);
            while (rs.next()) {
                corporate_name_id = rs.getInt("corporate_name_id");
                corporatename_library_id = rs.getInt("corporatename_library_id");
                if (corporate_name_id == null || corporatename_library_id == null || corporate_name_id == 0 || corporatename_library_id == 0) continue;
                doc.addField("CN_IDS", (Object)(corporate_name_id + "_" + corporatename_library_id));
            }
            query = "select * from searchable_corporatenameae_ass where cataloguerecordid=" + cataloguerecordid + " and owner_library_id=" + owner_library_id;
            rs = con.createStatement().executeQuery(query);
            while (rs.next()) {
                corporate_name_id = rs.getInt("corporate_name_id");
                corporatename_library_id = rs.getInt("corporatename_library_id");
                if (corporate_name_id == null || corporatename_library_id == null || corporate_name_id == 0 || corporatename_library_id == 0) continue;
                doc.addField("CN_IDS", (Object)(corporate_name_id + "_" + corporatename_library_id));
            }
            query = "select * from searchable_corporatesae_ass where cataloguerecordid=" + cataloguerecordid + " and owner_library_id=" + owner_library_id;
            rs = con.createStatement().executeQuery(query);
            while (rs.next()) {
                corporate_name_id = rs.getInt("corporate_name_id");
                corporatename_library_id = rs.getInt("corporatename_library_id");
                if (corporate_name_id == null || corporatename_library_id == null || corporate_name_id == 0 || corporatename_library_id == 0) continue;
                doc.addField("CN_IDS", (Object)(corporate_name_id + "_" + corporatename_library_id));
            }
            query = "select * from searchable_corporatesh_ass where cataloguerecordid=" + cataloguerecordid + " and owner_library_id=" + owner_library_id;
            rs = con.createStatement().executeQuery(query);
            while (rs.next()) {
                corporate_name_id = rs.getInt("subcorporatename_id");
                corporatename_library_id = rs.getInt("library_id");
                if (corporate_name_id == null || corporatename_library_id == null || corporate_name_id == 0 || corporatename_library_id == 0) continue;
                doc.addField("CN_IDS", (Object)(corporate_name_id + "_" + corporatename_library_id));
            }
            query = "select * from searchable_cataloguerecord where cataloguerecordid=" + cataloguerecordid + " and owner_library_id=" + owner_library_id;
            rs = con.createStatement().executeQuery(query);
            while (rs.next()) {
                meeting_name_id = rs.getInt("meeting_name_id");
                meetingname_library_id = rs.getInt("meetingname_library_id");
                if (meeting_name_id == null || meetingname_library_id == null || meeting_name_id == 0 || meetingname_library_id == 0) continue;
                doc.addField("MN_IDS", (Object)(meeting_name_id + "_" + meetingname_library_id));
            }
            query = "select * from searchable_meetingnameae_ass where cataloguerecordid=" + cataloguerecordid + " and owner_library_id=" + owner_library_id;
            rs = con.createStatement().executeQuery(query);
            while (rs.next()) {
                meeting_name_id = rs.getInt("meeting_name_id");
                meetingname_library_id = rs.getInt("meetingname_library_id");
                if (meeting_name_id == null || meetingname_library_id == null || meeting_name_id == 0 || meetingname_library_id == 0) continue;
                doc.addField("MN_IDS", (Object)(meeting_name_id + "_" + meetingname_library_id));
            }
            query = "select * from searchable_meetingnamesae_ass where cataloguerecordid=" + cataloguerecordid + " and owner_library_id=" + owner_library_id;
            rs = con.createStatement().executeQuery(query);
            while (rs.next()) {
                meeting_name_id = rs.getInt("meeting_name_id");
                meetingname_library_id = rs.getInt("meetingname_library_id");
                if (meeting_name_id == null || meetingname_library_id == null || meeting_name_id == 0 || meetingname_library_id == 0) continue;
                doc.addField("MN_IDS", (Object)(meeting_name_id + "_" + meetingname_library_id));
            }
            query = "select * from searchable_meetingsh_ass where cataloguerecordid=" + cataloguerecordid + " and owner_library_id=" + owner_library_id;
            rs = con.createStatement().executeQuery(query);
            while (rs.next()) {
                meeting_name_id = rs.getInt("submeetingname_id");
                meetingname_library_id = rs.getInt("submeetingname_libraryid");
                if (meeting_name_id == null || meetingname_library_id == null || meeting_name_id == 0 || meetingname_library_id == 0) continue;
                doc.addField("MN_IDS", (Object)(meeting_name_id + "_" + meetingname_library_id));
            }
            query = "select * from searchable_cataloguerecord where cataloguerecordid=" + cataloguerecordid + " and owner_library_id=" + owner_library_id;
            rs = con.createStatement().executeQuery(query);
            while (rs.next()) {
                uniform_title_id = rs.getInt("uniform_title_id");
                uniformtitle_library_id = rs.getInt("uniformtitle_library_id");
                if (uniform_title_id == null || uniformtitle_library_id == null || uniform_title_id == 0 || uniformtitle_library_id == 0) continue;
                doc.addField("UT_IDS", (Object)(uniform_title_id + "_" + uniformtitle_library_id));
            }
            query = "select * from searchable_uniformsh_ass where cataloguerecordid=" + cataloguerecordid + " and owner_library_id=" + owner_library_id;
            rs = con.createStatement().executeQuery(query);
            while (rs.next()) {
                uniform_title_id = rs.getInt("subuniformtitle_id");
                uniformtitle_library_id = rs.getInt("subuniformtitle_libraryid");
                if (uniform_title_id == null || uniformtitle_library_id == null || uniform_title_id == 0 || uniformtitle_library_id == 0) continue;
                doc.addField("UT_IDS", (Object)(uniform_title_id + "_" + uniformtitle_library_id));
            }
            query = "select * from searchable_uniformtitlesae_ass where cataloguerecordid=" + cataloguerecordid + " and owner_library_id=" + owner_library_id;
            rs = con.createStatement().executeQuery(query);
            while (rs.next()) {
                uniform_title_id = rs.getInt("uniform_title_id");
                uniformtitle_library_id = rs.getInt("uniformtitle_library_id");
                if (uniform_title_id == null || uniformtitle_library_id == null || uniform_title_id == 0 || uniformtitle_library_id == 0) continue;
                doc.addField("UT_IDS", (Object)(uniform_title_id + "_" + uniformtitle_library_id));
            }
            query = "select * from searchable_series_name_ass where cataloguerecordid=" + cataloguerecordid + " and owner_library_id=" + owner_library_id;
            rs = con.createStatement().executeQuery(query);
            while (rs.next()) {
                Integer series_name_id = rs.getInt("series_name_id");
                Integer seriesname_libraryid = rs.getInt("seriesname_library_id");
                if (series_name_id == null || seriesname_libraryid == null || series_name_id == 0 || seriesname_libraryid == 0) continue;
                doc.addField("UT_IDS", (Object)(series_name_id + "_" + seriesname_libraryid));
            }
            query = "select * from searchable_topicaltermsh_ass where cataloguerecordid=" + cataloguerecordid + " and owner_library_id=" + owner_library_id;
            rs = con.createStatement().executeQuery(query);
            while (rs.next()) {
                Integer subtopic_id = rs.getInt("subtopic_id");
                Integer subtopic_libraryid = rs.getInt("subtopic_libraryid");
                if (subtopic_id == null || subtopic_libraryid == null || subtopic_id == 0 || subtopic_libraryid == 0) continue;
                doc.addField("TTSH_IDS", (Object)(subtopic_id + "_" + subtopic_libraryid));
            }
            query = "select * from searchable_geonamesh_ass where cataloguerecordid=" + cataloguerecordid + " and owner_library_id=" + owner_library_id;
            rs = con.createStatement().executeQuery(query);
            while (rs.next()) {
                Integer subgeoname_id = rs.getInt("subgeoname_id");
                Integer subgeoname_libraryid = rs.getInt("subgeoname_libraryid");
                if (subgeoname_id == null || subgeoname_libraryid == null || subgeoname_id == 0 || subgeoname_libraryid == 0) continue;
                doc.addField("GNSH_IDS", (Object)(subgeoname_id + "_" + subgeoname_libraryid));
            }
            query = "select * from searchable_formgenresh_ass where cataloguerecordid=" + cataloguerecordid + " and owner_library_id=" + owner_library_id;
            rs = con.createStatement().executeQuery(query);
            while (rs.next()) {
                Integer formgenre_id = rs.getInt("formgenre_id");
                Integer formgenre_library_id = rs.getInt("formgenre_library_id");
                if (formgenre_id == null || formgenre_library_id == null || formgenre_id == 0 || formgenre_library_id == 0) continue;
                doc.addField("FGSH_IDS", (Object)(formgenre_id + "_" + formgenre_library_id));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return doc;
    }

    public void indexingOneRecordData(Connection con, String catalogueRecordId, String ownerLibraryId) {
        try {
            System.out.println("..............solrIndexingCreator..............................");
            Properties pro = SystemFilesLoader.getInstance().getNewgenlibProperties();
            String solrUrl = pro.getProperty("SOLR_SERVER_URL_FOR_BIBLIOGRAPHIC_DATA");
            CommonsHttpSolrServer server = new CommonsHttpSolrServer(solrUrl);
            String newQuery = "select * from cataloguerecord where cataloguerecordid=" + catalogueRecordId + " and owner_library_id=" + ownerLibraryId;
            Statement stat = con.createStatement();
            ResultSet rs = stat.executeQuery(newQuery);
            while (rs.next()) {
                Integer cataloguerecordid = rs.getInt("cataloguerecordid");
                Integer owner_library_id = rs.getInt("owner_library_id");
                String query = "select * from searchable_cataloguerecord where cataloguerecordid=" + cataloguerecordid + " and owner_library_id=" + owner_library_id;
                Statement tsta1 = con.createStatement();
                ResultSet rs1 = tsta1.executeQuery(query);
                String wholeXml = "";
                while (rs1.next()) {
                    wholeXml = rs1.getString("wholecataloguerecord");
                }
                rs1.close();
                tsta1.close();
                if (wholeXml == null) continue;
                Converter c = Converter.getInstance();
                CatalogMaterialDescription[] cat = null;
                try {
                    cat = c.getMarcModelsFromMarc(wholeXml);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (cat == null || cat.length < 1) continue;
                SolrInputDocument solrInputDocument = new SolrInputDocument();
                solrInputDocument.addField("CatalogueRecordID", (Object)cataloguerecordid);
                solrInputDocument.addField("OwnerLibraryID", (Object)owner_library_id);
                solrInputDocument.addField("ID", (Object)(cataloguerecordid + "_" + owner_library_id));
                ControlField[] controlField = cat[0].getControlField();
                for (int j = 0; j < controlField.length; ++j) {
                    ControlField field = controlField[j];
                    String tagno = field.getTag();
                    if (!tagno.equalsIgnoreCase("008")) continue;
                    String lang = field.getData().toString();
                    String language = "";
                    if (lang.length() >= 36) {
                        language = language + lang.charAt(35);
                    }
                    if (lang.length() >= 37) {
                        language = language + lang.charAt(36);
                    }
                    if (lang.length() >= 38) {
                        language = language + lang.charAt(37);
                    }
                    if (language.trim() != null && language.trim().length() > 1) {
                        solrInputDocument.addField("langcode", (Object)language.trim());
                    }
                    if (lang.length() > 15) {
                        String ystr1 = lang.substring(7, 11);
                        String ystr2 = lang.substring(11, 15);
                        int int1 = this.parseInteger(ystr1);
                        int int2 = this.parseInteger(ystr2);
                        if (int1 != 0) {
                            solrInputDocument.addField("Year", (Object)int1);
                        }
                        if (int2 != 0) {
                            solrInputDocument.addField("Year", (Object)int2);
                        }
                    }
                    if (lang.length() != 40) continue;
                    char[] str008charr = lang.toCharArray();
                    if (str008charr[24] != ' ') {
                        solrInputDocument.addField("NatureOfContents", (Object)(str008charr[24] + ""));
                    }
                    if (str008charr[25] != ' ') {
                        solrInputDocument.addField("NatureOfContents", (Object)(str008charr[25] + ""));
                    }
                    if (str008charr[26] != ' ') {
                        solrInputDocument.addField("NatureOfContents", (Object)(str008charr[26] + ""));
                    }
                    if (str008charr[27] != ' ') {
                        solrInputDocument.addField("NatureOfContents", (Object)(str008charr[27] + ""));
                    }
                    if (str008charr[29] != ' ') {
                        solrInputDocument.addField("ConferencePublication", (Object)(str008charr[29] + ""));
                    }
                    if (str008charr[18] != ' ') {
                        solrInputDocument.addField("008_18_21", (Object)(str008charr[18] + ""));
                    }
                    if (str008charr[19] != ' ') {
                        solrInputDocument.addField("008_18_21", (Object)(str008charr[19] + ""));
                    }
                    if (str008charr[20] != ' ') {
                        solrInputDocument.addField("008_18_21", (Object)(str008charr[20] + ""));
                    }
                    if (str008charr[21] != ' ') {
                        solrInputDocument.addField("008_18_21", (Object)(str008charr[21] + ""));
                    }
                    if (str008charr[22] != ' ') {
                        solrInputDocument.addField("008_22", (Object)(str008charr[22] + ""));
                    }
                    if (str008charr[23] != ' ') {
                        solrInputDocument.addField("008_23", (Object)(str008charr[23] + ""));
                    }
                    if (str008charr[28] != ' ') {
                        solrInputDocument.addField("008_28", (Object)(str008charr[28] + ""));
                    }
                    if (str008charr[30] != ' ') {
                        solrInputDocument.addField("008_30", (Object)(str008charr[30] + ""));
                    }
                    if (str008charr[31] != ' ') {
                        solrInputDocument.addField("008_31", (Object)(str008charr[31] + ""));
                    }
                    if (str008charr[33] != ' ') {
                        solrInputDocument.addField("008_33", (Object)(str008charr[33] + ""));
                    }
                    if (str008charr[34] == ' ') continue;
                    solrInputDocument.addField("008_34", (Object)(str008charr[34] + ""));
                }
                Field[] fieldArr = cat[0].getFields();
                for (int j = 0; j < fieldArr.length; ++j) {
                    SubField[] subFldsArr;
                    Field field = fieldArr[j];
                    String tagno = field.getTag();
                    if (tagno != null) {
                        String subFldsData = "";
                        SubField[] subFldsArr2 = field.getSubFields();
                        if (subFldsArr2 != null) {
                            for (int k = 0; k < subFldsArr2.length; ++k) {
                                SubField subfld = subFldsArr2[k];
                                if (String.valueOf(subfld.getIdentifier()).equalsIgnoreCase("a")) {
                                    solrInputDocument.addField(tagno + "_Tag", (Object)subfld.getData().trim());
                                }
                                subFldsData = subFldsData + subfld.getData() + " ";
                            }
                            solrInputDocument.addField(tagno + "_Text", (Object)subFldsData.trim());
                        }
                        if (tagno.equals("880")) {
                            String dat;
                            String[] splitt;
                            String tagToUse = "";
                            SubField[] subField6 = field.getSubFields('6');
                            if (subField6 != null && subField6.length > 0 && (splitt = (dat = subField6[0].getData()).split("\\-")).length > 0) {
                                tagToUse = splitt[0];
                            }
                            if (!tagToUse.equals("")) {
                                String subFldsDatax = "";
                                SubField[] subFldsArrx = field.getSubFields();
                                if (subFldsArrx != null) {
                                    for (int k = 0; k < subFldsArrx.length; ++k) {
                                        SubField subfld = subFldsArrx[k];
                                        if (String.valueOf(subfld.getIdentifier()).equalsIgnoreCase("a")) {
                                            solrInputDocument.addField(tagToUse + "_Tag", (Object)subfld.getData().trim());
                                        }
                                        subFldsDatax = subFldsDatax + subfld.getData() + " ";
                                    }
                                }
                                solrInputDocument.addField(tagToUse + "_Text", (Object)subFldsData.trim());
                            }
                        }
                    }
                    if (tagno.equalsIgnoreCase("100")) {
                        subFldsArr = field.getSubFields();
                        if (subFldsArr == null) continue;
                        for (int k = 0; k < subFldsArr.length; ++k) {
                            SubField subfld = subFldsArr[k];
                            String localTag = tagno + "_" + subfld.getIdentifier();
                            if (!localTag.equalsIgnoreCase("100_a")) continue;
                            solrInputDocument.addField("authorStr", (Object)subfld.getData().trim());
                        }
                        continue;
                    }
                    if (tagno.equalsIgnoreCase("110")) {
                        subFldsArr = field.getSubFields();
                        if (subFldsArr == null) continue;
                        for (int k = 0; k < subFldsArr.length; ++k) {
                            SubField subfld = subFldsArr[k];
                            String localTag = tagno + "_" + subfld.getIdentifier();
                            if (!localTag.equalsIgnoreCase("110_a")) continue;
                            solrInputDocument.addField("authorStr", (Object)subfld.getData().trim());
                        }
                        continue;
                    }
                    if (tagno.equalsIgnoreCase("111")) {
                        subFldsArr = field.getSubFields();
                        if (subFldsArr == null) continue;
                        for (int k = 0; k < subFldsArr.length; ++k) {
                            SubField subfld = subFldsArr[k];
                            String localTag = tagno + "_" + subfld.getIdentifier();
                            if (!localTag.equalsIgnoreCase("111_a")) continue;
                            solrInputDocument.addField("authorStr", (Object)subfld.getData().trim());
                        }
                        continue;
                    }
                    if (tagno.equalsIgnoreCase("700")) {
                        subFldsArr = field.getSubFields();
                        if (subFldsArr == null) continue;
                        for (int k = 0; k < subFldsArr.length; ++k) {
                            SubField subfld = subFldsArr[k];
                            String localTag = tagno + "_" + subfld.getIdentifier();
                            if (!localTag.equalsIgnoreCase("700_a")) continue;
                            solrInputDocument.addField("authorStr", (Object)subfld.getData().trim());
                        }
                        continue;
                    }
                    if (tagno.equalsIgnoreCase("710")) {
                        subFldsArr = field.getSubFields();
                        if (subFldsArr == null) continue;
                        for (int k = 0; k < subFldsArr.length; ++k) {
                            SubField subfld = subFldsArr[k];
                            String localTag = tagno + "_" + subfld.getIdentifier();
                            if (!localTag.equalsIgnoreCase("710_a")) continue;
                            solrInputDocument.addField("authorStr", (Object)subfld.getData().trim());
                        }
                        continue;
                    }
                    if (tagno.equalsIgnoreCase("711")) {
                        subFldsArr = field.getSubFields();
                        if (subFldsArr == null) continue;
                        for (int k = 0; k < subFldsArr.length; ++k) {
                            SubField subfld = subFldsArr[k];
                            String localTag = tagno + "_" + subfld.getIdentifier();
                            if (!localTag.equalsIgnoreCase("711_a")) continue;
                            solrInputDocument.addField("authorStr", (Object)subfld.getData().trim());
                        }
                        continue;
                    }
                    if (tagno.equalsIgnoreCase("800")) {
                        subFldsArr = field.getSubFields();
                        if (subFldsArr == null) continue;
                        for (int k = 0; k < subFldsArr.length; ++k) {
                            SubField subfld = subFldsArr[k];
                            String localTag = tagno + "_" + subfld.getIdentifier();
                            if (!localTag.equalsIgnoreCase("800_a")) continue;
                            solrInputDocument.addField("authorStr", (Object)subfld.getData().trim());
                        }
                        continue;
                    }
                    if (tagno.equalsIgnoreCase("810")) {
                        subFldsArr = field.getSubFields();
                        if (subFldsArr == null) continue;
                        for (int k = 0; k < subFldsArr.length; ++k) {
                            SubField subfld = subFldsArr[k];
                            String localTag = tagno + "_" + subfld.getIdentifier();
                            if (!localTag.equalsIgnoreCase("810_a")) continue;
                            solrInputDocument.addField("authorStr", (Object)subfld.getData().trim());
                        }
                        continue;
                    }
                    if (tagno.equalsIgnoreCase("811")) {
                        subFldsArr = field.getSubFields();
                        if (subFldsArr == null) continue;
                        for (int k = 0; k < subFldsArr.length; ++k) {
                            SubField subfld = subFldsArr[k];
                            String localTag = tagno + "_" + subfld.getIdentifier();
                            if (!localTag.equalsIgnoreCase("811_a")) continue;
                            solrInputDocument.addField("authorStr", (Object)subfld.getData().trim());
                        }
                        continue;
                    }
                    if (tagno.equalsIgnoreCase("650")) {
                        subFldsArr = field.getSubFields();
                        if (subFldsArr == null) continue;
                        for (int k = 0; k < subFldsArr.length; ++k) {
                            SubField subfld = subFldsArr[k];
                            String localTag = tagno + "_" + subfld.getIdentifier();
                            if (!localTag.equalsIgnoreCase("650_a")) continue;
                            solrInputDocument.addField("topicStr", (Object)subfld.getData().trim());
                        }
                        continue;
                    }
                    if (tagno.equalsIgnoreCase("600")) {
                        subFldsArr = field.getSubFields();
                        String subjectStr = "";
                        if (subFldsArr == null) continue;
                        for (int k = 0; k < subFldsArr.length; ++k) {
                            SubField subfld = subFldsArr[k];
                            String localTag = tagno + "_" + subfld.getIdentifier();
                            if (localTag.equalsIgnoreCase("600_a")) {
                                solrInputDocument.addField("topicStr", (Object)subfld.getData().trim());
                            }
                            if (!localTag.equalsIgnoreCase("600_a") && !localTag.equalsIgnoreCase("600_v") && !localTag.equalsIgnoreCase("600_x") && !localTag.equalsIgnoreCase("600_y") && !localTag.equalsIgnoreCase("600_z")) continue;
                            subjectStr = subjectStr + subfld.getData().trim() + " --";
                        }
                        solrInputDocument.addField(tagno + "_Tag", (Object)subjectStr.trim());
                        continue;
                    }
                    if (tagno.equalsIgnoreCase("610")) {
                        subFldsArr = field.getSubFields();
                        if (subFldsArr == null) continue;
                        String subjectStr = "";
                        for (int k = 0; k < subFldsArr.length; ++k) {
                            SubField subfld = subFldsArr[k];
                            String localTag = tagno + "_" + subfld.getIdentifier();
                            if (localTag.equalsIgnoreCase("610_a")) {
                                solrInputDocument.addField("topicStr", (Object)subfld.getData().trim());
                            }
                            if (!localTag.equalsIgnoreCase("610_a") && !localTag.equalsIgnoreCase("610_v") && !localTag.equalsIgnoreCase("610_x") && !localTag.equalsIgnoreCase("610_y") && !localTag.equalsIgnoreCase("610_z")) continue;
                            subjectStr = subjectStr + subfld.getData().trim() + " --";
                        }
                        solrInputDocument.addField(tagno + "_Tag", (Object)subjectStr.trim());
                        continue;
                    }
                    if (tagno.equalsIgnoreCase("611")) {
                        subFldsArr = field.getSubFields();
                        if (subFldsArr == null) continue;
                        String subjectStr = "";
                        for (int k = 0; k < subFldsArr.length; ++k) {
                            SubField subfld = subFldsArr[k];
                            String localTag = tagno + "_" + subfld.getIdentifier();
                            if (localTag.equalsIgnoreCase("611_a")) {
                                solrInputDocument.addField("topicStr", (Object)subfld.getData().trim());
                            }
                            if (!localTag.equalsIgnoreCase("611_a") && !localTag.equalsIgnoreCase("611_v") && !localTag.equalsIgnoreCase("611_x") && !localTag.equalsIgnoreCase("611_y") && !localTag.equalsIgnoreCase("611_z")) continue;
                            subjectStr = subjectStr + subfld.getData().trim() + " --";
                        }
                        solrInputDocument.addField(tagno + "_Tag", (Object)subjectStr.trim());
                        continue;
                    }
                    if (tagno.equalsIgnoreCase("630")) {
                        subFldsArr = field.getSubFields();
                        String subjectStr = "";
                        if (subFldsArr == null) continue;
                        for (int k = 0; k < subFldsArr.length; ++k) {
                            SubField subfld = subFldsArr[k];
                            String localTag = tagno + "_" + subfld.getIdentifier();
                            if (localTag.equalsIgnoreCase("630_a")) {
                                solrInputDocument.addField("topicStr", (Object)subfld.getData().trim());
                            }
                            if (!localTag.equalsIgnoreCase("630_a") && !localTag.equalsIgnoreCase("630_v") && !localTag.equalsIgnoreCase("630_x") && !localTag.equalsIgnoreCase("630_y") && !localTag.equalsIgnoreCase("630_z")) continue;
                            subjectStr = subjectStr + subfld.getData().trim() + " --";
                        }
                        solrInputDocument.addField(tagno + "_Tag", (Object)subjectStr.trim());
                        continue;
                    }
                    if (tagno.equalsIgnoreCase("650")) {
                        subFldsArr = field.getSubFields();
                        String subjectStr = "";
                        if (subFldsArr == null) continue;
                        for (int k = 0; k < subFldsArr.length; ++k) {
                            SubField subfld = subFldsArr[k];
                            String localTag = tagno + "_" + subfld.getIdentifier();
                            if (!localTag.equalsIgnoreCase("650_a") && !localTag.equalsIgnoreCase("650_v") && !localTag.equalsIgnoreCase("650_x") && !localTag.equalsIgnoreCase("650_y") && !localTag.equalsIgnoreCase("650_z")) continue;
                            subjectStr = subjectStr + subfld.getData().trim() + " --";
                        }
                        solrInputDocument.addField(tagno + "_Tag", (Object)subjectStr.trim());
                        continue;
                    }
                    if (tagno.equalsIgnoreCase("651")) {
                        subFldsArr = field.getSubFields();
                        String subjectStr = "";
                        if (subFldsArr == null) continue;
                        for (int k = 0; k < subFldsArr.length; ++k) {
                            SubField subfld = subFldsArr[k];
                            String localTag = tagno + "_" + subfld.getIdentifier();
                            if (localTag.equalsIgnoreCase("651_a")) {
                                solrInputDocument.addField("topicStr", (Object)subfld.getData().trim());
                            }
                            if (!localTag.equalsIgnoreCase("651_a") && !localTag.equalsIgnoreCase("651_v") && !localTag.equalsIgnoreCase("651_x") && !localTag.equalsIgnoreCase("651_y") && !localTag.equalsIgnoreCase("651_z")) continue;
                            subjectStr = subjectStr + subfld.getData().trim() + " --";
                        }
                        solrInputDocument.addField(tagno + "_Tag", (Object)subjectStr.trim());
                        continue;
                    }
                    if (tagno.equalsIgnoreCase("655")) {
                        subFldsArr = field.getSubFields();
                        String subjectStr = "";
                        if (subFldsArr == null) continue;
                        for (int k = 0; k < subFldsArr.length; ++k) {
                            SubField subfld = subFldsArr[k];
                            String localTag = tagno + "_" + subfld.getIdentifier();
                            if (localTag.equalsIgnoreCase("655_a")) {
                                solrInputDocument.addField("topicStr", (Object)subfld.getData().trim());
                            }
                            if (!localTag.equalsIgnoreCase("655_a") && !localTag.equalsIgnoreCase("655_v") && !localTag.equalsIgnoreCase("655_x") && !localTag.equalsIgnoreCase("655_y") && !localTag.equalsIgnoreCase("655_z")) continue;
                            subjectStr = subjectStr + subfld.getData().trim() + " --";
                        }
                        solrInputDocument.addField(tagno + "_Tag", (Object)subjectStr.trim());
                        continue;
                    }
                    if (tagno.equalsIgnoreCase("260")) {
                        subFldsArr = field.getSubFields();
                        String subjectStr = "";
                        if (subFldsArr == null) continue;
                        for (int k = 0; k < subFldsArr.length; ++k) {
                            String dataSF;
                            SubField subfld = subFldsArr[k];
                            String localTag = tagno + "_" + subfld.getIdentifier();
                            if (localTag.equalsIgnoreCase("260_c")) {
                                dataSF = subfld.getData().trim();
                                String[] tsr = dataSF.split("-?:?,");
                                for (int i = 0; i < tsr.length; ++i) {
                                    String string = tsr[i];
                                    int valInt = this.extractInteger(string);
                                    if (valInt == 0) continue;
                                    solrInputDocument.addField("Year", (Object)valInt);
                                    if (tsr.length <= 1) continue;
                                    System.out.println(dataSF);
                                    System.out.println("******* " + valInt);
                                    System.out.println("********************************************");
                                }
                                continue;
                            }
                            if (!localTag.equalsIgnoreCase("260_b")) continue;
                            dataSF = subfld.getData().trim();
                            solrInputDocument.addField("Publisher_Name", (Object)dataSF);
                        }
                        solrInputDocument.addField(tagno + "_Tag", (Object)subjectStr.trim());
                        continue;
                    }
                    if (!tagno.equalsIgnoreCase("082") && !tagno.equalsIgnoreCase("080") && !tagno.equalsIgnoreCase("083") && !tagno.equalsIgnoreCase("084") && !tagno.equalsIgnoreCase("085") && !tagno.equalsIgnoreCase("086") && !tagno.equalsIgnoreCase("055") && !tagno.equalsIgnoreCase("060") && !tagno.equalsIgnoreCase("070") || (subFldsArr = field.getSubFields()) == null) continue;
                    for (int k = 0; k < subFldsArr.length; ++k) {
                        SubField subfld = subFldsArr[k];
                        char sfident = subfld.getIdentifier();
                        String localTag = tagno + "_" + subfld.getIdentifier();
                        if (sfident != 'a') continue;
                        solrInputDocument.addField("classificationNumber", (Object)subfld.getData().trim());
                    }
                }
                solrInputDocument = this.getCatalogueRecordData(cataloguerecordid, owner_library_id, con, solrInputDocument);
                server.add(solrInputDocument);
            }
            rs.close();
            stat.close();
            server.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

