/*
 * Decompiled with CFR 0.152.
 */
package org.verus.ngl.indexing;

import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.apache.solr.client.solrj.impl.CommonsHttpSolrServer;
import org.apache.solr.common.SolrInputDocument;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.verus.ngl.util.DBConnector;
import org.verus.ngl.util.SimpleUtility;
import org.verus.ngl.util.SystemFilesLoader;

public class UserProfileIndexer {
    public static void main(String[] args) {
        UserProfileIndexer bsic = new UserProfileIndexer();
        bsic.deleteData();
        bsic.indexingData();
    }

    public void deleteData() {
        try {
            System.out.println("-----------Deleting User profile index data--------");
            Properties pro = SystemFilesLoader.getInstance().getNewgenlibProperties();
            String solrUrl = pro.getProperty("SOLR_SERVER_URL_FOR_USER_PROFILE_DATA", "http://localhost:8080/apache-solr-user");
            CommonsHttpSolrServer server = new CommonsHttpSolrServer(solrUrl);
            server.deleteByQuery("*:*");
            server.commit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void indexingData() {
        block43: {
            try {
                System.out.println("..............solrIndexingCreator.............................. User profile");
                Properties pro = SystemFilesLoader.getInstance().getNewgenlibProperties();
                String solrUrl = pro.getProperty("SOLR_SERVER_URL_FOR_USER_PROFILE_DATA");
                CommonsHttpSolrServer server = new CommonsHttpSolrServer(solrUrl);
                Connection con = DBConnector.getInstance().getDBConnection();
                String bibRecCount = "select count(*) from user_profile where status='A'";
                int bibCount = 0;
                Statement statx = con.createStatement();
                ResultSet rsCount = statx.executeQuery(bibRecCount);
                while (rsCount.next()) {
                    bibCount = rsCount.getInt(1);
                }
                rsCount.close();
                statx.close();
                if (bibCount > 0) {
                    int iterationVal = bibCount / 500;
                    if (bibCount / 500 != 0) {
                        ++iterationVal;
                    }
                    if (bibCount < 500) {
                        ++iterationVal;
                    }
                    boolean incrementVal = false;
                    String query = "Begin work;declare catalogue cursor for select * from user_profile where status='A'";
                    statx = con.createStatement();
                    statx.execute(query);
                    int count = 0;
                    for (int x = 0; x < iterationVal; ++x) {
                        String newQuery = "fetch forward 500 from catalogue";
                        Statement stat = con.createStatement();
                        ResultSet rs = stat.executeQuery(newQuery);
                        Vector<SolrInputDocument> vecFlush = new Vector<SolrInputDocument>();
                        System.out.println("Pooling 500 records.... A total of " + count + " are indexed so far");
                        while (rs.next()) {
                            int i2;
                            String patronId = rs.getString("patron_id");
                            Integer library_id = rs.getInt("library_id");
                            query = "select a.fname,a.mname,a.lname,a.dept_id,a.patron_category_id,a.city,a.state,a.country,a.pin,a.sub_location_id,b.work,b.subject_of_expertise,b.fields from patron a, user_profile b where a.patron_id=b.patron_id and a.library_id=b.library_id and a.patron_id='" + patronId + "' and a.library_id=" + library_id;
                            Statement tsta1 = con.createStatement();
                            ResultSet rs1 = tsta1.executeQuery(query);
                            String name = "";
                            String work = "";
                            String subjects = "";
                            String fields = "";
                            String deptId = "";
                            String patcatid = "";
                            String city = "";
                            String state = "";
                            String country = "";
                            String zipCode = "";
                            String subLocationId = "";
                            String department = "";
                            String patCat = "";
                            String subLocation = "";
                            while (rs1.next()) {
                                name = SimpleUtility.getTestedString(rs1.getString(1)) + " " + SimpleUtility.getTestedString(rs1.getString(2)) + " " + SimpleUtility.getTestedString(rs1.getString(3));
                                work = SimpleUtility.getTestedString(rs1.getString(11));
                                subjects = SimpleUtility.getTestedString(rs1.getString(12));
                                fields = SimpleUtility.getTestedString(rs1.getString(13));
                                deptId = SimpleUtility.getTestedString(rs1.getString(4));
                                patcatid = SimpleUtility.getTestedString(rs1.getString(5));
                                city = SimpleUtility.getTestedString(rs1.getString(6));
                                state = SimpleUtility.getTestedString(rs1.getString(7));
                                country = SimpleUtility.getTestedString(rs1.getString(8));
                                zipCode = SimpleUtility.getTestedString(rs1.getString(9));
                                subLocationId = SimpleUtility.getTestedString(rs1.getString(10));
                            }
                            rs1.close();
                            tsta1.close();
                            if (!deptId.equals("")) {
                                tsta1 = con.createStatement();
                                rs1 = tsta1.executeQuery("select dept_name from dept where dept_id=" + deptId + " and library_id=" + library_id);
                                while (rs1.next()) {
                                    department = SimpleUtility.getTestedString(rs1.getString("dept_name"));
                                }
                                rs1.close();
                                tsta1.close();
                            }
                            if (!patcatid.equals("")) {
                                tsta1 = con.createStatement();
                                rs1 = tsta1.executeQuery("select patron_category_name from patron_category where patron_category_id=" + patcatid + " and library_id=" + library_id);
                                while (rs1.next()) {
                                    patCat = SimpleUtility.getTestedString(rs1.getString("patron_category_name"));
                                }
                                rs1.close();
                                tsta1.close();
                            }
                            if (!subLocationId.equals("")) {
                                tsta1 = con.createStatement();
                                rs1 = tsta1.executeQuery("select sublocation from catalogue_sublocation where id=" + subLocationId + " and library_id=" + library_id);
                                while (rs1.next()) {
                                    subLocation = SimpleUtility.getTestedString(rs1.getString("sublocation"));
                                }
                                rs1.close();
                                tsta1.close();
                            }
                            ArrayList<String[]> alWork = new ArrayList<String[]>();
                            if (!work.equals("")) {
                                SAXBuilder sb = new SAXBuilder();
                                Document doc = null;
                                try {
                                    doc = sb.build((Reader)new StringReader(work));
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                if (doc != null) {
                                    List liWork = doc.getRootElement().getChildren();
                                    for (i2 = 0; i2 < liWork.size(); ++i2) {
                                        Element ele = (Element)liWork.get(i2);
                                        String[] str = new String[]{ele.getChildText("Id"), ele.getChildText("Value")};
                                        alWork.add(str);
                                    }
                                }
                            }
                            ArrayList<String[]> alSubject = new ArrayList<String[]>();
                            if (!subjects.equals("")) {
                                SAXBuilder sb = new SAXBuilder();
                                Document doc = null;
                                try {
                                    doc = sb.build((Reader)new StringReader(subjects));
                                }
                                catch (Exception i2) {
                                    // empty catch block
                                }
                                if (doc != null) {
                                    List liWork = doc.getRootElement().getChildren();
                                    for (int i3 = 0; i3 < liWork.size(); ++i3) {
                                        Element ele = (Element)liWork.get(i3);
                                        String[] str = new String[]{ele.getChildText("Id"), ele.getChildText("Value")};
                                        alSubject.add(str);
                                    }
                                }
                            }
                            ArrayList<String[]> alFields = new ArrayList<String[]>();
                            if (!fields.equals("")) {
                                SAXBuilder sb = new SAXBuilder();
                                Document doc = null;
                                try {
                                    doc = sb.build((Reader)new StringReader(fields));
                                }
                                catch (Exception i3) {
                                    // empty catch block
                                }
                                if (doc != null) {
                                    List liWork = doc.getRootElement().getChildren();
                                    for (int i4 = 0; i4 < liWork.size(); ++i4) {
                                        Element ele = (Element)liWork.get(i4);
                                        String[] str = new String[]{ele.getChildText("Id"), ele.getChildText("Value")};
                                        alFields.add(str);
                                    }
                                }
                            }
                            SolrInputDocument solrInputDocument = new SolrInputDocument();
                            solrInputDocument.addField("PATRON_ID", (Object)patronId);
                            solrInputDocument.addField("LIBRARY_ID", (Object)library_id);
                            solrInputDocument.addField("ID", (Object)(patronId + "_" + library_id));
                            solrInputDocument.addField("NAME", (Object)name.trim());
                            if (!deptId.equals("")) {
                                solrInputDocument.addField("DEPT_ID", (Object)(deptId + "_" + library_id));
                                solrInputDocument.addField("DEPARTMENT", (Object)department);
                            }
                            if (!patcatid.equals("")) {
                                solrInputDocument.addField("PAT_CAT_ID", (Object)(patcatid + "_" + library_id));
                                solrInputDocument.addField("PATRONCATEGORY", (Object)patCat);
                            }
                            if (!subLocationId.equals("")) {
                                solrInputDocument.addField("SUBLOCATIONID", (Object)(subLocationId + "_" + library_id));
                                solrInputDocument.addField("SUBLOCATION", (Object)subLocation);
                            }
                            if (!city.equals("")) {
                                solrInputDocument.addField("City", (Object)city);
                                solrInputDocument.addField("City_str", (Object)city);
                            }
                            if (!state.equals("")) {
                                solrInputDocument.addField("State", (Object)state);
                                solrInputDocument.addField("State_str", (Object)state);
                            }
                            if (!country.equals("")) {
                                solrInputDocument.addField("Country", (Object)country);
                                solrInputDocument.addField("Country_str", (Object)country);
                            }
                            if (!zipCode.equals("")) {
                                solrInputDocument.addField("ZIPCode", (Object)zipCode);
                            }
                            if (alWork.size() > 0) {
                                for (i2 = 0; i2 < alWork.size(); ++i2) {
                                    String[] arr = (String[])alWork.get(i2);
                                    solrInputDocument.addField(arr[0] + "_WORK", (Object)arr[1]);
                                }
                            }
                            if (alSubject.size() > 0) {
                                for (i2 = 0; i2 < alSubject.size(); ++i2) {
                                    String[] arr = (String[])alSubject.get(i2);
                                    solrInputDocument.addField(arr[0] + "_SUBJECT", (Object)arr[1]);
                                }
                            }
                            if (alFields.size() > 0) {
                                for (i2 = 0; i2 < alFields.size(); ++i2) {
                                    String[] arr = (String[])alFields.get(i2);
                                    solrInputDocument.addField(arr[0] + "_FIELD", (Object)arr[1]);
                                }
                            }
                            vecFlush.addElement(solrInputDocument);
                            ++count;
                        }
                        rs.close();
                        stat.close();
                        System.out.println("Committing: " + vecFlush.size());
                        server.add(vecFlush);
                        server.commit();
                    }
                    statx.close();
                    statx = con.createStatement();
                    statx.execute("CLOSE catalogue");
                    statx.close();
                    con.close();
                    break block43;
                }
                System.out.println("########### There is no data is available in the Database ##############");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

