/*
 * Decompiled with CFR 0.152.
 */
package org.verus.ngl.indexing;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import newgenlib.marccomponent.conversion.Converter;
import newgenlib.marccomponent.marcmodel.CatalogMaterialDescription;
import newgenlib.marccomponent.marcmodel.ControlField;
import newgenlib.marccomponent.marcmodel.Field;
import newgenlib.marccomponent.marcmodel.SubField;
import org.apache.solr.client.solrj.impl.CommonsHttpSolrServer;
import org.apache.solr.common.SolrInputDocument;

public class BibliographicSolrIndexCreator {
    public static void main(String[] args) {
        BibliographicSolrIndexCreator bsic = new BibliographicSolrIndexCreator();
        bsic.deleteData();
    }

    public void deleteData() {
        try {
            CommonsHttpSolrServer server = new CommonsHttpSolrServer("http://localhost:8080/apache-solr-bib");
            server.deleteByQuery("*:*");
            server.commit();
            server = new CommonsHttpSolrServer("http://localhost:8080/apache-solr-auth");
            server.deleteByQuery("*:*");
            server.commit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void indexingData() {
        try {
            System.out.println("..............solrIndexingCreator..............................");
            CommonsHttpSolrServer server = new CommonsHttpSolrServer("http://localhost:8080/apache-solr-bib");
            Class.forName("org.postgresql.Driver");
            Connection conOld = DriverManager.getConnection("jdbc:postgresql://localhost:5432/SDM", "postgres", "newgenlib");
            String query = "select * from cataloguerecord order by cataloguerecordid";
            ResultSet rs = conOld.createStatement().executeQuery(query);
            while (rs.next()) {
                String tagno;
                ControlField field;
                int j;
                Converter c;
                CatalogMaterialDescription[] cat;
                Integer cataloguerecordid = rs.getInt("cataloguerecordid");
                Integer owner_library_id = rs.getInt("owner_library_id");
                query = "select * from searchable_cataloguerecord where cataloguerecordid=" + cataloguerecordid + " and owner_library_id=" + owner_library_id;
                System.out.println("...............cataloguerecordid: " + cataloguerecordid);
                ResultSet rs1 = conOld.createStatement().executeQuery(query);
                String wholeXml = "";
                while (rs1.next()) {
                    wholeXml = rs1.getString("wholecataloguerecord");
                }
                if (wholeXml == null || (cat = (c = Converter.getInstance()).getMarcModelsFromMarc(wholeXml)).length < 1) continue;
                SolrInputDocument solrInputDocument = new SolrInputDocument();
                solrInputDocument.addField("CatalogueRecordID", (Object)cataloguerecordid);
                solrInputDocument.addField("OwnerLibraryID", (Object)owner_library_id);
                solrInputDocument.addField("ID", (Object)(cataloguerecordid + "_" + owner_library_id));
                Field[] fieldArr = cat[0].getFields();
                ControlField[] controlField = cat[0].getControlField();
                for (j = 0; j < controlField.length; ++j) {
                    field = controlField[j];
                    tagno = field.getTag();
                    if (!tagno.equalsIgnoreCase("008")) continue;
                    String lang = field.getData().toString();
                    String language = "";
                    if (lang.length() >= 36) {
                        language = language + lang.charAt(35);
                    }
                    if (lang.length() >= 37) {
                        language = language + lang.charAt(36);
                    }
                    if (lang.length() >= 38) {
                        language = language + lang.charAt(37);
                    }
                    if (language.trim() == null || language.trim().length() <= 1) continue;
                    solrInputDocument.addField("langcode", (Object)language.trim());
                }
                for (j = 0; j < fieldArr.length; ++j) {
                    String localTag;
                    String fulltopic;
                    String series;
                    SubField[] subFldsArr;
                    String callnumber;
                    String author2Tag;
                    char ch;
                    String authorTag;
                    String localTag2;
                    SubField subfld;
                    int k;
                    String titleTag;
                    field = fieldArr[j];
                    tagno = field.getTag();
                    if (tagno.equalsIgnoreCase("245")) {
                        titleTag = "";
                        SubField[] subFldsArr2 = field.getSubFields();
                        for (k = 0; k < subFldsArr2.length; ++k) {
                            subfld = subFldsArr2[k];
                            localTag2 = tagno + "_" + subfld.getIdentifier();
                            if (!localTag2.equalsIgnoreCase("245_a") && !localTag2.equalsIgnoreCase("245_b")) continue;
                            titleTag = titleTag + subfld.getData() + " ";
                            if (!localTag2.equals("245_a")) continue;
                            solrInputDocument.addField("title", (Object)subfld.getData().trim());
                            solrInputDocument.addField("title_short", (Object)subfld.getData().trim());
                        }
                        solrInputDocument.addField("title", (Object)titleTag.trim());
                    }
                    if (tagno.equalsIgnoreCase("210")) {
                        titleTag = "";
                        SubField[] subFldsArr3 = field.getSubFields();
                        for (k = 0; k < subFldsArr3.length; ++k) {
                            subfld = subFldsArr3[k];
                            localTag2 = tagno + "_" + subfld.getIdentifier();
                            if (!localTag2.equalsIgnoreCase("210_a")) continue;
                            titleTag = titleTag + subfld.getData() + " ";
                        }
                        solrInputDocument.addField("title", (Object)titleTag.trim());
                    }
                    if (tagno.equalsIgnoreCase("222")) {
                        titleTag = "";
                        SubField[] subFldsArr4 = field.getSubFields();
                        for (k = 0; k < subFldsArr4.length; ++k) {
                            subfld = subFldsArr4[k];
                            localTag2 = tagno + "_" + subfld.getIdentifier();
                            if (!localTag2.equalsIgnoreCase("222_a")) continue;
                            titleTag = titleTag + subfld.getData() + " ";
                        }
                        solrInputDocument.addField("title", (Object)titleTag.trim());
                    }
                    if (tagno.equalsIgnoreCase("242")) {
                        titleTag = "";
                        SubField[] subFldsArr5 = field.getSubFields();
                        for (k = 0; k < subFldsArr5.length; ++k) {
                            subfld = subFldsArr5[k];
                            localTag2 = tagno + "_" + subfld.getIdentifier();
                            if (!localTag2.equalsIgnoreCase("242_a")) continue;
                            titleTag = titleTag + subfld.getData() + " ";
                        }
                        solrInputDocument.addField("title", (Object)titleTag.trim());
                    }
                    if (tagno.equalsIgnoreCase("243")) {
                        titleTag = "";
                        SubField[] subFldsArr6 = field.getSubFields();
                        for (k = 0; k < subFldsArr6.length; ++k) {
                            subfld = subFldsArr6[k];
                            localTag2 = tagno + "_" + subfld.getIdentifier();
                            if (!localTag2.equalsIgnoreCase("243_a")) continue;
                            titleTag = titleTag + subfld.getData() + " ";
                        }
                        solrInputDocument.addField("title", (Object)titleTag.trim());
                    }
                    if (tagno.equalsIgnoreCase("246")) {
                        titleTag = "";
                        SubField[] subFldsArr7 = field.getSubFields();
                        for (k = 0; k < subFldsArr7.length; ++k) {
                            subfld = subFldsArr7[k];
                            localTag2 = tagno + "_" + subfld.getIdentifier();
                            if (!localTag2.equalsIgnoreCase("246_a")) continue;
                            titleTag = titleTag + subfld.getData() + " ";
                        }
                        solrInputDocument.addField("title", (Object)titleTag.trim());
                    }
                    if (tagno.equalsIgnoreCase("247")) {
                        titleTag = "";
                        SubField[] subFldsArr8 = field.getSubFields();
                        for (k = 0; k < subFldsArr8.length; ++k) {
                            subfld = subFldsArr8[k];
                            localTag2 = tagno + "_" + subfld.getIdentifier();
                            if (!localTag2.equalsIgnoreCase("247_a")) continue;
                            titleTag = titleTag + subfld.getData() + " ";
                        }
                        solrInputDocument.addField("title", (Object)titleTag.trim());
                    }
                    if (tagno.equalsIgnoreCase("100")) {
                        authorTag = "";
                        SubField[] subFldsArr9 = field.getSubFields();
                        for (k = 0; k < subFldsArr9.length; ++k) {
                            subfld = subFldsArr9[k];
                            localTag2 = tagno + "_" + subfld.getIdentifier();
                            if (!localTag2.equalsIgnoreCase("100_a") && !localTag2.equalsIgnoreCase("100_b") && !localTag2.equalsIgnoreCase("100_c") && !localTag2.equalsIgnoreCase("100_d")) continue;
                            authorTag = authorTag + subfld.getData() + " ";
                            if (!localTag2.equals("100_a")) continue;
                            ch = subfld.getData().charAt(0);
                            solrInputDocument.addField("author-letter", (Object)String.valueOf(ch).trim());
                        }
                        solrInputDocument.addField("author", (Object)authorTag.trim());
                        solrInputDocument.addField("auth-author", (Object)authorTag.trim());
                    }
                    if (tagno.equalsIgnoreCase("110")) {
                        author2Tag = "";
                        String authorTag2 = "";
                        SubField[] subFldsArr10 = field.getSubFields();
                        for (int k2 = 0; k2 < subFldsArr10.length; ++k2) {
                            SubField subfld2 = subFldsArr10[k2];
                            String localTag3 = tagno + "_" + subfld2.getIdentifier();
                            if (localTag3.equalsIgnoreCase("110_a") || localTag3.equalsIgnoreCase("110_b")) {
                                author2Tag = author2Tag + subfld2.getData() + " ";
                            }
                            if (localTag3.equalsIgnoreCase("110_a") || localTag3.equalsIgnoreCase("110_b") || localTag3.equalsIgnoreCase("110_c") || localTag3.equalsIgnoreCase("110_d")) {
                                authorTag2 = authorTag2 + subfld2.getData() + " ";
                            }
                            if (!localTag3.equals("110_a")) continue;
                            char ch2 = subfld2.getData().charAt(0);
                            solrInputDocument.addField("author-letter", (Object)String.valueOf(ch2).trim());
                        }
                        solrInputDocument.addField("author2", (Object)author2Tag.trim());
                        solrInputDocument.addField("author", (Object)authorTag2.trim());
                        solrInputDocument.addField("auth-author", (Object)authorTag2.trim());
                    }
                    if (tagno.equalsIgnoreCase("111")) {
                        authorTag = "";
                        SubField[] subFldsArr11 = field.getSubFields();
                        for (int k3 = 0; k3 < subFldsArr11.length; ++k3) {
                            SubField subfld3 = subFldsArr11[k3];
                            localTag2 = tagno + "_" + subfld3.getIdentifier();
                            if (!localTag2.equalsIgnoreCase("111_a") && !localTag2.equalsIgnoreCase("111_b") && !localTag2.equalsIgnoreCase("111_c") && !localTag2.equalsIgnoreCase("111_d")) continue;
                            authorTag = authorTag + subfld3.getData() + " ";
                            if (!localTag2.equals("111_a")) continue;
                            ch = subfld3.getData().charAt(0);
                            solrInputDocument.addField("author-letter", (Object)String.valueOf(ch).trim());
                        }
                        solrInputDocument.addField("author", (Object)authorTag.trim());
                        solrInputDocument.addField("auth-author", (Object)authorTag.trim());
                    }
                    if (tagno.equalsIgnoreCase("700")) {
                        author2Tag = "";
                        SubField[] subFldsArr12 = field.getSubFields();
                        for (int k4 = 0; k4 < subFldsArr12.length; ++k4) {
                            SubField subfld4 = subFldsArr12[k4];
                            localTag2 = tagno + "_" + subfld4.getIdentifier();
                            if (localTag2.equalsIgnoreCase("700_a") || localTag2.equalsIgnoreCase("700_b") || localTag2.equalsIgnoreCase("700_c") || localTag2.equalsIgnoreCase("700_d")) {
                                author2Tag = author2Tag + subfld4.getData() + " ";
                            }
                            if (!localTag2.equals("700_e")) continue;
                            solrInputDocument.addField("author2-role", (Object)author2Tag.trim());
                        }
                        solrInputDocument.addField("author2", (Object)author2Tag.trim());
                    }
                    if (tagno.equalsIgnoreCase("710")) {
                        author2Tag = "";
                        SubField[] subFldsArr13 = field.getSubFields();
                        for (int k5 = 0; k5 < subFldsArr13.length; ++k5) {
                            SubField subfld5 = subFldsArr13[k5];
                            localTag2 = tagno + "_" + subfld5.getIdentifier();
                            if (localTag2.equalsIgnoreCase("710_a") || localTag2.equalsIgnoreCase("710_b")) {
                                author2Tag = author2Tag + subfld5.getData() + " ";
                            }
                            if (!localTag2.equals("710_e")) continue;
                            solrInputDocument.addField("author2-role", (Object)author2Tag.trim());
                        }
                        solrInputDocument.addField("author2", (Object)author2Tag.trim());
                    }
                    if (tagno.equalsIgnoreCase("711")) {
                        author2Tag = "";
                        SubField[] subFldsArr14 = field.getSubFields();
                        for (int k6 = 0; k6 < subFldsArr14.length; ++k6) {
                            SubField subfld6 = subFldsArr14[k6];
                            localTag2 = tagno + "_" + subfld6.getIdentifier();
                            if (!localTag2.equalsIgnoreCase("711_a") && !localTag2.equalsIgnoreCase("711_b")) continue;
                            author2Tag = author2Tag + subfld6.getData() + " ";
                        }
                        solrInputDocument.addField("author2", (Object)author2Tag.trim());
                    }
                    if (tagno.equalsIgnoreCase("090")) {
                        callnumber = "";
                        SubField[] subFldsArr15 = field.getSubFields();
                        for (int k7 = 0; k7 < subFldsArr15.length; ++k7) {
                            SubField subfld7 = subFldsArr15[k7];
                            localTag2 = tagno + "_" + subfld7.getIdentifier();
                            if (!localTag2.equalsIgnoreCase("090_a") && !localTag2.equalsIgnoreCase("090_b")) continue;
                            callnumber = callnumber + subfld7.getData() + " ";
                            if (!localTag2.equals("090_a")) continue;
                            solrInputDocument.addField("callnumber-first", (Object)String.valueOf(subfld7.getData().charAt(1)).trim());
                        }
                        solrInputDocument.addField("callnumber", (Object)callnumber.trim());
                    }
                    if (tagno.equalsIgnoreCase("050")) {
                        callnumber = "";
                        SubField[] subFldsArr16 = field.getSubFields();
                        for (int k8 = 0; k8 < subFldsArr16.length; ++k8) {
                            SubField subfld8 = subFldsArr16[k8];
                            localTag2 = tagno + "_" + subfld8.getIdentifier();
                            if (!localTag2.equalsIgnoreCase("050_a") && !localTag2.equalsIgnoreCase("050_b")) continue;
                            callnumber = callnumber + subfld8.getData() + " ";
                            if (!localTag2.equals("050_a")) continue;
                            solrInputDocument.addField("callnumber-a", (Object)subfld8.getData().trim());
                            solrInputDocument.addField("callnumber-first", (Object)String.valueOf(subfld8.getData().charAt(1)).trim());
                        }
                        solrInputDocument.addField("callnumber", (Object)callnumber.trim());
                    }
                    if (tagno.equalsIgnoreCase("240")) {
                        subFldsArr = field.getSubFields();
                        for (int k9 = 0; k9 < subFldsArr.length; ++k9) {
                            SubField subfld9 = subFldsArr[k9];
                            String localTag4 = tagno + "_" + subfld9.getIdentifier();
                            if (!localTag4.equalsIgnoreCase("240_a")) continue;
                            solrInputDocument.addField("title2", (Object)subfld9.getData().trim());
                            solrInputDocument.addField("title", (Object)subfld9.getData().trim());
                        }
                    }
                    if (tagno.equalsIgnoreCase("130")) {
                        subFldsArr = field.getSubFields();
                        for (int k10 = 0; k10 < subFldsArr.length; ++k10) {
                            SubField subfld10 = subFldsArr[k10];
                            String localTag5 = tagno + "_" + subfld10.getIdentifier();
                            if (!localTag5.equalsIgnoreCase("130_a")) continue;
                            solrInputDocument.addField("title2", (Object)subfld10.getData().trim());
                        }
                    }
                    if (tagno.equalsIgnoreCase("440")) {
                        subFldsArr = field.getSubFields();
                        for (int k11 = 0; k11 < subFldsArr.length; ++k11) {
                            SubField subfld11 = subFldsArr[k11];
                            String localTag6 = tagno + "_" + subfld11.getIdentifier();
                            if (!localTag6.equalsIgnoreCase("440_a")) continue;
                            solrInputDocument.addField("series", (Object)subfld11.getData().trim());
                        }
                    }
                    if (tagno.equalsIgnoreCase("800")) {
                        series = "";
                        SubField[] subFldsArr17 = field.getSubFields();
                        for (int k12 = 0; k12 < subFldsArr17.length; ++k12) {
                            SubField subfld12 = subFldsArr17[k12];
                            localTag2 = tagno + "_" + subfld12.getIdentifier();
                            if (!localTag2.equalsIgnoreCase("800_a") && !localTag2.equalsIgnoreCase("800_b") && !localTag2.equalsIgnoreCase("800_c") && !localTag2.equalsIgnoreCase("800_d") && !localTag2.equalsIgnoreCase("800_f") && !localTag2.equalsIgnoreCase("800_p") && !localTag2.equalsIgnoreCase("800_q") && !localTag2.equalsIgnoreCase("800_t")) continue;
                            series = series + subfld12.getData() + " ";
                        }
                        solrInputDocument.addField("series", (Object)series.trim());
                    }
                    if (tagno.equalsIgnoreCase("830")) {
                        series = "";
                        SubField[] subFldsArr18 = field.getSubFields();
                        for (int k13 = 0; k13 < subFldsArr18.length; ++k13) {
                            SubField subfld13 = subFldsArr18[k13];
                            localTag2 = tagno + "_" + subfld13.getIdentifier();
                            if (!localTag2.equalsIgnoreCase("830_a") && !localTag2.equalsIgnoreCase("830_p")) continue;
                            series = series + subfld13.getData() + " ";
                        }
                        solrInputDocument.addField("series", (Object)series.trim());
                    }
                    if (tagno.equalsIgnoreCase("490")) {
                        subFldsArr = field.getSubFields();
                        for (int k14 = 0; k14 < subFldsArr.length; ++k14) {
                            SubField subfld14 = subFldsArr[k14];
                            String localTag7 = tagno + "_" + subfld14.getIdentifier();
                            if (!localTag7.equals("490_a")) continue;
                            solrInputDocument.addField("series2", (Object)subfld14.getData().trim());
                        }
                    }
                    if (tagno.equalsIgnoreCase("600")) {
                        fulltopic = "";
                        String topic = "";
                        String subtopic = "";
                        SubField[] subFldsArr19 = field.getSubFields();
                        for (int k15 = 0; k15 < subFldsArr19.length; ++k15) {
                            SubField subfld15 = subFldsArr19[k15];
                            fulltopic = fulltopic + subfld15.getData() + " ";
                            String localTag8 = tagno + "_" + subfld15.getIdentifier();
                            if (localTag8.equalsIgnoreCase("600_a") || localTag8.equalsIgnoreCase("600_b") || localTag8.equalsIgnoreCase("600_c") || localTag8.equalsIgnoreCase("600_d") || localTag8.equalsIgnoreCase("600_p") || localTag8.equalsIgnoreCase("600_q") || localTag8.equalsIgnoreCase("600_t")) {
                                topic = topic + subfld15.getData() + " ";
                            }
                            if (!localTag8.equalsIgnoreCase("600_v") && !localTag8.equalsIgnoreCase("600_x") && !localTag8.equalsIgnoreCase("600_y") && !localTag8.equalsIgnoreCase("600_z")) continue;
                            subtopic = subtopic + subfld15.getData() + " ";
                        }
                        solrInputDocument.addField("fulltopic", (Object)fulltopic.trim());
                        solrInputDocument.addField("topic", (Object)topic.trim());
                        solrInputDocument.addField("subtopic", (Object)subtopic.trim());
                    }
                    if (tagno.equalsIgnoreCase("610")) {
                        fulltopic = "";
                        String topic = "";
                        String subtopic = "";
                        SubField[] subFldsArr20 = field.getSubFields();
                        for (int k16 = 0; k16 < subFldsArr20.length; ++k16) {
                            SubField subfld16 = subFldsArr20[k16];
                            fulltopic = fulltopic + subfld16.getData() + " ";
                            String localTag9 = tagno + "_" + subfld16.getIdentifier();
                            if (localTag9.equalsIgnoreCase("610_a") || localTag9.equalsIgnoreCase("610_b")) {
                                topic = topic + subfld16.getData() + " ";
                            }
                            if (!localTag9.equalsIgnoreCase("610_v") && !localTag9.equalsIgnoreCase("610_x") && !localTag9.equalsIgnoreCase("610_y") && !localTag9.equalsIgnoreCase("610_z")) continue;
                            subtopic = subtopic + subfld16.getData() + " ";
                        }
                        solrInputDocument.addField("fulltopic", (Object)fulltopic.trim());
                        solrInputDocument.addField("topic", (Object)topic.trim());
                        solrInputDocument.addField("subtopic", (Object)subtopic.trim());
                    }
                    if (tagno.equalsIgnoreCase("630")) {
                        fulltopic = "";
                        String topic = "";
                        String subtopic = "";
                        SubField[] subFldsArr21 = field.getSubFields();
                        for (int k17 = 0; k17 < subFldsArr21.length; ++k17) {
                            SubField subfld17 = subFldsArr21[k17];
                            fulltopic = fulltopic + subfld17.getData() + " ";
                            String localTag10 = tagno + "_" + subfld17.getIdentifier();
                            if (localTag10.equalsIgnoreCase("630_a") || localTag10.equalsIgnoreCase("630_p") || localTag10.equalsIgnoreCase("630_s") || localTag10.equalsIgnoreCase("630_t")) {
                                topic = topic + subfld17.getData() + " ";
                            }
                            if (!localTag10.equalsIgnoreCase("630_v") && !localTag10.equalsIgnoreCase("630_x") && !localTag10.equalsIgnoreCase("630_y") && !localTag10.equalsIgnoreCase("630_z")) continue;
                            subtopic = subtopic + subfld17.getData() + " ";
                        }
                        solrInputDocument.addField("fulltopic", (Object)fulltopic.trim());
                        solrInputDocument.addField("topic", (Object)topic.trim());
                        solrInputDocument.addField("subtopic", (Object)subtopic.trim());
                    }
                    if (tagno.equalsIgnoreCase("650")) {
                        fulltopic = "";
                        String topic = "";
                        String subtopic = "";
                        SubField[] subFldsArr22 = field.getSubFields();
                        for (int k18 = 0; k18 < subFldsArr22.length; ++k18) {
                            SubField subfld18 = subFldsArr22[k18];
                            fulltopic = fulltopic + subfld18.getData() + " ";
                            String localTag11 = tagno + "_" + subfld18.getIdentifier();
                            if (localTag11.equalsIgnoreCase("650_a") || localTag11.equalsIgnoreCase("650_v") || localTag11.equalsIgnoreCase("650_x") || localTag11.equalsIgnoreCase("650_y") || localTag11.equalsIgnoreCase("650_z")) {
                                topic = topic + subfld18.getData() + " ";
                            }
                            if (!localTag11.equalsIgnoreCase("650_v") && !localTag11.equalsIgnoreCase("650_x") && !localTag11.equalsIgnoreCase("650_y") && !localTag11.equalsIgnoreCase("650_z")) continue;
                            subtopic = subtopic + subfld18.getData() + " ";
                            if (!localTag11.equals("650_y")) continue;
                            solrInputDocument.addField("era", (Object)subfld18.getData().trim());
                        }
                        solrInputDocument.addField("fulltopic", (Object)fulltopic.trim());
                        solrInputDocument.addField("topic", (Object)topic.trim());
                        solrInputDocument.addField("subtopic", (Object)subtopic.trim());
                    }
                    if (tagno.equalsIgnoreCase("655")) {
                        String fullgenre = "";
                        String genre = "";
                        String subgenre = "";
                        String topic = "";
                        SubField[] subFldsArr23 = field.getSubFields();
                        for (int k19 = 0; k19 < subFldsArr23.length; ++k19) {
                            SubField subfld19 = subFldsArr23[k19];
                            fullgenre = fullgenre + subfld19.getData() + " ";
                            localTag = tagno + "_" + subfld19.getIdentifier();
                            if (localTag.equalsIgnoreCase("655_a") || localTag.equalsIgnoreCase("655_b")) {
                                genre = genre + subfld19.getData() + " ";
                            }
                            if (localTag.equalsIgnoreCase("655_v") || localTag.equalsIgnoreCase("655_x") || localTag.equalsIgnoreCase("655_y") || localTag.equalsIgnoreCase("655_z")) {
                                subgenre = subgenre + subfld19.getData() + " ";
                            }
                            if (!localTag.equalsIgnoreCase("655_a") && !localTag.equalsIgnoreCase("655_v") && !localTag.equalsIgnoreCase("655_x") && !localTag.equalsIgnoreCase("655_y") && !localTag.equalsIgnoreCase("655_z")) continue;
                            topic = topic + subfld19.getData() + " ";
                        }
                        solrInputDocument.addField("fulltopic", (Object)fullgenre.trim());
                        solrInputDocument.addField("topic", (Object)topic.trim());
                        solrInputDocument.addField("subtopic", (Object)subgenre.trim());
                        solrInputDocument.addField("fullgenre", (Object)fullgenre.trim());
                        solrInputDocument.addField("genre", (Object)genre.trim());
                        solrInputDocument.addField("subgenre", (Object)subgenre.trim());
                    }
                    if (tagno.equalsIgnoreCase("651")) {
                        String fullgeographic = "";
                        String geographic = "";
                        String subgeographic = "";
                        String topic = "";
                        SubField[] subFldsArr24 = field.getSubFields();
                        for (int k20 = 0; k20 < subFldsArr24.length; ++k20) {
                            SubField subfld20 = subFldsArr24[k20];
                            fullgeographic = fullgeographic + subfld20.getData() + " ";
                            localTag = tagno + "_" + subfld20.getIdentifier();
                            if (localTag.equalsIgnoreCase("651_a")) {
                                geographic = geographic + subfld20.getData() + " ";
                            }
                            if (localTag.equalsIgnoreCase("651_v") || localTag.equalsIgnoreCase("651_x") || localTag.equalsIgnoreCase("651_y") || localTag.equalsIgnoreCase("651_z")) {
                                subgeographic = subgeographic + subfld20.getData() + " ";
                                if (localTag.equals("651_y")) {
                                    solrInputDocument.addField("era", (Object)subfld20.getData().trim());
                                }
                            }
                            if (!localTag.equalsIgnoreCase("651_a") && !localTag.equalsIgnoreCase("651_v") && !localTag.equalsIgnoreCase("651_x") && !localTag.equalsIgnoreCase("651_y") && !localTag.equalsIgnoreCase("651_z")) continue;
                            topic = topic + subfld20.getData() + " ";
                        }
                        solrInputDocument.addField("fulltopic", (Object)fullgeographic.trim());
                        solrInputDocument.addField("topic", (Object)topic.trim());
                        solrInputDocument.addField("subtopic", (Object)subgeographic.trim());
                        solrInputDocument.addField("fullgeographic", (Object)fullgeographic.trim());
                        solrInputDocument.addField("geographic", (Object)geographic.trim());
                        solrInputDocument.addField("subgeographic", (Object)subgeographic.trim());
                    }
                    if (tagno.equalsIgnoreCase("780")) {
                        subFldsArr = field.getSubFields();
                        for (int k21 = 0; k21 < subFldsArr.length; ++k21) {
                            SubField subfld21 = subFldsArr[k21];
                            String localTag12 = tagno + "_" + subfld21.getIdentifier();
                            if (!localTag12.equalsIgnoreCase("780_a")) continue;
                            solrInputDocument.addField("oldTitle", (Object)subfld21.getData().trim());
                        }
                    }
                    if (tagno.equalsIgnoreCase("785")) {
                        subFldsArr = field.getSubFields();
                        for (int k22 = 0; k22 < subFldsArr.length; ++k22) {
                            SubField subfld22 = subFldsArr[k22];
                            String localTag13 = tagno + "_" + subfld22.getIdentifier();
                            if (!localTag13.equalsIgnoreCase("785_a")) continue;
                            solrInputDocument.addField("newTitle", (Object)subfld22.getData().trim());
                        }
                    }
                    if (tagno.equalsIgnoreCase("856")) {
                        subFldsArr = field.getSubFields();
                        for (int k23 = 0; k23 < subFldsArr.length; ++k23) {
                            SubField subfld23 = subFldsArr[k23];
                            String localTag14 = tagno + "_" + subfld23.getIdentifier();
                            if (!localTag14.equalsIgnoreCase("856_u")) continue;
                            solrInputDocument.addField("url", (Object)subfld23.getData().trim());
                        }
                    }
                    if (tagno.equalsIgnoreCase("260")) {
                        subFldsArr = field.getSubFields();
                        for (int k24 = 0; k24 < subFldsArr.length; ++k24) {
                            SubField subfld24 = subFldsArr[k24];
                            String localTag15 = tagno + "_" + subfld24.getIdentifier();
                            if (localTag15.equalsIgnoreCase("260_b")) {
                                solrInputDocument.addField("publisher", (Object)subfld24.getData().trim());
                            }
                            if (!localTag15.equalsIgnoreCase("260_c") || subfld24.getData().trim().length() < 1) continue;
                            String dateStr = subfld24.getData();
                            solrInputDocument.addField("publishDate", (Object)dateStr.trim());
                        }
                    }
                    if (tagno.equalsIgnoreCase("250")) {
                        subFldsArr = field.getSubFields();
                        for (int k25 = 0; k25 < subFldsArr.length; ++k25) {
                            SubField subfld25 = subFldsArr[k25];
                            String localTag16 = tagno + "_" + subfld25.getIdentifier();
                            if (!localTag16.equalsIgnoreCase("250_a") || subfld25.getData().length() < 1) continue;
                            solrInputDocument.addField("edition", (Object)subfld25.getData().trim());
                        }
                    }
                    if (tagno.equalsIgnoreCase("505")) {
                        subFldsArr = field.getSubFields();
                        String contents = "";
                        for (int k26 = 0; k26 < subFldsArr.length; ++k26) {
                            SubField subfld26 = subFldsArr[k26];
                            String localTag17 = tagno + "_" + subfld26.getIdentifier();
                            if (!localTag17.equalsIgnoreCase("505_a") && !localTag17.equalsIgnoreCase("505_t")) continue;
                            contents = contents + subfld26.getData();
                        }
                        solrInputDocument.addField("contents", (Object)contents.trim());
                    }
                    if (tagno.equalsIgnoreCase("020")) {
                        subFldsArr = field.getSubFields();
                        for (int k27 = 0; k27 < subFldsArr.length; ++k27) {
                            SubField subfld27 = subFldsArr[k27];
                            String localTag18 = tagno + "_" + subfld27.getIdentifier();
                            if (!localTag18.equalsIgnoreCase("020_a")) continue;
                            String str = subfld27.getData();
                            String[] sta = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
                            String isbn = "";
                            String str1 = subfld27.getData();
                            for (int s = 0; s < str1.length(); ++s) {
                                char e = str1.charAt(s);
                                for (int l = 0; l < sta.length; ++l) {
                                    char f = sta[l].charAt(0);
                                    if (f != e) continue;
                                    isbn = isbn + e;
                                }
                            }
                            solrInputDocument.addField("isbn", (Object)isbn.trim());
                        }
                    }
                    if (!tagno.equalsIgnoreCase("022")) continue;
                    subFldsArr = field.getSubFields();
                    for (int k28 = 0; k28 < subFldsArr.length; ++k28) {
                        SubField subfld28 = subFldsArr[k28];
                        String localTag19 = tagno + "_" + subfld28.getIdentifier();
                        if (!localTag19.equalsIgnoreCase("022_a")) continue;
                        String str = subfld28.getData();
                        String str2 = str.replace("-", "");
                        solrInputDocument.addField("issn", (Object)str2.trim());
                    }
                }
                solrInputDocument = this.getCatalogueRecordData(cataloguerecordid, owner_library_id, conOld, solrInputDocument);
                solrInputDocument.addField("format", (Object)"AH");
                server.add(solrInputDocument);
                server.commit();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private SolrInputDocument getCatalogueRecordData(Integer cataloguerecordid, Integer owner_library_id, Connection con, SolrInputDocument doc) {
        try {
            Integer uniformtitle_library_id;
            Integer uniform_title_id;
            Integer meetingname_library_id;
            Integer meeting_name_id;
            Integer corporatename_library_id;
            Integer corporate_name_id;
            Integer personalname_library_id;
            Integer personal_name_id;
            String query = "select * from cataloguerecord where cataloguerecordid=" + cataloguerecordid + " and owner_library_id=" + owner_library_id;
            ResultSet rs = con.createStatement().executeQuery(query);
            while (rs.next()) {
                Integer bibliograId = rs.getInt("bibiliographic_level_id");
                Integer matTypeId = rs.getInt("material_type_id");
                doc.addField("BibliographicLevelID", (Object)bibliograId);
                doc.addField("MaterialTypeID", (Object)matTypeId);
            }
            query = "select * from cat_volume where cataloguerecordid=" + cataloguerecordid + " and owner_library_id=" + owner_library_id;
            rs = con.createStatement().executeQuery(query);
            while (rs.next()) {
                Integer volume_id = rs.getInt("volume_id");
                query = "select * from document where volume_id=" + volume_id;
                rs = con.createStatement().executeQuery(query);
                while (rs.next()) {
                    String accession_number = rs.getString("accession_number");
                    String barcode = rs.getString("barcode");
                    Integer library_id = rs.getInt("library_id");
                    Integer location_id = rs.getInt("location_id");
                    String call_number = rs.getString("call_number");
                    doc.addField("ShelvingLocationID", (Object)location_id);
                    doc.addField("AccessionNumber", (Object)accession_number.trim());
                    doc.addField("BarcodeNumber", (Object)barcode.trim());
                    doc.addField("HoldingsLibraryID", (Object)library_id);
                    doc.addField("callnumber", (Object)call_number.trim());
                }
            }
            query = "select * from library_holdings where cataloguerecordid=" + cataloguerecordid + " and owner_library_id=" + owner_library_id;
            rs = con.createStatement().executeQuery(query);
            while (rs.next()) {
                Integer holdings_library_id = rs.getInt("holdings_library_id");
                doc.addField("SubLocationID", (Object)holdings_library_id);
            }
            query = "select * from cataloguerecord where cataloguerecordid=" + cataloguerecordid + " and owner_library_id=" + owner_library_id;
            rs = con.createStatement().executeQuery(query);
            while (rs.next()) {
                String open_archive = rs.getString("open_archive");
                doc.addField("OpenArchive", (Object)open_archive.trim());
            }
            query = "select * from keywords where cataloguerecordid=" + cataloguerecordid + " and owner_library=" + owner_library_id;
            rs = con.createStatement().executeQuery(query);
            while (rs.next()) {
                String keyword = rs.getString("keyword");
                doc.addField("Keywords", (Object)keyword.trim());
            }
            query = "select * from searchable_cataloguerecord where cataloguerecordid=" + cataloguerecordid + " and owner_library_id=" + owner_library_id;
            rs = con.createStatement().executeQuery(query);
            while (rs.next()) {
                personal_name_id = rs.getInt("personal_name_id");
                personalname_library_id = rs.getInt("personalname_library_id");
                if (personal_name_id == null || personal_name_id == 0 || personalname_library_id == null || personalname_library_id == 0) continue;
                doc.addField("PN_IDS", (Object)(personal_name_id + "_" + personalname_library_id));
            }
            query = "select * from searchable_personalnameae_ass where cataloguerecordid=" + cataloguerecordid + " and owner_library_id=" + owner_library_id;
            rs = con.createStatement().executeQuery(query);
            while (rs.next()) {
                personal_name_id = rs.getInt("personal_name_id");
                personalname_library_id = rs.getInt("personalname_library_id");
                if (personal_name_id == null || personal_name_id == 0 || personalname_library_id == null || personalname_library_id == 0) continue;
                doc.addField("PN_IDS", (Object)(personal_name_id + "_" + personalname_library_id));
            }
            query = "select * from searchable_personalsae_ass where cataloguerecordid=" + cataloguerecordid + " and owner_library_id=" + owner_library_id;
            rs = con.createStatement().executeQuery(query);
            while (rs.next()) {
                personal_name_id = rs.getInt("personal_name_id");
                personalname_library_id = rs.getInt("personalname_library_id");
                if (personal_name_id == null || personal_name_id == 0 || personalname_library_id == null || personalname_library_id == 0) continue;
                doc.addField("PN_IDS", (Object)(personal_name_id + "_" + personalname_library_id));
            }
            query = "select * from searchable_personalsh_ass where cataloguerecordid=" + cataloguerecordid + " and owner_library_id=" + owner_library_id;
            rs = con.createStatement().executeQuery(query);
            while (rs.next()) {
                personal_name_id = rs.getInt("subpersonalname_id");
                personalname_library_id = rs.getInt("subpersonalname_libraryid");
                if (personal_name_id == null || personal_name_id == 0 || personalname_library_id == null || personalname_library_id == 0) continue;
                doc.addField("PN_IDS", (Object)(personal_name_id + "_" + personalname_library_id));
            }
            query = "select * from searchable_cataloguerecord where cataloguerecordid=" + cataloguerecordid + " and owner_library_id=" + owner_library_id;
            rs = con.createStatement().executeQuery(query);
            while (rs.next()) {
                corporate_name_id = rs.getInt("corporate_name_id");
                corporatename_library_id = rs.getInt("corporatename_library_id");
                if (corporate_name_id == null || corporatename_library_id == null || corporate_name_id == 0 || corporatename_library_id == 0) continue;
                doc.addField("CN_IDS", (Object)(corporate_name_id + "_" + corporatename_library_id));
            }
            query = "select * from searchable_corporatenameae_ass where cataloguerecordid=" + cataloguerecordid + " and owner_library_id=" + owner_library_id;
            rs = con.createStatement().executeQuery(query);
            while (rs.next()) {
                corporate_name_id = rs.getInt("corporate_name_id");
                corporatename_library_id = rs.getInt("corporatename_library_id");
                if (corporate_name_id == null || corporatename_library_id == null || corporate_name_id == 0 || corporatename_library_id == 0) continue;
                doc.addField("CN_IDS", (Object)(corporate_name_id + "_" + corporatename_library_id));
            }
            query = "select * from searchable_corporatesae_ass where cataloguerecordid=" + cataloguerecordid + " and owner_library_id=" + owner_library_id;
            rs = con.createStatement().executeQuery(query);
            while (rs.next()) {
                corporate_name_id = rs.getInt("corporate_name_id");
                corporatename_library_id = rs.getInt("corporatename_library_id");
                if (corporate_name_id == null || corporatename_library_id == null || corporate_name_id == 0 || corporatename_library_id == 0) continue;
                doc.addField("CN_IDS", (Object)(corporate_name_id + "_" + corporatename_library_id));
            }
            query = "select * from searchable_corporatesh_ass where cataloguerecordid=" + cataloguerecordid + " and owner_library_id=" + owner_library_id;
            rs = con.createStatement().executeQuery(query);
            while (rs.next()) {
                corporate_name_id = rs.getInt("subcorporatename_id");
                corporatename_library_id = rs.getInt("library_id");
                if (corporate_name_id == null || corporatename_library_id == null || corporate_name_id == 0 || corporatename_library_id == 0) continue;
                doc.addField("CN_IDS", (Object)(corporate_name_id + "_" + corporatename_library_id));
            }
            query = "select * from searchable_cataloguerecord where cataloguerecordid=" + cataloguerecordid + " and owner_library_id=" + owner_library_id;
            rs = con.createStatement().executeQuery(query);
            while (rs.next()) {
                meeting_name_id = rs.getInt("meeting_name_id");
                meetingname_library_id = rs.getInt("meetingname_library_id");
                if (meeting_name_id == null || meetingname_library_id == null || meeting_name_id == 0 || meetingname_library_id == 0) continue;
                doc.addField("MN_IDS", (Object)(meeting_name_id + "_" + meetingname_library_id));
            }
            query = "select * from searchable_meetingnameae_ass where cataloguerecordid=" + cataloguerecordid + " and owner_library_id=" + owner_library_id;
            rs = con.createStatement().executeQuery(query);
            while (rs.next()) {
                meeting_name_id = rs.getInt("meeting_name_id");
                meetingname_library_id = rs.getInt("meetingname_library_id");
                if (meeting_name_id == null || meetingname_library_id == null || meeting_name_id == 0 || meetingname_library_id == 0) continue;
                doc.addField("MN_IDS", (Object)(meeting_name_id + "_" + meetingname_library_id));
            }
            query = "select * from searchable_meetingnamesae_ass where cataloguerecordid=" + cataloguerecordid + " and owner_library_id=" + owner_library_id;
            rs = con.createStatement().executeQuery(query);
            while (rs.next()) {
                meeting_name_id = rs.getInt("meeting_name_id");
                meetingname_library_id = rs.getInt("meetingname_library_id");
                if (meeting_name_id == null || meetingname_library_id == null || meeting_name_id == 0 || meetingname_library_id == 0) continue;
                doc.addField("MN_IDS", (Object)(meeting_name_id + "_" + meetingname_library_id));
            }
            query = "select * from searchable_meetingsh_ass where cataloguerecordid=" + cataloguerecordid + " and owner_library_id=" + owner_library_id;
            rs = con.createStatement().executeQuery(query);
            while (rs.next()) {
                meeting_name_id = rs.getInt("submeetingname_id");
                meetingname_library_id = rs.getInt("submeetingname_libraryid");
                if (meeting_name_id == null || meetingname_library_id == null || meeting_name_id == 0 || meetingname_library_id == 0) continue;
                doc.addField("MN_IDS", (Object)(meeting_name_id + "_" + meetingname_library_id));
            }
            query = "select * from searchable_cataloguerecord where cataloguerecordid=" + cataloguerecordid + " and owner_library_id=" + owner_library_id;
            rs = con.createStatement().executeQuery(query);
            while (rs.next()) {
                uniform_title_id = rs.getInt("uniform_title_id");
                uniformtitle_library_id = rs.getInt("uniformtitle_library_id");
                if (uniform_title_id == null || uniformtitle_library_id == null || uniform_title_id == 0 || uniformtitle_library_id == 0) continue;
                doc.addField("UT_IDS", (Object)(uniform_title_id + "_" + uniformtitle_library_id));
            }
            query = "select * from searchable_uniformsh_ass where cataloguerecordid=" + cataloguerecordid + " and owner_library_id=" + owner_library_id;
            rs = con.createStatement().executeQuery(query);
            while (rs.next()) {
                uniform_title_id = rs.getInt("subuniformtitle_id");
                uniformtitle_library_id = rs.getInt("subuniformtitle_libraryid");
                if (uniform_title_id == null || uniformtitle_library_id == null || uniform_title_id == 0 || uniformtitle_library_id == 0) continue;
                doc.addField("UT_IDS", (Object)(uniform_title_id + "_" + uniformtitle_library_id));
            }
            query = "select * from searchable_uniformtitlesae_ass where cataloguerecordid=" + cataloguerecordid + " and owner_library_id=" + owner_library_id;
            rs = con.createStatement().executeQuery(query);
            while (rs.next()) {
                uniform_title_id = rs.getInt("uniform_title_id");
                uniformtitle_library_id = rs.getInt("uniformtitle_library_id");
                if (uniform_title_id == null || uniformtitle_library_id == null || uniform_title_id == 0 || uniformtitle_library_id == 0) continue;
                doc.addField("UT_IDS", (Object)(uniform_title_id + "_" + uniformtitle_library_id));
            }
            query = "select * from searchable_topicaltermsh_ass where cataloguerecordid=" + cataloguerecordid + " and owner_library_id=" + owner_library_id;
            rs = con.createStatement().executeQuery(query);
            while (rs.next()) {
                Integer subtopic_id = rs.getInt("subtopic_id");
                Integer subtopic_libraryid = rs.getInt("subtopic_libraryid");
                if (subtopic_id == null || subtopic_libraryid == null || subtopic_id == 0 || subtopic_libraryid == 0) continue;
                doc.addField("TTSH_IDS", (Object)(subtopic_id + "_" + subtopic_libraryid));
            }
            query = "select * from searchable_geonamesh_ass where cataloguerecordid=" + cataloguerecordid + " and owner_library_id=" + owner_library_id;
            rs = con.createStatement().executeQuery(query);
            while (rs.next()) {
                Integer subgeoname_id = rs.getInt("subgeoname_id");
                Integer subgeoname_libraryid = rs.getInt("subgeoname_libraryid");
                if (subgeoname_id == null || subgeoname_libraryid == null || subgeoname_id == 0 || subgeoname_libraryid == 0) continue;
                doc.addField("GNSH_IDS", (Object)(subgeoname_id + "_" + subgeoname_libraryid));
            }
            query = "select * from searchable_formgenresh_ass where cataloguerecordid=" + cataloguerecordid + " and owner_library_id=" + owner_library_id;
            rs = con.createStatement().executeQuery(query);
            while (rs.next()) {
                Integer formgenre_id = rs.getInt("formgenre_id");
                Integer formgenre_library_id = rs.getInt("formgenre_library_id");
                if (formgenre_id == null || formgenre_library_id == null || formgenre_id == 0 || formgenre_library_id == 0) continue;
                doc.addField("FGSH_IDS", (Object)(formgenre_id + "_" + formgenre_library_id));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return doc;
    }
}

