/*
 * Decompiled with CFR 0.152.
 */
package org.verus.ngl.util;

import java.io.FileInputStream;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import org.json.JSONException;
import org.json.JSONObject;
import org.verus.ngl.util.NewGenLibRoot;

public class SimpleUtility {
    private static Properties mimeDescriptionProperties = null;

    public static String getDatabaseFormattedDate(String dateLong) {
        Timestamp ts = new Timestamp(Long.parseLong(dateLong));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(ts);
    }

    public static String getTestedString(Object object) {
        if (object == null) {
            return "";
        }
        return object.toString();
    }

    public static String getDateStringFromLongString(String longString) {
        Date date = new Date(Long.parseLong(longString));
        SimpleDateFormat sdf = new SimpleDateFormat("MMM dd, yyyy");
        return sdf.format(date);
    }

    public static String getDateTimeStringFromLongString(String longString) {
        Date date = new Date(Long.parseLong(longString));
        SimpleDateFormat sdf = new SimpleDateFormat("MMM dd, yyyy hh:mm");
        return sdf.format(date);
    }

    public static ArrayList convertHashOPACQueryToArrayList(Hashtable htQuery) {
        ArrayList alRet = new ArrayList();
        Enumeration enumx = htQuery.keys();
        while (enumx.hasMoreElements()) {
            HashMap<String, String> hmOneele = new HashMap<String, String>();
            String key = enumx.nextElement().toString();
            String[] str = (String[])htQuery.get(key);
            hmOneele.put("Number", key);
            hmOneele.put("Text", str[0]);
            hmOneele.put("Index", str[1]);
            hmOneele.put("BooleanOperator", str[2]);
            alRet.add(hmOneele);
        }
        Collections.sort(alRet, new Comparator(){

            public int compare(Object o1, Object o2) {
                Integer i1 = new Integer(((HashMap)o1).get("Number").toString());
                Integer i2 = new Integer(((HashMap)o2).get("Number").toString());
                return i1.compareTo(i2);
            }
        });
        return alRet;
    }

    public static String getMimeDescription(String mimeType) {
        String retStr = "";
        try {
            if (mimeDescriptionProperties == null) {
                Properties props = new Properties();
                FileInputStream fis = new FileInputStream(NewGenLibRoot.getRoot() + "/SystemFiles/MimeDescriptions.properties");
                props.load(fis);
                fis.close();
                mimeDescriptionProperties = props;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        retStr = mimeDescriptionProperties != null ? mimeDescriptionProperties.getProperty(mimeType, mimeType) : mimeType;
        return retStr;
    }

    public static String getQueryReadableFormat(String query) throws JSONException {
        String retStr = "";
        String[] first = query.split("\\?");
        JSONObject job = null;
        String one = "";
        String two = "";
        String three = "";
        String forque = "";
        String forque11 = "";
        for (int i = 0; i < first.length; ++i) {
            String last = first[1];
            StringTokenizer stk = new StringTokenizer(last, "&");
            while (stk.hasMoreTokens()) {
                one = stk.nextToken();
                two = stk.nextToken();
                three = stk.nextToken();
                StringTokenizer stk1 = new StringTokenizer(three, "=");
                while (stk1.hasMoreTokens()) {
                    forque = stk1.nextToken();
                    forque11 = stk1.nextToken();
                }
                job = new JSONObject(forque11);
            }
        }
        JSONObject job1 = job.getJSONObject("Query");
        String str = "";
        Iterator it = job1.keys();
        while (it.hasNext()) {
            String key = it.next().toString();
            JSONObject job2 = job1.getJSONObject(key);
            String searchtext = job2.getString("SearchText");
            String index = job2.getString("Index");
            String boolean1 = job2.getString("Boolean");
            str = boolean1 + " " + index + "=" + searchtext;
            str = str.trim();
            retStr = retStr + " " + str;
        }
        return retStr;
    }

    public static HashSet getDoNotApplyWildCardFields() {
        HashSet<String> hsNonWC = new HashSet<String>();
        hsNonWC.add("ID");
        hsNonWC.add("BibliographicLevelID");
        hsNonWC.add("MaterialTypeID");
        hsNonWC.add("SubLocationID");
        hsNonWC.add("ShelvingLocationID");
        hsNonWC.add("AccessionNumber");
        hsNonWC.add("BarcodeNumber");
        hsNonWC.add("HoldingsLibraryID");
        hsNonWC.add("OpenArchive");
        hsNonWC.add("langcode");
        hsNonWC.add("NatureOfContents");
        hsNonWC.add("008_18_21");
        hsNonWC.add("008_22");
        hsNonWC.add("008_23");
        hsNonWC.add("008_28");
        hsNonWC.add("008_30");
        hsNonWC.add("008_31");
        hsNonWC.add("008_33");
        hsNonWC.add("008_34");
        hsNonWC.add("ConferencePublication");
        hsNonWC.add("Year");
        return hsNonWC;
    }
}

