/*
 * Decompiled with CFR 0.152.
 */
package n;

import Jama.Matrix;
import Jama.QRDecomposition;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ScrollBarDemo
extends JFrame
implements ActionListener {
    static int N;
    static int p;
    private static Matrix beta;
    private static double SSE;
    private static double SST;
    public static final int WIDTH = 600;
    public static final int HEIGHT = 400;
    public static final int LINES = 18;
    public static final int CHAR_PER_LINE = 50;
    private JTextArea memoDisplay;
    private String memo1;
    private String memo2;

    public static double beta(int j) {
        return beta.get(j, 0);
    }

    public static double R2() {
        return 1.0 - SSE / SST;
    }

    public static void main(String[] args) {
        ScrollBarDemo gui = new ScrollBarDemo();
        gui.setVisible(true);
    }

    public ScrollBarDemo() {
        super("Crear Ecuaci\u00f3n de Regresi\u00f3n Lineal M\u00faltiple V2 2019");
        this.setSize(600, 400);
        this.setDefaultCloseOperation(3);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBackground(Color.LIGHT_GRAY);
        buttonPanel.setLayout(new FlowLayout());
        JButton memo1Button = new JButton("Inicio");
        memo1Button.addActionListener(this);
        buttonPanel.add(memo1Button);
        JButton clearButton = new JButton("Limpiar");
        clearButton.addActionListener(this);
        buttonPanel.add(clearButton);
        JButton get2Button = new JButton("Salir");
        get2Button.addActionListener(this);
        buttonPanel.add(get2Button);
        this.add((Component)buttonPanel, "South");
        JPanel textPanel = new JPanel();
        textPanel.setBackground(Color.GRAY);
        this.memoDisplay = new JTextArea(18, 50);
        this.memoDisplay.setBackground(Color.WHITE);
        JScrollPane scrolledText = new JScrollPane(this.memoDisplay);
        scrolledText.setHorizontalScrollBarPolicy(32);
        scrolledText.setVerticalScrollBarPolicy(22);
        textPanel.add(scrolledText);
        this.add((Component)textPanel, "Center");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (actionCommand.equals("Inicio")) {
            this.inicio();
        } else if (actionCommand.equals("Save Memo 2")) {
            this.memo2 = this.memoDisplay.getText();
        } else if (actionCommand.equals("Limpiar")) {
            this.memoDisplay.setText("");
        } else if (actionCommand.equals("Get Memo 1")) {
            this.memoDisplay.setText(this.memo1);
        } else if (actionCommand.equals("Salir")) {
            System.exit(0);
        } else {
            this.memoDisplay.setText("Error in memo interface");
        }
    }

    private void inicio() {
        JFileChooser chooser = new JFileChooser();
        chooser.showOpenDialog(null);
        File f = chooser.getSelectedFile();
        String filename = f.getAbsolutePath();
        this.memoDisplay.append("Archivo de datos: " + filename + "\n\n");
        double[] xx = new double[1000];
        double[] yy = new double[1000];
        int j = 0;
        int in = 0;
        int i = 0;
        double max1 = 0.0;
        double max2 = 0.0;
        try {
            FileReader reader = new FileReader(filename);
            Throwable throwable = null;
            Object var18_15 = null;
            try (BufferedReader br = new BufferedReader(reader);){
                String cadena = br.readLine();
                while ((cadena = br.readLine()) != null) {
                    String txt = cadena;
                    String[] result = txt.split("\\t|,|;|\\n|\\?|!|:|@|\\[|\\]|\\(|\\)|\\{|\\}|_|\\*|/");
                    xx[i] = Float.parseFloat(result[0]);
                    if (xx[i] > max1) {
                        max1 = xx[i];
                    }
                    yy[i] = Float.parseFloat(result[1]);
                    if (yy[i] > max2) {
                        max2 = yy[i];
                    }
                    ++i;
                }
                br.close();
                in = i;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            this.memoDisplay.append("\nError de lectura del archivo ...\n");
        }
        this.memoDisplay.append("\n");
        this.memoDisplay.append("Para 1 a " + Double.toString(max2) + " repeticiones m\u00e1ximo\n\n");
        double[] rep = new double[10000];
        double[] peso = new double[10000];
        double[] mm = new double[11];
        double[] orden = new double[11];
        double[] onormal = new double[10000];
        double[] est = new double[10000];
        int lon = in;
        int z = 0;
        j = 0;
        while (j < lon) {
            i = 0;
            while (i < 10) {
                peso[z] = xx[j] - xx[j] * 0.1 * (double)i;
                rep[z] = yy[j] - yy[j] * 0.1 * (double)i;
                ++z;
                ++i;
            }
            ++j;
        }
        lon = z;
        double mu = 0.0;
        double sigma = 0.3;
        Random r = new Random();
        z = 0;
        i = 0;
        while (i < 10) {
            double nn = r.nextGaussian() * sigma + mu;
            mm[z] = Math.abs(nn);
            ++z;
            ++i;
        }
        Arrays.sort(mm);
        in = 6;
        i = 10;
        while (i >= 6) {
            orden[in] = mm[i];
            ++in;
            --i;
        }
        i = 5;
        while (i >= 0) {
            orden[i] = mm[i];
            --i;
        }
        orden[0] = 0.0;
        z = 0;
        i = 0;
        while (i < lon) {
            j = 0;
            while (j < 10) {
                onormal[z] = orden[j];
                ++z;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i <= lon) {
            est[i] = peso[i] + onormal[i];
            ++i;
        }
        double[][] mat = new double[lon + 1][2];
        j = 0;
        while (j <= lon) {
            mat[j][0] = peso[j];
            mat[j][1] = rep[j];
            ++j;
        }
        double[][] x = new double[lon + 1][2];
        double[] y = new double[lon + 1];
        i = 0;
        while (i < lon) {
            y[i] = est[i];
            j = 0;
            while (j < 2) {
                x[i][j] = mat[i][j];
                ++j;
            }
            ++i;
        }
        double[][] xxx = new double[lon + 1][3];
        i = 0;
        while (i < lon) {
            xxx[i][0] = 1.0;
            xxx[i][1] = x[i][0];
            xxx[i][2] = x[i][1];
            ++i;
        }
        if (x.length != y.length) {
            throw new RuntimeException("diferente tama\u00f1o de muestras...");
        }
        N = y.length;
        p = x[0].length;
        Matrix X = new Matrix(xxx);
        Matrix Y = new Matrix(y, N);
        QRDecomposition qr = new QRDecomposition(X);
        beta = qr.solve(Y);
        this.memoDisplay.append("1RM= " + Double.toString(ScrollBarDemo.beta(0)) + "\n");
        this.memoDisplay.append("  +( " + Double.toString(ScrollBarDemo.beta(1)) + " * peso ) \n");
        this.memoDisplay.append("  +( " + Double.toString(ScrollBarDemo.beta(2)) + " * repeticiones)\n");
        double sum = 0.0;
        i = 0;
        while (i < N) {
            sum += y[i];
            ++i;
        }
        double mean = sum / (double)N;
        i = 0;
        while (i < N) {
            double dev = y[i] - mean;
            SST += dev * dev;
            ++i;
        }
        this.memoDisplay.append("\nSST= " + Double.toString(SST) + "\n");
        Matrix residuals = X.times(beta).minus(Y);
        SSE = residuals.norm2() * residuals.norm2();
        this.memoDisplay.append("SSE= " + Double.toString(SSE) + "\n");
        this.memoDisplay.append("R2= " + Double.toString(ScrollBarDemo.R2()));
    }
}

