/*
 * Decompiled with CFR 0.152.
 */
package org.goldang.qaparadigm;

import java.awt.Frame;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import org.goldang.qaparadigm.Alert;
import org.goldang.qaparadigm.Application;
import org.goldang.qaparadigm.Sex;
import org.goldang.qaparadigm.Strings;

class LogFile {
    private final OutputStreamWriter myStreamWriter;
    private final Application myApp;
    private final long myStartTime;

    LogFile(Application app, File directory) {
        String fileName;
        File file;
        Calendar calendar = Calendar.getInstance();
        this.myApp = app;
        this.myStartTime = calendar.getTimeInMillis();
        File logFileDir = new File(directory, "logs");
        if (!logFileDir.exists()) {
            logFileDir.mkdir();
        }
        if ((file = new File(logFileDir, fileName = this.assembleLogFileName(calendar))).exists()) {
            new Alert(Strings.res(Strings.LOG_FILE_EXISTS) + " '" + file.getName() + "'", (Frame)this.myApp);
            this.myStreamWriter = null;
        } else {
            this.myStreamWriter = this.createOutputStreamWriter(file);
            this.writeLogFileHeader(calendar);
        }
    }

    private String assembleLogFileName(Calendar calendar) {
        String name = this.myApp.getSubjectName().trim();
        if (name.length() == 0) {
            name = "anonymous";
        }
        return name + "." + calendar.getTimeInMillis() + ".log";
    }

    private void writeLogFileHeader(Calendar calendar) {
        String sexStr;
        this.writeLine("QAParadigm log " + calendar.getTime());
        this.writeLine("Subject name \"" + this.myApp.getSubjectName() + "\"");
        int age = this.myApp.getSubjectAge();
        this.writeLine("Subject age: " + (age == 0 ? "" : Integer.valueOf(age)));
        Sex sex = this.myApp.getSubjectSex();
        switch (sex) {
            case FEMALE: {
                sexStr = "F";
                break;
            }
            case MALE: {
                sexStr = "M";
                break;
            }
            default: {
                sexStr = "";
            }
        }
        this.writeLine("Subject sex: " + sexStr);
        this.writeLine("Subject speaks dialects: " + this.myApp.getSubjectDialects());
        this.writeLine("Subject studies Linguistics? " + this.myApp.isSubjectLinguist());
        this.writeLine("Sentence file path: " + this.myApp.sentenceFileCanonicalPath());
        this.writeLine("\tnumber\tmillisec\tsentence");
    }

    private OutputStreamWriter createOutputStreamWriter(File file) {
        try {
            FileOutputStream fos = new FileOutputStream(file);
            return new OutputStreamWriter((OutputStream)fos, "UTF-8");
        }
        catch (FileNotFoundException e) {
            this.printAndExit(e);
        }
        catch (SecurityException e) {
            this.printAndExit(e);
        }
        catch (UnsupportedEncodingException e) {
            this.printAndExit(e);
        }
        return null;
    }

    public void log(int sequenceNumber, int sentenceNumber, String string) {
        Calendar cal = Calendar.getInstance();
        this.writeLine(sequenceNumber + 1 + "\t" + sentenceNumber + "\t" + (cal.getTimeInMillis() - this.myStartTime) + "\t" + string);
    }

    private void writeLine(String line) {
        if (this.myStreamWriter == null) {
            return;
        }
        try {
            this.myStreamWriter.write(line, 0, line.length());
            this.myStreamWriter.write("\n", 0, 1);
            this.myStreamWriter.flush();
        }
        catch (IOException e) {
            this.printAndExit(e);
        }
    }

    private void printAndExit(Exception e) {
        System.err.println(e);
        System.exit(1);
    }
}

