/*
 * Decompiled with CFR 0.152.
 */
package org.goldang.qaparadigm;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.goldang.qaparadigm.GraphicDisplay;

class PictureDisplay
extends GraphicDisplay
implements ImageObserver {
    private final File myDirectory;
    private Image myImage;

    PictureDisplay(File directory) {
        this.myDirectory = directory;
    }

    void setFileName(String fileName) throws IOException {
        File myFile = new File(this.myDirectory, fileName);
        this.myImage = ImageIO.read(myFile);
        this.setSize(this.getPreferredSize());
        this.repaint();
    }

    public Dimension getSize() {
        if (this.myImage instanceof Image) {
            return new Dimension(this.myImage.getWidth(this), this.myImage.getHeight(this));
        }
        return new Dimension(1, 1);
    }

    public Dimension getPreferredSize() {
        return this.getSize();
    }

    public void paint(Graphics g) {
        g.setColor(this.getForeground());
        if (this.myImage instanceof Image && g instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.drawImage(this.myImage, 0, 0, this);
        }
    }

    public boolean imageUpdate(Image img, int infoflags, int x, int y, int w, int h) {
        return true;
    }
}

