/*
 * Decompiled with CFR 0.152.
 */
package org.goldang.qaparadigm;

import java.awt.Frame;
import java.io.IOException;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import org.goldang.qaparadigm.Alert;
import org.goldang.qaparadigm.DisplayPanel;
import org.goldang.qaparadigm.FullFrame;
import org.goldang.qaparadigm.GraphicDisplay;
import org.goldang.qaparadigm.PictureDisplay;
import org.goldang.qaparadigm.Strings;

class PictureDisplayPanel
extends DisplayPanel {
    private DisplayPanel.ControlMenu myMenu;
    private final PictureDisplay myPictureDisplay = new PictureDisplay(this.getSentenceFile().getParentFile());

    public PictureDisplayPanel(FullFrame frame) {
        super(frame);
        this.add(this.myPictureDisplay);
    }

    protected void sizeToFit() {
    }

    public GraphicDisplay getGraphicDisplay() {
        return this.myPictureDisplay;
    }

    final void showPicture(String s) {
        try {
            this.myPictureDisplay.setFileName(s);
            this.doLayout();
        }
        catch (IOException e) {
            new Alert(Strings.res(Strings.PICTURE_FILE_UNREADABLE) + ": '" + s + "'\n" + e.getMessage(), (Frame)this.getFrame());
        }
    }

    protected void showStimulus() {
        if (!this.sentencesAreFinished()) {
            this.showPicture(this.getCurrentSentence());
            this.getLogFile().log(this.sequenceIndex(), this.getCurrentSentenceNumber(), this.getCurrentSentence());
        }
    }

    public JMenu makeMenu() {
        if (!(this.myMenu instanceof JMenu)) {
            this.myMenu = new DisplayPanel.ControlMenu();
        }
        return this.myMenu;
    }

    public JPopupMenu getPopupMenu() {
        this.makeMenu();
        return this.myMenu.getPopupMenu();
    }
}

