/*
 * Decompiled with CFR 0.152.
 */
package org.goldang.qaparadigm;

import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.goldang.qaparadigm.Alert;
import org.goldang.qaparadigm.DisplayPanel;
import org.goldang.qaparadigm.Strings;

public class SoundFilePlayer
implements Runnable {
    private DisplayPanel myDisplay = null;
    private Clip myClip = null;
    private boolean iAmPlaying = false;

    public boolean isPlaying() {
        return this.iAmPlaying;
    }

    public void play(File file, DisplayPanel display) {
        try {
            Clip clip = this.openFileAsSoundClip(file);
            this.myDisplay = display;
            this.playClip(clip);
        }
        catch (IOException e) {
            new Alert(e, (Frame)display.getFrame());
        }
        catch (UnsupportedAudioFileException e) {
            new Alert(e, (Frame)display.getFrame());
        }
        catch (LineUnavailableException e) {
            new Alert(e, (Frame)display.getFrame());
        }
    }

    private Clip openFileAsSoundClip(File file) throws IOException, UnsupportedAudioFileException, LineUnavailableException {
        AudioInputStream ais = AudioSystem.getAudioInputStream(file);
        AudioFormat fmt = ais.getFormat();
        DataLine.Info info = new DataLine.Info(Clip.class, fmt);
        Clip clip = (Clip)AudioSystem.getLine(info);
        clip.open(ais);
        return clip;
    }

    private void playClip(Clip clip) {
        this.myClip = clip;
        Thread thread = new Thread(this);
        thread.start();
    }

    public void run() {
        if (this.myClip == null) {
            return;
        }
        long clipDurationMillisec = this.myClip.getMicrosecondLength() / 1000L;
        this.iAmPlaying = true;
        this.myClip.start();
        Calendar calendar = Calendar.getInstance();
        long startTime = calendar.getTimeInMillis();
        long delay = this.myDisplay.getDelayAfterPlayingMillisec();
        Thread thread = Thread.currentThread();
        try {
            this.waitAndDisplayProgress(thread, startTime, clipDurationMillisec, delay);
        }
        catch (InterruptedException e) {
            this.printAndExit(e);
        }
        if (this.myDisplay != null) {
            this.myDisplay.showFinished();
        }
        this.iAmPlaying = false;
        this.myClip = null;
    }

    private void waitAndDisplayProgress(Thread thread, long startTime, long clipDuration, long delay) throws InterruptedException {
        long nowTime = startTime;
        while (nowTime - startTime < clipDuration + delay) {
            Calendar calendar = Calendar.getInstance();
            nowTime = calendar.getTimeInMillis();
            float diff = nowTime - startTime;
            float dur = clipDuration + delay;
            Thread.sleep(50L);
            thread.yield();
            if (this.myDisplay == null || !(dur > 0.0f)) continue;
            this.myDisplay.showProgress(diff / dur);
        }
    }

    private void printAndExit(Exception e) {
        System.err.println(e);
        System.exit(1);
    }

    public static void main(String[] arg) {
        SoundFilePlayer sfp = new SoundFilePlayer();
        if (arg.length == 1) {
            sfp.play(new File(arg[0]), null);
        } else {
            System.err.println(Strings.res(Strings.PLEASE_PROVIDE_FILE));
        }
    }
}

