/*
 * Decompiled with CFR 0.152.
 */
package org.goldang.qaparadigm;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.goldang.qaparadigm.SentenceFile;
import org.goldang.qaparadigm.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Fontset {
    private static GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
    static final boolean IS_MAC = System.getProperty("os.name").equals("Mac OS X");
    static FontRenderContext myFRC = null;

    private Fontset() {
    }

    static List<Font> supporting(SentenceFile.NumberedSentences sentences) throws SupportException {
        ArrayList<Font> goodFonts = new ArrayList();
        if (sentences.size() > 0) {
            goodFonts = Fontset.buildListOfFontsSupporting((SentenceFile.NumberedSentence)sentences.get(0));
        }
        for (SentenceFile.NumberedSentence s : sentences) {
            Fontset.trimListOfFontsToSupport(goodFonts, s);
        }
        return goodFonts;
    }

    private static List<Font> buildListOfFontsSupporting(SentenceFile.NumberedSentence s) throws SupportException {
        ArrayList<Font> goodFonts = new ArrayList<Font>();
        String[] allFamilies = ge.getAvailableFontFamilyNames();
        int position = -1;
        for (String family : allFamilies) {
            Font font = Font.decode(family);
            position = font.canDisplayUpTo(s.sentence);
            if (position != -1 || "Dialog".equals(family) || "DialogInput".equals(family) || "Serif".equals(family) || "SansSerif".equals(family) || "Monospaced".equals(family)) continue;
            goodFonts.add(font);
        }
        if (goodFonts.isEmpty()) {
            Fontset.complain(s.number, position);
        }
        return goodFonts;
    }

    private static void trimListOfFontsToSupport(List<Font> goodFonts, SentenceFile.NumberedSentence s) throws SupportException {
        int position = -1;
        Iterator<Font> it = goodFonts.iterator();
        while (it.hasNext()) {
            Font font = it.next();
            position = Fontset.fontHasGlyphsUpTo(font, s.sentence);
            if (position == -1) continue;
            it.remove();
        }
        if (goodFonts.isEmpty()) {
            Fontset.complain(s.number, position);
        }
    }

    private static int fontHasGlyphsUpTo(Font font, String s) {
        if (IS_MAC) {
            int firstFailure = -1;
            GlyphVector gv = font.createGlyphVector(myFRC, s);
            int n = gv.getNumGlyphs();
            for (int i = 0; i < n; ++i) {
                if (gv.getGlyphCode(i) >= 0) continue;
                firstFailure = i;
                break;
            }
            return firstFailure;
        }
        return font.canDisplayUpTo(s);
    }

    private static void complain(int sentenceNumber, int charPosition) throws SupportException {
        throw new SupportException(Strings.res(Strings.NO_FONT_SUPPORTS_SENTENCE) + sentenceNumber + Strings.res(Strings.CHARACTER_AT) + charPosition + Strings.res(Strings.POSITION));
    }

    static {
        if (IS_MAC) {
            BufferedImage bi = new BufferedImage(1, 1, 1);
            Graphics2D g2D = ge.createGraphics(bi);
            myFRC = g2D.getFontRenderContext();
        }
    }

    static class SupportException
    extends Exception {
        SupportException(String msg) {
            super(msg);
        }
    }
}

