/*
 * Decompiled with CFR 0.152.
 */
package org.goldang.qaparadigm;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Insets;
import java.awt.Toolkit;
import javax.swing.JFrame;
import org.goldang.qaparadigm.Application;
import org.goldang.qaparadigm.DisplayPanel;
import org.goldang.qaparadigm.Fontset;
import org.goldang.qaparadigm.PictureDisplayPanel;
import org.goldang.qaparadigm.TextDisplayPanel;

public class FullFrame
extends JFrame {
    private final DisplayPanel myDisplayPanel;
    private final Application myApp;

    public FullFrame(Application app, GraphicsDevice gd) throws Fontset.SupportException {
        super(gd.getDefaultConfiguration());
        this.myApp = app;
        GraphicsConfiguration gc = gd.getDefaultConfiguration();
        Toolkit tk = Toolkit.getDefaultToolkit();
        Insets si = tk.getScreenInsets(gc);
        DisplayMode dm = gd.getDisplayMode();
        Dimension sz = new Dimension(dm.getWidth(), dm.getHeight());
        this.setSize(sz.width - si.left - si.right, sz.height - si.top - si.bottom);
        this.setUndecorated(true);
        this.myDisplayPanel = this.makeDisplayPanel();
        if (this.myDisplayPanel instanceof DisplayPanel) {
            this.add((Component)this.myDisplayPanel, "Center");
        }
    }

    private DisplayPanel makeDisplayPanel() throws Fontset.SupportException {
        if (this.myApp.getSentenceFile().isType(1)) {
            return new TextDisplayPanel(this);
        }
        if (this.myApp.getSentenceFile().isType(2)) {
            return new PictureDisplayPanel(this);
        }
        return null;
    }

    public Application getApp() {
        return this.myApp;
    }

    public DisplayPanel getDisplayPanel() {
        return this.myDisplayPanel;
    }
}

