/*
 * Decompiled with CFR 0.152.
 */
package org.goldang.qaparadigm;

import java.awt.event.KeyEvent;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import org.goldang.qaparadigm.DisplayPanel;
import org.goldang.qaparadigm.InsetPanel;
import org.goldang.qaparadigm.Strings;

class InfoPanel
extends InsetPanel {
    private static final int WIDTH = 220;
    private static final int HEIGHT = 110;
    private final DisplayPanel myDisplay;
    private final JTextField myTextField = new TextField();
    private final JProgressBar myExperProgressBar;
    private final JProgressBar myAudioProgressBar;

    InfoPanel(DisplayPanel display) {
        super(true);
        this.myDisplay = display;
        this.setLayout(new BoxLayout(this, 1));
        this.myTextField.setEditable(false);
        this.add(this.myTextField);
        this.add(new JLabel(Strings.res(Strings.EXPERIMENT_PROGRESS)));
        this.myExperProgressBar = new JProgressBar(0, 0);
        this.myExperProgressBar.setStringPainted(true);
        this.add(this.myExperProgressBar);
        this.add(new JLabel(Strings.res(Strings.AUDIO_PROGRESS)));
        this.myAudioProgressBar = new JProgressBar(0, 220);
        this.myAudioProgressBar.setStringPainted(true);
        this.add(this.myAudioProgressBar);
        this.setSize(220, 110);
    }

    void sequenceIndexChanged() {
        this.updateText();
        this.myExperProgressBar.setMaximum(this.numberOfSentences());
        this.setExperimentProgressValue();
    }

    final void setExperimentProgressValue() {
        this.myExperProgressBar.setValue(this.sequenceIndex() + 1);
        this.myExperProgressBar.setString(this.getExperimentProgress());
    }

    final String getExperimentProgress() {
        int n;
        int i = this.sequenceIndex();
        if (i < (n = this.numberOfSentences())) {
            return i + 1 + " / " + n;
        }
        return n + " / " + n;
    }

    private int numberOfSentences() {
        return this.myDisplay.numberOfSentences();
    }

    private int sequenceIndex() {
        return this.myDisplay.sequenceIndex();
    }

    private void updateText() {
        this.myTextField.setText(this.myDisplay.getCurrentSentence());
    }

    final void showSoundProgress(float val) {
        this.myAudioProgressBar.setValue((int)(val * 220.0f));
        this.myAudioProgressBar.setString("");
    }

    final void showSoundFinished() {
        this.myAudioProgressBar.setValue(0);
    }

    private class TextField
    extends JTextField {
        public void processKeyEvent(KeyEvent e) {
            InfoPanel.this.myDisplay.passKeyEvent(e);
        }
    }
}

