/*
 * Decompiled with CFR 0.152.
 */
package org.goldang.qaparadigm;

import java.awt.Point;
import java.util.prefs.Preferences;

public class Prefs {
    private final Class myApplicationClass;

    Prefs(Class appClass) {
        this.myApplicationClass = appClass;
    }

    public void setPreferredWinPosition(Point loc) {
        Preferences pref = this.getPreferences();
        pref.putInt("AppWin_X", loc.x);
        pref.putInt("AppWin_Y", loc.y);
    }

    public Point getPreferredWinPosition() {
        Preferences pref = this.getPreferences();
        int x = pref.getInt("AppWin_X", 100);
        int y = pref.getInt("AppWin_Y", 100);
        return new Point(x, y);
    }

    void setCurrentDirPath(String path) {
        this.getPreferences().put("Last_Dir", path);
    }

    String getCurrentDirPath() {
        return this.getPreferences().get("Last_Dir", "");
    }

    long getDelayAfterPlayingMillisec() {
        return this.getPreferences().getLong("Delay_MS", 2000L);
    }

    boolean shouldRandomizeSentences() {
        return this.getPreferences().getBoolean("Randomize", true);
    }

    int prefDisplayDevice(int numCurrDevices) {
        int n = this.getPreferences().getInt("DisplayDevice", numCurrDevices - 1);
        if (n < numCurrDevices) {
            return n;
        }
        return numCurrDevices - 1;
    }

    final Preferences getPreferences() {
        return Preferences.userNodeForPackage(this.myApplicationClass);
    }

    String preferredFontFamily() {
        return this.getPreferences().get("Font", "");
    }

    int preferredFontSize() {
        return this.getPreferences().getInt("Font_Size", 64);
    }

    int displayDeviceNum() {
        return this.getPreferences().getInt("DisplayDevice", 0);
    }
}

