/*
 * Decompiled with CFR 0.152.
 */
package org.goldang.qaparadigm;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import org.goldang.qaparadigm.GraphicDisplay;
import org.goldang.qaparadigm.SentenceFile;

class TextDisplay
extends GraphicDisplay {
    public static final int MAX_FONT_SIZE = 600;
    private String myString = "";
    private final Graphics2D myG2D = this.getGraphics2D();
    private final FontRenderContext myFRC = this.myG2D.getFontRenderContext();

    TextDisplay(Font font) {
        this.setFont(font);
    }

    void setString(String s) {
        this.myString = s;
        this.setSize(this.getPreferredSize());
        this.repaint();
    }

    void setFontSize(int size) {
        Font f = this.getFont();
        Font newfont = new Font(f.getName(), f.getStyle(), size);
        this.setFont(newfont);
        this.setSize(this.getPreferredSize());
        this.repaint();
    }

    void setFontName(String name) {
        Font font = this.getFont();
        int size = font.getSize();
        this.setFont(new Font(name, 0, size));
        this.repaint();
    }

    public Dimension getPreferredSize() {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        return new Dimension(fm.stringWidth(this.myString), fm.getHeight());
    }

    int sizeFontToFit(SentenceFile.NumberedSentences sentences, float w) {
        Font font = this.getFont();
        double fsize = font.getSize();
        double size = 600.0;
        for (SentenceFile.NumberedSentence s : sentences) {
            Dimension2D d = this.getStringDisplaySize(s.sentence);
            double val = fsize * (double)w / d.getWidth();
            if (!(val > 0.0)) continue;
            size = Math.min(size, val);
        }
        return (int)size;
    }

    public void paint(Graphics g) {
        g.setColor(this.getForeground());
        Font font = this.getFont();
        g.setFont(font);
        Dimension size = this.getSize();
        int cx = size.width / 2;
        int cy = 0;
        Dimension2D d = this.getStringDisplaySize(this.myString);
        FontMetrics fm = g.getFontMetrics();
        int x = cx - (int)(d.getWidth() / 2.0);
        int y = cy + fm.getAscent();
        if (g instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            FontRenderContext frc = g2d.getFontRenderContext();
            TextLayout tl = new TextLayout(this.myString, font, frc);
            tl.draw(g2d, x, y);
        } else {
            g.drawString(this.myString, x, y);
        }
    }

    private Dimension2D getStringDisplaySize(String s) {
        Rectangle2D r = this.getFont().getStringBounds(s, this.myFRC);
        Dimension d = new Dimension();
        d.setSize(r.getWidth(), r.getHeight());
        return d;
    }
}

