# PEBL 2.3 Portable

PEBL (Psychology Experiment Building Language) is a free, open-source system for designing and running psychological experiments, behavioral tests, and surveys.

## Getting Started

**To launch PEBL:**
- Double-click `runPEBL.bat` in this folder, OR
- Double-click `PEBL\bin\pebl-launcher.exe` directly

The launcher lets you browse the test battery, create studies, and run experiments.  All data and study configuration is carried out within the portable directory.

## Directory Structure

```
PEBL2.3_Portable/
├── runPEBL.bat          # Launch script
├── PEBL/
│   ├── bin/             # Executables (pebl2.exe, pebl-launcher.exe, pebl-validator.exe)
│   ├── battery/         # 100+ pre-built psychological tests
│   ├── pebl-lib/        # PEBL standard library
│   └── media/           # Fonts, images, sounds
├── my_studies/          # Your studies (created on first run)
├── demo/                # Demo experiments
└── tutorials/           # Tutorial examples
```

## Battery of Tests

PEBL includes over 100 psychological tests:

- **Attention & Executive Function**: Flanker, Stroop, Go/No-Go, Trail Making, Wisconsin Card Sort
- **Memory**: Digit Span, Corsi Blocks, N-Back, Tower of London/Hanoi
- **Decision Making**: Iowa Gambling Task, Balloon Analog Risk Task
- **Perception**: Visual Search, Multiple Object Tracking
- **Surveys**: NASA-TLX, SUS, Big Five Personality

Browse `PEBL\battery\` for the complete collection.

## Syntax Validation

Use `pebl-validator.exe` to check PEBL code for syntax errors before running:

```
PEBL\bin\pebl-validator.exe path\to\script.pbl
```

- Exit code 0 = valid syntax
- Exit code 1 = syntax errors (details printed to stderr, or via .json file using --json command line)

This is useful for catching errors quickly without launching the full interpreter.

## For AI Assistants / LLM Users

If you're using an AI assistant (Claude, ChatGPT, etc.) to help write or modify PEBL experiments, see:

**`PEBL\doc\Notes_for_LLMs.txt`**

This file contains essential guidance for AI assistants including:
- Common PEBL programming mistakes and how to avoid them
- Function reference organized by category
- How to use the validator for syntax checking
- Complete workflow for creating new battery tasks

Share this file with your AI assistant for best results.

## Running Experiments from Command Line

```bash
# Run a test directly. You normally need to cd to the directory of the test, to access
# assets like translations, parameters, and stimuli.
cd battery\nback
..\..\PEBL\bin\pebl2.exe nback.pbl

# Run with subject number
cd battery\nback
..\..\PEBL\bin\pebl2.exe nback.pbl -s 101

# Run with parameters file located in params
cd battery\nback
..\..\PEBL\bin\pebl2.exe nback.pbl -s 101 --pfile nback-easy.par.json
```

## Simple Example

```pebl
define Start(p)
{
  gWin <- MakeWindow("black")

  inst <- EasyLabel("Press any key when you see the X",
                    gVideoWidth/2, gVideoHeight/2, gWin, 44)
  Draw()
  WaitForAnyKeyPress()

  Hide(inst)
  Draw()
  Wait(1000 + RandomUniform(1000))

  stimulus <- EasyLabel("X", gVideoWidth/2, gVideoHeight/2, gWin, 100)
  Draw()
  time1 <- GetTime()
  WaitForAnyKeyPress()
  rt <- GetTime() - time1

  MessageBox("Your reaction time: " + rt + " ms", gWin)
}
```

## Data Output

Experiment data is saved in:
- `my_studies\[study-name]\tests\[test-name]\data\` for studies created in the launcher
- The test's own `data\` folder when running tests directly from the battery

## Citation

If you use PEBL in your research, please cite:

```
Mueller, S. T. (2026). PEBL: The Psychology Experiment Building Language
(Version 2.3) [Computer software]. Retrieved from http://pebl.sourceforge.net
```

## Links & Support

- **Website**: http://pebl.sourceforge.net
- **Documentation**: http://pebl.sourceforge.net/doc.html

## License

PEBL is released under the GNU General Public License v2.0.
