/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.event;

import com.coi.tools.os.win.NativeLibException;
import com.izforge.izpack.event.NativeUninstallerListener;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import com.izforge.izpack.util.TargetFactory;
import com.izforge.izpack.util.os.RegistryHandler;
import com.izforge.izpack.util.os.WrappedNativeLibException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.List;

public class RegistryUninstallerListener
extends NativeUninstallerListener {
    public void beforeDeletion(List list, AbstractUIProgressHandler abstractUIProgressHandler) throws Exception {
        InputStream inputStream = this.getClass().getResourceAsStream("/registryEntries");
        if (inputStream == null) {
            return;
        }
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        List list2 = (List)objectInputStream.readObject();
        objectInputStream.close();
        inputStream.close();
        if (list2 == null || list2.size() < 1) {
            return;
        }
        try {
            RegistryHandler registryHandler = this.initializeRegistryHandler();
            if (registryHandler == null) {
                return;
            }
            registryHandler.activateLogging();
            registryHandler.setLoggingInfo(list2);
            registryHandler.rewind();
        }
        catch (Exception exception) {
            if (exception instanceof NativeLibException) {
                throw new WrappedNativeLibException(exception);
            }
            throw exception;
        }
    }

    private RegistryHandler initializeRegistryHandler() throws Exception {
        RegistryHandler registryHandler = null;
        try {
            registryHandler = (RegistryHandler)TargetFactory.getInstance().makeObject("com.izforge.izpack.util.os.RegistryHandler");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            registryHandler = null;
        }
        if (!(registryHandler == null || registryHandler.good() && registryHandler.doPerform())) {
            System.out.println("initializeRegistryHandler is Bad " + registryHandler.good() + registryHandler.doPerform());
            registryHandler = null;
        }
        return registryHandler;
    }
}

