/*
 * Decompiled with CFR 0.152.
 */
package SocLab.GUI.desktop;

import SocLab.GUI.analysisView.GraphView;
import SocLab.GUI.analysisView.StateAnalysisSynthesisView;
import SocLab.GUI.analysisView.StructuralAnalysisView;
import SocLab.GUI.desktop.DesktopFrame;
import SocLab.GUI.evolLauncher.GraphicalEvolLauncher;
import SocLab.GUI.modelEditor.ModelDescFrame;
import SocLab.GUI.modelEditor.ModelEditor;
import SocLab.GUI.modelEditor.ParamsPanels.OrgParamTabbedPane;
import SocLab.GUI.sensiLauncher.GraphicalSensiLauncher;
import SocLab.GUI.simuLauncher.GraphicalSimuLauncher;
import SocLab.GUI.simuLauncher.simuResultSynth.SimuResulsSynthFrame;
import SocLab.GUI.stateAnalysis.StateAnalysisFrame;
import SocLab.core.OrgNew;
import SocLab.core.SocLabToolkit;
import SocLab.core.SwitchLanguages;
import SocLab.tools.RTFReports;
import SocLab.tools.Screenshot;
import controller.simuSynthesis.AnyObservationIsConvergingException;
import controller.simuSynthesis.ControllerImpl;
import gui.synthesis.GuiImpl;
import input.WrongFormException;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;

public class MyMenuBar
extends JMenuBar {
    private DesktopFrame desktopFrame;
    private JMenu filesActions = new JMenu("File");
    private JMenuItem newModelItem = new JMenuItem("New Model ...");
    private JMenuItem openModelItem = new JMenuItem("Open Model ...");
    private JMenuItem saveModelItem = new JMenuItem("Save Model");
    private JMenuItem saveAsModelItem = new JMenuItem("Save Model as ...");
    private JMenuItem closeModelItem = new JMenuItem("Close Model");
    private JMenuItem screenshotItem = new JMenuItem("screenshot");
    private JMenuItem exitItem = new JMenuItem("Exit");
    private JMenu modelActions = new JMenu("Organization Model");
    private JMenuItem modelEditorItem = new JMenuItem("Model Editor");
    private JMenuItem paramsEditorItem = new JMenuItem("Parameters Editor");
    private JMenuItem modelDescItem = new JMenuItem("Model Description");
    private JMenuItem modelSaveReportItem = new JMenuItem("Save Report");
    private JMenu analysis = new JMenu("Analysis");
    private JMenuItem structuralAnalysis = new JMenuItem("Structural Analysis");
    private JMenuItem stateInterpreterItem = new JMenuItem("State Analysis");
    private JMenuItem stateAnalysisSynthesis = new JMenuItem("State Analysis: Synthesis");
    private JMenuItem networks = new JMenuItem("Networks");
    private JMenu simu_actions = new JMenu("Simulations");
    private JMenuItem new_simu = new JMenuItem("Simulation Explorer");
    private JMenuItem new_sensi = new JMenuItem("Sensitivity Analysis");
    private JMenuItem specificRun = new JMenuItem("Run Specific");
    private JMenu optionsActions = new JMenu("Options");
    private JMenu languagesActions = new JMenu("Set Language");
    private JCheckBoxMenuItem languageFrench = new JCheckBoxMenuItem("French");
    private JCheckBoxMenuItem languageEnglish = new JCheckBoxMenuItem("English");
    private JMenu help = new JMenu("Help");
    private JMenuItem HelpSocLab = new JMenuItem("SocLab");
    private JMenuItem HelpEdit = new JMenuItem("Model Editor");
    private JMenuItem HelpState = new JMenuItem("State Analysis");
    private JMenuItem HelpStateSynthesis = new JMenuItem("State Analysis: Synthesis");
    private JMenuItem HelpStruct = new JMenuItem("Structural Analysis");
    private JMenuItem HelpNetwork = new JMenuItem("Networks");
    private JMenuItem HelpSimu = new JMenuItem("Simulation Explorer");
    private JMenuItem HelpSensi = new JMenuItem("Sensitivity Analysis");
    private JMenu evol_actions = new JMenu("Evolution");
    private JMenuItem new_evol = new JMenuItem("Evolution Explorer");
    private static final ImageIcon simuIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(String.valueOf(System.getProperty("user.dir")) + File.separatorChar + "SocLab" + File.separatorChar + "_images" + File.separatorChar + "desktop" + File.separatorChar + "simu_icon.jpg"));

    MyMenuBar(DesktopFrame desktop) {
        this.setGUILabels();
        this.simu_actions.setIcon(simuIcon);
        this.newModelItem.setIcon(DesktopFrame.newModelIcon);
        this.openModelItem.setIcon(DesktopFrame.openModelIcon);
        this.saveModelItem.setIcon(DesktopFrame.saveModelIcon);
        this.saveAsModelItem.setIcon(DesktopFrame.saveAsModelIcon);
        this.closeModelItem.setIcon(DesktopFrame.closeModelIcon);
        this.modelEditorItem.setIcon(DesktopFrame.modelEditorIcon);
        this.paramsEditorItem.setIcon(DesktopFrame.modelEditorIcon);
        this.modelDescItem.setIcon(DesktopFrame.modelEditorIcon);
        this.modelSaveReportItem.setIcon(DesktopFrame.saveAsModelIcon);
        this.structuralAnalysis.setIcon(DesktopFrame.statAnalysisIcon);
        this.stateInterpreterItem.setIcon(DesktopFrame.stateAnalysisIcon);
        this.stateAnalysisSynthesis.setIcon(DesktopFrame.stateAnalysisIcon);
        this.networks.setIcon(DesktopFrame.stateAnalysisIcon);
        this.new_simu.setIcon(DesktopFrame.runModelIcon);
        this.new_sensi.setIcon(DesktopFrame.runModelIcon);
        this.exitItem.setIcon(DesktopFrame.exitIcon);
        this.filesActions.add(this.newModelItem);
        this.filesActions.add(this.openModelItem);
        this.filesActions.add(this.saveModelItem);
        this.filesActions.add(this.saveAsModelItem);
        this.filesActions.add(this.closeModelItem);
        this.filesActions.add(new JSeparator());
        this.filesActions.add(this.screenshotItem);
        this.filesActions.add(new JSeparator());
        this.filesActions.add(this.exitItem);
        this.modelActions.add(this.modelEditorItem);
        this.modelActions.add(this.paramsEditorItem);
        this.modelActions.add(this.modelDescItem);
        this.modelActions.add(this.modelSaveReportItem);
        this.analysis.add(this.stateInterpreterItem);
        this.analysis.add(this.stateAnalysisSynthesis);
        this.analysis.add(this.structuralAnalysis);
        this.analysis.add(this.networks);
        this.simu_actions.add(this.new_simu);
        this.simu_actions.add(this.new_sensi);
        this.simu_actions.add(this.specificRun);
        this.evol_actions.add(this.new_evol);
        this.languageEnglish.setState(true);
        this.languagesActions.add(this.languageFrench);
        this.languagesActions.add(this.languageEnglish);
        this.optionsActions.add(this.languagesActions);
        this.help.add(this.HelpSocLab);
        this.help.add(this.HelpEdit);
        this.help.add(this.HelpSimu);
        this.help.add(this.HelpState);
        this.help.add(this.HelpSensi);
        this.help.add(this.HelpStateSynthesis);
        this.help.add(this.HelpStruct);
        this.help.add(this.HelpNetwork);
        this.add(this.filesActions);
        this.add(this.modelActions);
        this.add(this.analysis);
        this.add(this.simu_actions);
        this.add(this.help);
        this.add(this.optionsActions);
        this.modelEditorItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    MyMenuBar.this.newModelEditor();
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.paramsEditorItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    MyMenuBar.this.newParamsEditor();
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.modelDescItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyMenuBar.this.newModelDescEditor();
            }
        });
        this.modelSaveReportItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyMenuBar.this.saveReport();
            }
        });
        this.structuralAnalysis.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyMenuBar.this.newStructuralAnalysis();
            }
        });
        this.stateInterpreterItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyMenuBar.this.newStateAnalysis();
            }
        });
        this.stateAnalysisSynthesis.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MyMenuBar.this.newStateAnalysisSynthesis();
            }
        });
        this.networks.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MyMenuBar.this.newGraphView();
            }
        });
        this.newModelItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyMenuBar.this.newOrg();
            }
        });
        this.closeModelItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyMenuBar.this.closeOrg();
            }
        });
        this.openModelItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyMenuBar.this.openOrg();
            }
        });
        this.saveModelItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyMenuBar.this.saveOrg();
            }
        });
        this.saveAsModelItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyMenuBar.this.saveOrgAs();
            }
        });
        this.exitItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyMenuBar.this.closeOrg();
                MyMenuBar.this.desktopFrame.dispose();
            }
        });
        this.screenshotItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyMenuBar.this.take_screenshot();
            }
        });
        this.new_simu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyMenuBar.this.newSimuExplorer();
            }
        });
        this.new_sensi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyMenuBar.this.newSensiExplorer();
            }
        });
        this.new_evol.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyMenuBar.this.newEvolExplorer();
            }
        });
        this.HelpSocLab.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyMenuBar.this.newHelpSocLab();
            }
        });
        this.HelpEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyMenuBar.this.newHelpEdit();
            }
        });
        this.HelpStruct.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyMenuBar.this.newHelpStruct();
            }
        });
        this.HelpState.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyMenuBar.this.newHelpState();
            }
        });
        this.HelpSimu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyMenuBar.this.newHelpSimu();
            }
        });
        this.HelpStateSynthesis.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyMenuBar.this.newHelpStateSynth();
            }
        });
        this.HelpNetwork.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyMenuBar.this.newHelpNetwork();
            }
        });
        this.HelpSensi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyMenuBar.this.newHelpSensi();
            }
        });
        this.languageFrench.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyMenuBar.this.setLanguageFrench();
            }
        });
        this.languageEnglish.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyMenuBar.this.setLanguageEnglish();
            }
        });
        this.specificRun.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SocLabToolkit.currentOrgNew.specificRun();
            }
        });
        this.updateMenuVisibility();
        this.desktopFrame = desktop;
    }

    public void updateMenuVisibility() {
        if (SocLabToolkit.currentOrgNew == null) {
            this.saveModelItem.setEnabled(false);
            this.saveAsModelItem.setEnabled(false);
            this.closeModelItem.setEnabled(false);
            this.modelActions.setEnabled(false);
            this.analysis.setEnabled(false);
            this.simu_actions.setEnabled(false);
            this.evol_actions.setEnabled(false);
        } else {
            this.saveModelItem.setEnabled(true);
            this.saveAsModelItem.setEnabled(true);
            this.closeModelItem.setEnabled(true);
            this.modelActions.setEnabled(true);
            this.analysis.setEnabled(true);
            this.simu_actions.setEnabled(true);
            this.evol_actions.setEnabled(true);
        }
    }

    private void setGUILabels() {
        DesktopFrame.statusBar.setText(SwitchLanguages.StatusBarText[SocLabToolkit.idLanguage]);
        this.filesActions.setText(SwitchLanguages.MyMenuBarFilesActions[SocLabToolkit.idLanguage]);
        this.newModelItem.setText(SwitchLanguages.MyMenuBarNewModelItem[SocLabToolkit.idLanguage]);
        this.openModelItem.setText(SwitchLanguages.MyMenuBarOpenModelItem[SocLabToolkit.idLanguage]);
        this.saveModelItem.setText(SwitchLanguages.MyMenuBarSaveModelItem[SocLabToolkit.idLanguage]);
        this.saveAsModelItem.setText(SwitchLanguages.MyMenuBarSaveAsModelItem[SocLabToolkit.idLanguage]);
        this.closeModelItem.setText(SwitchLanguages.MyMenuBarCloseModelItem[SocLabToolkit.idLanguage]);
        this.screenshotItem.setText(SwitchLanguages.MyMenuBarScreenShotItem[SocLabToolkit.idLanguage]);
        this.exitItem.setText(SwitchLanguages.MyMenuBarExitItem[SocLabToolkit.idLanguage]);
        this.modelActions.setText(SwitchLanguages.MyMenuBarModelActions[SocLabToolkit.idLanguage]);
        this.modelEditorItem.setText(SwitchLanguages.MyMenuBarModelEditorItem[SocLabToolkit.idLanguage]);
        this.paramsEditorItem.setText(SwitchLanguages.MyMenuBarParamsEditorItem[SocLabToolkit.idLanguage]);
        this.analysis.setText(SwitchLanguages.MyMenuBarAnalysis[SocLabToolkit.idLanguage]);
        this.structuralAnalysis.setText(SwitchLanguages.MyMenuBarStructuralAnalysis[SocLabToolkit.idLanguage]);
        this.stateInterpreterItem.setText(SwitchLanguages.MyMenuBarStateInterpreterItem[SocLabToolkit.idLanguage]);
        this.stateAnalysisSynthesis.setText(SwitchLanguages.MyMenuBarStateAnalysis[SocLabToolkit.idLanguage]);
        this.networks.setText(SwitchLanguages.MyMenuBarNetworks[SocLabToolkit.idLanguage]);
        this.simu_actions.setText(SwitchLanguages.MyMenuBarSimuActions[SocLabToolkit.idLanguage]);
        this.new_simu.setText(SwitchLanguages.MyMenuBarNewSimu[SocLabToolkit.idLanguage]);
        this.new_sensi.setText(SwitchLanguages.MyMenuBarNewSensi[SocLabToolkit.idLanguage]);
        this.new_evol.setText(SwitchLanguages.MyMenuBarNewEvol[SocLabToolkit.idLanguage]);
        this.optionsActions.setText(SwitchLanguages.MyMenuOptionsActions[SocLabToolkit.idLanguage]);
        this.languagesActions.setText(SwitchLanguages.MyMenuBarLanguagesActions[SocLabToolkit.idLanguage]);
        this.languageFrench.setText(SwitchLanguages.MyMenuBarLanguageFrench[SocLabToolkit.idLanguage]);
        this.languageEnglish.setText(SwitchLanguages.MyMenuBarLanguageEnglish[SocLabToolkit.idLanguage]);
        this.help.setText(SwitchLanguages.MyMenuBarHelp[SocLabToolkit.idLanguage]);
        DesktopFrame.desktopPanel.repaint();
        if (DesktopFrame.sensiLauncher != null) {
            DesktopFrame.sensiLauncher.switchLanguage();
        }
        if (DesktopFrame.simuLauncher != null) {
            DesktopFrame.simuLauncher.switchLanguage();
        }
    }

    private void take_screenshot() {
        String img_name = "screenshot_" + SocLabToolkit.currentOrgNew.scrShtCntr++;
        try {
            Screenshot.export_screen2png(img_name);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void closeOrg() {
        if (SocLabToolkit.currentOrgNew != null) {
            SocLabToolkit.setCurrentOrgNew(null);
            SocLabToolkit.orgFileNew = null;
            DesktopFrame.desktopPanel.paint(DesktopFrame.desktopPanel.getGraphics());
            if (DesktopFrame.modelEditor != null) {
                DesktopFrame.modelEditor.setVisible(false);
                DesktopFrame.modelEditor = null;
            }
            if (DesktopFrame.orgparm != null) {
                DesktopFrame.orgparm.setVisible(false);
                DesktopFrame.orgparm = null;
            }
            if (DesktopFrame.modelDescEditor != null) {
                DesktopFrame.modelDescEditor.setVisible(false);
                DesktopFrame.modelDescEditor = null;
            }
            if (DesktopFrame.structuralAnalysisView != null) {
                DesktopFrame.structuralAnalysisView.setVisible(false);
                DesktopFrame.structuralAnalysisView = null;
            }
            if (DesktopFrame.stateInterpreter != null) {
                DesktopFrame.stateInterpreter.setVisible(false);
                DesktopFrame.stateInterpreter = null;
            }
            if (DesktopFrame.stateAnalysisSynthesisView != null) {
                DesktopFrame.stateAnalysisSynthesisView.setVisible(false);
                DesktopFrame.stateAnalysisSynthesisView = null;
            }
            if (DesktopFrame.graphView != null) {
                DesktopFrame.graphView.setVisible(false);
                DesktopFrame.graphView = null;
            }
            if (DesktopFrame.simuLauncher != null) {
                DesktopFrame.simuLauncher.setVisible(false);
                DesktopFrame.simuLauncher = null;
            }
            if (DesktopFrame.guiSimulationSynthesis != null) {
                DesktopFrame.guiSimulationSynthesis.setVisible(false);
                DesktopFrame.guiSimulationSynthesis = null;
                DesktopFrame.controllerSimulationSynthesis = null;
            }
            if (DesktopFrame.simuResult != null) {
                DesktopFrame.simuResult.setVisible(false);
                DesktopFrame.simuResult = null;
            }
            if (DesktopFrame.sensiLauncher != null) {
                DesktopFrame.sensiLauncher.setVisible(false);
                DesktopFrame.sensiLauncher = null;
            }
            if (DesktopFrame.guiSensitivitySynthesis != null) {
                DesktopFrame.guiSensitivitySynthesis.setVisible(false);
                DesktopFrame.guiSensitivitySynthesis = null;
                DesktopFrame.controllerSensitivitySynthesis = null;
            }
            if (DesktopFrame.evolLauncher != null) {
                DesktopFrame.evolLauncher.setVisible(false);
                DesktopFrame.evolLauncher = null;
            }
            this.desktopFrame.setTitle("SocLab");
            this.updateMenuVisibility();
            DesktopFrame.statusBar.setText("Model Closed Successfully ...");
        }
    }

    private void newOrg() {
        File file = null;
        DesktopFrame.statusBar.setText("Creating New Model ...");
        DesktopFrame.fileChooser.init("Creating New Model", "Create", false);
        int returnVal = DesktopFrame.fileChooser.showOpenDialog(this.desktopFrame);
        if (returnVal == 0) {
            this.closeOrg();
            file = DesktopFrame.fileChooser.getSelectedFile();
            String fileName = file.getName();
            String extension = fileName.length() > 4 ? fileName.substring(fileName.length() - 4, fileName.length()).toLowerCase() : "";
            if (!extension.equals(".org")) {
                fileName = String.valueOf(fileName) + ".org";
                file = new File(String.valueOf(file.getParent()) + File.separatorChar + fileName);
            }
            if (file != null) {
                try {
                    file.createNewFile();
                    String orgName = fileName.substring(0, fileName.length() - 4);
                    SocLabToolkit.orgFileNew = file;
                    SocLabToolkit.setCurrentOrgNew(new OrgNew(orgName));
                    DesktopFrame.desktopPanel.paint(DesktopFrame.desktopPanel.getGraphics());
                    SocLabToolkit.saveOrgNew();
                    this.desktopFrame.setTitle(String.valueOf(SocLabToolkit.currentOrgNew.getName()) + " (" + SocLabToolkit.orgFileNew.getPath() + ")");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        this.updateMenuVisibility();
        if (file != null) {
            DesktopFrame.statusBar.setText("Model " + file.getName() + " Created Successfully ...");
        } else {
            DesktopFrame.statusBar.setText("Creating New Model Canceled ...");
        }
    }

    private void openOrg() {
        File file = null;
        DesktopFrame.statusBar.setText("Opening a Model ...");
        DesktopFrame.fileChooser.init("Opening a Model", "Open", false);
        int returnVal = DesktopFrame.fileChooser.showOpenDialog(this.desktopFrame);
        if (returnVal == 0) {
            this.closeOrg();
            file = DesktopFrame.fileChooser.getSelectedFile();
            if (file != null) {
                SocLabToolkit.openOrgNew(file);
                DesktopFrame.desktopPanel.paint(DesktopFrame.desktopPanel.getGraphics());
                this.desktopFrame.setTitle(String.valueOf(SocLabToolkit.currentOrgNew.getName()) + " (" + SocLabToolkit.orgFileNew.getPath() + ")");
            }
        }
        this.updateMenuVisibility();
        if (file != null) {
            DesktopFrame.statusBar.setText("Model " + file.getName() + " Opened Successfully ...");
            this.newModelDescEditor();
        } else {
            DesktopFrame.statusBar.setText("Opening a Model Canceled ...");
        }
    }

    private void saveOrg() {
        SocLabToolkit.saveOrgNew();
        DesktopFrame.statusBar.setText("Saved Successfully ...");
    }

    private void saveOrgAs() {
        File file = null;
        if (SocLabToolkit.currentOrgNew != null) {
            DesktopFrame.fileChooser.init("Saving as ...", "Save As", false);
            int returnVal = DesktopFrame.fileChooser.showOpenDialog(this.desktopFrame);
            if (returnVal == 0) {
                file = DesktopFrame.fileChooser.getSelectedFile();
                String fileName = file.getName();
                String extension = fileName.length() > 4 ? fileName.substring(fileName.length() - 4, fileName.length()).toLowerCase() : "";
                if (!extension.equals(".org")) {
                    fileName = String.valueOf(fileName) + ".org";
                    file = new File(String.valueOf(file.getParent()) + File.separatorChar + fileName);
                }
                if (file != null) {
                    try {
                        String orgName = fileName.substring(0, fileName.length() - 4);
                        file.createNewFile();
                        SocLabToolkit.currentOrgNew.setName(orgName);
                        SocLabToolkit.orgFileNew = file;
                        DesktopFrame.desktopPanel.paint(DesktopFrame.desktopPanel.getGraphics());
                        SocLabToolkit.saveOrgNew();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                this.desktopFrame.setTitle(String.valueOf(SocLabToolkit.currentOrgNew.getName()) + " (" + SocLabToolkit.orgFileNew.getPath() + ")");
            }
        }
        this.updateMenuVisibility();
        if (file != null) {
            DesktopFrame.statusBar.setText("Model Saved as " + file.getName() + " successfully ...");
        } else {
            DesktopFrame.statusBar.setText("Saving As Canceled ...");
        }
    }

    private void newHelpSocLab() {
        File f = SocLabToolkit.idLanguage == 0 ? new File("HelpSocLab/Help-SocLab.fr.pdf") : new File("HelpSocLab/Help-SocLab.en.pdf");
        try {
            Desktop.getDesktop().open(f);
        }
        catch (IOException e3) {
            DesktopFrame.statusBar.setText("Error while loading HelpSocLab/Help-SocLab.pdf");
        }
    }

    public void newHelpEdit() {
        File f = SocLabToolkit.idLanguage == 0 ? new File("HelpSocLab/Help-Edit.fr.pdf") : new File("HelpSocLab/Help-Edit.en.pdf");
        try {
            Desktop.getDesktop().open(f);
        }
        catch (IOException e3) {
            DesktopFrame.statusBar.setText("Error while loading HelpSocLab/Help-Edit.pdf");
        }
    }

    public void newHelpStruct() {
        File f = SocLabToolkit.idLanguage == 0 ? new File("HelpSocLab/Help-Analyzis.fr.pdf") : new File("HelpSocLab/Help-Analyzis.en.pdf");
        try {
            Desktop.getDesktop().open(f);
        }
        catch (IOException e3) {
            DesktopFrame.statusBar.setText("Error while loading HelpSocLab/Help-Stuct.pdf");
        }
    }

    public void newHelpNetwork() {
        File f = SocLabToolkit.idLanguage == 0 ? new File("HelpSocLab/Help-Analyzis.fr.pdf") : new File("HelpSocLab/Help-Analyzis.en.pdf");
        try {
            Desktop.getDesktop().open(f);
        }
        catch (IOException e3) {
            DesktopFrame.statusBar.setText("Error while loading HelpSocLab/Help-Stuct.pdf");
        }
    }

    public void newHelpStateSynth() {
        File f = SocLabToolkit.idLanguage == 0 ? new File("HelpSocLab/Help-Analyzis.fr.pdf") : new File("HelpSocLab/Help-Analyzis.en.pdf");
        try {
            Desktop.getDesktop().open(f);
        }
        catch (IOException e3) {
            DesktopFrame.statusBar.setText("Error while loading HelpSocLab/Help-Stuct.pdf");
        }
    }

    public void newHelpState() {
        File f = SocLabToolkit.idLanguage == 0 ? new File("HelpSocLab/Help-State.fr.pdf") : new File("HelpSocLab/Help-State.en.pdf");
        try {
            Desktop.getDesktop().open(f);
        }
        catch (IOException e3) {
            DesktopFrame.statusBar.setText("Error while loading HelpSocLab/Help-State.pdf");
        }
    }

    public void newHelpSimu() {
        File f = SocLabToolkit.idLanguage == 0 ? new File("HelpSocLab/Help-Simu.fr.pdf") : new File("HelpSocLab/Help-Simu.en.pdf");
        try {
            Desktop.getDesktop().open(f);
        }
        catch (IOException e3) {
            DesktopFrame.statusBar.setText("Error while loading HelpSocLab/Help-Simu.pdf");
        }
    }

    public void newHelpSensi() {
        File f = SocLabToolkit.idLanguage == 0 ? new File("HelpSocLab/Help-Sensi.fr.pdf") : new File("HelpSocLab/Help-Sensi.en.pdf");
        try {
            Desktop.getDesktop().open(f);
        }
        catch (IOException e3) {
            DesktopFrame.statusBar.setText("Error while loading HelpSocLab/Help-Sensi.pdf");
        }
    }

    private void setLanguageFrench() {
        if (this.languageFrench.getState()) {
            this.languageEnglish.setState(false);
            SocLabToolkit.idLanguage = 0;
            this.setGUILabels();
        } else {
            this.languageFrench.setState(true);
        }
    }

    private void setLanguageEnglish() {
        if (this.languageEnglish.getState()) {
            this.languageFrench.setState(false);
            SocLabToolkit.idLanguage = 1;
            this.setGUILabels();
        } else {
            this.languageEnglish.setState(true);
        }
    }

    public void newRtfReport() {
        if (SocLabToolkit.currentOrgNew.getCurrentSimulationPath() != null) {
            RTFReports.makeSimuSynthesisReport(SocLabToolkit.currentOrgNew);
        } else {
            JOptionPane.showMessageDialog(DesktopFrame.desktopPanel, "Error during the report generation.\nThere is no synthesis.", "Error", -1);
            DesktopFrame.statusBar.setText("Error during the report generation. There is no synthesis.");
        }
    }

    public void simuResultsSynthesis() {
        if (DesktopFrame.simuResult == null) {
            DesktopFrame.simuResult = new SimuResulsSynthFrame();
            DesktopFrame.desktopPanel.add(DesktopFrame.simuResult);
        }
        SimuResulsSynthFrame gui = DesktopFrame.simuResult;
        DesktopFrame.simuResult.update();
        gui.setVisible(true);
        gui.moveToFront();
        DesktopFrame.statusBar.setText("Simulation Results ...");
    }

    public void simuResultView() {
        String simulationsPath = SocLabToolkit.currentOrgNew.getCurrentSimulationPath();
        ControllerImpl c = DesktopFrame.controllerSimulationSynthesis = new ControllerImpl();
        GuiImpl gui = DesktopFrame.guiSimulationSynthesis = new GuiImpl(DesktopFrame.controllerSimulationSynthesis);
        DesktopFrame.desktopPanel.add(gui);
        gui.launch();
        gui.setClosable(true);
        gui.setIconifiable(true);
        gui.setMaximizable(true);
        gui.moveToFront();
        if (simulationsPath != null) {
            if (new File(simulationsPath).exists()) {
                try {
                    c.loadResults(simulationsPath);
                    gui.updateGUI();
                    c.createSummaryFiles(simulationsPath, "synthesis." + SocLabToolkit.orgFileNew.getName() + ".txt");
                    DesktopFrame.statusBar.setText("Synthesis of Simulation ...");
                }
                catch (WrongFormException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (AnyObservationIsConvergingException e) {
                    JOptionPane.showMessageDialog(DesktopFrame.desktopPanel, "Error during the file generation.\nThere is not converging observation.", "Error", -1);
                    DesktopFrame.statusBar.setText("Error during the file generation. There is not converging observation.");
                }
            }
        } else {
            JOptionPane.showMessageDialog(DesktopFrame.desktopPanel, "Error during the file generation.\nYou need to run some simulations before.", "Error", -1);
            DesktopFrame.statusBar.setText("Error during the file generation. You need to run some simulations before.");
        }
    }

    public void viewSensitivityResults() {
        String sensitivityPath = SocLabToolkit.currentOrgNew.getCurrentSensitivityPath();
        DesktopFrame.controllerSensitivitySynthesis = new controller.sensitivity.ControllerImpl();
        DesktopFrame.guiSensitivitySynthesis = new gui.sensitivity.GuiImpl(DesktopFrame.controllerSensitivitySynthesis);
        DesktopFrame.desktopPanel.add(DesktopFrame.guiSensitivitySynthesis);
        controller.sensitivity.ControllerImpl c = DesktopFrame.controllerSensitivitySynthesis;
        gui.sensitivity.GuiImpl gui = DesktopFrame.guiSensitivitySynthesis;
        gui.launch();
        gui.setClosable(true);
        gui.setIconifiable(true);
        gui.setMaximizable(true);
        gui.moveToFront();
        if (sensitivityPath != null) {
            if (new File(sensitivityPath).exists()) {
                try {
                    c.loadResults(sensitivityPath);
                    gui.updateGUI();
                }
                catch (WrongFormException e) {
                    e.printStackTrace();
                }
            }
            DesktopFrame.statusBar.setText("Synthesis of Sensitivity ...");
        } else {
            JOptionPane.showMessageDialog(DesktopFrame.desktopPanel, "Error during the files generation.\nYou need to run some simulations before.", "Error", -1);
            DesktopFrame.statusBar.setText("Error during the files generation. You need to run some simulations before.");
        }
    }

    private void newModelEditor() throws Exception {
        if (DesktopFrame.modelEditor == null) {
            DesktopFrame.modelEditor = new ModelEditor(DesktopFrame.desktopPanel);
            DesktopFrame.desktopPanel.add(DesktopFrame.modelEditor);
        }
        if (!DesktopFrame.modelEditor.isVisible()) {
            DesktopFrame.desktopPanel.remove(DesktopFrame.modelEditor);
            DesktopFrame.modelEditor = new ModelEditor(DesktopFrame.desktopPanel);
            DesktopFrame.desktopPanel.add(DesktopFrame.modelEditor);
            ModelEditor gui = DesktopFrame.modelEditor;
            gui.setVisible(true);
            gui.moveToFront();
            DesktopFrame.statusBar.setText("Editing Model ...");
        }
        if (DesktopFrame.orgparm != null && DesktopFrame.orgparm.isVisible()) {
            DesktopFrame.orgparm.dispose();
        }
    }

    private void newParamsEditor() throws Exception {
        if (DesktopFrame.orgparm == null) {
            DesktopFrame.orgparm = new OrgParamTabbedPane(DesktopFrame.desktopPanel);
            DesktopFrame.desktopPanel.add(DesktopFrame.orgparm);
        }
        if (!DesktopFrame.orgparm.isVisible()) {
            DesktopFrame.desktopPanel.remove(DesktopFrame.orgparm);
            DesktopFrame.orgparm = new OrgParamTabbedPane(DesktopFrame.desktopPanel);
            DesktopFrame.desktopPanel.add(DesktopFrame.orgparm);
            OrgParamTabbedPane gui = DesktopFrame.orgparm;
            gui.setVisible(true);
            gui.moveToFront();
            DesktopFrame.statusBar.setText("Model Parameters ...");
        }
        if (DesktopFrame.modelEditor != null && DesktopFrame.modelEditor.isVisible()) {
            DesktopFrame.modelEditor.dispose();
        }
    }

    private void newModelDescEditor() {
        if (DesktopFrame.modelDescEditor == null) {
            DesktopFrame.modelDescEditor = new ModelDescFrame();
            DesktopFrame.desktopPanel.add(DesktopFrame.modelDescEditor);
        }
        if (!DesktopFrame.modelDescEditor.isVisible()) {
            DesktopFrame.desktopPanel.remove(DesktopFrame.modelDescEditor);
            DesktopFrame.modelDescEditor = new ModelDescFrame();
            DesktopFrame.desktopPanel.add(DesktopFrame.modelDescEditor);
            ModelDescFrame gui = DesktopFrame.modelDescEditor;
            gui.setVisible(true);
            gui.moveToFront();
            DesktopFrame.statusBar.setText("Editing Model Description ...");
        }
    }

    private boolean checkIfOneIsOpened() {
        if (DesktopFrame.structuralAnalysisView != null && DesktopFrame.structuralAnalysisView.isVisible()) {
            return true;
        }
        if (DesktopFrame.stateInterpreter != null && DesktopFrame.stateInterpreter.isVisible()) {
            return true;
        }
        if (DesktopFrame.stateAnalysisSynthesisView != null && DesktopFrame.stateAnalysisSynthesisView.isVisible()) {
            return true;
        }
        if (DesktopFrame.graphView != null && DesktopFrame.graphView.isVisible()) {
            return true;
        }
        if (DesktopFrame.simuLauncher != null && DesktopFrame.simuLauncher.isVisible()) {
            return true;
        }
        if (DesktopFrame.guiSimulationSynthesis != null && DesktopFrame.guiSimulationSynthesis.isVisible()) {
            return true;
        }
        if (DesktopFrame.simuResult != null && DesktopFrame.simuResult.isVisible()) {
            return true;
        }
        if (DesktopFrame.sensiLauncher != null && DesktopFrame.sensiLauncher.isVisible()) {
            return true;
        }
        if (DesktopFrame.guiSensitivitySynthesis != null && DesktopFrame.guiSensitivitySynthesis.isVisible()) {
            return true;
        }
        return DesktopFrame.evolLauncher != null && DesktopFrame.evolLauncher.isVisible();
    }

    private boolean closedEdition() {
        Object[] options;
        boolean canOpen = true;
        if (DesktopFrame.modelEditor != null && DesktopFrame.modelEditor.isVisible() && !this.checkIfOneIsOpened()) {
            options = new Object[]{"Yes", "No"};
            if (JOptionPane.showOptionDialog(DesktopFrame.desktopPanel, "In ordre to continue and open the simulation module, the model must be saved (apply button).\nDo you want to continue ?", "Warning", -1, 2, null, options, options[0]) == 0) {
                DesktopFrame.modelEditor.closeEdition();
            } else {
                canOpen = false;
            }
        }
        if (canOpen && DesktopFrame.orgparm != null && DesktopFrame.orgparm.isVisible() && !this.checkIfOneIsOpened()) {
            options = new Object[]{"Yes", "No"};
            if (JOptionPane.showOptionDialog(DesktopFrame.desktopPanel, "In ordre to continue and open the simulation module, the model must be saved (apply button).\nDo you want to continue ?", "Warning", -1, 2, null, options, options[0]) == 0) {
                DesktopFrame.orgparm.closeEdition();
            } else {
                canOpen = false;
            }
        }
        return canOpen;
    }

    public void newSimuExplorer() {
        if (this.closedEdition()) {
            if (DesktopFrame.simuLauncher == null) {
                DesktopFrame.simuLauncher = new GraphicalSimuLauncher(DesktopFrame.desktopPanel);
                DesktopFrame.desktopPanel.add(DesktopFrame.simuLauncher);
            }
            if (!DesktopFrame.simuLauncher.isVisible()) {
                DesktopFrame.simuLauncher.update();
                DesktopFrame.simuLauncher.setPreferredSize(new Dimension(700, 500));
                DesktopFrame.simuLauncher.setVisible(true);
            }
            DesktopFrame.simuLauncher.moveToFront();
            DesktopFrame.statusBar.setText("Simulation ...");
        }
    }

    private void newSensiExplorer() {
        if (this.closedEdition()) {
            if (DesktopFrame.sensiLauncher == null) {
                DesktopFrame.sensiLauncher = new GraphicalSensiLauncher(DesktopFrame.desktopPanel);
                DesktopFrame.desktopPanel.add(DesktopFrame.sensiLauncher);
            }
            if (!DesktopFrame.sensiLauncher.isVisible()) {
                DesktopFrame.sensiLauncher.update();
                DesktopFrame.sensiLauncher.setVisible(true);
            }
            DesktopFrame.sensiLauncher.moveToFront();
            DesktopFrame.statusBar.setText("Sensitivity ...");
        }
    }

    private void newEvolExplorer() {
        if (this.closedEdition()) {
            if (DesktopFrame.evolLauncher == null) {
                DesktopFrame.evolLauncher = new GraphicalEvolLauncher(DesktopFrame.desktopPanel);
                DesktopFrame.desktopPanel.add(DesktopFrame.evolLauncher);
            }
            if (!DesktopFrame.evolLauncher.isVisible()) {
                DesktopFrame.evolLauncher.update();
                DesktopFrame.evolLauncher.setPreferredSize(new Dimension(700, 500));
                DesktopFrame.evolLauncher.setVisible(true);
            }
            DesktopFrame.evolLauncher.moveToFront();
            DesktopFrame.statusBar.setText("Evolution ...");
        }
    }

    private void newStructuralAnalysis() {
        if (this.closedEdition()) {
            if (DesktopFrame.structuralAnalysisView == null) {
                StructuralAnalysisView gui;
                DesktopFrame.structuralAnalysisView = gui = new StructuralAnalysisView(DesktopFrame.desktopPanel);
                DesktopFrame.desktopPanel.add(gui);
                gui.moveToFront();
            } else if (!DesktopFrame.structuralAnalysisView.isVisible()) {
                StructuralAnalysisView gui;
                DesktopFrame.desktopPanel.remove(DesktopFrame.structuralAnalysisView);
                DesktopFrame.structuralAnalysisView = gui = new StructuralAnalysisView(DesktopFrame.desktopPanel);
                DesktopFrame.desktopPanel.add(gui);
                gui.moveToFront();
            }
            DesktopFrame.statusBar.setText("Graph View ...");
        }
    }

    private void newGraphView() {
        if (this.closedEdition()) {
            if (DesktopFrame.graphView == null) {
                GraphView gui;
                DesktopFrame.graphView = gui = new GraphView(DesktopFrame.desktopPanel);
                DesktopFrame.desktopPanel.add(gui);
                gui.moveToFront();
            } else if (!DesktopFrame.graphView.isVisible()) {
                GraphView gui;
                DesktopFrame.desktopPanel.remove(DesktopFrame.graphView);
                DesktopFrame.graphView = gui = new GraphView(DesktopFrame.desktopPanel);
                DesktopFrame.desktopPanel.add(gui);
                gui.moveToFront();
            }
            DesktopFrame.statusBar.setText("Graph View ...");
        }
    }

    private void newStateAnalysisSynthesis() {
        if (this.closedEdition()) {
            if (DesktopFrame.stateAnalysisSynthesisView == null) {
                StateAnalysisSynthesisView gui;
                DesktopFrame.stateAnalysisSynthesisView = gui = new StateAnalysisSynthesisView(DesktopFrame.desktopPanel);
                DesktopFrame.desktopPanel.add(gui);
                gui.moveToFront();
            } else if (!DesktopFrame.stateAnalysisSynthesisView.isVisible()) {
                StateAnalysisSynthesisView gui;
                DesktopFrame.desktopPanel.remove(DesktopFrame.stateAnalysisSynthesisView);
                DesktopFrame.stateAnalysisSynthesisView = gui = new StateAnalysisSynthesisView(DesktopFrame.desktopPanel);
                DesktopFrame.desktopPanel.add(gui);
                gui.moveToFront();
            }
            DesktopFrame.statusBar.setText("State Analysis : Synthesis ...");
        }
    }

    public void newStateAnalysis() {
        if (this.closedEdition()) {
            if (DesktopFrame.stateInterpreter == null) {
                DesktopFrame.stateInterpreter = new StateAnalysisFrame(this.desktopFrame);
                DesktopFrame.desktopPanel.add(DesktopFrame.stateInterpreter);
            } else if (!DesktopFrame.stateInterpreter.isVisible()) {
                DesktopFrame.desktopPanel.remove(DesktopFrame.stateInterpreter);
                DesktopFrame.stateInterpreter = null;
                DesktopFrame.stateInterpreter = new StateAnalysisFrame(this.desktopFrame);
                DesktopFrame.desktopPanel.add(DesktopFrame.stateInterpreter);
            }
            DesktopFrame.stateInterpreter.moveToFront();
            DesktopFrame.statusBar.setText("Static Analysis ...");
        }
    }

    public void newSensiRtfReport() {
        if (SocLabToolkit.currentOrgNew.getCurrentSensitivityPath() != null) {
            RTFReports.makeSensiSynthesisReport(SocLabToolkit.currentOrgNew);
        } else {
            JOptionPane.showMessageDialog(DesktopFrame.desktopPanel, "Error during the report generation.\nThere is no synthesis.", "Error", -1);
            DesktopFrame.statusBar.setText("Error during the report generation. There is no synthesis.");
        }
    }

    private void saveReport() {
        String choosedFile = "";
        DesktopFrame.fileChooser.init("choose the folder where you want to save the report", "Select", true);
        int returnVal = DesktopFrame.fileChooser.showOpenDialog(ModelEditor.desktop);
        if (returnVal == 0) {
            choosedFile = DesktopFrame.fileChooser.getSelectedFile().getPath();
            File f1 = new File(choosedFile);
            if (!f1.exists()) {
                f1.mkdirs();
            }
            choosedFile = f1.getPath();
            SocLabToolkit.currentOrgNew.setCurrentModelEditorPath(choosedFile);
            RTFReports.makeModelReport(SocLabToolkit.currentOrgNew);
        }
    }
}

