/*
 * Decompiled with CFR 0.152.
 */
package SocLab.GUI.effectAction;

import SocLab.core.EffectNew;
import SocLab.tools.functions.AbstractFunction;
import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JPanel;

class MyEffectViewer
extends JPanel {
    protected EffectNew effectNew;

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        this.drawBackground(g);
        if (this.effectNew != null && this.effectNew.getFunction() != null) {
            this.drawDatas(g, this.effectNew.getFunction(), Color.BLACK);
        }
    }

    public void drawDatas(Graphics g, AbstractFunction f, Color c) {
        g.setColor(c);
        double i = this.effectNew.getRelationNew().getRPNInitial().getLowerBound();
        while (i <= this.effectNew.getRelationNew().getRPNInitial().getUpperBound()) {
            this.drawValue(g, i, f.getF(i));
            i += 0.5;
        }
    }

    public void drawValue(Graphics g, double i, double j) {
        int x = new Double(Math.round((i + 10.0) * 10.0)).intValue();
        int y = new Double((10.0 - j) * 10.0).intValue();
        g.fillRect(x, y, 4, 4);
    }

    public void drawBackground(Graphics g) {
        g.setColor(Color.white);
        if (this.effectNew != null) {
            g.fillRect(new Double(this.effectNew.getRelationNew().getRPNInitial().getLowerBound()).intValue() * 10 + 100, 0, new Double((this.effectNew.getRelationNew().getRPNInitial().getUpperBound() - this.effectNew.getRelationNew().getRPNInitial().getLowerBound()) * 10.0 + 4.0).intValue(), 200);
        }
        int i = 0;
        while (i < 41) {
            int x1 = i * 5;
            g.setColor(Color.lightGray);
            g.fillRect(x1, 0, 4, 4);
            g.fillRect(x1, 200, 4, 4);
            g.setColor(Color.gray);
            g.fillRect(x1, 100, 4, 4);
            ++i;
        }
        i = 0;
        while (i < 41) {
            int y1 = i * 5;
            g.setColor(Color.lightGray);
            g.fillRect(0, y1, 4, 4);
            g.fillRect(200, y1, 4, 4);
            g.setColor(Color.gray);
            g.fillRect(100, y1, 4, 4);
            ++i;
        }
    }

    public EffectNew getEffectNew() {
        return this.effectNew;
    }

    public void setEffectNew(EffectNew effectNew) {
        this.effectNew = effectNew;
    }
}

