/*
 * Decompiled with CFR 0.152.
 */
package SocLab.GUI.effectAction;

import SocLab.GUI.effectAction.ConstraintModellingGUI;
import SocLab.GUI.effectAction.MyChangeConstraintListener;
import SocLab.GUI.effectAction.effectGuiComponents.ConstraintControl;
import SocLab.GUI.effectAction.functionConstraintController.FunctionController;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;

public class ParamsConstraintSlider
extends JComponent {
    private static final long serialVersionUID = 1L;
    private String name = "";
    private JSlider slider;
    private JTextField value;
    private double ratio = 1.0;
    private JPanel jp = new JPanel();
    private MyChangeConstraintListener aListener;
    public static FunctionController control;

    public ParamsConstraintSlider(FunctionController controller, String name, int min, int max, int val, double ratio, boolean b) {
        this.name = name;
        this.ratio = ratio;
        control = controller;
        this.slider = new JSlider(0, min, max, val);
        this.value = new JTextField(String.valueOf((double)this.slider.getValue() * ratio));
        this.aListener = new MyChangeConstraintListener(controller);
        this.slider.addChangeListener(this.aListener);
        this.value.setPreferredSize(new Dimension(51, 21));
        this.value.setEditable(b);
        this.slider.setMinimumSize(new Dimension(51, 21));
        this.slider.setEnabled(b);
        this.setLayout(new BorderLayout());
        this.jp.add(new JLabel(name));
        this.jp.add(this.value);
        this.add((Component)this.value, "West");
        this.add((Component)this.slider, "Center");
        this.value.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ParamsConstraintSlider.this.setValue(new Double(Double.parseDouble(ParamsConstraintSlider.this.value.getText())));
                ParamsConstraintSlider.this.aListener.stateChanged(new ChangeEvent(control));
            }
        });
    }

    public void setValue(double v) {
        this.slider.removeChangeListener(this.aListener);
        this.slider.setValue(new Double(v / this.ratio).intValue());
        this.slider.addChangeListener(this.aListener);
        this.updateText();
    }

    public double getValue() {
        return (double)this.slider.getValue() * this.ratio;
    }

    public void updateText() {
        double v = new Double(Math.round((double)(10 * this.slider.getValue()) * this.ratio)) / 10.0;
        this.value.setText(String.valueOf(v));
        if (ConstraintControl.vall == 1) {
            ConstraintModellingGUI.funcLab.setText(control.getFunction().getFormula());
            ConstraintModellingGUI.jtext.setText("");
            ConstraintModellingGUI.jtext.setText("\n" + control.getFunction().getFormula());
        }
        if (ConstraintControl.vall == 0) {
            ConstraintModellingGUI.funcLab.setText(control.getFunction().getFormula());
            ConstraintModellingGUI.jtext.setText("");
            ConstraintModellingGUI.jtext.setText(control.getFunction().getFormula());
        }
    }
}

