/*
 * Decompiled with CFR 0.152.
 */
package SocLab.GUI.evolLauncher;

import SocLab.GUI.desktop.DesktopFrame;
import SocLab.GUI.evolLauncher.MyThread;
import SocLab.GUI.evolLauncher.paramsPanels.EvolSimuParamTabbedPane;
import SocLab.GUI.evolLauncher.paramsPanels.EvolSimuParams;
import SocLab.core.OrgNew;
import SocLab.core.SocLabToolkit;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSplitPane;
import javax.swing.border.Border;

public class GraphicalEvolLauncher
extends JInternalFrame {
    private JComponent currentParamPanel = null;
    public EvolSimuParams simuParams = new EvolSimuParams(this);
    private JDesktopPane desktop;
    private JPanel orgPanel = new JPanel();
    private JSplitPane listPanel;
    private JPanel controlPanel = new JPanel();
    EvolSimuParamTabbedPane simuTabbedPane;
    private JPanel radioPanel = new JPanel(new GridBagLayout());
    private JButton runButton = new JButton("Run!");
    private JButton synthesisButton = new JButton("Synthesis");
    private JButton resultButton = new JButton("Synthesis Result");
    private JButton stateAnalysisButton = new JButton("State Analysis");
    private JButton reportButton = new JButton("Make Synthesis report");
    private static String first = "Normal Stakes";
    private static String second = "Fuzzy Stakes";
    private static String third = "Normal Solidarities";
    private static String fourth = "Fuzzy Solidarities";
    private static boolean isFuzzyStakes = false;
    private static boolean isFuzzySolidarities = false;
    private String choosedFile;
    private boolean synthesisRunned = false;

    public GraphicalEvolLauncher(JDesktopPane desktop) {
        super("Simu explorer", true, true, true, true);
        this.setName("Simu explorer");
        this.setDefaultCloseOperation(1);
        this.setFrameIcon(DesktopFrame.runModelIcon);
        this.desktop = desktop;
        this.simuTabbedPane = new EvolSimuParamTabbedPane(this, desktop);
        this.controlPanel.setPreferredSize(new Dimension(400, 400));
        this.controlPanel.setLayout(new BorderLayout());
        this.runButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DesktopFrame.fileChooser.init("Choose the folder where you want to save the simulations", "Select", true);
                int returnVal = DesktopFrame.fileChooser.showOpenDialog(GraphicalEvolLauncher.this.desktop);
                if (returnVal == 0) {
                    GraphicalEvolLauncher.this.choosedFile = DesktopFrame.fileChooser.getSelectedFile().getPath();
                    File f1 = new File(GraphicalEvolLauncher.this.choosedFile);
                    if (!f1.exists()) {
                        f1.mkdirs();
                    }
                    int i = 0;
                    while (i < f1.list().length) {
                        if (f1.list()[i].equals("Simulation") && f1.listFiles()[i].isDirectory()) {
                            File f2 = f1.listFiles()[i];
                            GraphicalEvolLauncher.deleteDirectory(f2);
                        }
                        ++i;
                    }
                    File f2 = new File(String.valueOf(GraphicalEvolLauncher.this.choosedFile) + File.separatorChar + "Simulation");
                    if (!f2.exists()) {
                        f2.mkdir();
                    }
                    GraphicalEvolLauncher.this.choosedFile = f2.getPath();
                    SocLabToolkit.currentOrgNew.setCurrentSimulationPath(GraphicalEvolLauncher.this.choosedFile);
                    GraphicalEvolLauncher.this.temporaryRun();
                    DesktopFrame.menuBar.updateMenuVisibility();
                    GraphicalEvolLauncher.this.updateButtonVisibility();
                }
            }
        });
        this.resultButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DesktopFrame.menuBar.simuResultsSynthesis();
            }
        });
        this.synthesisButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphicalEvolLauncher.this.synthesisRunned = true;
                GraphicalEvolLauncher.this.updateButtonVisibility2();
                DesktopFrame.menuBar.simuResultView();
            }
        });
        this.stateAnalysisButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DesktopFrame.menuBar.newStateAnalysis();
            }
        });
        this.reportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DesktopFrame.menuBar.newRtfReport();
            }
        });
        JRadioButton firstButton = new JRadioButton(first);
        JRadioButton secondButton = new JRadioButton(second);
        JRadioButton thirdButton = new JRadioButton(third);
        JRadioButton fourthButton = new JRadioButton(fourth);
        firstButton.setActionCommand(first);
        secondButton.setActionCommand(second);
        thirdButton.setActionCommand(third);
        fourthButton.setActionCommand(fourth);
        firstButton.setSelected(true);
        thirdButton.setSelected(true);
        this.runButton.setIcon(DesktopFrame.runModelIcon);
        this.synthesisButton.setIcon(DesktopFrame.synthesisIcon);
        this.resultButton.setIcon(DesktopFrame.numbersIcon);
        this.stateAnalysisButton.setIcon(DesktopFrame.stateAnalysisIcon);
        this.runButton.setToolTipText("Run simulations");
        this.synthesisButton.setToolTipText("Synthesis of Simulation Results");
        this.stateAnalysisButton.setToolTipText("Analysis of notable states of the game (and the mean converging state)");
        ButtonGroup group1 = new ButtonGroup();
        group1.add(firstButton);
        group1.add(secondButton);
        ButtonGroup group2 = new ButtonGroup();
        group2.add(thirdButton);
        group2.add(fourthButton);
        firstButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals(first)) {
                    isFuzzyStakes = false;
                } else {
                    isFuzzyStakes = true;
                }
            }
        });
        secondButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals(second)) {
                    isFuzzyStakes = true;
                } else {
                    isFuzzyStakes = false;
                }
            }
        });
        thirdButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals(third)) {
                    isFuzzySolidarities = false;
                } else {
                    isFuzzySolidarities = true;
                }
            }
        });
        secondButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals(fourth)) {
                    isFuzzySolidarities = true;
                } else {
                    isFuzzySolidarities = false;
                }
            }
        });
        JPanel p1 = new JPanel(new GridBagLayout());
        GridBagConstraints cc = new GridBagConstraints();
        cc.fill = 2;
        cc.anchor = 10;
        cc.gridx = 0;
        cc.gridy = 0;
        p1.add((Component)firstButton, cc);
        ++cc.gridy;
        p1.add((Component)secondButton, cc);
        ++cc.gridy;
        p1.add((Component)thirdButton, cc);
        ++cc.gridy;
        p1.add((Component)fourthButton, cc);
        Border border = BorderFactory.createLineBorder(Color.gray, 3);
        p1.setBorder(border);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 10;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(10, 5, 10, 5);
        c.ipadx = 5;
        c.ipady = 5;
        this.radioPanel.add((Component)p1, c);
        ++c.gridy;
        this.radioPanel.add((Component)this.simuParams, c);
        ++c.gridy;
        c.insets = new Insets(1, 5, 1, 5);
        this.radioPanel.add((Component)this.runButton, c);
        ++c.gridy;
        this.radioPanel.add((Component)this.synthesisButton, c);
        ++c.gridy;
        this.radioPanel.add((Component)this.resultButton, c);
        ++c.gridy;
        this.radioPanel.add((Component)this.stateAnalysisButton, c);
        ++c.gridy;
        this.radioPanel.add((Component)this.reportButton, c);
        ++c.gridy;
        this.orgPanel.setLayout(new BorderLayout());
        this.orgPanel.add((Component)this.radioPanel, "North");
        this.listPanel = new JSplitPane(1, this.orgPanel, this.controlPanel);
        this.listPanel.setResizeWeight(0.5);
        this.listPanel.setOneTouchExpandable(true);
        this.listPanel.setContinuousLayout(true);
        this.setLayout(new BorderLayout());
        this.add((Component)this.orgPanel, "West");
        this.add((Component)this.controlPanel, "Center");
        this.setSize(1150, 450);
    }

    private static void deleteDirectory(File path) {
        if (path.exists()) {
            File[] files = path.listFiles();
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    GraphicalEvolLauncher.deleteDirectory(files[i]);
                } else {
                    files[i].delete();
                }
                ++i;
            }
        }
        path.delete();
    }

    private void updateButtonVisibility() {
        String sensitivityPath = SocLabToolkit.currentOrgNew.getCurrentSimulationPath();
        if (sensitivityPath != null) {
            if (new File(sensitivityPath).exists()) {
                this.synthesisButton.setEnabled(true);
                this.synthesisButton.setToolTipText("Synthesis of Simulation Results");
            }
        } else {
            this.synthesisButton.setEnabled(false);
            this.synthesisButton.setToolTipText("You need to run some simulations before !");
        }
    }

    private void updateButtonVisibility2() {
        if (this.synthesisRunned) {
            this.reportButton.setEnabled(true);
            this.resultButton.setEnabled(true);
            this.reportButton.setToolTipText("Report for Synthesis Results");
            this.resultButton.setToolTipText("Result of Synthesis");
        } else {
            this.reportButton.setEnabled(false);
            this.resultButton.setEnabled(false);
            this.reportButton.setToolTipText("You need to run a synthesis before");
            this.resultButton.setToolTipText("You need to run a synthesis before");
        }
    }

    private void temporaryRun() {
        MyThread mt = new MyThread(this.desktop, this.choosedFile, isFuzzyStakes, isFuzzySolidarities, this);
        mt.start();
    }

    private void switchPanel(JComponent component) {
        if (this.currentParamPanel != null) {
            this.controlPanel.remove(this.currentParamPanel);
        }
        this.currentParamPanel = component;
        this.controlPanel.add((Component)this.currentParamPanel, "Center");
        this.currentParamPanel.paintAll(this.currentParamPanel.getGraphics());
    }

    public void update() {
        if (SocLabToolkit.currentOrgNew != null) {
            this.simuTabbedPane.initValues();
            OrgNew orgNew = SocLabToolkit.currentOrgNew;
            this.setTitle("Model > " + orgNew.getName());
            this.switchPanel(this.simuTabbedPane);
            this.synthesisRunned = false;
            this.updateButtonVisibility();
            this.updateButtonVisibility2();
        }
    }
}

