/*
 * Decompiled with CFR 0.152.
 */
package SocLab.GUI.evolLauncher.paramsPanels;

import SocLab.GUI.desktop.DesktopFrame;
import SocLab.GUI.evolLauncher.GraphicalEvolLauncher;
import SocLab.GUI.evolLauncher.paramsPanels.EvolAgentParams;
import SocLab.GUI.evolLauncher.paramsPanels.EvolParams;
import SocLab.GUI.evolLauncher.paramsPanels.EvolSimulationDescEditor;
import SocLab.GUI.simuLauncher.paramsPanels.AgentParams;
import SocLab.GUI.simuLauncher.paramsPanels.TEParams;
import SocLab.core.OrgNew;
import SocLab.core.SocLabToolkit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class EvolSimuParamTabbedPane
extends JPanel {
    private GraphicalEvolLauncher project;
    private JTabbedPane tabbedPane = new JTabbedPane();
    public TEParams teParams;
    private AgentParams agentParams;
    private EvolSimulationDescEditor simuDescEditor;
    private JButton validate = new JButton("Accept");
    private EvolParams structParams;
    private EvolAgentParams agentParamsStructure;

    public EvolSimuParamTabbedPane(GraphicalEvolLauncher graphicalEvolLauncher, JDesktopPane desktop) {
        this.project = graphicalEvolLauncher;
        this.validate.setIcon(DesktopFrame.okIcon);
        this.validate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EvolSimuParamTabbedPane.this.updateParams(SocLabToolkit.currentOrgNew);
            }
        });
        this.teParams = new TEParams();
        this.agentParams = new AgentParams();
        this.simuDescEditor = new EvolSimulationDescEditor();
        this.agentParamsStructure = new EvolAgentParams(false);
        this.structParams = new EvolParams(graphicalEvolLauncher);
        this.tabbedPane.add((Component)this.teParams, "Initial State (terms of exchange)");
        this.tabbedPane.add((Component)this.agentParams, "Agent Parameters");
        this.tabbedPane.add((Component)this.simuDescEditor, "Simulation Description");
        this.tabbedPane.add((Component)this.structParams, "Structure Parameters");
        this.tabbedPane.add((Component)this.agentParamsStructure, "Structure : Agents Parameters");
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabbedPane, "Center");
        this.add((Component)this.validate, "South");
        this.setVisible(true);
    }

    public void updateParams(OrgNew orgNew) {
        this.project.simuParams.updateParams(orgNew);
        this.teParams.updateParams();
        this.agentParams.updateParams();
        this.agentParamsStructure.updateParams(orgNew);
        this.simuDescEditor.updateParams(orgNew);
        this.structParams.updateParams(orgNew);
    }

    public void initValues() {
        this.project.simuParams.initValues();
        this.teParams.initValues(this.project.getGraphics());
        this.agentParams.initValues(this.project.getGraphics());
        this.simuDescEditor.initValues();
        this.structParams.initValues();
        this.agentParamsStructure.initValues(this.project.getGraphics());
    }
}

