/*
 * Decompiled with CFR 0.152.
 */
package SocLab.GUI.modelEditor.ParamsPanels;

import SocLab.GUI.desktop.DesktopFrame;
import SocLab.GUI.effectAction.ConstraintModellingGUI;
import SocLab.GUI.effectAction.EffectModellingGUI;
import SocLab.GUI.modelEditor.CreateStructfromOrgFile;
import SocLab.GUI.modelEditor.ModelEditor;
import SocLab.GUI.modelEditor.ParamsPanels.OrgTable;
import SocLab.GUI.modelEditor.ParamsPanels.OrgTableModel;
import SocLab.core.ActorNew;
import SocLab.core.ConstraintsElement;
import SocLab.core.EffectNew;
import SocLab.core.OrgNew;
import SocLab.core.RelationNew;
import SocLab.core.SocLabToolkit;
import SocLab.core.SwitchLanguages;
import SocLab.core.structures.RelationRelation;
import SocLab.tools.fileKit.OrgIOToolkit;
import SocLab.tools.functions.AbsFunction;
import SocLab.tools.functions.AbstractFunction;
import SocLab.tools.functions.ComplexSigmoid2Function;
import SocLab.tools.functions.ComplexSigmoidFunction;
import SocLab.tools.functions.ConstanteFunction;
import SocLab.tools.functions.GaussianFunction;
import SocLab.tools.functions.LinearFunction;
import SocLab.tools.functions.QuadraticFunction;
import SocLab.tools.functions.QuadraticFunction2;
import SocLab.tools.functions.Sigmoid2Function;
import SocLab.tools.functions.SigmoidFunction;
import SocLab.tools.functions.x3function;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.html.HTMLEditorKit;

public class ModelParams
extends JPanel {
    static final String CONTROL = "control";
    static final String STAKE = "stake";
    static final String EFFECT = "effect";
    static final String CONSTRAINT = "constraint";
    static final String SOLIDARITY = "solidarity";
    static final String FUZZYSTAKE = "fuzzyStake";
    static final String FUZZYSOLIDARITY = "fuzzyAltruism";
    private int maxActorNameWidth;
    private int maxRelationNameWidth;
    private int[] actorNameWidths;
    private int[] relationNameWidths;
    public static OrgNew orgTemp;
    private JSplitPane splitPane;
    private JScrollPane scroll_table;
    private JTextPane descTextArea = new JTextPane();
    private JPanel descPanel = new JPanel();
    public static String xmlTemp;
    public OrgTable table;
    public JToggleButton editDescButton;
    public JToggleButton editButton = new JToggleButton("Edit Mode", DesktopFrame.editCancelIcon, false);
    private JButton editEffectButton = new JButton("Edit Effect", DesktopFrame.effectIcon);
    private JButton copyEffectButton = new JButton("Copy Effect", DesktopFrame.effectIcon);
    private JButton pasteEffectButton = new JButton("Paste Effect", DesktopFrame.effectIcon);
    private JButton editConstraintButton = new JButton("Edit Constraint", DesktopFrame.effectIcon);
    private JButton copyConstraintButton = new JButton("Copy Constraint", DesktopFrame.effectIcon);
    private JButton pasteConstraintButton = new JButton("Paste Constraint", DesktopFrame.effectIcon);
    private String param;
    private String[] stakeChoices = new String[]{"0", "0.1", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
    private String[] solidarityChoices = new String[]{"-1", "-0.9", "-0.8", "-0.7", "-0.6", "-0.5", "-0.4", "-0.3", "-0.2", "-0.1", "0", "0.1", "0.2", "0.3", "0.4", "0.5", "0.6", "0.7", "0.8", "0.9", "1"};
    private JComboBox stakeComboBox = new JComboBox<String>(this.stakeChoices);
    private JComboBox solidarityComboBox = new JComboBox<String>(this.solidarityChoices);
    private String description = "\n";
    private int selectedRow = -1;
    private int selectedColumn = -1;
    private AbstractFunction tempFunction = null;
    private AbstractFunction tempMinFunction = null;
    private AbstractFunction tempMaxFunction = null;
    private JLabel paramLabel = new JLabel();
    private JLabel panelLabel = new JLabel("");
    private JPanel jbuttonModel = new JPanel();

    ModelParams(String param) throws Exception {
        xmlTemp = OrgIOToolkit.saveObjectNew(SocLabToolkit.currentOrgNew);
        orgTemp = CreateStructfromOrgFile.loadOrgNewStruct(xmlTemp);
        this.param = param;
        this.init();
    }

    private void init() throws Exception {
        this.updateParamLabel();
        this.stakeComboBox.setEditable(true);
        this.solidarityComboBox.setEditable(true);
        this.table = new OrgTable(this.param);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (ModelParams.this.param.equals(ModelParams.CONTROL)) {
                    ModelParams.this.descTextArea.setEditorKit(new HTMLEditorKit());
                    ModelParams.this.descTextArea.setText("<html><font color=#D3D3D3 size=+3><center><b><i>" + SwitchLanguages.ModelParamsControlsDescTextArea[SocLabToolkit.idLanguage] + "</i></b></center></font></html>");
                } else {
                    if (ModelParams.this.editDescButton.isSelected()) {
                        ModelParams.this.description = ModelParams.this.descTextArea.getText();
                        ModelParams.this.updateDescriptionInOrg(ModelParams.this.selectedRow, ModelParams.this.selectedColumn);
                    }
                    ModelParams.this.selectedColumn = ModelParams.this.table.getSelectedColumn();
                    ModelParams.this.selectedRow = ModelParams.this.table.getSelectedRow();
                    if ((ModelParams.this.selectedRow < 1 || ModelParams.this.selectedColumn < 1) && ModelParams.this.editDescButton.isSelected()) {
                        ModelParams.this.editDescButton.setSelected(false);
                        ModelParams.this.editDescButton.setIcon(DesktopFrame.editCancelIcon);
                        ModelParams.this.descTextArea.setEditorKit(new HTMLEditorKit());
                        ModelParams.this.descTextArea.setText(ModelParams.this.getHTMLDescription(ModelParams.this.selectedRow, ModelParams.this.selectedColumn));
                        ModelParams.this.descTextArea.setEditable(false);
                        ModelParams.this.descTextArea.setBackground(new Color(235, 235, 255));
                    }
                    ModelParams.this.updateParamLabel();
                    ModelParams.this.description = ModelParams.this.getDescription(ModelParams.this.selectedRow, ModelParams.this.selectedColumn);
                    if (ModelParams.this.editDescButton.isSelected()) {
                        ModelParams.this.descTextArea.setText(ModelParams.this.description);
                        ModelParams.this.descTextArea.requestFocus(true);
                    } else {
                        ModelParams.this.descTextArea.setEditorKit(new HTMLEditorKit());
                        ModelParams.this.descTextArea.setText(ModelParams.this.getHTMLDescription(ModelParams.this.selectedRow, ModelParams.this.selectedColumn));
                    }
                }
            }
        });
        this.descTextArea.setEditorKit(new HTMLEditorKit());
        this.descTextArea.setEditable(false);
        this.descTextArea.setBackground(new Color(245, 245, 255));
        this.descTextArea.setText("<html><center><font color=green size=-1>" + SwitchLanguages.ModelParamsOthersDescTextArea1[SocLabToolkit.idLanguage] + "<br>" + SwitchLanguages.ModelParamsOthersDescTextArea2[SocLabToolkit.idLanguage] + "</font>" + "\"<font color=bleu size=-1><b><u>Description</u></b></font>\"" + "<font color=green size=-1>" + SwitchLanguages.ModelParamsOthersDescTextArea3[SocLabToolkit.idLanguage] + "</font>" + "</center></html>");
        this.editButton.setFocusable(false);
        this.editButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!ModelParams.this.editDescButton.isSelected() && ModelParams.this.canEdit()) {
                    ModelParams.this.table.setEditMode(ModelParams.this.editButton.isSelected());
                    if (ModelParams.this.editButton.isSelected()) {
                        ModelParams.this.editButton.setIcon(DesktopFrame.editOkIcon);
                        ModelParams.this.editButton.setText("Save");
                        ModelParams.this.scroll_table.setBackground(Color.GREEN);
                        ModelParams.this.table.setBackground(Color.WHITE);
                    } else {
                        ModelParams.this.editButton.setIcon(DesktopFrame.editCancelIcon);
                        ModelParams.this.editButton.setText("Edit");
                        ModelParams.this.table.setBackground(Color.LIGHT_GRAY);
                        if (ModelParams.this.param.equals(ModelParams.STAKE)) {
                            OrgNew orgNew = orgTemp;
                            String[] aNames = orgNew.getActorsNewName();
                            String[] rNames = orgNew.getRelationsNewName();
                            boolean existg = false;
                            boolean existl = false;
                            String nameg = "";
                            String namel = "";
                            int i = 0;
                            while (i < aNames.length) {
                                ActorNew aN = orgNew.getActorNew(aNames[i]);
                                double sum = 0.0;
                                int j = 0;
                                while (j < orgNew.getNbRelationsNew()) {
                                    RelationNew rN = orgNew.getRelationNew(rNames[j]);
                                    sum += rN.getDepend(aN.getName()).getStake();
                                    ++j;
                                }
                                if (sum > 10.0) {
                                    existg = true;
                                    nameg = aN.getName();
                                } else if (sum < 10.0) {
                                    existl = true;
                                    namel = aN.getName();
                                }
                                ++i;
                            }
                            if (existg) {
                                JOptionPane.showMessageDialog(DesktopFrame.desktopPanel, String.valueOf(SwitchLanguages.ModelParamsStakesDialog1[SocLabToolkit.idLanguage]) + nameg + SwitchLanguages.ModelParamsStakesDialog2[SocLabToolkit.idLanguage], SwitchLanguages.ModelParamsDialogTitle[SocLabToolkit.idLanguage], -1);
                                DesktopFrame.statusBar.setText(String.valueOf(SwitchLanguages.ModelParamsStakesDialog1[SocLabToolkit.idLanguage]) + nameg + SwitchLanguages.ModelParamsStakesDialog2[SocLabToolkit.idLanguage]);
                            } else if (existl) {
                                JOptionPane.showMessageDialog(DesktopFrame.desktopPanel, String.valueOf(SwitchLanguages.ModelParamsStakesDialog1[SocLabToolkit.idLanguage]) + namel + SwitchLanguages.ModelParamsStakesDialog3[SocLabToolkit.idLanguage], SwitchLanguages.ModelParamsDialogTitle[SocLabToolkit.idLanguage], -1);
                                DesktopFrame.statusBar.setText(String.valueOf(SwitchLanguages.ModelParamsStakesDialog1[SocLabToolkit.idLanguage]) + namel + SwitchLanguages.ModelParamsStakesDialog3[SocLabToolkit.idLanguage]);
                            }
                        }
                    }
                } else {
                    ModelParams.this.editButton.setSelected(false);
                }
            }
        });
        this.editDescButton = new JToggleButton("Edit description", DesktopFrame.editCancelIcon);
        this.editDescButton.setFocusable(false);
        this.descTextArea.setBackground(new Color(235, 235, 255));
        this.editEffectButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (ModelParams.this.selectedRow > 0 && ModelParams.this.selectedColumn > 0 && ModelParams.this.canEdit()) {
                    EffectNew effectNew = (EffectNew)ModelParams.this.table.getModel().getValueAt(ModelParams.this.selectedRow, ModelParams.this.selectedColumn);
                    AbstractFunction function = null;
                    if (effectNew.getFunction().getType().equals("Default")) {
                        function = OrgNew.effetNull;
                    }
                    if (effectNew.getFunction().getType().equals("Constante")) {
                        function = new ConstanteFunction("Constante");
                    }
                    if (effectNew.getFunction().getType().equals("abs_linear")) {
                        function = new AbsFunction("abs_linear");
                    }
                    if (effectNew.getFunction().getType().equals("CS2F")) {
                        function = new ComplexSigmoid2Function("CS2F");
                    }
                    if (effectNew.getFunction().getType().equals("CSF")) {
                        function = new ComplexSigmoidFunction("CSF");
                    }
                    if (effectNew.getFunction().getType().equals("gaussian")) {
                        function = new GaussianFunction("gaussian");
                    }
                    if (effectNew.getFunction().getType().equals("linear")) {
                        function = new LinearFunction("linear");
                    }
                    if (effectNew.getFunction().getType().equals("quadratic")) {
                        function = new QuadraticFunction("quadratic");
                    }
                    if (effectNew.getFunction().getType().equals("quadratic2")) {
                        function = new QuadraticFunction2("quadratic2");
                    }
                    if (effectNew.getFunction().getType().equals("x3")) {
                        function = new x3function("x3");
                    }
                    if (effectNew.getFunction().getType().equals("S2F")) {
                        function = new Sigmoid2Function("S2F");
                    }
                    if (effectNew.getFunction().getType().equals("SF")) {
                        function = new SigmoidFunction("SF");
                    }
                    int i = 0;
                    while (i < effectNew.getFunction().getParamNames().length) {
                        function.setParam(effectNew.getFunction().getParamNames()[i], effectNew.getFunction().getParam(effectNew.getFunction().getParamNames()[i]));
                        ++i;
                    }
                    function.recompute();
                    EffectModellingGUI temp = new EffectModellingGUI((Frame)DesktopFrame.desktopPanel.getDesktop(), effectNew);
                    if (temp.cancelled) {
                        effectNew.setFunction(function);
                    }
                    ((OrgTableModel)ModelParams.this.table.getModel()).cellUpdate(ModelParams.this.selectedRow, ModelParams.this.selectedColumn);
                }
            }
        });
        this.copyEffectButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (ModelParams.this.selectedRow > 0 && ModelParams.this.selectedColumn > 0 && ModelParams.this.canEdit()) {
                    EffectNew effectNew = (EffectNew)ModelParams.this.table.getModel().getValueAt(ModelParams.this.selectedRow, ModelParams.this.selectedColumn);
                    ModelParams.this.tempFunction = null;
                    if (effectNew.getFunction().getType().equals("Default")) {
                        ModelParams.this.tempFunction = OrgNew.effetNull;
                    }
                    if (effectNew.getFunction().getType().equals("Constante")) {
                        ModelParams.this.tempFunction = new ConstanteFunction("Constante");
                    }
                    if (effectNew.getFunction().getType().equals("abs_linear")) {
                        ModelParams.this.tempFunction = new AbsFunction("abs_linear");
                    }
                    if (effectNew.getFunction().getType().equals("CS2F")) {
                        ModelParams.this.tempFunction = new ComplexSigmoid2Function("CS2F");
                    }
                    if (effectNew.getFunction().getType().equals("CSF")) {
                        ModelParams.this.tempFunction = new ComplexSigmoidFunction("CSF");
                    }
                    if (effectNew.getFunction().getType().equals("gaussian")) {
                        ModelParams.this.tempFunction = new GaussianFunction("gaussian");
                    }
                    if (effectNew.getFunction().getType().equals("linear")) {
                        ModelParams.this.tempFunction = new LinearFunction("linear");
                    }
                    if (effectNew.getFunction().getType().equals("quadratic")) {
                        ModelParams.this.tempFunction = new QuadraticFunction("quadratic");
                    }
                    if (effectNew.getFunction().getType().equals("quadratic2")) {
                        ModelParams.this.tempFunction = new QuadraticFunction2("quadratic2");
                    }
                    if (effectNew.getFunction().getType().equals("x3")) {
                        ModelParams.this.tempFunction = new x3function("x3");
                    }
                    if (effectNew.getFunction().getType().equals("S2F")) {
                        ModelParams.this.tempFunction = new Sigmoid2Function("S2F");
                    }
                    if (effectNew.getFunction().getType().equals("SF")) {
                        ModelParams.this.tempFunction = new SigmoidFunction("SF");
                    }
                    int i = 0;
                    while (i < effectNew.getFunction().getParamNames().length) {
                        ModelParams.this.tempFunction.setParam(effectNew.getFunction().getParamNames()[i], effectNew.getFunction().getParam(effectNew.getFunction().getParamNames()[i]));
                        ++i;
                    }
                    ModelParams.this.tempFunction.recompute();
                }
            }
        });
        this.pasteEffectButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (ModelParams.this.selectedRow > 0 && ModelParams.this.selectedColumn > 0 && ModelParams.this.tempFunction != null && ModelParams.this.canEdit()) {
                    ((EffectNew)ModelParams.this.table.getModel().getValueAt(ModelParams.this.selectedRow, ModelParams.this.selectedColumn)).setFunction(ModelParams.this.tempFunction);
                    ((OrgTableModel)ModelParams.this.table.getModel()).cellUpdate(ModelParams.this.selectedRow, ModelParams.this.selectedColumn);
                }
            }
        });
        this.editConstraintButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (ModelParams.this.selectedRow > 0 && ModelParams.this.selectedColumn > 0 && ModelParams.this.canEdit()) {
                    if (ModelParams.this.selectedRow == ModelParams.this.selectedColumn) {
                        JOptionPane.showMessageDialog(DesktopFrame.desktopPanel, SwitchLanguages.ModelParamsConstraintDialog[SocLabToolkit.idLanguage], SwitchLanguages.ModelParamsDialogTitle[SocLabToolkit.idLanguage], -1);
                        DesktopFrame.statusBar.setText(SwitchLanguages.ModelParamsConstraintDialog[SocLabToolkit.idLanguage]);
                    } else {
                        RelationRelation relationRelation = (RelationRelation)ModelParams.this.table.getModel().getValueAt(ModelParams.this.selectedRow, ModelParams.this.selectedColumn);
                        AbstractFunction bmin = null;
                        AbstractFunction bmax = null;
                        if (relationRelation.getBminFunction().getType().equals("DefaultMin")) {
                            bmin = OrgNew.effetMin;
                        }
                        if (relationRelation.getBminFunction().getType().equals("Constante")) {
                            bmin = new ConstanteFunction("Constante");
                        }
                        if (relationRelation.getBminFunction().getType().equals("abs_linear")) {
                            bmin = new AbsFunction("abs_linear");
                        }
                        if (relationRelation.getBminFunction().getType().equals("CS2F")) {
                            bmin = new ComplexSigmoid2Function("CS2F");
                        }
                        if (relationRelation.getBminFunction().getType().equals("CSF")) {
                            bmin = new ComplexSigmoidFunction("CSF");
                        }
                        if (relationRelation.getBminFunction().getType().equals("gaussian")) {
                            bmin = new GaussianFunction("gaussian");
                        }
                        if (relationRelation.getBminFunction().getType().equals("linear")) {
                            bmin = new LinearFunction("linear");
                        }
                        if (relationRelation.getBminFunction().getType().equals("quadratic")) {
                            bmin = new QuadraticFunction("quadratic");
                        }
                        if (relationRelation.getBminFunction().getType().equals("quadratic2")) {
                            bmin = new QuadraticFunction2("quadratic2");
                        }
                        if (relationRelation.getBminFunction().getType().equals("x3")) {
                            bmin = new x3function("x3");
                        }
                        if (relationRelation.getBminFunction().getType().equals("S2F")) {
                            bmin = new Sigmoid2Function("S2F");
                        }
                        if (relationRelation.getBminFunction().getType().equals("SF")) {
                            bmin = new SigmoidFunction("SF");
                        }
                        int i = 0;
                        while (i < relationRelation.getBminFunction().getParamNames().length) {
                            bmin.setParam(relationRelation.getBminFunction().getParamNames()[i], relationRelation.getBminFunction().getParam(relationRelation.getBminFunction().getParamNames()[i]));
                            ++i;
                        }
                        if (relationRelation.getBmaxFunction().getType().equals("DefaultMax")) {
                            bmax = OrgNew.effetMax;
                        }
                        if (relationRelation.getBmaxFunction().getType().equals("Constante")) {
                            bmax = new ConstanteFunction("Constante");
                        }
                        if (relationRelation.getBmaxFunction().getType().equals("abs_linear")) {
                            bmax = new AbsFunction("abs_linear");
                        }
                        if (relationRelation.getBmaxFunction().getType().equals("CS2F")) {
                            bmax = new ComplexSigmoid2Function("CS2F");
                        }
                        if (relationRelation.getBmaxFunction().getType().equals("CSF")) {
                            bmax = new ComplexSigmoidFunction("CSF");
                        }
                        if (relationRelation.getBmaxFunction().getType().equals("gaussian")) {
                            bmax = new GaussianFunction("gaussian");
                        }
                        if (relationRelation.getBmaxFunction().getType().equals("linear")) {
                            bmax = new LinearFunction("linear");
                        }
                        if (relationRelation.getBmaxFunction().getType().equals("quadratic")) {
                            bmax = new QuadraticFunction("quadratic");
                        }
                        if (relationRelation.getBmaxFunction().getType().equals("quadratic2")) {
                            bmax = new QuadraticFunction2("quadratic2");
                        }
                        if (relationRelation.getBmaxFunction().getType().equals("x3")) {
                            bmax = new x3function("x3");
                        }
                        if (relationRelation.getBmaxFunction().getType().equals("S2F")) {
                            bmax = new Sigmoid2Function("S2F");
                        }
                        if (relationRelation.getBmaxFunction().getType().equals("SF")) {
                            bmax = new SigmoidFunction("SF");
                        }
                        i = 0;
                        while (i < relationRelation.getBmaxFunction().getParamNames().length) {
                            bmax.setParam(relationRelation.getBmaxFunction().getParamNames()[i], relationRelation.getBmaxFunction().getParam(relationRelation.getBmaxFunction().getParamNames()[i]));
                            ++i;
                        }
                        bmin.recompute();
                        bmax.recompute();
                        ConstraintModellingGUI temp = new ConstraintModellingGUI((Frame)DesktopFrame.desktopPanel.getDesktop(), orgTemp, relationRelation);
                        if (temp.cancelled) {
                            relationRelation.setBminFunction(bmin);
                            relationRelation.setBmaxFunction(bmax);
                        }
                        ((OrgTableModel)ModelParams.this.table.getModel()).cellUpdate(ModelParams.this.selectedRow, ModelParams.this.selectedColumn);
                    }
                }
            }
        });
        this.copyConstraintButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (ModelParams.this.selectedRow > 0 && ModelParams.this.selectedColumn > 0 && ModelParams.this.canEdit()) {
                    RelationRelation relationRelation = (RelationRelation)ModelParams.this.table.getModel().getValueAt(ModelParams.this.selectedRow, ModelParams.this.selectedColumn);
                    ModelParams.this.tempMinFunction = null;
                    ModelParams.this.tempMaxFunction = null;
                    if (relationRelation.getBminFunction().getType().equals("DefaultMin")) {
                        ModelParams.this.tempMinFunction = OrgNew.effetMin;
                    }
                    if (relationRelation.getBminFunction().getType().equals("Constante")) {
                        ModelParams.this.tempMinFunction = new ConstanteFunction("Constante");
                    }
                    if (relationRelation.getBminFunction().getType().equals("abs_linear")) {
                        ModelParams.this.tempMinFunction = new AbsFunction("abs_linear");
                    }
                    if (relationRelation.getBminFunction().getType().equals("CS2F")) {
                        ModelParams.this.tempMinFunction = new ComplexSigmoid2Function("CS2F");
                    }
                    if (relationRelation.getBminFunction().getType().equals("CSF")) {
                        ModelParams.this.tempMinFunction = new ComplexSigmoidFunction("CSF");
                    }
                    if (relationRelation.getBminFunction().getType().equals("gaussian")) {
                        ModelParams.this.tempMinFunction = new GaussianFunction("gaussian");
                    }
                    if (relationRelation.getBminFunction().getType().equals("linear")) {
                        ModelParams.this.tempMinFunction = new LinearFunction("linear");
                    }
                    if (relationRelation.getBminFunction().getType().equals("quadratic")) {
                        ModelParams.this.tempMinFunction = new QuadraticFunction("quadratic");
                    }
                    if (relationRelation.getBminFunction().getType().equals("quadratic2")) {
                        ModelParams.this.tempMinFunction = new QuadraticFunction2("quadratic2");
                    }
                    if (relationRelation.getBminFunction().getType().equals("x3")) {
                        ModelParams.this.tempMinFunction = new x3function("x3");
                    }
                    if (relationRelation.getBminFunction().getType().equals("S2F")) {
                        ModelParams.this.tempMinFunction = new Sigmoid2Function("S2F");
                    }
                    if (relationRelation.getBminFunction().getType().equals("SF")) {
                        ModelParams.this.tempMinFunction = new SigmoidFunction("SF");
                    }
                    int i = 0;
                    while (i < relationRelation.getBminFunction().getParamNames().length) {
                        ModelParams.this.tempMinFunction.setParam(relationRelation.getBminFunction().getParamNames()[i], relationRelation.getBminFunction().getParam(relationRelation.getBminFunction().getParamNames()[i]));
                        ++i;
                    }
                    if (relationRelation.getBmaxFunction().getType().equals("DefaultMax")) {
                        ModelParams.this.tempMaxFunction = OrgNew.effetMax;
                    }
                    if (relationRelation.getBmaxFunction().getType().equals("Constante")) {
                        ModelParams.this.tempMaxFunction = new ConstanteFunction("Constante");
                    }
                    if (relationRelation.getBmaxFunction().getType().equals("abs_linear")) {
                        ModelParams.this.tempMaxFunction = new AbsFunction("abs_linear");
                    }
                    if (relationRelation.getBmaxFunction().getType().equals("CS2F")) {
                        ModelParams.this.tempMaxFunction = new ComplexSigmoid2Function("CS2F");
                    }
                    if (relationRelation.getBmaxFunction().getType().equals("CSF")) {
                        ModelParams.this.tempMaxFunction = new ComplexSigmoidFunction("CSF");
                    }
                    if (relationRelation.getBmaxFunction().getType().equals("gaussian")) {
                        ModelParams.this.tempMaxFunction = new GaussianFunction("gaussian");
                    }
                    if (relationRelation.getBmaxFunction().getType().equals("linear")) {
                        ModelParams.this.tempMaxFunction = new LinearFunction("linear");
                    }
                    if (relationRelation.getBmaxFunction().getType().equals("quadratic")) {
                        ModelParams.this.tempMaxFunction = new QuadraticFunction("quadratic");
                    }
                    if (relationRelation.getBmaxFunction().getType().equals("quadratic2")) {
                        ModelParams.this.tempMaxFunction = new QuadraticFunction2("quadratic2");
                    }
                    if (relationRelation.getBmaxFunction().getType().equals("x3")) {
                        ModelParams.this.tempMaxFunction = new x3function("x3");
                    }
                    if (relationRelation.getBmaxFunction().getType().equals("S2F")) {
                        ModelParams.this.tempMaxFunction = new Sigmoid2Function("S2F");
                    }
                    if (relationRelation.getBmaxFunction().getType().equals("SF")) {
                        ModelParams.this.tempMaxFunction = new SigmoidFunction("SF");
                    }
                    i = 0;
                    while (i < relationRelation.getBmaxFunction().getParamNames().length) {
                        ModelParams.this.tempMaxFunction.setParam(relationRelation.getBmaxFunction().getParamNames()[i], relationRelation.getBmaxFunction().getParam(relationRelation.getBmaxFunction().getParamNames()[i]));
                        ++i;
                    }
                    ModelParams.this.tempMinFunction.recompute();
                    ModelParams.this.tempMaxFunction.recompute();
                }
            }
        });
        this.pasteConstraintButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (ModelParams.this.selectedRow > 0 && ModelParams.this.selectedColumn > 0 && ModelParams.this.tempMinFunction != null && ModelParams.this.tempMaxFunction != null && ModelParams.this.canEdit()) {
                    if (ModelParams.this.selectedRow == ModelParams.this.selectedColumn) {
                        JOptionPane.showMessageDialog(DesktopFrame.desktopPanel, SwitchLanguages.ModelParamsConstraintDialog[SocLabToolkit.idLanguage], SwitchLanguages.ModelParamsDialogTitle[SocLabToolkit.idLanguage], -1);
                        DesktopFrame.statusBar.setText(SwitchLanguages.ModelParamsConstraintDialog[SocLabToolkit.idLanguage]);
                    } else {
                        ConstraintsElement target;
                        RelationRelation relationRelation = (RelationRelation)ModelParams.this.table.getModel().getValueAt(ModelParams.this.selectedRow, ModelParams.this.selectedColumn);
                        relationRelation.setBminFunction(ModelParams.this.tempMinFunction);
                        relationRelation.setBmaxFunction(ModelParams.this.tempMaxFunction);
                        boolean error = false;
                        double i = -10.0;
                        while (i <= 10.0) {
                            if (relationRelation.getBminFunction().getF(i) > relationRelation.getBmaxFunction().getF(i)) {
                                error = true;
                            }
                            i += 0.5;
                        }
                        if (error) {
                            ConstanteFunction bminFunction = OrgNew.effetMin;
                            ConstanteFunction bmaxFunction = OrgNew.effetMax;
                            relationRelation.setBminFunction(bminFunction);
                            relationRelation.setBmaxFunction(bmaxFunction);
                            JOptionPane.showMessageDialog(DesktopFrame.desktopPanel, SwitchLanguages.ConstraintModellingGuiMessageIncoherentLabel[SocLabToolkit.idLanguage], SwitchLanguages.ConstraintModellingGuiMessageIncoherentTitle[SocLabToolkit.idLanguage], -1);
                            DesktopFrame.statusBar.setText(SwitchLanguages.ConstraintModellingGuiMessageIncoherentLabel[SocLabToolkit.idLanguage]);
                        }
                        OrgNew orgNew = orgTemp;
                        if (relationRelation.getBminFunction().getMax() > -10.0 || relationRelation.getBmaxFunction().getMin() < 10.0) {
                            ConstraintsElement source = orgNew.getConstraintsElement(relationRelation.getRelationSource());
                            if (source.hadFather(source, target = orgNew.getConstraintsElement(relationRelation.getRelationTarget())) || target.hadson(target, source)) {
                                ConstanteFunction bminFunction = OrgNew.effetMin;
                                ConstanteFunction bmaxFunction = OrgNew.effetMax;
                                relationRelation.setBminFunction(bminFunction);
                                relationRelation.setBmaxFunction(bmaxFunction);
                                JOptionPane.showMessageDialog(DesktopFrame.desktopPanel, "Model incoherent, Constraints have been re-initialized ...", SwitchLanguages.ConstraintModellingGuiMessageIncoherentTitle[SocLabToolkit.idLanguage], -1);
                                DesktopFrame.statusBar.setText("Model incoherent, Constraints have been re-initialized ...");
                            } else {
                                source.setSons(target);
                                if (target.getNbFathers() == 1 && target.getFather(0).getHim() == null) {
                                    target.getFather(0).delSons(target);
                                    target.clearFathers();
                                }
                                target.setFather(source);
                            }
                        } else {
                            ConstraintsElement source = orgNew.getConstraintsElement(relationRelation.getRelationSource());
                            target = orgNew.getConstraintsElement(relationRelation.getRelationTarget());
                            source.delSons(target);
                            target.delFather(source);
                            if (target.getFathers().size() == 0) {
                                target.addFather(orgTemp.getConstraintsElementOriginal());
                                orgTemp.getConstraintsElementOriginal().addSons(target);
                            }
                        }
                        ((OrgTableModel)ModelParams.this.table.getModel()).cellUpdate(ModelParams.this.selectedRow, ModelParams.this.selectedColumn);
                    }
                }
            }
        });
        this.editDescButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (ModelParams.this.canEdit()) {
                    if (ModelParams.this.param.equals(ModelParams.CONTROL)) {
                        ModelParams.this.editDescButton.setSelected(false);
                        ModelParams.this.descTextArea.setEditorKit(new HTMLEditorKit());
                        ModelParams.this.descTextArea.setText("<html><font color=#D3D3D3 size=+3><center><b><i>" + SwitchLanguages.ModelParamsControlsDescTextArea[SocLabToolkit.idLanguage] + "</i></b></center></font></html>");
                    } else if (!ModelParams.this.editButton.isSelected()) {
                        if (ModelParams.this.selectedRow > 0 && ModelParams.this.selectedColumn > 0) {
                            if (ModelParams.this.editDescButton.isSelected()) {
                                ModelParams.this.editDescButton.setIcon(DesktopFrame.editOkIcon);
                                ModelParams.this.editDescButton.setText("Save description");
                                ModelParams.this.descTextArea.getCaret().setVisible(true);
                                ModelParams.this.descTextArea.setEditorKit(new StyledEditorKit());
                                ModelParams.this.descTextArea.setEditable(true);
                                ModelParams.this.descTextArea.setBackground(Color.WHITE);
                                ModelParams.this.descTextArea.setText(ModelParams.this.description);
                                ModelParams.this.descTextArea.requestFocus(true);
                            } else {
                                ModelParams.this.editDescButton.setText("Edit description");
                                ModelParams.this.description = ModelParams.this.descTextArea.getText();
                                ModelParams.this.updateDescriptionInOrg(ModelParams.this.selectedRow, ModelParams.this.selectedColumn);
                                ModelParams.this.editDescButton.setIcon(DesktopFrame.editCancelIcon);
                                ModelParams.this.descTextArea.setEditorKit(new HTMLEditorKit());
                                ModelParams.this.descTextArea.setText(ModelParams.this.getHTMLDescription(ModelParams.this.selectedRow, ModelParams.this.selectedColumn));
                                ModelParams.this.descTextArea.setEditable(false);
                                ModelParams.this.descTextArea.setBackground(new Color(235, 235, 255));
                            }
                        } else {
                            ModelParams.this.descTextArea.setText("<html><center><font color=green size=-1>" + SwitchLanguages.ModelParamsOthersDescTextArea1[SocLabToolkit.idLanguage] + "<br>" + SwitchLanguages.ModelParamsOthersDescTextArea2[SocLabToolkit.idLanguage] + "</font>" + "\"<font color=bleu size=-1><b><u>Description</u></b></font>\"" + "<font color=green size=-1>" + SwitchLanguages.ModelParamsOthersDescTextArea3[SocLabToolkit.idLanguage] + "</font>" + "</center></html>");
                            ModelParams.this.editDescButton.setSelected(false);
                        }
                    } else {
                        ModelParams.this.editDescButton.setSelected(false);
                    }
                }
            }
        });
        JPanel panel = new JPanel();
        JPanel panelButton = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.panelLabel, "Center");
        if (!this.param.equals(EFFECT) && !this.param.equals(CONSTRAINT)) {
            panelButton.add(this.editButton);
        } else if (this.param.equals(EFFECT)) {
            panelButton.add(this.editEffectButton);
            panelButton.add(this.copyEffectButton);
            panelButton.add(this.pasteEffectButton);
        } else {
            panelButton.add(this.editConstraintButton);
            panelButton.add(this.copyConstraintButton);
            panelButton.add(this.pasteConstraintButton);
        }
        panel.add((Component)panelButton, "East");
        JPanel panelButton2 = new JPanel();
        panelButton2.setLayout(new BorderLayout());
        panelButton2.add((Component)this.paramLabel, "Center");
        panelButton2.add((Component)this.editDescButton, "East");
        panel.add((Component)this.jbuttonModel, "Center");
        this.descPanel.setLayout(new BorderLayout());
        this.descPanel.add((Component)new JScrollPane(this.descTextArea), "Center");
        this.descPanel.add((Component)panelButton2, "North");
        this.scroll_table = new JScrollPane(this.table);
        this.splitPane = new JSplitPane(0, true, this.scroll_table, this.descPanel);
        this.setLayout(new BorderLayout());
        this.add((Component)panel, "North");
        this.add((Component)this.splitPane, "Center");
        this.switchLanguage();
    }

    protected void model() throws Exception {
        if (DesktopFrame.modelEditor == null) {
            DesktopFrame.modelEditor = new ModelEditor(DesktopFrame.desktopPanel);
            DesktopFrame.desktopPanel.add(DesktopFrame.modelEditor);
        }
        if (!DesktopFrame.modelEditor.isVisible()) {
            DesktopFrame.desktopPanel.remove(DesktopFrame.modelEditor);
            DesktopFrame.modelEditor = new ModelEditor(DesktopFrame.desktopPanel);
            DesktopFrame.desktopPanel.add(DesktopFrame.modelEditor);
            ModelEditor gui = DesktopFrame.modelEditor;
            gui.setVisible(true);
            gui.moveToFront();
            DesktopFrame.statusBar.setText("Editing Model ...");
        }
        DesktopFrame.orgparm.dispose();
    }

    void switchLanguage() {
        if (this.param.equals(CONTROL)) {
            this.descTextArea.setText("<html><font color=#D3D3D3 size=+3><center><b><i>" + SwitchLanguages.ModelParamsControlsDescTextArea[SocLabToolkit.idLanguage] + "</i></b></center></font></html>");
        } else if (this.selectedRow < 0 || this.selectedColumn < 0) {
            this.descTextArea.setText("<html><center><font color=green size=-1>" + SwitchLanguages.ModelParamsOthersDescTextArea1[SocLabToolkit.idLanguage] + "<br>" + SwitchLanguages.ModelParamsOthersDescTextArea2[SocLabToolkit.idLanguage] + "</font>" + "\"<font color=bleu size=-1><b><u>Description</u></b></font>\"" + "<font color=green size=-1>" + SwitchLanguages.ModelParamsOthersDescTextArea3[SocLabToolkit.idLanguage] + "</font>" + "</center></html>");
        }
        String val = "";
        if (this.param.equals(CONTROL)) {
            val = SwitchLanguages.OrgParamTabbedPaneControls[SocLabToolkit.idLanguage];
        } else if (this.param.equals(STAKE)) {
            val = SwitchLanguages.OrgParamTabbedPaneStakes[SocLabToolkit.idLanguage];
        } else if (this.param.equals(EFFECT)) {
            val = SwitchLanguages.OrgParamTabbedPaneEffects[SocLabToolkit.idLanguage];
        } else if (this.param.equals(CONSTRAINT)) {
            val = SwitchLanguages.OrgParamTabbedPaneConstraints[SocLabToolkit.idLanguage];
        } else if (this.param.equals(SOLIDARITY)) {
            val = SwitchLanguages.OrgParamTabbedPaneSolidarities[SocLabToolkit.idLanguage];
        } else if (this.param.equals(FUZZYSTAKE)) {
            val = SwitchLanguages.OrgParamTabbedPaneFuzzyStakes[SocLabToolkit.idLanguage];
        } else if (this.param.equals(FUZZYSOLIDARITY)) {
            val = SwitchLanguages.OrgParamTabbedPaneFuzzySolidarities[SocLabToolkit.idLanguage];
        }
        this.panelLabel.setText("<html><center><b><font color=blue>" + val + " MATRIX" + "</font></b></center></html>");
        this.editDescButton.setToolTipText(String.valueOf(SwitchLanguages.ModelParamsEditDescButton[SocLabToolkit.idLanguage]) + this.param);
        this.editButton.setText(SwitchLanguages.ModelParamsEditButton[SocLabToolkit.idLanguage]);
        this.editEffectButton.setText(SwitchLanguages.ModelParamsEditEffectButton[SocLabToolkit.idLanguage]);
        this.editConstraintButton.setText(SwitchLanguages.ModelParamsEditConstraintButton[SocLabToolkit.idLanguage]);
    }

    private void updateParamLabel() {
        String from = "";
        String to = "";
        OrgNew orgNew = orgTemp;
        if (orgNew != null && this.selectedRow > 0 && this.selectedColumn > 0) {
            String[] actorNames = orgNew.getActorsNewName();
            String[] relationNames = orgNew.getRelationsNewName();
            if (this.param.equals(CONTROL) || this.param.equals(EFFECT) || this.param.equals(STAKE) || this.param.equals(FUZZYSTAKE)) {
                from = relationNames[this.selectedRow - 1];
                to = actorNames[this.selectedColumn - 1];
            }
            if (this.param.equals(SOLIDARITY) || this.param.equals(FUZZYSOLIDARITY)) {
                from = actorNames[this.selectedRow - 1];
                to = actorNames[this.selectedColumn - 1];
            }
            if (this.param.equals(CONSTRAINT)) {
                from = relationNames[this.selectedRow - 1];
                to = relationNames[this.selectedColumn - 1];
            }
        }
        String from_to = from.equals("") || to.equals("") ? "" : "(" + from + " <-> " + to + ")";
        this.paramLabel.setText("<html><center><b><font color=#1E9771 size=-1>" + this.param + " DESCRIPTION " + from_to + "</font></b>" + "</center></html>");
    }

    private void updateDescriptionInOrg(int row, int col) {
        OrgNew orgNew = orgTemp;
        if (orgNew != null && row > 0 && col > 0) {
            String actorSName;
            String relationName;
            String actorName;
            this.description = this.description.replace('<', '_');
            this.description = this.description.replace('>', '_');
            this.description = this.description.replace('\"', '_');
            if (this.param.equals(STAKE)) {
                actorName = orgNew.getActorsNew().elementAt(col - 1).getName();
                relationName = orgNew.getRelationsNew().elementAt(row - 1).getName();
                orgNew.getActorNew(actorName).getDepend(relationName).setStakeDesc(this.description);
            }
            if (this.param.equals(FUZZYSTAKE)) {
                actorName = orgNew.getActorsNew().elementAt(col - 1).getName();
                relationName = orgNew.getRelationsNew().elementAt(row - 1).getName();
                orgNew.getActorNew(actorName).getDepend(relationName).setFuzzyStakeDesc(this.description);
            }
            if (this.param.equals(EFFECT)) {
                actorName = orgNew.getActorsNew().elementAt(col - 1).getName();
                relationName = orgNew.getRelationsNew().elementAt(row - 1).getName();
                orgNew.getActorNew(actorName).getDepend(relationName).setEffectNewDesc(this.description);
            }
            if (this.param.equals(CONSTRAINT)) {
                String relationTName = orgNew.getRelationsNew().elementAt(col - 1).getName();
                relationName = orgNew.getRelationsNew().elementAt(row - 1).getName();
                orgNew.getRelationNew(relationName).getTarget(relationTName).setDescription(this.description);
            }
            if (this.param.equals(SOLIDARITY)) {
                actorName = orgNew.getActorsNew().elementAt(col - 1).getName();
                actorSName = orgNew.getActorsNew().elementAt(row - 1).getName();
                orgNew.getActorNew(actorName).getSource(actorSName).setSolidarityDesc(this.description);
            }
            if (this.param.equals(FUZZYSOLIDARITY)) {
                actorName = orgNew.getActorsNew().elementAt(col - 1).getName();
                actorSName = orgNew.getActorsNew().elementAt(row - 1).getName();
                orgNew.getActorNew(actorName).getSource(actorSName).setFuzzySolidarityDesc(this.description);
            }
        }
    }

    private String getDescription(int row, int col) {
        OrgNew orgNew = orgTemp;
        if (orgNew != null && row > 0 && col > 0) {
            if (this.param.equals(STAKE)) {
                String actorName = orgNew.getActorsNew().elementAt(col - 1).getName();
                String relationName = orgNew.getRelationsNew().elementAt(row - 1).getName();
                return orgNew.getActorNew(actorName).getDepend(relationName).getStakeDesc();
            }
            if (this.param.equals(FUZZYSTAKE)) {
                String actorName = orgNew.getActorsNew().elementAt(col - 1).getName();
                String relationName = orgNew.getRelationsNew().elementAt(row - 1).getName();
                return orgNew.getActorNew(actorName).getDepend(relationName).getFuzzyStakeDesc();
            }
            if (this.param.equals(EFFECT)) {
                String actorName = orgNew.getActorsNew().elementAt(col - 1).getName();
                String relationName = orgNew.getRelationsNew().elementAt(row - 1).getName();
                return orgNew.getActorNew(actorName).getDepend(relationName).getEffectNewDesc();
            }
            if (this.param.equals(CONSTRAINT)) {
                String relationTName = orgNew.getRelationsNew().elementAt(col - 1).getName();
                String relationName = orgNew.getRelationsNew().elementAt(row - 1).getName();
                return orgNew.getRelationNew(relationName).getTarget(relationTName).getDescription();
            }
            if (this.param.equals(SOLIDARITY)) {
                String actorName = orgNew.getActorsNew().elementAt(col - 1).getName();
                String actorSName = orgNew.getActorsNew().elementAt(row - 1).getName();
                return orgNew.getActorNew(actorName).getSource(actorSName).getSolidarityDesc();
            }
            if (this.param.equals(FUZZYSOLIDARITY)) {
                String actorName = orgNew.getActorsNew().elementAt(col - 1).getName();
                String actorSName = orgNew.getActorsNew().elementAt(row - 1).getName();
                return orgNew.getActorNew(actorName).getSource(actorSName).getFuzzySolidarityDesc();
            }
        }
        return null;
    }

    private String getHTMLDescription(int row, int col) {
        String finalHTMLDesc = "<html>";
        String itemHTMLDesc = "";
        OrgNew orgNew = orgTemp;
        if (orgNew != null && row > 0 && col > 0) {
            this.description = this.getDescription(row, col);
            itemHTMLDesc = this.text2HTML(this.description);
            finalHTMLDesc = String.valueOf(finalHTMLDesc) + itemHTMLDesc + "</html>";
            return finalHTMLDesc;
        }
        return "<html><font color=#D3D3D3 size=+3><center><b><i>???</i></b></center></font></html>";
    }

    private String text2HTML(String text) {
        if (text != null) {
            String result = "";
            StringTokenizer token = new StringTokenizer(text, "\n");
            while (token.hasMoreTokens()) {
                String line = token.nextToken();
                result = this.isUpperCase(line) ? String.valueOf(result) + "<font color=blue><b><u>" + line + "</u></b></font>" + "<br>" : String.valueOf(result) + "<font size=-1>" + line + "</font>" + "<br>";
            }
            return result;
        }
        return "<font color=#D3D3D3 size=+3><center><b><i>???</i></b></center></font>";
    }

    private boolean isUpperCase(String text) {
        int i = 0;
        while (i < text.length()) {
            Character c = Character.valueOf(text.charAt(i));
            if (Character.isLetter(c.charValue()) && Character.isLowerCase(c.charValue())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    void initValues() {
        int i;
        this.splitPane.setDividerLocation(DesktopFrame.desktopPanel.getHeight() - 350);
        ((OrgTableModel)this.table.getModel()).orgNewUpdate(orgTemp);
        if (this.param.equals(EFFECT) || this.param.equals(CONSTRAINT)) {
            i = 1;
            while (i < this.table.getRowCount()) {
                this.table.setRowHeight(i, 42);
                ++i;
            }
        }
        if (this.param.equals(FUZZYSOLIDARITY) || this.param.equals(FUZZYSTAKE)) {
            i = 1;
            while (i < this.table.getRowCount()) {
                this.table.setRowHeight(i, 28);
                ++i;
            }
        }
        this.updateColumnWidth();
    }

    private void updateColumnWidth() {
        Rectangle2D r;
        OrgNew orgNew = orgTemp;
        String[] actorNames = orgNew.getActorsNewName();
        String[] relationNames = orgNew.getRelationsNewName();
        this.actorNameWidths = new int[actorNames.length];
        this.relationNameWidths = new int[relationNames.length];
        Graphics2D g2D = (Graphics2D)DesktopFrame.desktopPanel.getGraphics();
        Font font = new Font("Times New Roman", 1, 14);
        this.maxActorNameWidth = new Double(Double.NEGATIVE_INFINITY).intValue();
        int i = 0;
        while (i < actorNames.length) {
            r = font.getStringBounds(actorNames[i], 0, actorNames[i].length(), g2D.getFontRenderContext());
            this.actorNameWidths[i] = new Double(r.getWidth()).intValue();
            if (this.actorNameWidths[i] > this.maxActorNameWidth) {
                this.maxActorNameWidth = this.actorNameWidths[i] + 2;
            }
            ++i;
        }
        this.maxRelationNameWidth = new Double(Double.NEGATIVE_INFINITY).intValue();
        i = 0;
        while (i < relationNames.length) {
            r = font.getStringBounds(relationNames[i], 0, relationNames[i].length(), g2D.getFontRenderContext());
            this.relationNameWidths[i] = new Double(r.getWidth()).intValue();
            if (this.relationNameWidths[i] > this.maxRelationNameWidth) {
                this.maxRelationNameWidth = this.relationNameWidths[i] + 2;
            }
            ++i;
        }
        int minWidth = 80;
        if (this.param.equals(EFFECT)) {
            this.table.getColumnModel().getColumn(0).setPreferredWidth(Math.max(this.maxRelationNameWidth, minWidth));
            int i2 = 1;
            while (i2 < this.table.getColumnCount()) {
                this.table.getColumnModel().getColumn(i2).setPreferredWidth(Math.max(this.actorNameWidths[i2 - 1], 42));
                ++i2;
            }
        }
        if (this.param.equals(CONSTRAINT)) {
            this.table.getColumnModel().getColumn(0).setPreferredWidth(Math.max(this.maxRelationNameWidth, minWidth));
            int i3 = 1;
            while (i3 < this.table.getColumnCount()) {
                this.table.getColumnModel().getColumn(i3).setPreferredWidth(Math.max(this.relationNameWidths[i3 - 1], 42));
                ++i3;
            }
        }
        if (this.param.equals(SOLIDARITY)) {
            this.table.getColumnModel().getColumn(0).setPreferredWidth(Math.max(this.maxActorNameWidth, minWidth));
            int i4 = 1;
            while (i4 < this.table.getColumnCount()) {
                this.table.getColumnModel().getColumn(i4).setPreferredWidth(Math.max(this.actorNameWidths[i4 - 1], minWidth));
                ++i4;
            }
        }
        if (this.param.equals(STAKE) || this.param.equals(CONTROL)) {
            this.table.getColumnModel().getColumn(0).setPreferredWidth(Math.max(this.maxRelationNameWidth, minWidth));
            int i5 = 1;
            while (i5 < this.table.getColumnCount() - 3) {
                this.table.getColumnModel().getColumn(i5).setPreferredWidth(Math.max(this.actorNameWidths[i5 - 1], minWidth));
                ++i5;
            }
            this.table.getColumnModel().getColumn(this.table.getColumnCount() - 1).setPreferredWidth(this.table.getColumnModel().getColumn(this.table.getColumnCount() - 1).getPreferredWidth());
        }
        if (this.param.equals(FUZZYSOLIDARITY)) {
            this.table.getColumnModel().getColumn(0).setPreferredWidth(Math.max(this.maxActorNameWidth, minWidth));
            int i6 = 1;
            while (i6 < this.table.getColumnCount()) {
                this.table.getColumnModel().getColumn(i6).setPreferredWidth(Math.max(this.actorNameWidths[i6 - 1], 2 * minWidth));
                ++i6;
            }
        }
        if (this.param.equals(FUZZYSTAKE)) {
            this.table.getColumnModel().getColumn(0).setPreferredWidth(Math.max(this.maxRelationNameWidth, minWidth));
            int i7 = 1;
            while (i7 < this.table.getColumnCount()) {
                this.table.getColumnModel().getColumn(i7).setPreferredWidth(Math.max(this.actorNameWidths[i7 - 1], 2 * minWidth));
                ++i7;
            }
        }
    }

    private boolean canEdit() {
        if (DesktopFrame.structuralAnalysisView != null && DesktopFrame.structuralAnalysisView.isVisible()) {
            return false;
        }
        if (DesktopFrame.stateInterpreter != null && DesktopFrame.stateInterpreter.isVisible()) {
            return false;
        }
        if (DesktopFrame.stateAnalysisSynthesisView != null && DesktopFrame.stateAnalysisSynthesisView.isVisible()) {
            return false;
        }
        if (DesktopFrame.graphView != null && DesktopFrame.graphView.isVisible()) {
            return false;
        }
        if (DesktopFrame.simuLauncher != null && DesktopFrame.simuLauncher.isVisible()) {
            return false;
        }
        if (DesktopFrame.guiSimulationSynthesis != null && DesktopFrame.guiSimulationSynthesis.isVisible()) {
            return false;
        }
        if (DesktopFrame.simuResult != null && DesktopFrame.simuResult.isVisible()) {
            return false;
        }
        if (DesktopFrame.sensiLauncher != null && DesktopFrame.sensiLauncher.isVisible()) {
            return false;
        }
        if (DesktopFrame.guiSensitivitySynthesis != null && DesktopFrame.guiSensitivitySynthesis.isVisible()) {
            return false;
        }
        return DesktopFrame.evolLauncher == null || !DesktopFrame.evolLauncher.isVisible();
    }
}

