/*
 * Decompiled with CFR 0.152.
 */
package SocLab.GUI.modelEditor.ParamsPanels;

import SocLab.GUI.desktop.DesktopFrame;
import SocLab.GUI.modelEditor.CreateStructfromOrgFile;
import SocLab.GUI.modelEditor.ModelEditor;
import SocLab.GUI.modelEditor.ParamsPanels.ModelParams;
import SocLab.core.SocLabToolkit;
import SocLab.core.SwitchLanguages;
import SocLab.tools.RTFReports;
import SocLab.tools.fileKit.OrgIOToolkit;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class OrgParamTabbedPane
extends JInternalFrame {
    private JButton help;
    private JButton close;
    private JButton model;
    private JButton apply;
    private JButton cancel;
    private JPanel jPanel1;
    public ModelParams controlParams2;
    public ModelParams stakeParams2;
    public ModelParams effectParams2;
    public ModelParams ConstraintParams2;
    public ModelParams solidarityParams2;
    public ModelParams fuzzyStakeParams2;
    public ModelParams fuzzySolidarityParams2;
    private JTabbedPane jtabe = new JTabbedPane();
    private JDesktopPane desktop;

    public OrgParamTabbedPane(JDesktopPane desktop) throws Exception {
        super("Model Editor", true, true, true, true);
        this.desktop = desktop;
        this.controlParams2 = new ModelParams("control");
        this.stakeParams2 = new ModelParams("stake");
        this.effectParams2 = new ModelParams("effect");
        this.ConstraintParams2 = new ModelParams("constraint");
        this.solidarityParams2 = new ModelParams("solidarity");
        this.fuzzyStakeParams2 = new ModelParams("fuzzyStake");
        this.fuzzySolidarityParams2 = new ModelParams("fuzzyAltruism");
        this.controlParams2.initValues();
        this.jtabe.add((Component)this.controlParams2, "<html><font color=green><b>CONTROLS</b></font></html>");
        this.jtabe.add((Component)this.stakeParams2, "<html><font color=green><b>STAKES</b></font></html>");
        this.jtabe.add((Component)this.effectParams2, "<html><font color=green><b>EFFECTS</b></font></html>");
        this.jtabe.add((Component)this.ConstraintParams2, "<html><font color=green><b>CONSTRAINTS</b></font></html>");
        this.jtabe.add((Component)this.solidarityParams2, "<html><font color=green><b>SOLIDARITIES</b></font></html>");
        this.jtabe.add((Component)this.fuzzyStakeParams2, "<html><font color=green><b>FUZZY STAKES</b></font></html>");
        this.jtabe.add((Component)this.fuzzySolidarityParams2, "<html><font color=green><b>FUZZY SOLIDARITIES</b></font></html>");
        this.switchLanguage();
        this.close = new JButton("close", DesktopFrame.cancelIcon);
        this.help = new JButton("help", DesktopFrame.editIcon);
        this.apply = new JButton("apply", DesktopFrame.okIcon);
        this.cancel = new JButton("cancel", DesktopFrame.cancelIcon);
        this.model = new JButton("model", DesktopFrame.switchIcon);
        this.jPanel1 = new JPanel();
        this.add((Component)this.jtabe, "Center");
        this.setVisible(true);
        this.setSize(900, 600);
        this.init();
        this.add((Component)this.jPanel1, "South");
        this.setClosable(false);
        this.jtabe.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (OrgParamTabbedPane.this.jtabe.getSelectedIndex() == 1) {
                    OrgParamTabbedPane.this.stakeParams2.initValues();
                }
                if (OrgParamTabbedPane.this.jtabe.getSelectedIndex() == 2) {
                    OrgParamTabbedPane.this.effectParams2.initValues();
                }
                if (OrgParamTabbedPane.this.jtabe.getSelectedIndex() == 3) {
                    OrgParamTabbedPane.this.ConstraintParams2.initValues();
                }
                if (OrgParamTabbedPane.this.jtabe.getSelectedIndex() == 4) {
                    OrgParamTabbedPane.this.solidarityParams2.initValues();
                }
                if (OrgParamTabbedPane.this.jtabe.getSelectedIndex() == 5) {
                    OrgParamTabbedPane.this.fuzzyStakeParams2.initValues();
                }
                if (OrgParamTabbedPane.this.jtabe.getSelectedIndex() == 6) {
                    OrgParamTabbedPane.this.fuzzySolidarityParams2.initValues();
                }
                if (OrgParamTabbedPane.this.jtabe.getSelectedIndex() == 7) {
                    OrgParamTabbedPane.this.stakeParams2.initValues();
                }
            }
        });
    }

    public void init() {
        GroupLayout jPanel11Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel11Layout);
        jPanel11Layout.setHorizontalGroup(jPanel11Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel11Layout.createSequentialGroup().addGap(100, 100, 100).addGroup(jPanel11Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel11Layout.createSequentialGroup().addComponent(this.apply, -2, 131, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancel, -2, 131, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.close, -1, 131, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.model, -2, 131, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.help, -2, 131, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel11Layout.setVerticalGroup(jPanel11Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel11Layout.createSequentialGroup().addContainerGap().addGroup(jPanel11Layout.createParallelGroup(GroupLayout.Alignment.BASELINE)).addGap(20, 20, 20).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel11Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel11Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.help, -2, 31, -2).addComponent(this.close, -2, 30, -2)).addGroup(GroupLayout.Alignment.TRAILING, jPanel11Layout.createSequentialGroup().addGroup(jPanel11Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, jPanel11Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.model, -1, 31, Short.MAX_VALUE).addComponent(this.cancel, -1, 31, Short.MAX_VALUE)).addComponent(this.apply, GroupLayout.Alignment.LEADING, -1, 31, Short.MAX_VALUE)).addGap(39, 39, 39))).addContainerGap()));
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    OrgParamTabbedPane.this.cancelOrg();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.model.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    OrgParamTabbedPane.this.openModel();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    OrgParamTabbedPane.this.closeOrg();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.help.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrgParamTabbedPane.this.help();
            }
        });
        this.apply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    OrgParamTabbedPane.this.apply();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.add((Component)this.jPanel1, "South");
        this.setDefaultCloseOperation(1);
        this.jtabe.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (OrgParamTabbedPane.this.jtabe.getSelectedIndex() == 1) {
                    OrgParamTabbedPane.this.stakeParams2.initValues();
                }
                if (OrgParamTabbedPane.this.jtabe.getSelectedIndex() == 2) {
                    OrgParamTabbedPane.this.effectParams2.initValues();
                }
                if (OrgParamTabbedPane.this.jtabe.getSelectedIndex() == 3) {
                    OrgParamTabbedPane.this.ConstraintParams2.initValues();
                }
                if (OrgParamTabbedPane.this.jtabe.getSelectedIndex() == 4) {
                    OrgParamTabbedPane.this.solidarityParams2.initValues();
                }
                if (OrgParamTabbedPane.this.jtabe.getSelectedIndex() == 5) {
                    OrgParamTabbedPane.this.fuzzyStakeParams2.initValues();
                }
                if (OrgParamTabbedPane.this.jtabe.getSelectedIndex() == 6) {
                    OrgParamTabbedPane.this.fuzzySolidarityParams2.initValues();
                }
                if (OrgParamTabbedPane.this.jtabe.getSelectedIndex() == 7) {
                    OrgParamTabbedPane.this.stakeParams2.initValues();
                }
            }
        });
    }

    public void switchLanguage() {
        this.jtabe.setTitleAt(0, SwitchLanguages.OrgParamTabbedPaneControls[SocLabToolkit.idLanguage]);
        this.jtabe.setTitleAt(1, SwitchLanguages.OrgParamTabbedPaneStakes[SocLabToolkit.idLanguage]);
        this.jtabe.setTitleAt(2, SwitchLanguages.OrgParamTabbedPaneEffects[SocLabToolkit.idLanguage]);
        this.jtabe.setTitleAt(3, SwitchLanguages.OrgParamTabbedPaneConstraints[SocLabToolkit.idLanguage]);
        this.jtabe.setTitleAt(4, SwitchLanguages.OrgParamTabbedPaneSolidarities[SocLabToolkit.idLanguage]);
        this.jtabe.setTitleAt(5, SwitchLanguages.OrgParamTabbedPaneFuzzyStakes[SocLabToolkit.idLanguage]);
        this.jtabe.setTitleAt(6, SwitchLanguages.OrgParamTabbedPaneFuzzySolidarities[SocLabToolkit.idLanguage]);
        this.controlParams2.switchLanguage();
        this.stakeParams2.switchLanguage();
        this.effectParams2.switchLanguage();
        this.ConstraintParams2.switchLanguage();
        this.solidarityParams2.switchLanguage();
        this.fuzzyStakeParams2.switchLanguage();
        this.fuzzySolidarityParams2.switchLanguage();
    }

    public void apply() throws Exception {
        if (this.canEdit() && ModelParams.orgTemp != null) {
            ModelParams.xmlTemp = OrgIOToolkit.saveObjectNew(ModelParams.orgTemp);
            SocLabToolkit.currentOrgNew = CreateStructfromOrgFile.loadOrgNewStruct(ModelParams.xmlTemp);
        }
    }

    private void cancelOrg() throws Exception {
        if (this.canEdit()) {
            DesktopFrame.orgparm = new OrgParamTabbedPane(DesktopFrame.desktopPanel);
            DesktopFrame.desktopPanel.add(DesktopFrame.orgparm);
            OrgParamTabbedPane gui = DesktopFrame.orgparm;
            gui.setVisible(true);
            this.dispose();
        }
    }

    private void closeOrg() throws Exception {
        this.setVisible(false);
    }

    private void help() {
        DesktopFrame.menuBar.newHelpEdit();
    }

    private void saveReport() {
        String choosedFile = "";
        DesktopFrame.fileChooser.init("choose the folder where you want to save the report", "Select", true);
        int returnVal = DesktopFrame.fileChooser.showOpenDialog(this.desktop);
        if (returnVal == 0) {
            choosedFile = DesktopFrame.fileChooser.getSelectedFile().getPath();
            File f1 = new File(choosedFile);
            if (!f1.exists()) {
                f1.mkdirs();
            }
            choosedFile = f1.getPath();
            ModelParams.orgTemp.setCurrentModelEditorPath(choosedFile);
            RTFReports.makeModelReport(ModelParams.orgTemp);
        }
    }

    public void openModel() throws Exception {
        if (DesktopFrame.modelEditor == null) {
            DesktopFrame.modelEditor = new ModelEditor(DesktopFrame.desktopPanel);
            DesktopFrame.desktopPanel.add(DesktopFrame.modelEditor);
        }
        if (!DesktopFrame.modelEditor.isVisible()) {
            DesktopFrame.desktopPanel.remove(DesktopFrame.modelEditor);
            DesktopFrame.modelEditor = new ModelEditor(DesktopFrame.desktopPanel);
            DesktopFrame.desktopPanel.add(DesktopFrame.modelEditor);
            ModelEditor gui = DesktopFrame.modelEditor;
            gui.setVisible(true);
            gui.moveToFront();
            DesktopFrame.statusBar.setText("Editing Model ...");
        }
        this.dispose();
    }

    private boolean canEdit() {
        if (DesktopFrame.structuralAnalysisView != null && DesktopFrame.structuralAnalysisView.isVisible()) {
            return false;
        }
        if (DesktopFrame.stateInterpreter != null && DesktopFrame.stateInterpreter.isVisible()) {
            return false;
        }
        if (DesktopFrame.stateAnalysisSynthesisView != null && DesktopFrame.stateAnalysisSynthesisView.isVisible()) {
            return false;
        }
        if (DesktopFrame.graphView != null && DesktopFrame.graphView.isVisible()) {
            return false;
        }
        if (DesktopFrame.simuLauncher != null && DesktopFrame.simuLauncher.isVisible()) {
            return false;
        }
        if (DesktopFrame.guiSimulationSynthesis != null && DesktopFrame.guiSimulationSynthesis.isVisible()) {
            return false;
        }
        if (DesktopFrame.simuResult != null && DesktopFrame.simuResult.isVisible()) {
            return false;
        }
        if (DesktopFrame.sensiLauncher != null && DesktopFrame.sensiLauncher.isVisible()) {
            return false;
        }
        if (DesktopFrame.guiSensitivitySynthesis != null && DesktopFrame.guiSensitivitySynthesis.isVisible()) {
            return false;
        }
        return DesktopFrame.evolLauncher == null || !DesktopFrame.evolLauncher.isVisible();
    }

    public void closeEdition() {
        try {
            this.apply();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.controlParams2.editButton.isSelected()) {
            this.controlParams2.editButton.doClick();
        }
        if (this.stakeParams2.editButton.isSelected()) {
            this.stakeParams2.editButton.doClick();
        }
        if (this.solidarityParams2.editButton.isSelected()) {
            this.solidarityParams2.editButton.doClick();
        }
        if (this.fuzzyStakeParams2.editButton.isSelected()) {
            this.fuzzyStakeParams2.editButton.doClick();
        }
        if (this.fuzzySolidarityParams2.editButton.isSelected()) {
            this.fuzzySolidarityParams2.editButton.doClick();
        }
        if (this.controlParams2.editDescButton.isSelected()) {
            this.controlParams2.editDescButton.doClick();
        }
        if (this.stakeParams2.editDescButton.isSelected()) {
            this.stakeParams2.editDescButton.doClick();
        }
        if (this.solidarityParams2.editDescButton.isSelected()) {
            this.solidarityParams2.editDescButton.doClick();
        }
        if (this.fuzzyStakeParams2.editDescButton.isSelected()) {
            this.fuzzyStakeParams2.editDescButton.doClick();
        }
        if (this.fuzzySolidarityParams2.editDescButton.isSelected()) {
            this.fuzzySolidarityParams2.editDescButton.doClick();
        }
        if (this.effectParams2.editDescButton.isSelected()) {
            this.effectParams2.editDescButton.doClick();
        }
        if (this.ConstraintParams2.editDescButton.isSelected()) {
            this.ConstraintParams2.editDescButton.doClick();
        }
    }
}

