/*
 * Decompiled with CFR 0.152.
 */
package SocLab.GUI.modelEditor.ParamsPanels.renderers;

import SocLab.core.structures.RelationRelation;
import SocLab.tools.functions.AbstractFunction;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class MiniConstraintFunctionRender
extends JPanel
implements TableCellRenderer {
    private RelationRelation relationRelation;
    private boolean selected;

    public MiniConstraintFunctionRender(RelationRelation relationRelation) {
        this.relationRelation = relationRelation;
    }

    private void drawDatas(Graphics g, AbstractFunction f, Color c) {
        g.setColor(c);
        double i = this.relationRelation.getBminFunction().getLowerBound();
        while (i < this.relationRelation.getBminFunction().getUpperBound()) {
            this.drawALine(g, f, i);
            i += 0.5;
        }
    }

    private void drawALine(Graphics g, AbstractFunction f, double i) {
        double i2 = i + 0.5;
        double j = f.getF(i);
        double j2 = f.getF(i + 0.5);
        int x1 = new Double(Math.round((i + 10.0) * 2.0)).intValue();
        int y1 = new Double((10.0 - j) * 2.0).intValue();
        int x2 = new Double(Math.round((i2 + 10.0) * 2.0)).intValue();
        int y2 = new Double((10.0 - j2) * 2.0).intValue();
        g.drawLine(x1, y1, x2, y2);
    }

    @Override
    public void paint(Graphics g) {
        this.drawBackground(g);
        if (this.relationRelation != null) {
            this.drawDatas(g, this.relationRelation.getBminFunction(), Color.BLACK);
            this.drawDatas(g, this.relationRelation.getBmaxFunction(), Color.RED);
        }
        if (this.selected) {
            g.setColor(Color.blue);
            g.drawRect(0, 0, 40, 40);
        }
    }

    private void drawBackground(Graphics g) {
        g.setColor(Color.white);
        g.fillRect(0, 0, 41, 41);
        g.setColor(Color.lightGray);
        int i = 0;
        while (i < 41) {
            g.fillRect(i, 0, 1, 1);
            g.fillRect(i, 20, 1, 1);
            g.fillRect(i, 40, 1, 1);
            ++i;
        }
        i = 0;
        while (i < 41) {
            int y1 = i++;
            g.fillRect(0, y1, 1, 1);
            g.fillRect(20, y1, 1, 1);
            g.fillRect(40, y1, 1, 1);
        }
    }

    public Image getImage() {
        BufferedImage image = new BufferedImage(41, 41, 1);
        Graphics2D g2d = image.createGraphics();
        this.paint(g2d);
        g2d.dispose();
        return image;
    }

    public void setSelected(boolean b) {
        this.selected = b;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object object, boolean isSelected, boolean hasFocus, int row, int column) {
        this.relationRelation = (RelationRelation)object;
        this.selected = hasFocus;
        return this;
    }
}

