/*
 * Decompiled with CFR 0.152.
 */
package SocLab.GUI.stateInterpreter.graphicModel;

import SocLab.core.ActorNew;
import SocLab.core.SocLabToolkit;
import SocLab.core.SocialGameState;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

class GraphicCapacityActionPanelModel
extends JPanel
implements Observer {
    private DefaultCategoryDataset actionCapDataset;
    public SocialGameState userstate;

    GraphicCapacityActionPanelModel(SocialGameState userstate) {
        this.userstate = userstate;
        this.actionCapDataset = new DefaultCategoryDataset();
        this.setPreferredSize(new Dimension(770, 349));
        this.setVisible(true);
    }

    private double shiftDecimal(double d, int decay) {
        double coef = Math.pow(10.0, decay);
        double result = d * coef;
        return (double)Math.round(result) / coef;
    }

    @Override
    public void update(Observable ob, Object o) {
        this.userstate = (SocialGameState)o;
        this.plotActionCap();
    }

    private void plotActionCap() {
        this.actionCapDataset.clear();
        String[] aNames = SocLabToolkit.currentOrgNew.getActorsNewName();
        int i = 0;
        while (i < aNames.length) {
            ActorNew c = SocLabToolkit.currentOrgNew.getActorNew(aNames[i]);
            int j = 0;
            while (j < aNames.length) {
                ActorNew a = SocLabToolkit.currentOrgNew.getActorNew(aNames[j]);
                this.actionCapDataset.addValue(this.shiftDecimal(a.getTarget(c.getName()).getActualPower(a, c, this.userstate), 1), (Comparable)((Object)("Action Capacity from " + a.getName())), (Comparable)((Object)c.getName()));
                ++j;
            }
            ++i;
        }
        JFreeChart barchart = ChartFactory.createStackedBarChart((String)"", (String)"", (String)"Actions Capacity", (CategoryDataset)this.actionCapDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
        ChartPanel chartPanel = new ChartPanel(barchart, false);
        this.setLayout(new BorderLayout());
        this.add((Component)chartPanel, "Center");
    }
}

