/*
 * Decompiled with CFR 0.152.
 */
package SocLab.core;

import SocLab.core.ActorNew;
import SocLab.core.OrgNew;
import SocLab.core.RelationParamsNew;
import SocLab.core.SocLabToolkit;
import SocLab.core.structures.Control;
import SocLab.core.structures.Depend;
import SocLab.core.structures.Interpretation;
import SocLab.core.structures.RelationRelation;
import java.util.Vector;

public class RelationNew {
    private String name;
    private String description;
    private Vector<Depend> dependActors = new Vector();
    private Control controlActor = new Control(null, this);
    private Vector<RelationRelation> sources = new Vector();
    private Vector<RelationRelation> targets = new Vector();
    private Vector<Interpretation> interpretations = new Vector();
    private RelationParamsNew RPNInitial = new RelationParamsNew(0.0, 1.0, -10.0, 10.0);
    private RelationParamsNew RPNCurrent = new RelationParamsNew(0.0, 1.0, -10.0, 10.0);
    private double maxPotentialStrength;
    private double accumulatedPotentialStrength;
    private double effectiveMaxStrength;
    private double accumulatedEffectiveStrength;
    private double relevance;

    public RelationNew() {
    }

    RelationNew(String name, String description) {
        this();
        this.name = name;
        this.description = description;
    }

    void reset() {
        this.getRPNCurrent().setState(this.getRPNInitial().getState());
        this.getRPNCurrent().setFrequency(this.getRPNInitial().getFrequency());
        this.resetBounds();
    }

    void resetBounds() {
        this.getRPNCurrent().setLowerBound(this.getRPNInitial().getLowerBound());
        this.getRPNCurrent().setUpperBound(this.getRPNInitial().getUpperBound());
    }

    public double getMaxPotentialStrength(RelationNew rN) {
        double max = Double.NEGATIVE_INFINITY;
        OrgNew orgNew = SocLabToolkit.currentOrgNew;
        String[] aNames = orgNew.getActorsNewName();
        int i = 0;
        while (i < aNames.length) {
            ActorNew aN = orgNew.getActorNew(aNames[i]);
            double strength = rN.getDepend(aN.getName()).getPotentialStrength(rN, aN);
            if (strength > max) {
                max = strength;
            }
            ++i;
        }
        this.maxPotentialStrength = max;
        return max;
    }

    public double getAccumulatedPotentialStrength(RelationNew rN) {
        double sum = 0.0;
        OrgNew orgNew = SocLabToolkit.currentOrgNew;
        String[] aNames = orgNew.getActorsNewName();
        int i = 0;
        while (i < aNames.length) {
            ActorNew aN = orgNew.getActorNew(aNames[i]);
            double max = Double.NEGATIVE_INFINITY;
            double t1 = -10.0;
            while (t1 <= 10.0) {
                double t2 = -10.0;
                while (t2 <= 10.0) {
                    double effect2;
                    double effect1 = rN.getDepend(aN.getName()).getEffectNew().getFunction().getF(t1);
                    double strength = effect1 - (effect2 = rN.getDepend(aN.getName()).getEffectNew().getFunction().getF(t2));
                    if (strength > max) {
                        max = strength;
                    }
                    t2 += 1.0;
                }
                t1 += 1.0;
            }
            sum += max;
            ++i;
        }
        this.accumulatedPotentialStrength = sum;
        return sum;
    }

    public double getEffectiveMaxStrength(RelationNew rN) {
        double max = Double.NEGATIVE_INFINITY;
        OrgNew orgNew = SocLabToolkit.currentOrgNew;
        String[] aNames = orgNew.getActorsNewName();
        int i = 0;
        while (i < aNames.length) {
            ActorNew aN = orgNew.getActorNew(aNames[i]);
            double t1 = rN.getRPNCurrent().getLowerBound();
            while (t1 <= rN.getRPNCurrent().getUpperBound()) {
                double t2 = rN.getRPNCurrent().getLowerBound();
                while (t2 <= rN.getRPNCurrent().getUpperBound()) {
                    double effect2;
                    double effect1 = rN.getDepend(aN.getName()).getEffectNew().getFunction().getF(t1);
                    double strength = effect1 - (effect2 = rN.getDepend(aN.getName()).getEffectNew().getFunction().getF(t2));
                    if (strength > max) {
                        max = strength;
                    }
                    t2 += 1.0;
                }
                t1 += 1.0;
            }
            ++i;
        }
        this.effectiveMaxStrength = max;
        return max;
    }

    public double getAccumulatedEffectiveStrength(RelationNew rN) {
        double sum = 0.0;
        OrgNew orgNew = SocLabToolkit.currentOrgNew;
        String[] aNames = orgNew.getActorsNewName();
        int i = 0;
        while (i < aNames.length) {
            ActorNew aN = orgNew.getActorNew(aNames[i]);
            double max = Double.NEGATIVE_INFINITY;
            double t1 = rN.getRPNCurrent().getLowerBound();
            while (t1 <= rN.getRPNCurrent().getUpperBound()) {
                double t2 = rN.getRPNCurrent().getLowerBound();
                while (t2 <= rN.getRPNCurrent().getUpperBound()) {
                    double effect2;
                    double effect1 = rN.getDepend(aN.getName()).getEffectNew().getFunction().getF(t1);
                    double strength = effect1 - (effect2 = rN.getDepend(aN.getName()).getEffectNew().getFunction().getF(t2));
                    if (strength > max) {
                        max = strength;
                    }
                    t2 += 1.0;
                }
                t1 += 1.0;
            }
            sum += max;
            ++i;
        }
        this.accumulatedEffectiveStrength = sum;
        return sum;
    }

    public double getRelevance(RelationNew rN) {
        double rel = 0.0;
        OrgNew orgNew = SocLabToolkit.currentOrgNew;
        String[] aNames = orgNew.getActorsNewName();
        int i = 0;
        while (i < aNames.length) {
            ActorNew aN1 = orgNew.getActorNew(aNames[i]);
            int j = 0;
            while (j < aNames.length) {
                ActorNew aN2 = orgNew.getActorNew(aNames[j]);
                double stake = rN.getDepend(aN1.getName()).getStake();
                double sol = aN1.getTarget(aN2.getName()).getSolidarity();
                rel += stake * sol;
                ++j;
            }
            ++i;
        }
        this.relevance = rel;
        return rel;
    }

    public double getMaxPotentialStrength() {
        return this.maxPotentialStrength;
    }

    public double getAccumulatedPotentialStrength() {
        return this.accumulatedPotentialStrength;
    }

    public double getEffectiveMaxStrength() {
        return this.effectiveMaxStrength;
    }

    public double getAccumulatedEffectiveStrength() {
        return this.accumulatedEffectiveStrength;
    }

    public double getRelevance() {
        return this.relevance;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Depend getDepend(String actorName) {
        int i = 0;
        while (i < this.getNbDependActors()) {
            if (this.getDependActors().elementAt(i).getActorNew().getName().equals(actorName)) {
                return this.getDependActors().elementAt(i);
            }
            ++i;
        }
        return null;
    }

    public void setDepend(Depend dependActor) {
        int position = this.containsDepend(dependActor);
        if (position > -1) {
            this.dependActors.setElementAt(dependActor, position);
        } else {
            this.addDepend(dependActor);
        }
    }

    void addDepend(Depend dependActor) {
        if (this.containsDepend(dependActor) > -1) {
            System.out.println("Error duplicating dependActor");
        } else {
            this.dependActors.add(dependActor);
        }
    }

    void delDepend(Depend dependActor) {
        int position = this.containsDepend(dependActor);
        if (position > -1) {
            this.dependActors.removeElementAt(position);
        } else {
            System.out.println("Error existing dependActor");
        }
    }

    private int containsDepend(Depend dependActor) {
        int i = 0;
        while (i < this.dependActors.size()) {
            String name = this.dependActors.elementAt(i).getActorNew().getName();
            if (name.equals(dependActor.getActorNew().getName())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Vector<Depend> getDependActors() {
        return this.dependActors;
    }

    public void setDependActors(Vector<Depend> dependActors) {
        this.dependActors = dependActors;
    }

    public int getNbDependActors() {
        return this.dependActors.size();
    }

    public Control getControlActor() {
        return this.controlActor;
    }

    public void setControlActor(Control CA) {
        this.controlActor = CA;
    }

    RelationRelation getSource(String RelationSourceName) {
        int i = 0;
        while (i < this.getNbSources()) {
            if (this.getSources().elementAt(i).getRelationSource().getName().equals(RelationSourceName)) {
                return this.getSources().elementAt(i);
            }
            ++i;
        }
        return null;
    }

    public void setSource(RelationRelation source) {
        int position = this.containsSource(source);
        if (position > -1) {
            this.sources.setElementAt(source, position);
        } else {
            this.addSource(source);
        }
    }

    void addSource(RelationRelation source) {
        if (this.containsSource(source) > -1) {
            System.out.println("Error duplicating source");
        } else {
            this.sources.add(source);
        }
    }

    void delSource(RelationRelation source) {
        int position = this.containsSource(source);
        if (position > -1) {
            this.sources.removeElementAt(position);
        } else {
            System.out.println("Error existing source");
        }
    }

    private int containsSource(RelationRelation source) {
        int i = 0;
        while (i < this.sources.size()) {
            String name = this.sources.elementAt(i).getRelationSource().getName();
            if (name.equals(source.getRelationSource().getName())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Vector<RelationRelation> getSources() {
        return this.sources;
    }

    public void setSources(Vector<RelationRelation> sources) {
        this.sources = sources;
    }

    public int getNbSources() {
        return this.sources.size();
    }

    public RelationRelation getTarget(String RelationTargetName) {
        int i = 0;
        while (i < this.getNbTargets()) {
            if (this.getTargets().elementAt(i).getRelationTarget().getName().equals(RelationTargetName)) {
                return this.getTargets().elementAt(i);
            }
            ++i;
        }
        return null;
    }

    public void setTarget(RelationRelation target) {
        int position = this.containsTarget(target);
        if (position > -1) {
            this.targets.setElementAt(target, position);
        } else {
            this.addTarget(target);
        }
    }

    void addTarget(RelationRelation target) {
        if (this.containsTarget(target) > -1) {
            System.out.println("Error duplicating target");
        } else {
            this.targets.add(target);
        }
    }

    void delTarget(RelationRelation target) {
        int position = this.containsTarget(target);
        if (position > -1) {
            this.targets.removeElementAt(position);
        } else {
            System.out.println("Error existing target");
        }
    }

    private int containsTarget(RelationRelation target) {
        int i = 0;
        while (i < this.targets.size()) {
            String name = this.targets.elementAt(i).getRelationTarget().getName();
            if (name.equals(target.getRelationTarget().getName())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Vector<RelationRelation> getTargets() {
        return this.targets;
    }

    public void setTargets(Vector<RelationRelation> targets) {
        this.targets = targets;
    }

    public int getNbTargets() {
        return this.targets.size();
    }

    public void setInterpretation(Interpretation interpretation) {
        int position = this.containsInterpretation(interpretation);
        if (position > -1) {
            this.interpretations.setElementAt(interpretation, position);
        } else {
            this.addInterpretation(interpretation);
        }
    }

    public void addInterpretation(Interpretation interpretation) {
        if (this.containsInterpretation(interpretation) > -1) {
            System.out.println("Error duplicating interpretation");
        } else {
            this.interpretations.add(interpretation);
        }
    }

    private int containsInterpretation(Interpretation interpretation) {
        int i = 0;
        while (i < this.interpretations.size()) {
            double min = this.interpretations.elementAt(i).getStateBegin();
            double max = this.interpretations.elementAt(i).getStateEnd();
            boolean mBegin = this.interpretations.elementAt(i).getIncludeBegin();
            boolean mEnd = this.interpretations.elementAt(i).getIncludeEnd();
            if (Double.compare(min, interpretation.getStateBegin()) == 0 && Double.compare(max, interpretation.getStateEnd()) == 0 && mBegin == interpretation.getIncludeBegin() && mEnd == interpretation.getIncludeEnd()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void clearInterpretation() {
        this.interpretations.clear();
    }

    public Vector<Interpretation> getInterpretations() {
        return this.interpretations;
    }

    public void setInterpretations(Vector<Interpretation> interpretations) {
        this.interpretations = interpretations;
    }

    public int getNbInterpretations() {
        return this.interpretations.size();
    }

    public RelationParamsNew getRPNInitial() {
        return this.RPNInitial;
    }

    public void setRPNInitial(RelationParamsNew RPN) {
        this.RPNInitial = RPN;
    }

    public RelationParamsNew getRPNCurrent() {
        return this.RPNCurrent;
    }

    public void setRPNCurrent(RelationParamsNew RPN) {
        this.RPNCurrent = RPN;
    }
}

