/*
 * Decompiled with CFR 0.152.
 */
package SocLab.core.structures;

import SocLab.core.ActorNew;
import SocLab.core.OrgNew;
import SocLab.core.RelationNew;
import SocLab.core.SocLabToolkit;
import SocLab.core.SocialGameMultiState;
import SocLab.core.SocialGameState;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Vector;

public class ActorActor
implements Serializable {
    private double solidarity = 0.0;
    public double tempSolidarity;
    private String solidarityDesc = "";
    private double fuzzySolidarityMin = 0.0;
    private double fuzzySolidarityMax = 0.0;
    private double sensibilityAnalysisSolidarityMin = 0.0;
    private double sensibilityAnalysisSolidarityMax = 0.0;
    private String fuzzySolidarityDesc = "";
    private ActorNew actorSource = null;
    private ActorNew actorTarget = null;
    private double structInfluence;
    private double structPowerBrut;
    private double relationStructuralInfluence;
    private double relationStructuralPowerBrut;
    private double maxActualInfluence;
    private double minActualInfluence;
    private double maxActualPowerBrut;
    private double minActualPowerBrut;

    public ActorActor() {
    }

    public ActorActor(ActorNew as, ActorNew at) {
        this();
        this.actorSource = as;
        this.actorTarget = at;
    }

    public ActorActor(double s, double fmn, double fmx, ActorNew as, ActorNew at) {
        this(as, at);
        this.solidarity = s;
        this.fuzzySolidarityMin = fmn;
        this.fuzzySolidarityMax = fmx;
    }

    public double getStructInfluence(ActorNew aN1, ActorNew aN2) {
        double struct_Influence = 0.0;
        OrgNew orgNew = SocLabToolkit.currentOrgNew;
        String[] rNames = orgNew.getRelationsNewName();
        int i = 0;
        while (i < rNames.length) {
            RelationNew rN = orgNew.getRelationNew(rNames[i]);
            if (rN.getControlActor().getActorNew() != null && rN.getControlActor().getActorNew().getName().equals(aN1.getName())) {
                struct_Influence += rN.getDepend(aN2.getName()).getStrength(aN2, rN);
            }
            ++i;
        }
        this.structInfluence = struct_Influence;
        return this.structInfluence;
    }

    public double getStructPowerBrut(ActorNew aN1, ActorNew aN2) {
        double struct_powBrut = 0.0;
        OrgNew orgNew = SocLabToolkit.currentOrgNew;
        String[] rNames = orgNew.getRelationsNewName();
        int i = 0;
        while (i < rNames.length) {
            RelationNew rN = orgNew.getRelationNew(rNames[i]);
            if (rN.getControlActor().getActorNew() != null && rN.getControlActor().getActorNew().getName().equals(aN1.getName())) {
                struct_powBrut += rN.getDepend(aN2.getName()).getIndividualStrength(rN, aN2);
            }
            ++i;
        }
        if (aN1.getName().equals(this.actorSource.getName()) && aN2.getName().equals(this.actorTarget.getName())) {
            this.structPowerBrut = struct_powBrut;
        }
        return this.structPowerBrut;
    }

    public double getMinStructPowerBrut(ActorNew aN1, ActorNew aN2) {
        double structPowerBrut = 0.0;
        OrgNew orgNew = SocLabToolkit.currentOrgNew;
        String[] rNames = orgNew.getRelationsNewName();
        int i = 0;
        while (i < rNames.length) {
            RelationNew rN = orgNew.getRelationNew(rNames[i]);
            if (rN.getControlActor().getActorNew() != null && rN.getControlActor().getActorNew().getName().equals(aN1.getName())) {
                structPowerBrut += rN.getDepend(aN2.getName()).getEffectNew().getFunction().getMin() * rN.getDepend(aN2.getName()).getStake();
            }
            ++i;
        }
        return structPowerBrut;
    }

    public double getMaxStructPowerBrut(ActorNew aN1, ActorNew aN2) {
        double structPowerBrut = 0.0;
        OrgNew orgNew = SocLabToolkit.currentOrgNew;
        String[] rNames = orgNew.getRelationsNewName();
        int i = 0;
        while (i < rNames.length) {
            RelationNew rN = orgNew.getRelationNew(rNames[i]);
            if (rN.getControlActor().getActorNew() != null && rN.getControlActor().getActorNew().getName().equals(aN1.getName())) {
                structPowerBrut += rN.getDepend(aN2.getName()).getEffectNew().getFunction().getMax() * rN.getDepend(aN2.getName()).getStake();
            }
            ++i;
        }
        return structPowerBrut;
    }

    public double getActualInfluence(ActorNew aN1, ActorNew aN2, SocialGameState s) {
        double influence = 0.0;
        OrgNew orgNew = SocLabToolkit.currentOrgNew;
        String[] rNames = orgNew.getRelationsNewName();
        int i = 0;
        while (i < rNames.length) {
            RelationNew rN = orgNew.getRelationNew(rNames[i]);
            if (rN.getControlActor().getActorNew() != null && rN.getControlActor().getActorNew().getName().equals(aN1.getName())) {
                influence += rN.getDepend(aN2.getName()).getImpact(rN, aN2, s.getRelationState(rN));
            }
            ++i;
        }
        return influence;
    }

    public void computeMaxMinActualInfluence(ActorNew aN1, ActorNew aN2) {
        double max_influence = Double.NEGATIVE_INFINITY;
        double min_influence = Double.POSITIVE_INFINITY;
        OrgNew orgNew = SocLabToolkit.currentOrgNew;
        SocialGameMultiState etat_sol_max = new SocialGameMultiState(orgNew);
        SocialGameMultiState etat_sol_min = new SocialGameMultiState(orgNew);
        Vector<SocialGameState> v = this.getAllControlledStates(aN1);
        if (v == null) {
            v = new Vector(1);
            SocialGameState s = new SocialGameState(aN1, orgNew);
            s = new SocialGameState(aN1, orgNew);
            String[] rNames = SocLabToolkit.currentOrgNew.getRelationsNewName();
            int i = 0;
            while (i < rNames.length) {
                RelationNew rN = SocLabToolkit.currentOrgNew.getRelationNew(rNames[i]);
                s.setRelationState(rN, (rN.getRPNInitial().getUpperBound() + rN.getRPNInitial().getLowerBound()) / 2.0);
                ++i;
            }
            v.add(s);
        }
        int j = 0;
        j = 0;
        while (j < v.size()) {
            SocialGameState s = v.get(j);
            double influence = this.getActualInfluence(aN1, aN2, s);
            if (influence >= max_influence) {
                max_influence = influence;
                etat_sol_max.clear_values();
                for (RelationNew rN : s.keySet()) {
                    etat_sol_max.addRelationState(rN, s.getRelationState(rN));
                }
            }
            if (influence <= min_influence) {
                min_influence = influence;
                etat_sol_min.clear_values();
                for (RelationNew rN : s.keySet()) {
                    etat_sol_min.addRelationState(rN, s.getRelationState(rN));
                }
            }
            ++j;
        }
        for (RelationNew rN : etat_sol_max.keySet()) {
            if (((HashSet)etat_sol_max.get(rN)).size() != 0) continue;
            etat_sol_max.addRelationState(rN, Double.NaN);
        }
        for (RelationNew rN : etat_sol_min.keySet()) {
            if (((HashSet)etat_sol_min.get(rN)).size() != 0) continue;
            etat_sol_min.addRelationState(rN, Double.NaN);
        }
        this.maxActualInfluence = max_influence;
        this.minActualInfluence = min_influence;
    }

    public double getActualPower(ActorNew aN1, ActorNew aN2, SocialGameState s) {
        double pow = 0.0;
        OrgNew orgNew = SocLabToolkit.currentOrgNew;
        String[] rNames = orgNew.getRelationsNewName();
        int i = 0;
        while (i < rNames.length) {
            RelationNew rN = orgNew.getRelationNew(rNames[i]);
            if (rN.getControlActor().getActorNew() != null && rN.getControlActor().getActorNew().getName().equals(aN1.getName())) {
                pow += rN.getDepend(aN2.getName()).getImpactIndiv(rN, aN2, s.getRelationState(rN));
            }
            ++i;
        }
        return pow;
    }

    public void computeMaxMinActualPower(ActorNew aN1, ActorNew aN2) {
        double max_powerBrut = Double.NEGATIVE_INFINITY;
        double min_powerBrut = Double.POSITIVE_INFINITY;
        OrgNew orgNew = SocLabToolkit.currentOrgNew;
        SocialGameMultiState etat_sol_max = new SocialGameMultiState(orgNew);
        SocialGameMultiState etat_sol_min = new SocialGameMultiState(orgNew);
        Vector<SocialGameState> v = this.getAllControlledStates(aN1);
        if (v == null) {
            v = new Vector(1);
            SocialGameState s = new SocialGameState(aN1, orgNew);
            s = new SocialGameState(aN1, orgNew);
            String[] rNames = SocLabToolkit.currentOrgNew.getRelationsNewName();
            int i = 0;
            while (i < rNames.length) {
                RelationNew rN = SocLabToolkit.currentOrgNew.getRelationNew(rNames[i]);
                s.setRelationState(rN, (rN.getRPNInitial().getUpperBound() + rN.getRPNInitial().getLowerBound()) / 2.0);
                ++i;
            }
            v.add(s);
        }
        int j = 0;
        j = 0;
        while (j < v.size()) {
            SocialGameState s = v.get(j);
            double powerBrut = this.getActualPower(aN1, aN2, s);
            if (powerBrut >= max_powerBrut) {
                max_powerBrut = powerBrut;
                etat_sol_max.clear_values();
                for (RelationNew rN : s.keySet()) {
                    etat_sol_max.addRelationState(rN, s.getRelationState(rN));
                }
            }
            if (powerBrut <= min_powerBrut) {
                min_powerBrut = powerBrut;
                etat_sol_min.clear_values();
                for (RelationNew rN : s.keySet()) {
                    etat_sol_min.addRelationState(rN, s.getRelationState(rN));
                }
            }
            ++j;
        }
        for (RelationNew rN : etat_sol_max.keySet()) {
            if (((HashSet)etat_sol_max.get(rN)).size() != 0) continue;
            etat_sol_max.addRelationState(rN, Double.NaN);
        }
        for (RelationNew rN : etat_sol_min.keySet()) {
            if (((HashSet)etat_sol_min.get(rN)).size() != 0) continue;
            etat_sol_min.addRelationState(rN, Double.NaN);
        }
        this.maxActualPowerBrut = max_powerBrut;
        this.minActualPowerBrut = min_powerBrut;
    }

    public double getRelativeStructuralPowerBrut(ActorNew aN1, ActorNew aN2) {
        double power;
        this.relationStructuralPowerBrut = power = this.getStructPowerBrut(aN1, aN2) - this.getStructPowerBrut(aN2, aN1);
        return power;
    }

    /*
     * Unable to fully structure code
     */
    private Vector<SocialGameState> getAllControlledStates(ActorNew aN) {
        v = new Vector<SocialGameState>();
        orgNew = SocLabToolkit.currentOrgNew;
        s = new SocialGameState(aN, orgNew);
        relationKeySet = s.keySet();
        count = 0;
        rNames = new String[relationKeySet.size()];
        for (RelationNew rN : relationKeySet) {
            rNames[count++] = rN.getName();
        }
        count = 0;
        val = new double[rNames.length];
        end = false;
        i = 0;
        while (i < val.length) {
            val[i] = orgNew.getRelationNew(rNames[i]).getRPNCurrent().getLowerBound();
            ++i;
        }
        if (val.length != 0) ** GOTO lbl42
        return null;
lbl-1000:
        // 1 sources

        {
            i = val.length - 1;
            while (i >= 0) {
                if (val[i] > orgNew.getRelationNew(rNames[i]).getRPNInitial().getUpperBound()) {
                    if (i == 0) {
                        end = true;
                    } else {
                        val[i] = orgNew.getRelationNew(rNames[i]).getRPNCurrent().getLowerBound();
                        v0 = i - 1;
                        val[v0] = val[v0] + 1.0;
                    }
                }
                --i;
            }
            if (!end) {
                s = new SocialGameState(aN, orgNew);
                i = 0;
                while (i < val.length) {
                    s.setRelationState(orgNew.getRelationNew(rNames[i]), val[i]);
                    ++i;
                }
                v.add(s);
            }
            v1 = val.length - 1;
            val[v1] = val[v1] + 1.0;
lbl42:
            // 2 sources

            ** while (!end)
        }
lbl43:
        // 1 sources

        return v;
    }

    public double getStructInfluence() {
        return this.structInfluence;
    }

    public double getStructPowerBrut() {
        return this.structPowerBrut;
    }

    public double getRelationStructuralInfluence() {
        return this.relationStructuralInfluence;
    }

    public double getRelationStructuralPowerBrut() {
        return this.relationStructuralPowerBrut;
    }

    public double getMaxActualInfluence() {
        return this.maxActualInfluence;
    }

    public double getMinActualInfluence() {
        return this.minActualInfluence;
    }

    public double getMaxActualPowerBrut() {
        return this.maxActualPowerBrut;
    }

    public double getMinActualPower() {
        return this.minActualPowerBrut;
    }

    public double getSolidarity() {
        return this.solidarity;
    }

    public void setSolidarity(double solidarity) {
        this.solidarity = solidarity;
    }

    public double getFuzzySolidarityMin() {
        return this.fuzzySolidarityMin;
    }

    public void setFuzzySolidarityMin(double fuzzySolidarityMin) {
        this.fuzzySolidarityMin = fuzzySolidarityMin;
    }

    public double getSensibilityAnalysisSolidarityMin() {
        return this.sensibilityAnalysisSolidarityMin;
    }

    public void setSensibilityAnalysisSolidarityMin(double sensibilityAnalysisSolidarityMin) {
        this.sensibilityAnalysisSolidarityMin = sensibilityAnalysisSolidarityMin;
    }

    public double getFuzzySolidarityMax() {
        return this.fuzzySolidarityMax;
    }

    public void setFuzzySolidarityMax(double fuzzysolidarityMax) {
        this.fuzzySolidarityMax = fuzzysolidarityMax;
    }

    public double getSensibilityAnalysisSolidarityMax() {
        return this.sensibilityAnalysisSolidarityMax;
    }

    public void setSensibilityAnalysisSolidarityMax(double sensibilityAnalysissolidarityMax) {
        this.sensibilityAnalysisSolidarityMax = sensibilityAnalysissolidarityMax;
    }

    public String getSolidarityDesc() {
        return this.solidarityDesc;
    }

    public void setSolidarityDesc(String desc) {
        this.solidarityDesc = desc;
    }

    public String getFuzzySolidarityDesc() {
        return this.fuzzySolidarityDesc;
    }

    public void setFuzzySolidarityDesc(String desc) {
        this.fuzzySolidarityDesc = desc;
    }

    public ActorNew getActorSource() {
        return this.actorSource;
    }

    public void setActorSource(ActorNew AN) {
        this.actorSource = AN;
    }

    public ActorNew getActorTarget() {
        return this.actorTarget;
    }

    public void setActorTarget(ActorNew AN) {
        this.actorTarget = AN;
    }
}

