/*
 * Decompiled with CFR 0.152.
 */
package SocLab.tools.functions;

import java.io.Serializable;
import java.util.HashMap;

public abstract class AbstractFunction
implements Serializable {
    protected String type = "";
    protected String[] paramNames;
    private HashMap paramValues = new HashMap();
    private String formula;
    private double[] discretizedFunction;
    private double lowerBound;
    private double upperBound;
    private double step;
    private double max = Double.NEGATIVE_INFINITY;
    private double maxTE = Double.NaN;
    private double min = Double.POSITIVE_INFINITY;
    private double minTE = Double.NaN;
    protected String name;
    private String description;
    private static final int nbstep = 200;

    public AbstractFunction() {
    }

    AbstractFunction(String name) {
        this(name, -10.0, 10.0, 200);
    }

    public static void copyFunction(AbstractFunction src, AbstractFunction dest) {
        dest.type = src.type;
        dest.paramNames = new String[src.paramNames.length];
        System.arraycopy(src.paramNames, 0, dest.paramNames, 0, src.paramNames.length);
        dest.paramValues = (HashMap)src.paramValues.clone();
        dest.formula = src.formula;
        dest.discretizedFunction = new double[src.discretizedFunction.length];
        System.arraycopy(src.discretizedFunction, 0, dest.discretizedFunction, 0, src.discretizedFunction.length);
        dest.lowerBound = src.lowerBound;
        dest.upperBound = src.upperBound;
        dest.step = src.step;
        dest.max = src.max;
        dest.min = src.min;
        dest.maxTE = src.maxTE;
        dest.minTE = src.minTE;
        dest.name = src.name;
        dest.description = src.description;
    }

    private AbstractFunction(String name, double lowerBound, double upperBound, int nbstep) {
        this.name = name;
        this.upperBound = upperBound;
        this.lowerBound = lowerBound;
        this.step = 0.1;
        this.discretizedFunction = new double[201];
    }

    public void recompute() {
        this.step = 0.1;
        int i = 0;
        while (i < this.discretizedFunction.length) {
            this.discretizedFunction[i] = this.effectFunction(-10.0 + (double)i * this.step);
            if (this.discretizedFunction[i] < -10.0) {
                this.discretizedFunction[i] = -10.0;
            }
            if (this.discretizedFunction[i] > 10.0) {
                this.discretizedFunction[i] = 10.0;
            }
            ++i;
        }
        this.computeMinMax();
    }

    public abstract void initParam();

    public abstract double effectFunction(double var1);

    public double getF(double x) {
        if (x >= this.lowerBound && x <= this.upperBound) {
            return this.discretizedFunction[new Double(Math.round((x - this.lowerBound) / this.step)).intValue()];
        }
        return Double.NaN;
    }

    private void computeMinMax() {
        int minTEIndex = 0;
        int maxTEIndex = 0;
        this.max = Double.NEGATIVE_INFINITY;
        this.min = Double.POSITIVE_INFINITY;
        int i = 0;
        while (i < this.discretizedFunction.length) {
            if (this.discretizedFunction[i] < this.min) {
                this.min = this.discretizedFunction[i];
                minTEIndex = i;
            }
            if (this.discretizedFunction[i] > this.max) {
                this.max = this.discretizedFunction[i];
                maxTEIndex = i;
            }
            ++i;
        }
        this.minTE = this.lowerBound + (double)minTEIndex * this.step;
        this.maxTE = this.lowerBound + (double)maxTEIndex * this.step;
    }

    public int getNbValues() {
        return this.discretizedFunction.length;
    }

    public double getUpperBound() {
        return this.upperBound;
    }

    public void setUpperBound(double upperBound) {
        this.upperBound = upperBound;
    }

    public double getLowerBound() {
        return this.lowerBound;
    }

    public void setLowerBound(double lowerBound) {
        this.lowerBound = lowerBound;
    }

    public double getStep() {
        return this.step;
    }

    public void setStep(double step) {
        this.step = step;
    }

    public double getMax() {
        return this.max;
    }

    public void setMax(double max) {
        this.max = max;
    }

    public double getMaxTE() {
        return this.maxTE;
    }

    public void setMaxTE(double maxTE) {
        this.maxTE = maxTE;
    }

    public double getMin() {
        return this.min;
    }

    public void setMin(double min) {
        this.min = min;
    }

    public double getMinTE() {
        return this.minTE;
    }

    public void setMinTE(double minTE) {
        this.minTE = minTE;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public double[] getEffectMatrix() {
        return this.discretizedFunction;
    }

    public void setEffectMatrix(double[] effectMatrix) {
        this.discretizedFunction = effectMatrix;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String[] getParamNames() {
        return this.paramNames;
    }

    public HashMap getParamValues() {
        return this.paramValues;
    }

    public void setParams(HashMap paramValues) {
        this.paramValues = paramValues;
    }

    public void setParam(String paramName, double val) {
        this.paramValues.put(paramName, val);
    }

    public double getParam(String paramName) {
        return (Double)this.paramValues.get(paramName);
    }
}

