/*
 * Decompiled with CFR 0.152.
 */
package SocLab.tools.interval.gui;

import SocLab.tools.interval.Interval;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JSeparator;

public class IntervalEditor
extends JDialog {
    private String[] list = new String[]{"-10", "-9", "-8", "-7", "-6", "-5", "-4", "-3", "-2", "-1", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
    private JButton fromButton;
    private JButton toButton;
    private JButton okButton = new JButton("ok");
    private JButton cancelButton = new JButton("cancel");
    private JComboBox from = new JComboBox<String>(this.list);
    private JComboBox to = new JComboBox<String>(this.list);
    private Interval interval;
    private boolean ok = false;

    public IntervalEditor(Frame owner, Interval interval) {
        super(owner, "Define an interval : " + interval, true);
        this.interval = interval;
        this.init();
    }

    private void init() {
        String fromParenthesis = "[";
        String toParenthesis = "]";
        if (!this.interval.isIncludeFrom()) {
            fromParenthesis = "]";
        }
        if (!this.interval.isIncludeTo()) {
            toParenthesis = "[";
        }
        this.from.setSelectedItem("" + this.interval.getFrom());
        this.to.setSelectedItem("" + this.interval.getTo());
        this.fromButton = new JButton(fromParenthesis);
        this.toButton = new JButton(toParenthesis);
        this.fromButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (IntervalEditor.this.fromButton.getText().equals("[")) {
                    IntervalEditor.this.fromButton.setText("]");
                } else {
                    IntervalEditor.this.fromButton.setText("[");
                }
                IntervalEditor.this.setTitle("Define an interval : " + IntervalEditor.this.getResultInterval());
            }
        });
        this.toButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (IntervalEditor.this.toButton.getText().equals("[")) {
                    IntervalEditor.this.toButton.setText("]");
                } else {
                    IntervalEditor.this.toButton.setText("[");
                }
                IntervalEditor.this.setTitle("Define an interval : " + IntervalEditor.this.getResultInterval());
            }
        });
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (IntervalEditor.this.toButton.getText().equals("]")) {
                    IntervalEditor.this.interval.setIncludeTo(true);
                } else {
                    IntervalEditor.this.interval.setIncludeTo(false);
                }
                if (IntervalEditor.this.fromButton.getText().equals("[")) {
                    IntervalEditor.this.interval.setIncludeFrom(true);
                } else {
                    IntervalEditor.this.interval.setIncludeFrom(false);
                }
                IntervalEditor.this.interval.setFrom(new Double((String)IntervalEditor.this.from.getSelectedItem()));
                IntervalEditor.this.interval.setTo(new Double((String)IntervalEditor.this.to.getSelectedItem()));
                IntervalEditor.this.ok = true;
                IntervalEditor.this.dispose();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IntervalEditor.this.dispose();
            }
        });
        this.from.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IntervalEditor.this.setTitle("Define an interval : " + IntervalEditor.this.getResultInterval());
            }
        });
        this.to.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IntervalEditor.this.setTitle("Define an interval : " + IntervalEditor.this.getResultInterval());
            }
        });
        this.from.setEditable(true);
        this.to.setEditable(true);
        this.setLayout(new FlowLayout());
        this.add(this.fromButton);
        this.add(this.from);
        this.add(new JLabel(";"));
        this.add(this.to);
        this.add(this.toButton);
        this.add(new JSeparator(1));
        this.add(this.okButton);
        this.add(this.cancelButton);
        this.setSize(600, 70);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getWidth()) / 2, (screenSize.height - this.getHeight()) / 2);
        this.setResizable(false);
        this.setVisible(true);
    }

    public String getResultInterval() {
        String s = String.valueOf(this.fromButton.getText()) + this.from.getSelectedItem() + " ; " + this.to.getSelectedItem() + this.toButton.getText();
        return s;
    }

    public Interval getInterval() {
        if (this.ok) {
            return this.interval;
        }
        return null;
    }
}

