/*
 * Decompiled with CFR 0.152.
 */
package controller.simuSynthesis;

import SocLab.GUI.simuLauncher.simuResultSynth.simuResultSynthesis;
import SocLab.core.SocLabToolkit;
import SocLab.core.SocialGameState;
import SocLab.tools.RTFReports;
import chart.GraphicGenerator;
import chart.GraphicGeneratorManager;
import controller.ControllerGenDoc;
import controller.EmptyException;
import controller.simuSynthesis.AnyObservationIsConvergingException;
import controller.simuSynthesis.Controller;
import input.WrongFormException;
import input.rawResults.RawResultImpl;
import java.awt.geom.Point2D;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.JPanel;
import statistic.StatImpl;

public class ControllerImpl
extends ControllerGenDoc
implements Controller {
    public static final int ACTOR = 1;
    public static final int RELATION = 2;
    public static final int SIMULATION = 3;
    public static final int CONVERGENCE = 4;
    public static final String ALLSIMULATIONS = "toutes les simulations";
    public static final String ALLACTORS = "tous les acteurs";
    public static final String ALLRELATIONS = "toutes les relations";
    public static final String ALLVARIABLES = "all final variables";
    public static final String ALLSTEPVARIABLES = "all step variables";
    public static final String GRAPHECONVERGENCE = "Percentage of convergence on all the Simulations ";
    public static final String GRAPHESIMULATION = "Graph of the simulation variables";
    public static final String GRAPHESIMULATIONCONV = "Graph of the simulation variables for converging Simulations";
    public static final String GRAPHEINSTANTFINALSACTOR = "Graph of the actor variables at the final state";
    public static final String GRAPHEINSTANTFINALACTORS = "Graph of the actors variable at the final state";
    public static final String GRAPHEINSTANTFINALSRELATION = "Graph of the relation variables at the final state";
    public static final String GRAPHEINSTANTFINALRELATIONS = "Graph of the relations variable at the final state";
    public static final String GRAPHEGENERALACTOR = "Evolution graph of the actor variable";
    public static final String GRAPHEGENERALACTORS = "Evolution graph of the actor variables";
    public static final String GRAPHEGENERALRELATION = "Evolution graph of the relation variable";
    public static final String GRAPHEGENERALRELATIONS = "Evolution graph of the relation variables";
    public HashMap<String, RawResultImpl> rawResult = new HashMap();
    public String dirDocName = null;
    public String fileDocName = null;
    public String directoryName = null;

    @Override
    public void loadResults(String directoryName) throws WrongFormException {
        this.directoryName = directoryName;
        File directory = new File(directoryName);
        File[] listFiles = directory.listFiles();
        this.rawResult.clear();
        int i = 0;
        while (i < listFiles.length) {
            String fileName = listFiles[i].getName();
            if (fileName.endsWith(".xls") && fileName.startsWith("results_")) {
                RawResultImpl rawResultImpl = new RawResultImpl(listFiles[i].getAbsolutePath());
                try {
                    rawResultImpl.getDatas();
                    this.rawResult.put(fileName, rawResultImpl);
                }
                catch (Exception e) {
                    throw new WrongFormException();
                }
            }
            ++i;
        }
        this.dirDocName = directoryName;
        this.fileDocName = "results.rtf";
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public String createSummaryFiles(String directoryName, String fileName) throws IOException, AnyObservationIsConvergingException {
        block28: {
            collRawResult = this.rawResult.values();
            itRawResult = collRawResult.iterator();
            result = itRawResult.next();
            nbVarSimulation = result.getNbVarSimulation();
            nbActors = result.getNbActors();
            nbRelations = result.getNbRelations();
            nbVarActor = result.getNbVarActor();
            nbVarRelation = result.getNbVarRelation();
            nbCv = this.nbConvergence();
            nbObs = this.rawResult.size();
            if (nbCv == 0) break block28;
            try {
                absoluteFileName = String.valueOf(directoryName) + File.separator + fileName;
                f = new File(absoluteFileName);
                f.createNewFile();
                fw = new FileWriter(f);
                output = new BufferedWriter(fw);
                output.write("runs\t");
                i = 0;
                while (i < nbVarSimulation) {
                    output.write(String.valueOf(result.getNameVarSimulations()[i]) + "\t");
                    ++i;
                }
                i = 0;
                while (i < nbActors) {
                    j = 0;
                    while (j < nbVarActor) {
                        output.write(String.valueOf(result.getNameActors()[i]) + "." + result.getNameVarActors()[j] + "\t");
                        ++j;
                    }
                    ++i;
                }
                i = 0;
                while (i < nbRelations) {
                    j = 0;
                    while (j < nbVarRelation) {
                        output.write(String.valueOf(result.getNameRelations()[i]) + "." + result.getNameVarRelations()[j] + "\t");
                        ++j;
                    }
                    ++i;
                }
                output.write("\n");
                k = 0;
                ** GOTO lbl80
                {
                    if (itRawResult.hasNext()) {
                        result = itRawResult.next();
                    } else {
                        itRawResult = collRawResult.iterator();
                        result = itRawResult.next();
                    }
                    do {
                        if (!result.getExperiment().equals(String.valueOf(k))) continue block7;
                        if (result.getConvergence()) {
                            output.write(String.valueOf(k) + "\t");
                            i = 0;
                            while (i < nbVarSimulation) {
                                output.write(String.valueOf(result.getVarSimulation()[i]) + "\t");
                                ++i;
                            }
                            i = 0;
                            while (i < nbActors) {
                                j = 0;
                                while (j < nbVarActor) {
                                    output.write(String.valueOf(result.getVarActorConv()[j][i]) + "\t");
                                    ++j;
                                }
                                ++i;
                            }
                            i = 0;
                            while (i < nbRelations) {
                                j = 0;
                                while (j < nbVarRelation) {
                                    output.write(String.valueOf(result.getVarRelationConv()[j][i]) + "\t");
                                    ++j;
                                }
                                ++i;
                            }
                            output.write("\n");
                        }
                        ++k;
lbl80:
                        // 2 sources

                    } while (k < nbObs);
                }
                output.write("\n");
                output.flush();
                output.close();
                matrixSatisf = new double[nbActors][nbCv];
                matrixStateRel = new double[nbRelations][nbCv];
                valSimu = new double[nbVarSimulation][nbCv];
                array3DVarActor = new double[nbVarActor][nbActors][nbCv];
                array3DVarRelation = new double[nbVarRelation][nbRelations][nbCv];
                nbsteps_run_conv = new double[nbCv];
                nbsteps_run_non_conv = new double[nbObs - nbCv];
                cpt_conv = 0;
                cpt_non_conv = 0;
                j = 0;
                itRawResult = collRawResult.iterator();
                m = 0;
                while (m < nbObs) {
                    result = itRawResult.next();
                    if (!result.getConvergence()) {
                        nbsteps_run_non_conv[cpt_non_conv] = result.getNbStepConv();
                        ++cpt_non_conv;
                    } else {
                        nbsteps_run_conv[cpt_conv] = result.getNbStepConv();
                        k = 0;
                        while (k < nbVarSimulation) {
                            valSimu[k][j] = result.getVarSimulation()[k];
                            ++k;
                        }
                        i = 0;
                        while (i < nbActors) {
                            matrixSatisf[i][j] = result.getVarActorConv()[0][i];
                            ++i;
                        }
                        i = 0;
                        while (i < nbRelations) {
                            matrixStateRel[i][j] = result.getVarRelationConv()[0][i];
                            ++i;
                        }
                        i = 0;
                        while (i < nbVarActor) {
                            k = 0;
                            while (k < nbActors) {
                                array3DVarActor[i][k][j] = result.getVarActorConv()[i][k];
                                ++k;
                            }
                            ++i;
                        }
                        i = 1;
                        while (i < nbVarRelation) {
                            k = 0;
                            while (k < nbRelations) {
                                array3DVarRelation[i][k][j] = result.getVarRelationConv()[i][k];
                                ++k;
                            }
                            ++i;
                        }
                        ++cpt_conv;
                        ++j;
                    }
                    ++m;
                }
                stat = new StatImpl();
                res = stat.meanAndDeviation2D(valSimu);
                res = stat.meanAndDeviation2D(matrixSatisf);
                meanConvergingState = new SocialGameState();
                rNames = SocLabToolkit.currentOrgNew.getRelationsNewName();
                res = stat.meanAndDeviation2D(matrixStateRel);
                i = 0;
                while (i < res.length) {
                    rN = SocLabToolkit.currentOrgNew.getRelationNew(rNames[i]);
                    meanConvergingState.put(rN, res[i][0]);
                    ++i;
                }
                SocLabToolkit.currentOrgNew.setSocialGameState(meanConvergingState);
                stats_steps_conv = stat.meanAndDeviation(nbsteps_run_conv);
                stat.meanAndDeviation(nbsteps_run_non_conv);
                simuResults = new simuResultSynthesis(SocLabToolkit.currentOrgNew);
                simuResults.nbConv = nbCv;
                simuResults.mean_nb_steps = stats_steps_conv[0];
                simuResults.std_nb_steps = stats_steps_conv[1];
                simuResults.nbVarActor = nbVarActor;
                simuResults.nameVarActors = result.getNameVarActors();
                simuResults.matrixSatisf = stat.meanAndDeviation2D(matrixSatisf);
                simuResults.matrixStateRel = stat.meanAndDeviation2D(matrixStateRel);
                simuResults.array3DVarActor = stat.meanAndDeviation3D(array3DVarActor);
                SocLabToolkit.currentOrgNew.setSimuResults(simuResults);
                return absoluteFileName;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IOException();
            }
        }
        throw new AnyObservationIsConvergingException();
    }

    @Override
    public String[] getObservations(boolean type) {
        String[] obs;
        if (type) {
            obs = new String[]{ALLSIMULATIONS};
        } else {
            obs = new String[this.rawResult.size() + 1];
            Set<String> keySet = this.rawResult.keySet();
            Iterator<String> iteratorKey = keySet.iterator();
            obs[0] = ALLSIMULATIONS;
            int i = 1;
            while (i <= this.rawResult.size()) {
                obs[i] = iteratorKey.next();
                ++i;
            }
        }
        return obs;
    }

    @Override
    public String[] getNameCategory(String idObs, int category) {
        int i;
        RawResultImpl obs = this.rawResult.get(idObs);
        String[] names = null;
        String[] temp = null;
        if (idObs.equals(ALLSIMULATIONS)) {
            obs = this.rawResult.values().iterator().next();
        }
        if (category == 1) {
            names = new String[obs.getNbActors() + 1];
            names[0] = ALLACTORS;
            temp = obs.getNameActors();
            i = 1;
            while (i < names.length) {
                names[i] = temp[i - 1];
                ++i;
            }
        }
        if (category == 2) {
            names = new String[obs.getNbRelations() + 1];
            names[0] = ALLRELATIONS;
            temp = obs.getNameRelations();
            i = 1;
            while (i < names.length) {
                names[i] = temp[i - 1];
                ++i;
            }
        }
        if (category == 4 || category == 3) {
            names = new String[]{"None"};
        }
        return names;
    }

    @Override
    public String[] getVariables(String idObs, int category, boolean all, String idNameCat) {
        int i;
        RawResultImpl obs = this.rawResult.get(idObs);
        String[] names = null;
        String[] temp = null;
        if (idObs.equals(ALLSIMULATIONS)) {
            obs = this.rawResult.values().iterator().next();
        }
        if (category == 1) {
            if (all) {
                names = new String[obs.getNbVarActor() + obs.getNbVarActorStep()];
                temp = obs.getNameVarActors();
                i = 0;
                while (i < obs.getNbVarActor()) {
                    names[i] = temp[i];
                    ++i;
                }
                temp = obs.getNameVarActorsStep();
                i = obs.getNbVarActor();
                while (i < names.length) {
                    names[i] = temp[i - obs.getNbVarActor()];
                    ++i;
                }
            } else {
                names = !idObs.equals(ALLSIMULATIONS) ? new String[obs.getNbVarActorStep() + 2] : new String[obs.getNbVarActorStep() + 1];
                names[0] = ALLVARIABLES;
                temp = obs.getNameVarActorsStep();
                int iTemp = 0;
                if (!idObs.equals(ALLSIMULATIONS)) {
                    names[1] = ALLSTEPVARIABLES;
                    iTemp = 1;
                }
                int i2 = 1 + iTemp;
                while (i2 < names.length) {
                    names[i2] = temp[i2 - 1 - iTemp];
                    ++i2;
                }
            }
        }
        if (category == 2) {
            if (all) {
                names = new String[obs.getNbVarRelation() + obs.getNbVarRelationStep()];
                temp = obs.getNameVarRelations();
                i = 0;
                while (i < obs.getNbVarRelation()) {
                    names[i] = temp[i];
                    ++i;
                }
                temp = obs.getNameVarRelationsStep();
                i = obs.getNbVarRelation();
                while (i < names.length) {
                    names[i] = temp[i - obs.getNbVarRelation()];
                    ++i;
                }
            } else {
                names = new String[obs.getNbVarRelation() + 1];
                names[0] = ALLVARIABLES;
                temp = obs.getNameVarRelationsStep();
                i = 1;
                while (i < names.length) {
                    names[i] = temp[i - 1];
                    ++i;
                }
            }
        }
        if (category == 4) {
            names = new String[]{"None"};
        }
        if (category == 3) {
            names = new String[]{ALLVARIABLES};
        }
        return names;
    }

    @Override
    public String[] getGraph(String idObs, int category, String idNameCat, int idVar) {
        Collection<RawResultImpl> collRawResult = this.rawResult.values();
        Iterator<RawResultImpl> itRawResult = collRawResult.iterator();
        RawResultImpl result = itRawResult.next();
        int nbVarActor = result.getNbVarActor();
        int nbVarRelation = result.getNbVarRelation();
        Vector<String> names = new Vector<String>();
        if (category == 4) {
            names.add(GRAPHECONVERGENCE);
        } else if (category == 3) {
            names.add(GRAPHESIMULATION);
            names.add(GRAPHESIMULATIONCONV);
        } else if (category == 1 && idNameCat.equals(ALLACTORS) && idVar < nbVarActor) {
            names.add(GRAPHEINSTANTFINALACTORS);
        } else if (category == 1 && idNameCat.equals(ALLACTORS) && idVar >= nbVarActor) {
            names.add(GRAPHEGENERALACTORS);
        } else if (category == 1 && !idNameCat.equals(ALLACTORS) && idVar != 0) {
            names.add(GRAPHEGENERALACTOR);
        } else if (category == 1 && !idNameCat.equals(ALLACTORS) && idVar == 0) {
            names.add(GRAPHEINSTANTFINALSACTOR);
        } else if (category == 2 && idNameCat.equals(ALLRELATIONS) && idVar < nbVarRelation) {
            names.add(GRAPHEINSTANTFINALRELATIONS);
        } else if (category == 2 && idNameCat.equals(ALLRELATIONS) && idVar >= nbVarRelation) {
            names.add(GRAPHEGENERALRELATIONS);
        } else if (category == 2 && !idNameCat.equals(ALLRELATIONS) && idVar != 0) {
            names.add(GRAPHEGENERALRELATION);
        } else if (category == 2 && !idNameCat.equals(ALLRELATIONS) && idVar == 0) {
            names.add(GRAPHEINSTANTFINALSRELATION);
        }
        String[] ret = new String[names.size()];
        Iterator ite = names.iterator();
        int i = 0;
        while (i < ret.length) {
            ret[i] = (String)ite.next();
            ++i;
        }
        return ret;
    }

    @Override
    public JPanel getGraphic(String idObs, int category, String idNameCat, int idVar, String idGraph) {
        Collection<RawResultImpl> collRawResult = this.rawResult.values();
        Iterator<RawResultImpl> itRawResult = collRawResult.iterator();
        RawResultImpl result = itRawResult.next();
        int nbVarActor = result.getNbVarActor();
        int nbVarRelation = result.getNbVarRelation();
        GraphicGenerator gen = GraphicGeneratorManager.getDefaultGraphicGenerator();
        if (category == 4 && idGraph.equals(GRAPHECONVERGENCE)) {
            double nbObs = this.rawResult.size();
            double nbCv = this.nbConvergence();
            String[] titles = new String[]{"No convergence", "Convergence"};
            double[] values = new double[]{nbObs - nbCv, nbCv};
            return gen.getPie(idGraph, titles, values);
        }
        if (category == 3 && idGraph.equals(GRAPHESIMULATION)) {
            int nbObs = this.rawResult.values().size();
            int nbVarSimulation = result.getNbVarSimulation();
            double[][] valSimu = new double[nbVarSimulation][nbObs];
            double[] varSimu = result.getVarSimulation();
            String[] nameVarSimu = result.getNameVarSimulations();
            int i = 0;
            while (i < nbVarSimulation) {
                valSimu[i][0] = varSimu[i];
                ++i;
            }
            itRawResult = collRawResult.iterator();
            int j = 0;
            while (j < nbObs) {
                result = itRawResult.next();
                varSimu = result.getVarSimulation();
                int k = 0;
                while (k < nbVarSimulation) {
                    valSimu[k][j] = varSimu[k];
                    ++k;
                }
                ++j;
            }
            StatImpl stat = new StatImpl();
            Double[][] res = stat.meanAndDeviation2D(valSimu);
            double[][] res2 = new double[res[0].length][res.length];
            int i2 = 0;
            while (i2 < res.length) {
                int j2 = 0;
                while (j2 < res[0].length) {
                    res2[j2][i2] = res[i2][j2];
                    ++j2;
                }
                ++i2;
            }
            return gen.getBarChartWithDerivation(idGraph, nameVarSimu, res2[0], res2[1]);
        }
        if (category == 3 && idGraph.equals(GRAPHESIMULATIONCONV)) {
            int nbCv = this.nbConvergence();
            int nbVarSimulation = result.getNbVarSimulation();
            double[][] valSimu = new double[nbVarSimulation][nbCv];
            double[] varSimu = result.getVarSimulation();
            String[] nameVarSimu = result.getNameVarSimulations();
            itRawResult = collRawResult.iterator();
            int m = 0;
            while (m < nbCv) {
                result = itRawResult.next();
                if (!result.getConvergence()) continue;
                varSimu = result.getVarSimulation();
                int k = 0;
                while (k < nbVarSimulation) {
                    valSimu[k][m] = varSimu[k];
                    ++k;
                }
                ++m;
            }
            StatImpl stat = new StatImpl();
            Double[][] res = stat.meanAndDeviation2D(valSimu);
            double[][] res2 = new double[res[0].length][res.length];
            int i = 0;
            while (i < res.length) {
                int j = 0;
                while (j < res[0].length) {
                    res2[j][i] = res[i][j];
                    ++j;
                }
                ++i;
            }
            return gen.getBarChartWithDerivation(idGraph, nameVarSimu, res2[0], res2[1]);
        }
        if (idObs.equals(ALLSIMULATIONS) && category == 1 && idNameCat.equals(ALLACTORS) && idVar < nbVarActor && idGraph.equals(GRAPHEINSTANTFINALACTORS)) {
            int k;
            int val;
            int nbCv = this.nbConvergence();
            int nbActor = result.getNbActors();
            String[] nameActor = result.getNameActors();
            double[][] valVarActConv = new double[nbActor][nbCv];
            nbVarActor = result.getNbVarActor();
            int index = idVar;
            double[] varActorConv = result.getVarActorConv()[index];
            if (result.getConvergence()) {
                int j = 0;
                while (j < nbActor) {
                    valVarActConv[j][0] = varActorConv[j];
                    ++j;
                }
                val = 1;
                while (val < nbCv) {
                    result = itRawResult.next();
                    if (!result.getConvergence()) continue;
                    varActorConv = result.getVarActorConv()[index];
                    k = 0;
                    while (k < nbActor) {
                        valVarActConv[k][val] = varActorConv[k];
                        ++k;
                    }
                    ++val;
                }
            } else {
                val = 0;
                while (val < nbCv) {
                    result = itRawResult.next();
                    if (!result.getConvergence()) continue;
                    varActorConv = result.getVarActorConv()[index];
                    k = 0;
                    while (k < nbActor) {
                        valVarActConv[k][val] = varActorConv[k];
                        ++k;
                    }
                    ++val;
                }
            }
            StatImpl stat = new StatImpl();
            Double[][] res = stat.meanAndDeviation2D(valVarActConv);
            double[][] res2 = new double[res[0].length][res.length];
            int k2 = 0;
            while (k2 < res.length) {
                int j = 0;
                while (j < res[0].length) {
                    res2[j][k2] = res[k2][j];
                    ++j;
                }
                ++k2;
            }
            return gen.getBarChartWithDerivation(idGraph, nameActor, res2[0], res2[1]);
        }
        if (!(idObs.equals(ALLSIMULATIONS) && category == 1 && idNameCat.equals(ALLACTORS) && idVar >= nbVarActor && idGraph.equals(GRAPHEGENERALACTORS))) {
            if (idObs.equals(ALLSIMULATIONS) && category == 1 && !idNameCat.equals(ALLACTORS) && idVar == 0 && idGraph.equals(GRAPHEINSTANTFINALSACTOR)) {
                int k;
                int j;
                int nbCv = this.nbConvergence();
                int nbActor = result.getNbActors();
                String[] nameActors = result.getNameActors();
                int cpt = 0;
                boolean find = false;
                int indexActor = 0;
                while (cpt < nbActor && !find) {
                    if (nameActors[cpt].equals(idNameCat)) {
                        indexActor = cpt;
                        find = true;
                        continue;
                    }
                    ++cpt;
                }
                if (!find) {
                    return null;
                }
                double[][] valActor = new double[nbVarActor][nbCv];
                double[] varActor = new double[nbVarActor];
                String[] nameVarActor = result.getNameVarActors();
                if (result.getConvergence()) {
                    int i = 0;
                    while (i < nbVarActor) {
                        varActor[i] = result.getVarActorConv()[i][indexActor];
                        ++i;
                    }
                    i = 0;
                    while (i < nbVarActor) {
                        valActor[i][0] = varActor[i];
                        ++i;
                    }
                    j = 1;
                    while (j < nbCv) {
                        result = itRawResult.next();
                        if (!result.getConvergence()) continue;
                        k = 0;
                        while (k < nbVarActor) {
                            varActor[k] = result.getVarActorConv()[k][indexActor];
                            valActor[k][j] = varActor[k];
                            ++k;
                        }
                        ++j;
                    }
                } else {
                    j = 0;
                    while (j < nbCv) {
                        result = itRawResult.next();
                        if (!result.getConvergence()) continue;
                        k = 0;
                        while (k < nbVarActor) {
                            varActor[k] = result.getVarActorConv()[k][indexActor];
                            valActor[k][j] = varActor[k];
                            ++k;
                        }
                        ++j;
                    }
                }
                StatImpl stat = new StatImpl();
                Double[][] res = stat.meanAndDeviation2D(valActor);
                double[][] res2 = new double[res[0].length][res.length];
                int i = 0;
                while (i < res.length) {
                    int j3 = 0;
                    while (j3 < res[0].length) {
                        res2[j3][i] = res[i][j3];
                        ++j3;
                    }
                    ++i;
                }
                return gen.getBarChartWithDerivation(idGraph, nameVarActor, res2[0], res2[1]);
            }
            if (idObs.equals(ALLSIMULATIONS) && category == 1 && !idNameCat.equals(ALLACTORS) && idVar > 0 && idGraph.equals(GRAPHEGENERALACTOR)) {
                int j;
                int nbObs = this.rawResult.size();
                Vector vectStepVariable = new Vector();
                int nbActor = result.getNbActors();
                Vector<Point2D.Double[]> ptStepVariable = new Vector<Point2D.Double[]>();
                Vector<String> curvesName = new Vector<String>();
                String[] nameActors = result.getNameActors();
                int i = 0;
                boolean find = false;
                int index = 0;
                while (i < nbActor && !find) {
                    if (nameActors[i].equals(idNameCat)) {
                        index = i;
                        find = true;
                        continue;
                    }
                    ++i;
                }
                if (!find) {
                    return null;
                }
                int nbStep = result.getNbStepConv() + 1;
                double[][] stepVariable = result.getVarActor()[idVar - 1];
                int nbStepMax = nbStep;
                Point2D.Double[] pts = new Point2D.Double[nbStep];
                int j4 = 0;
                while (j4 < nbStep) {
                    Vector<Double> vect = new Vector<Double>();
                    pts[j4] = new Point2D.Double(j4, stepVariable[j4][index]);
                    vect.add(stepVariable[j4][index]);
                    vectStepVariable.add(vect);
                    ++j4;
                }
                ptStepVariable.add(pts);
                curvesName.add(result.getExperiment());
                Vector vect = new Vector();
                int k = 1;
                while (k < nbObs) {
                    result = itRawResult.next();
                    nbStep = result.getNbStepConv() + 1;
                    int oldMax = nbStepMax;
                    if (nbStep > nbStepMax) {
                        nbStepMax = nbStep;
                    }
                    stepVariable = result.getVarActor()[idVar - 1];
                    pts = new Point2D.Double[nbStep];
                    int j5 = 0;
                    while (j5 < nbStep) {
                        pts[j5] = new Point2D.Double(j5, stepVariable[j5][index]);
                        if (j5 < oldMax) {
                            vect = (Vector)vectStepVariable.get(j5);
                            vect.add(stepVariable[j5][index]);
                        } else {
                            Vector<Double> newVect = new Vector<Double>();
                            newVect.add(stepVariable[j5][index]);
                            vectStepVariable.add(newVect);
                        }
                        ++j5;
                    }
                    ptStepVariable.add(pts);
                    curvesName.add(result.getExperiment());
                    ++k;
                }
                for (Point2D.Double[] pt : ptStepVariable) {
                    int nbStepPt = pt.length;
                    if (nbStepPt >= nbStepMax) continue;
                    Double convergingValue = pt[nbStepPt - 1].getY();
                    j = nbStepPt;
                    while (j < nbStepMax) {
                        vect = (Vector)vectStepVariable.get(j);
                        vect.add(convergingValue);
                        ++j;
                    }
                }
                Point2D.Double[] doublePts = new Point2D.Double[nbStepMax];
                StatImpl stat = new StatImpl();
                double mean = 0.0;
                j = 0;
                while (j < nbStepMax) {
                    vect = (Vector)vectStepVariable.get(j);
                    double[] array = ControllerImpl.vectToDoubleArray(vect);
                    mean = stat.meanAndDeviation(array)[0];
                    doublePts[j] = new Point2D.Double(j, mean);
                    ++j;
                }
                ptStepVariable.add(doublePts);
                curvesName.add("MEAN");
                return gen.getCurves(String.valueOf(idGraph) + " : " + idNameCat, curvesName, ptStepVariable);
            }
            if (!idObs.equals(ALLSIMULATIONS) && category == 1 && idNameCat.equals(ALLACTORS) && idVar < nbVarActor && idGraph.equals(GRAPHEINSTANTFINALACTORS)) {
                result = this.rawResult.get(idObs);
                int nbActor = result.getNbActors();
                String[] nameActor = result.getNameActors();
                double[] valVarActConv = new double[nbActor];
                nbVarActor = result.getNbVarActor();
                int index = idVar;
                double[] varActorConv = result.getVarActorConv()[index];
                if (result.getConvergence()) {
                    int j = 0;
                    while (j < nbActor) {
                        valVarActConv[j] = varActorConv[j];
                        ++j;
                    }
                }
                return gen.getBarChart(idGraph, nameActor, valVarActConv);
            }
            if (!idObs.equals(ALLSIMULATIONS) && category == 1 && idNameCat.equals(ALLACTORS) && idVar >= nbVarActor && idGraph.equals(GRAPHEGENERALACTORS)) {
                result = this.rawResult.get(idObs);
                int nbActors = result.getNbActors();
                double[][] matrixStepVariable = result.getVarActor()[idVar - result.getNbVarActor()];
                String[] nameActors = result.getNameActors();
                int nbStep = result.getNbStepConv() + 1;
                Vector<Point2D.Double[]> ptSatisf = new Vector<Point2D.Double[]>();
                Vector<String> curvesName = new Vector<String>();
                int i = 0;
                while (i < nbActors) {
                    Point2D.Double[] pts = new Point2D.Double[nbStep];
                    curvesName.add(nameActors[i]);
                    int j = 0;
                    while (j < nbStep) {
                        pts[j] = new Point2D.Double(j, matrixStepVariable[j][i]);
                        ++j;
                    }
                    ptSatisf.add(pts);
                    ++i;
                }
                return gen.getCurves(idGraph, curvesName, ptSatisf);
            }
            if (!idObs.equals(ALLSIMULATIONS) && category == 1 && !idNameCat.equals(ALLACTORS) && idVar == 0 && idGraph.equals(GRAPHEINSTANTFINALSACTOR)) {
                result = this.rawResult.get(idObs);
                int nbActor = result.getNbActors();
                String[] nameActors = result.getNameActors();
                int cpt = 0;
                boolean find = false;
                int indexActor = 0;
                while (cpt < nbActor && !find) {
                    if (nameActors[cpt].equals(idNameCat)) {
                        indexActor = cpt;
                        find = true;
                        continue;
                    }
                    ++cpt;
                }
                if (!find) {
                    return null;
                }
                double[] varActor = new double[nbVarActor];
                String[] nameVarActor = result.getNameVarActors();
                if (result.getConvergence()) {
                    int i = 0;
                    while (i < nbVarActor) {
                        varActor[i] = result.getVarActorConv()[i][indexActor];
                        ++i;
                    }
                }
                return gen.getBarChart(idGraph, nameVarActor, varActor);
            }
            if (!idObs.equals(ALLSIMULATIONS) && category == 1 && !idNameCat.equals(ALLACTORS) && idVar == 1 && idGraph.equals(GRAPHEGENERALACTOR)) {
                result = this.rawResult.get(idObs);
                String[] nameActors = result.getNameActors();
                int i = 0;
                boolean find = false;
                int index = 0;
                int nbActor = result.getNbActors();
                while (i < nbActor && !find) {
                    if (nameActors[i].equals(idNameCat)) {
                        index = i;
                        find = true;
                        continue;
                    }
                    ++i;
                }
                if (!find) {
                    return null;
                }
                Vector<String> curvesName = new Vector<String>();
                Vector<Point2D.Double[]> ptSatisf = new Vector<Point2D.Double[]>();
                int iTemp = 0;
                while (iTemp < result.getNbVarActorStep()) {
                    double[][] matrixStepVariable = result.getVarActor()[iTemp];
                    int nbStep = result.getNbStepConv() + 1;
                    Point2D.Double[] pts = new Point2D.Double[nbStep];
                    curvesName.add(nameActors[index]);
                    int j = 0;
                    while (j < nbStep) {
                        pts[j] = new Point2D.Double(j, matrixStepVariable[j][index]);
                        ++j;
                    }
                    ptSatisf.add(pts);
                    ++iTemp;
                }
                return gen.getCurves(idGraph, curvesName, ptSatisf);
            }
            if (!idObs.equals(ALLSIMULATIONS) && category == 1 && !idNameCat.equals(ALLACTORS) && idVar > 1 && idGraph.equals(GRAPHEGENERALACTOR)) {
                result = this.rawResult.get(idObs);
                String[] nameActors = result.getNameActors();
                int i = 0;
                boolean find = false;
                int index = 0;
                int nbActor = result.getNbActors();
                while (i < nbActor && !find) {
                    if (nameActors[i].equals(idNameCat)) {
                        index = i;
                        find = true;
                        continue;
                    }
                    ++i;
                }
                if (!find) {
                    return null;
                }
                double[][] matrixStepVariable = result.getVarActor()[idVar - 2];
                int nbStep = result.getNbStepConv() + 1;
                Vector<Point2D.Double[]> ptSatisf = new Vector<Point2D.Double[]>();
                Vector<String> curvesName = new Vector<String>();
                Point2D.Double[] pts = new Point2D.Double[nbStep];
                curvesName.add(nameActors[index]);
                int j = 0;
                while (j < nbStep) {
                    pts[j] = new Point2D.Double(j, matrixStepVariable[j][i]);
                    ++j;
                }
                ptSatisf.add(pts);
                return gen.getCurves(idGraph, curvesName, ptSatisf);
            }
            if (idObs.equals(ALLSIMULATIONS) && category == 2 && idNameCat.equals(ALLRELATIONS) && idVar < nbVarRelation && idGraph.equals(GRAPHEINSTANTFINALRELATIONS)) {
                int k;
                int val;
                int nbCv = this.nbConvergence();
                int nbRelation = result.getNbRelations();
                String[] nameRelation = result.getNameRelations();
                double[][] valVarActConv = new double[nbRelation][nbCv];
                nbVarRelation = result.getNbVarRelation();
                int index = idVar;
                double[] varRelationConv = result.getVarRelationConv()[index];
                if (result.getConvergence()) {
                    int j = 0;
                    while (j < nbRelation) {
                        valVarActConv[j][0] = varRelationConv[j];
                        ++j;
                    }
                    val = 1;
                    while (val < nbCv) {
                        result = itRawResult.next();
                        if (!result.getConvergence()) continue;
                        varRelationConv = result.getVarRelationConv()[index];
                        k = 0;
                        while (k < nbRelation) {
                            valVarActConv[k][val] = varRelationConv[k];
                            ++k;
                        }
                        ++val;
                    }
                } else {
                    val = 0;
                    while (val < nbCv) {
                        result = itRawResult.next();
                        if (!result.getConvergence()) continue;
                        varRelationConv = result.getVarRelationConv()[index];
                        k = 0;
                        while (k < nbRelation) {
                            valVarActConv[k][val] = varRelationConv[k];
                            ++k;
                        }
                        ++val;
                    }
                }
                StatImpl stat = new StatImpl();
                Double[][] res = stat.meanAndDeviation2D(valVarActConv);
                double[][] res2 = new double[res[0].length][res.length];
                int k3 = 0;
                while (k3 < res.length) {
                    int j = 0;
                    while (j < res[0].length) {
                        res2[j][k3] = res[k3][j];
                        ++j;
                    }
                    ++k3;
                }
                return gen.getBarChartWithDerivation(idGraph, nameRelation, res2[0], res2[1]);
            }
            if (!(idObs.equals(ALLSIMULATIONS) && category == 2 && idNameCat.equals(ALLRELATIONS) && idVar >= nbVarRelation && idGraph.equals(GRAPHEGENERALRELATIONS))) {
                if (idObs.equals(ALLSIMULATIONS) && category == 2 && !idNameCat.equals(ALLRELATIONS) && idVar == 0 && idGraph.equals(GRAPHEINSTANTFINALSRELATION)) {
                    int k;
                    int j;
                    int nbCv = this.nbConvergence();
                    int nbRelation = result.getNbRelations();
                    String[] nameRelations = result.getNameRelations();
                    int cpt = 0;
                    boolean find = false;
                    int indexRelation = 0;
                    while (cpt < nbRelation && !find) {
                        if (nameRelations[cpt].equals(idNameCat)) {
                            indexRelation = cpt;
                            find = true;
                            continue;
                        }
                        ++cpt;
                    }
                    if (!find) {
                        return null;
                    }
                    double[][] valRelation = new double[nbVarRelation][nbCv];
                    double[] varRelation = new double[nbVarRelation];
                    String[] nameVarRelation = result.getNameVarRelations();
                    if (result.getConvergence()) {
                        int i = 0;
                        while (i < nbVarRelation) {
                            varRelation[i] = result.getVarRelationConv()[i][indexRelation];
                            ++i;
                        }
                        i = 0;
                        while (i < nbVarRelation) {
                            valRelation[i][0] = varRelation[i];
                            ++i;
                        }
                        j = 1;
                        while (j < nbCv) {
                            result = itRawResult.next();
                            if (!result.getConvergence()) continue;
                            k = 0;
                            while (k < nbVarRelation) {
                                varRelation[k] = result.getVarRelationConv()[k][indexRelation];
                                valRelation[k][j] = varRelation[k];
                                ++k;
                            }
                            ++j;
                        }
                    } else {
                        j = 0;
                        while (j < nbCv) {
                            result = itRawResult.next();
                            if (!result.getConvergence()) continue;
                            k = 0;
                            while (k < nbVarRelation) {
                                varRelation[k] = result.getVarRelationConv()[k][indexRelation];
                                valRelation[k][j] = varRelation[k];
                                ++k;
                            }
                            ++j;
                        }
                    }
                    StatImpl stat = new StatImpl();
                    Double[][] res = stat.meanAndDeviation2D(valRelation);
                    double[][] res2 = new double[res[0].length][res.length];
                    int i = 0;
                    while (i < res.length) {
                        int j6 = 0;
                        while (j6 < res[0].length) {
                            res2[j6][i] = res[i][j6];
                            ++j6;
                        }
                        ++i;
                    }
                    return gen.getBarChartWithDerivation(idGraph, nameVarRelation, res2[0], res2[1]);
                }
                if (idObs.equals(ALLSIMULATIONS) && category == 2 && !idNameCat.equals(ALLRELATIONS) && idVar > 0 && idGraph.equals(GRAPHEGENERALRELATION)) {
                    int j;
                    int nbObs = this.rawResult.size();
                    Vector vectStepVariable = new Vector();
                    int nbRelation = result.getNbRelations();
                    Vector<Point2D.Double[]> ptStepVariable = new Vector<Point2D.Double[]>();
                    Vector<String> curvesName = new Vector<String>();
                    String[] nameRelations = result.getNameRelations();
                    int i = 0;
                    boolean find = false;
                    int index = 0;
                    while (i < nbRelation && !find) {
                        if (nameRelations[i].equals(idNameCat)) {
                            index = i;
                            find = true;
                            continue;
                        }
                        ++i;
                    }
                    if (!find) {
                        return null;
                    }
                    int nbStep = result.getNbStepConv() + 1;
                    double[][] stepVariable = result.getVarRelation()[idVar - 1];
                    int nbStepMax = nbStep;
                    Point2D.Double[] pts = new Point2D.Double[nbStep];
                    int j7 = 0;
                    while (j7 < nbStep) {
                        Vector<Double> vect = new Vector<Double>();
                        pts[j7] = new Point2D.Double(j7, stepVariable[j7][index]);
                        vect.add(stepVariable[j7][index]);
                        vectStepVariable.add(vect);
                        ++j7;
                    }
                    ptStepVariable.add(pts);
                    curvesName.add(result.getExperiment());
                    Vector vect = new Vector();
                    int k = 1;
                    while (k < nbObs) {
                        result = itRawResult.next();
                        nbStep = result.getNbStepConv() + 1;
                        int oldMax = nbStepMax;
                        if (nbStep > nbStepMax) {
                            nbStepMax = nbStep;
                        }
                        stepVariable = result.getVarRelation()[idVar - 1];
                        pts = new Point2D.Double[nbStep];
                        int j8 = 0;
                        while (j8 < nbStep) {
                            pts[j8] = new Point2D.Double(j8, stepVariable[j8][index]);
                            if (j8 < oldMax) {
                                vect = (Vector)vectStepVariable.get(j8);
                                vect.add(stepVariable[j8][index]);
                            } else {
                                Vector<Double> newVect = new Vector<Double>();
                                newVect.add(stepVariable[j8][index]);
                                vectStepVariable.add(newVect);
                            }
                            ++j8;
                        }
                        ptStepVariable.add(pts);
                        curvesName.add(result.getExperiment());
                        ++k;
                    }
                    for (Point2D.Double[] pt : ptStepVariable) {
                        int nbStepPt = pt.length;
                        if (nbStepPt >= nbStepMax) continue;
                        Double convergingValue = pt[nbStepPt - 1].getY();
                        j = nbStepPt;
                        while (j < nbStepMax) {
                            vect = (Vector)vectStepVariable.get(j);
                            vect.add(convergingValue);
                            ++j;
                        }
                    }
                    Point2D.Double[] doublePts = new Point2D.Double[nbStepMax];
                    StatImpl stat = new StatImpl();
                    double mean = 0.0;
                    j = 0;
                    while (j < nbStepMax) {
                        vect = (Vector)vectStepVariable.get(j);
                        double[] array = ControllerImpl.vectToDoubleArray(vect);
                        mean = stat.meanAndDeviation(array)[0];
                        doublePts[j] = new Point2D.Double(j, mean);
                        ++j;
                    }
                    ptStepVariable.add(doublePts);
                    curvesName.add("MEAN");
                    return gen.getCurves(String.valueOf(idGraph) + " : " + idNameCat, curvesName, ptStepVariable);
                }
                if (!idObs.equals(ALLSIMULATIONS) && category == 2 && idNameCat.equals(ALLRELATIONS) && idVar < nbVarRelation && idGraph.equals(GRAPHEINSTANTFINALRELATIONS)) {
                    result = this.rawResult.get(idObs);
                    int nbRelation = result.getNbRelations();
                    String[] nameRelation = result.getNameRelations();
                    double[] valVarActConv = new double[nbRelation];
                    nbVarRelation = result.getNbVarRelation();
                    int index = idVar;
                    double[] varRelationConv = result.getVarRelationConv()[index];
                    if (result.getConvergence()) {
                        int j = 0;
                        while (j < nbRelation) {
                            valVarActConv[j] = varRelationConv[j];
                            ++j;
                        }
                    }
                    return gen.getBarChart(idGraph, nameRelation, valVarActConv);
                }
                if (!idObs.equals(ALLSIMULATIONS) && category == 2 && idNameCat.equals(ALLRELATIONS) && idVar >= nbVarRelation && idGraph.equals(GRAPHEGENERALRELATIONS)) {
                    result = this.rawResult.get(idObs);
                    int nbRelations = result.getNbRelations();
                    double[][] matrixStepVariable = result.getVarRelation()[idVar - result.getNbVarRelation()];
                    String[] nameRelations = result.getNameRelations();
                    int nbStep = result.getNbStepConv() + 1;
                    Vector<Point2D.Double[]> ptSatisf = new Vector<Point2D.Double[]>();
                    Vector<String> curvesName = new Vector<String>();
                    int i = 0;
                    while (i < nbRelations) {
                        Point2D.Double[] pts = new Point2D.Double[nbStep];
                        curvesName.add(nameRelations[i]);
                        int j = 0;
                        while (j < nbStep) {
                            pts[j] = new Point2D.Double(j, matrixStepVariable[j][i]);
                            ++j;
                        }
                        ptSatisf.add(pts);
                        ++i;
                    }
                    return gen.getCurves(idGraph, curvesName, ptSatisf);
                }
                if (!idObs.equals(ALLSIMULATIONS) && category == 2 && !idNameCat.equals(ALLRELATIONS) && idVar == 0 && idGraph.equals(GRAPHEINSTANTFINALSRELATION)) {
                    result = this.rawResult.get(idObs);
                    int nbRelation = result.getNbRelations();
                    String[] nameRelations = result.getNameRelations();
                    int cpt = 0;
                    boolean find = false;
                    int indexRelation = 0;
                    while (cpt < nbRelation && !find) {
                        if (nameRelations[cpt].equals(idNameCat)) {
                            indexRelation = cpt;
                            find = true;
                            continue;
                        }
                        ++cpt;
                    }
                    if (!find) {
                        return null;
                    }
                    double[] varRelation = new double[nbVarRelation];
                    String[] nameVarRelation = result.getNameVarRelations();
                    if (result.getConvergence()) {
                        int i = 0;
                        while (i < nbVarRelation) {
                            varRelation[i] = result.getVarRelationConv()[i][indexRelation];
                            ++i;
                        }
                    }
                    return gen.getBarChart(idGraph, nameVarRelation, varRelation);
                }
                if (!idObs.equals(ALLSIMULATIONS) && category == 2 && !idNameCat.equals(ALLRELATIONS) && idVar > 0 && idGraph.equals(GRAPHEGENERALRELATION)) {
                    result = this.rawResult.get(idObs);
                    String[] nameRelations = result.getNameRelations();
                    int i = 0;
                    boolean find = false;
                    int index = 0;
                    int nbRelation = result.getNbRelations();
                    while (i < nbRelation && !find) {
                        if (nameRelations[i].equals(idNameCat)) {
                            index = i;
                            find = true;
                            continue;
                        }
                        ++i;
                    }
                    if (!find) {
                        return null;
                    }
                    double[][] matrixStepVariable = result.getVarRelation()[idVar - 1];
                    int nbStep = result.getNbStepConv() + 1;
                    Vector<Point2D.Double[]> ptSatisf = new Vector<Point2D.Double[]>();
                    Vector<String> curvesName = new Vector<String>();
                    Point2D.Double[] pts = new Point2D.Double[nbStep];
                    curvesName.add(nameRelations[index]);
                    int j = 0;
                    while (j < nbStep) {
                        pts[j] = new Point2D.Double(j, matrixStepVariable[j][i]);
                        ++j;
                    }
                    ptSatisf.add(pts);
                    return gen.getCurves(idGraph, curvesName, ptSatisf);
                }
            }
        }
        return new JPanel();
    }

    private int nbConvergence() {
        int nbObs = this.rawResult.size();
        Collection<RawResultImpl> collRawResult = this.rawResult.values();
        Iterator<RawResultImpl> itRawResult = collRawResult.iterator();
        int nbCv = 0;
        int i = 0;
        while (i < nbObs) {
            RawResultImpl result = itRawResult.next();
            if (result.getConvergence()) {
                ++nbCv;
            }
            ++i;
        }
        return nbCv;
    }

    private static double[] vectToDoubleArray(Vector<Double> vect) {
        int size = vect.size();
        double[] array = new double[size];
        int i = 0;
        while (i < size) {
            array[i] = vect.get(i);
            ++i;
        }
        return array;
    }

    @Override
    public String getCurrentDir() {
        return this.dirDocName;
    }

    @Override
    public String getFileResultName() {
        return this.fileDocName;
    }

    @Override
    public void setDocName(String dirName, String fileName) {
        this.dirDocName = dirName;
        this.fileDocName = fileName;
    }

    @Override
    public String getResultsFileName() {
        int index = this.directoryName.lastIndexOf("\\");
        if (index == -1) {
            index = this.directoryName.lastIndexOf("/");
        }
        String dir = this.directoryName.substring(index + 1);
        return "results_" + dir + ".txt";
    }

    @Override
    public String createDoc() throws EmptyException, IOException {
        int index = this.directoryName.lastIndexOf("\\");
        if (index == -1) {
            index = this.directoryName.lastIndexOf("/");
        }
        String expName = this.directoryName.substring(index + 1);
        Collection<RawResultImpl> collRawResult = this.rawResult.values();
        Iterator<RawResultImpl> itRawResult = collRawResult.iterator();
        RawResultImpl result = itRawResult.next();
        String orgaName = result.getOrganisation();
        this.addHeader(String.valueOf(orgaName) + "\n" + expName);
        return super.createDoc();
    }

    @Override
    public void addGraphToReport(JPanel graph, String title, String comment) {
        Object[] temp = new Object[]{this.getImage(graph), title, comment};
        RTFReports.simuSynImages.add(temp);
    }
}

