/*
 * Decompiled with CFR 0.152.
 */
package docGen;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.HeaderFooter;
import com.lowagie.text.Image;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.rtf.RtfWriter2;
import docGen.Generator;
import docGen.GeneratorException;
import java.awt.Color;
import java.io.FileOutputStream;
import java.io.OutputStream;

class RtfGenerator
implements Generator {
    private Document document = null;
    private final Font fontTitle = new Font(1, 25.0f, 1, Color.RED);
    private static final int alignTitle = 1;
    private static final float spacingBeforeTitle = 20.0f;
    private static final float spacingAfterTitle = 20.0f;
    private final Font fontSubtitle = new Font(1, 18.0f, 1, Color.GREEN);
    private static final int alignSubtitle = 1;
    private static final float spacingBeforeSubtitle = 12.0f;
    private static final float spacingAfterSubtitle = 12.0f;
    private final Font fontSubsubtitle = new Font(1, 14.0f, 1, Color.BLACK);
    private static final int alignSubsubitle = 0;
    private static final float spacingBeforeSubsubtitle = 5.0f;
    private static final float spacingAfterSubsubtitle = 5.0f;
    private final Font fontText = new Font(1, 12.0f, 0, Color.BLACK);
    private static final int alignText = 3;
    private final Font fontComment = new Font(1, 10.0f, 2, Color.BLACK);
    private static final int alignComment = 3;
    private final Font fontLegend = new Font(1, 8.0f, 0, Color.BLACK);
    private static final int alignImageAndLegend = 1;
    private static final float spacingBeforeImageAndLegend = 3.0f;
    private static final float spacingAfterImageAndLegend = 3.0f;
    private static final int alignFooter = 1;
    private final Font fontHeader = new Font(1, 12.0f, 0, Color.GRAY);
    private static final int alignHeader = 1;

    RtfGenerator() {
    }

    @Override
    public void changeFooter(boolean numerotation) throws GeneratorException {
        if (this.document == null) {
            throw new GeneratorException();
        }
        HeaderFooter toInsert = new HeaderFooter(null, numerotation);
        toInsert.setAlignment(1);
        this.document.setFooter(toInsert);
    }

    @Override
    public void changeHeadder(String header) throws GeneratorException {
        if (this.document == null) {
            throw new GeneratorException();
        }
        HeaderFooter toInsert = new HeaderFooter(new Phrase(header, this.fontHeader), false);
        toInsert.setAlignment(1);
        this.document.setHeader(toInsert);
    }

    @Override
    public void closeDocument() throws GeneratorException {
        if (this.document == null) {
            throw new GeneratorException();
        }
        this.document.close();
        this.document = null;
    }

    @Override
    public void createDocument(String fileName) throws GeneratorException {
        try {
            this.document = new Document();
            RtfWriter2.getInstance((Document)this.document, (OutputStream)new FileOutputStream(String.valueOf(fileName) + ".rtf"));
            this.document.open();
        }
        catch (Exception e) {
            throw new GeneratorException();
        }
    }

    @Override
    public void insertCommentary(String commentary) throws GeneratorException {
        try {
            Paragraph toInsert = new Paragraph(commentary, this.fontComment);
            toInsert.setAlignment(3);
            this.document.add((Element)toInsert);
        }
        catch (DocumentException e) {
            throw new GeneratorException();
        }
    }

    @Override
    public void insertImage(String fileImageName, String legende) throws GeneratorException {
        try {
            Image img = Image.getInstance((String)fileImageName);
            img.setAlignment(1);
            Paragraph par = new Paragraph();
            par.setSpacingBefore(3.0f);
            par.setSpacingAfter(3.0f);
            par.add((Object)img);
            if (legende != null) {
                Paragraph leg = new Paragraph("\n" + legende, this.fontLegend);
                leg.setAlignment(1);
                par.add((Object)leg);
            }
            this.document.add((Element)par);
        }
        catch (Exception e) {
            throw new GeneratorException();
        }
    }

    @Override
    public void insertImage(String fileImageName, int height, int width, String legende) throws GeneratorException {
        try {
            Image img = Image.getInstance((String)fileImageName);
            img.scaleToFit((float)height, (float)width);
            img.setAlignment(1);
            Paragraph par = new Paragraph();
            par.setSpacingBefore(3.0f);
            par.setSpacingAfter(3.0f);
            par.add((Object)img);
            if (legende != null) {
                Paragraph leg = new Paragraph("\n" + legende, this.fontLegend);
                leg.setAlignment(1);
                par.add((Object)leg);
            }
            this.document.add((Element)par);
        }
        catch (Exception e) {
            throw new GeneratorException();
        }
    }

    @Override
    public void insertSubsubtitle(String subsubtitle) throws GeneratorException {
        try {
            Paragraph toInsert = new Paragraph(subsubtitle, this.fontSubsubtitle);
            toInsert.setAlignment(0);
            toInsert.setSpacingBefore(5.0f);
            toInsert.setSpacingAfter(5.0f);
            this.document.add((Element)toInsert);
        }
        catch (DocumentException e) {
            throw new GeneratorException();
        }
    }

    @Override
    public void insertSubtitle(String subtitle) throws GeneratorException {
        try {
            Paragraph toInsert = new Paragraph(subtitle, this.fontSubtitle);
            toInsert.setAlignment(1);
            toInsert.setSpacingBefore(12.0f);
            toInsert.setSpacingAfter(12.0f);
            this.document.add((Element)toInsert);
        }
        catch (DocumentException e) {
            throw new GeneratorException();
        }
    }

    @Override
    public void insertText(String text) throws GeneratorException {
        try {
            Paragraph toInsert = new Paragraph(text, this.fontText);
            toInsert.setAlignment(3);
            this.document.add((Element)toInsert);
        }
        catch (DocumentException e) {
            throw new GeneratorException();
        }
    }

    @Override
    public void insertTitle(String title) throws GeneratorException {
        try {
            Paragraph toInsert = new Paragraph(title, this.fontTitle);
            toInsert.setAlignment(1);
            toInsert.setSpacingBefore(20.0f);
            toInsert.setSpacingAfter(20.0f);
            this.document.add((Element)toInsert);
        }
        catch (DocumentException e) {
            throw new GeneratorException();
        }
    }
}

